/* GUI_LocalLibrary.h */

/* Copyright (C) 2011-2024 Michael Lugmair (Lucio Carreras)
 *
 * This file is part of sayonara player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/*
 * GUI_LocalLibrary.h
 *
 *  Created on: Apr 24, 2011
 *      Author: Michael Lugmair (Lucio Carreras)
 */

#ifndef GUI_LOCAL_LIBRARY_H_
#define GUI_LOCAL_LIBRARY_H_

#include "Gui/Utils/Widgets/Widget.h"
#include "Utils/Library/LibraryNamespaces.h"
#include "Utils/Pimpl.h"

UI_FWD(GUI_LocalLibrary)

class QFrame;
class QAbstractItemView;

namespace Library
{
	class Manager;
	class SearchBar;
	class TableView;

	enum class ViewType :
		quint8;

	class GUI_LocalLibrary :
		public Gui::Widget
	{
		Q_OBJECT
		PIMPL(GUI_LocalLibrary)
		UI_CLASS_SHARED_PTR(GUI_LocalLibrary)

		public:
			explicit GUI_LocalLibrary(LibraryId id, Manager* libraryManager, QWidget* parent = nullptr);
			~GUI_LocalLibrary() override;

			[[nodiscard]] QMenu* menu() const;
			[[nodiscard]] QFrame* headerFrame() const;

		private:
			[[nodiscard]] bool hasSelections() const;

			void queryLibrary() const;

			void languageChanged() override;
			void skinChanged() override;

			void initConnections();
			void initWidgets(LibraryId id, Manager* libraryManager) const;
			void initShortcuts();
			void initCoverView();
			void initFileSystemWatcher();
			void checkViewState();
			void checkMainSplitterStatus();
			void checkFileExtensionBar();
			void boldFontChanged();

			void showEvent(QShowEvent* e) override;
			void closeEvent(QCloseEvent* e) override;

		private slots: // NOLINT(readability-redundant-access-specifiers)
			void tracksLoaded();
			void switchViewType();

			void progressChanged(const QString& type, int progress);

			void genreSelectionChanged(const QStringList& genres);
			void invalidGenreSelected();

			void reloadLibraryDeepRequested();
			void reloadLibraryRequested();
			void reloadLibraryRequestedWithQuality(ReloadQuality quality);
			void reloadLibraryAccepted(ReloadQuality quality);
			void reloadLibrary(ReloadQuality quality);
			void reloadFinished();

			void importDirsRequested();
			void importFilesRequested();
			void nameChanged(const QString& newName);
			void pathChanged(const QString& newPath);

			void importDialogRequested(const QString& targetDirectory);

			void splitterArtistMoved(int pos, int idx);
			void splitterTracksMoved(int pos, int idx);
			void splitterGenreMoved(int pos, int idx);

			TrackDeletionMode showDeleteDialog(int track_count);
			void clearSelections();

			void showInfoBox();
			void liveSearchChanged();

			void searchTriggered() const;
			void searchEdited(const QString& searchString) const;
			void keyPressed(int key);
			void itemDeleteClicked();
			void showDeleteAnswer(const QString& text);

			void tracksDeleteClicked();
	};
}

#endif /* GUI_LocalLibrary_H_ */

