/* DatabaseArtists.h */

/* Copyright (C) 2011-2024 Michael Lugmair (Lucio Carreras)
 *
 * This file is part of sayonara player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DATABASEARTISTS_H
#define DATABASEARTISTS_H

#include "Database/Utils.h"
#include "Utils/typedefs.h"

namespace Library
{
	class Filter;
}

class Artist;
class ArtistList;
class QSqlQuery;

namespace DB
{
	class Module;
	class Artists
	{
		public:
			Artists();
			~Artists();


			[[nodiscard]] ArtistId getArtistID(const QString& artist) const;
			[[nodiscard]] Artist getArtistByID(ArtistId id) const;
			[[nodiscard]] Artist getArtistByID(ArtistId id, bool alsoEmpty) const;

			[[nodiscard]] ArtistList getAllArtists(bool onlyAlbumArtists, bool alsoEmpty) const;
			[[nodiscard]] ArtistList getAllArtistsBySearchString(bool onlyAlbumArtists,
			                                                     const ::Library::Filter& filter) const;

			bool deleteArtist(ArtistId id);

			ArtistId insertArtistIntoDatabase(const QString& artist);
			[[maybe_unused]] virtual ArtistId insertArtistIntoDatabase(const Artist& artist);

		protected:
			[[nodiscard]] virtual QString trackView() const = 0;
			[[nodiscard]] virtual QString trackSearchView() const = 0;

			virtual Module* module() = 0;
			[[nodiscard]] virtual const Module* module() const = 0;

			virtual void updateArtistCissearch();
			virtual void deleteAllArtists();
	};
}

#endif // DATABASEARTISTS_H
