
/* Copyright (C) 2011-2024 Michael Lugmair (Lucio Carreras)
 *
 * This file is part of sayonara player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBRARY_HEADERVIEW_H
#define LIBRARY_HEADERVIEW_H

#include "Gui/Library/Header/ColumnHeader.h"
#include "Gui/Utils/Widgets/HeaderView.h"
#include "Utils/Library/Sortorder.h"
#include "Utils/Pimpl.h"

namespace Library
{
	class HeaderView :
		public Gui::HeaderView
	{
		Q_OBJECT
		PIMPL(HeaderView)

		signals:
			void sigAutoResizeToggled(bool b);
			void sigStateChanged(const QByteArray& state);

		public:
			HeaderView(Qt::Orientation orientation, QWidget* parent = nullptr);
			~HeaderView() override;

			void init(const ColumnHeaderList& columnHeaderList, const QByteArray& state,
			          Library::VariableSortorder sortOrder, bool autoResizeState);
			void resizeColumnsAutomatically();

			Library::VariableSortorder sortorder(int index, Qt::SortOrder sortOrder);
			[[nodiscard]] QString columnText(int index) const;
			void reloadColumnTexts();

			[[nodiscard]] bool isInitialized() const;
			QAction* initAction(const QString& title, bool isSwitchable, int index);

		protected:
			void languageChanged() override;
			void showEvent(QShowEvent* e) override;
			void resizeEvent(QResizeEvent* e) override;

		private:
			void initializeView();
			void saveHeaderState();
			void finalizeActions();

			using QHeaderView::resizeSections;
			using QHeaderView::setSectionResizeMode;
			using QHeaderView::setStretchLastSection;
			using QHeaderView::setCascadingSectionResizes;


		private slots:
			void actionTriggered(bool b);
			void actionResizeTriggered();
			void actionAutoResizeTriggered(bool b);
	};
}

#endif // LIBRARY_HEADERVIEW_H
