import React from 'react';
import Icon from '../../icon';
import TextTranslation from '../../../utils/text-translation';
import { baiduMapKey, gettext, googleMapKey } from '../../../utils/constants';
import { VIEW_TYPE, VIEW_TYPE_LABEL, VIEW_TYPE_ICON } from '../../../metadata/constants';

export const KEY_ADD_VIEW_MAP = {
  ADD_FOLDER: 'ADD_FOLDER',
  ADD_TABLE: 'ADD_TABLE',
  ADD_GALLERY: 'ADD_GALLERY',
  ADD_KANBAN: 'ADD_KANBAN',
  ADD_MAP: 'ADD_MAP',
  ADD_CARD: 'ADD_CARD',
  ADD_STATISTICS: 'ADD_STATISTICS',
};

const ADD_VIEW_OPTIONS = [
  {
    key: KEY_ADD_VIEW_MAP.ADD_TABLE,
    type: VIEW_TYPE.TABLE,
  },
  {
    key: KEY_ADD_VIEW_MAP.ADD_GALLERY,
    type: VIEW_TYPE.GALLERY,
  },
  {
    key: KEY_ADD_VIEW_MAP.ADD_KANBAN,
    type: VIEW_TYPE.KANBAN,
  },
  {
    key: KEY_ADD_VIEW_MAP.ADD_CARD,
    type: VIEW_TYPE.CARD,
  },
  {
    key: KEY_ADD_VIEW_MAP.ADD_STATISTICS,
    type: VIEW_TYPE.STATISTICS,
  }
];

export const getNewViewSubMenu = () => {
  const options = [...ADD_VIEW_OPTIONS];
  const hasMapOption = options.some(opt => opt.type === VIEW_TYPE.MAP);

  if (!hasMapOption && (baiduMapKey || googleMapKey)) {
    options.push({
      key: KEY_ADD_VIEW_MAP.ADD_MAP,
      type: VIEW_TYPE.MAP,
    });
  }

  return options.map((option) => {
    const { key, type } = option;
    return {
      key,
      value: VIEW_TYPE_LABEL[type],
      icon_dom: <Icon symbol={VIEW_TYPE_ICON[type] || VIEW_TYPE.TABLE} className="metadata-view-icon" />
    };
  });
};

export const getNewViewMenuItem = () => {
  return {
    ...TextTranslation.ADD_VIEW,
    subOpListHeader: gettext('New view'),
    subOpList: getNewViewSubMenu(),
  };
};
