#pragma once

#include "lib/spotify/qtauth.hpp"

#include <QTcpServer>

namespace spt
{
	/**
	 * Spotify authentication server
	 */
	class AuthServer: public QTcpServer
	{
	Q_OBJECT

	public:
		AuthServer(lib::settings &settings, QObject *parent);

		auto listen() -> bool;
		static auto redirectUrl() -> QString;
		void openUrl(QWidget *parent) const;

	signals:
		void success();
		void failed(const QString &message);

	private:
		lib::settings &settings;
		lib::qt::spt::auth auth;

		static constexpr int serverPort = 8888;
		static constexpr int writeTimeout = 3000;

		void onNewConnection();
	};
}
