// Copyright (c) Tailscale Inc & contributors
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by tailscale.com/cmd/cloner; DO NOT EDIT.

package filtertype

import (
	"net/netip"

	"tailscale.com/tailcfg"
	"tailscale.com/types/ipproto"
	"tailscale.com/types/views"
)

// Clone makes a deep copy of Match.
// The result aliases no memory with the original.
func (src *Match) Clone() *Match {
	if src == nil {
		return nil
	}
	dst := new(Match)
	*dst = *src
	dst.IPProto = src.IPProto
	dst.Srcs = append(src.Srcs[:0:0], src.Srcs...)
	dst.SrcCaps = append(src.SrcCaps[:0:0], src.SrcCaps...)
	dst.Dsts = append(src.Dsts[:0:0], src.Dsts...)
	if src.Caps != nil {
		dst.Caps = make([]CapMatch, len(src.Caps))
		for i := range dst.Caps {
			dst.Caps[i] = *src.Caps[i].Clone()
		}
	}
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _MatchCloneNeedsRegeneration = Match(struct {
	IPProto      views.Slice[ipproto.Proto]
	Srcs         []netip.Prefix
	SrcsContains func(netip.Addr) bool
	SrcCaps      []tailcfg.NodeCapability
	Dsts         []NetPortRange
	Caps         []CapMatch
}{})

// Clone makes a deep copy of CapMatch.
// The result aliases no memory with the original.
func (src *CapMatch) Clone() *CapMatch {
	if src == nil {
		return nil
	}
	dst := new(CapMatch)
	*dst = *src
	dst.Values = append(src.Values[:0:0], src.Values...)
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _CapMatchCloneNeedsRegeneration = CapMatch(struct {
	Dst    netip.Prefix
	Cap    tailcfg.PeerCapability
	Values []tailcfg.RawMessage
}{})
