// Copyright (c) Tailscale Inc & contributors
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by tailscale.com/cmd/cloner; DO NOT EDIT.

package tka

// Clone makes a deep copy of NodeKeySignature.
// The result aliases no memory with the original.
func (src *NodeKeySignature) Clone() *NodeKeySignature {
	if src == nil {
		return nil
	}
	dst := new(NodeKeySignature)
	*dst = *src
	dst.Pubkey = append(src.Pubkey[:0:0], src.Pubkey...)
	dst.KeyID = append(src.KeyID[:0:0], src.KeyID...)
	dst.Signature = append(src.Signature[:0:0], src.Signature...)
	dst.Nested = src.Nested.Clone()
	dst.WrappingPubkey = append(src.WrappingPubkey[:0:0], src.WrappingPubkey...)
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _NodeKeySignatureCloneNeedsRegeneration = NodeKeySignature(struct {
	SigKind        SigKind
	Pubkey         []byte
	KeyID          []byte
	Signature      []byte
	Nested         *NodeKeySignature
	WrappingPubkey []byte
}{})
