# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_typstyle_global_optspecs
	string join \n i/inplace check diff l/line-width= t/indent-width= no-reorder-import-items wrap-text a/ast p/pretty-doc timing v/verbose q/quiet h/help V/version
end

function __fish_typstyle_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_typstyle_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_typstyle_using_subcommand
	set -l cmd (__fish_typstyle_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c typstyle -n "__fish_typstyle_needs_command" -s l -s c -l line-width -l column -d 'Maximum width of each line' -r
complete -c typstyle -n "__fish_typstyle_needs_command" -s t -l indent-width -l tab-width -d 'Number of spaces per indentation level' -r
complete -c typstyle -n "__fish_typstyle_needs_command" -s i -l inplace -d 'Format the file in place'
complete -c typstyle -n "__fish_typstyle_needs_command" -l check -d 'Run in \'check\' mode. Exits with 0 if input is formatted correctly. Exits with a non-zero status code if formatting is required'
complete -c typstyle -n "__fish_typstyle_needs_command" -l diff -d 'Run in \'diff\' mode. Shows unified diff of what formatting changes would be made. Exits with 0 if input is formatted correctly. Exits with a non-zero status code if formatting is required'
complete -c typstyle -n "__fish_typstyle_needs_command" -l no-reorder-import-items -d 'Disable alphabetical reordering of import items'
complete -c typstyle -n "__fish_typstyle_needs_command" -l wrap-text -d 'Wrap text in markup to fit within the line width, and collapse spaces in markup'
complete -c typstyle -n "__fish_typstyle_needs_command" -s a -l ast -d 'Print the AST of the input file'
complete -c typstyle -n "__fish_typstyle_needs_command" -s p -l pretty-doc -d 'Print the pretty document'
complete -c typstyle -n "__fish_typstyle_needs_command" -l timing -d 'Show elapsed time taken by the formatter'
complete -c typstyle -n "__fish_typstyle_needs_command" -s v -l verbose -d 'Enable verbose logging'
complete -c typstyle -n "__fish_typstyle_needs_command" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c typstyle -n "__fish_typstyle_needs_command" -s h -l help -d 'Print help'
complete -c typstyle -n "__fish_typstyle_needs_command" -s V -l version -d 'Print version'
complete -c typstyle -n "__fish_typstyle_needs_command" -a "completions" -d 'Generate shell completions for the given shell to stdout'
complete -c typstyle -n "__fish_typstyle_needs_command" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c typstyle -n "__fish_typstyle_using_subcommand completions" -s l -s c -l line-width -l column -d 'Maximum width of each line' -r
complete -c typstyle -n "__fish_typstyle_using_subcommand completions" -s t -l indent-width -l tab-width -d 'Number of spaces per indentation level' -r
complete -c typstyle -n "__fish_typstyle_using_subcommand completions" -l check -d 'Run in \'check\' mode. Exits with 0 if input is formatted correctly. Exits with a non-zero status code if formatting is required'
complete -c typstyle -n "__fish_typstyle_using_subcommand completions" -l diff -d 'Run in \'diff\' mode. Shows unified diff of what formatting changes would be made. Exits with 0 if input is formatted correctly. Exits with a non-zero status code if formatting is required'
complete -c typstyle -n "__fish_typstyle_using_subcommand completions" -l no-reorder-import-items -d 'Disable alphabetical reordering of import items'
complete -c typstyle -n "__fish_typstyle_using_subcommand completions" -l wrap-text -d 'Wrap text in markup to fit within the line width, and collapse spaces in markup'
complete -c typstyle -n "__fish_typstyle_using_subcommand completions" -s v -l verbose -d 'Enable verbose logging'
complete -c typstyle -n "__fish_typstyle_using_subcommand completions" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c typstyle -n "__fish_typstyle_using_subcommand completions" -s h -l help -d 'Print help'
complete -c typstyle -n "__fish_typstyle_using_subcommand help; and not __fish_seen_subcommand_from completions help" -f -a "completions" -d 'Generate shell completions for the given shell to stdout'
complete -c typstyle -n "__fish_typstyle_using_subcommand help; and not __fish_seen_subcommand_from completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
