/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.Demand;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0006H\u0002J\u0014\u0010\b\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u0006H\u0003J\f\u0010\u000e\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0006H\u0002J\u001c\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J&\u0010\u0017\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\rH\u0002R\u000e\u0010\u0012\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DiplomacyTurnManager;", "", "<init>", "()V", "nextTurn", "", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "removeUntenableTrades", "remakePeaceTreaty", "durationLeft", "", "nextTurnCityStateInfluence", "getCityStateInfluenceRecovery", "", "nextTurnFlags", "scienceFromResearchAgreement", "nextTurnTrades", "nextTurnDiplomaticModifiers", "SPEED_ADJUSTMENT_NORMALIZATION_FACTOR", "revertToZero", "modifier", "Lcom/unciv/logic/civilization/diplomacy/DiplomaticModifiers;", "amount", "accumulateToAtMost", "maxAmount", "core"})
@SourceDebugExtension(value={"SMAP\nDiplomacyTurnManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiplomacyTurnManager.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyTurnManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n774#2:387\n865#2,2:388\n1563#2:390\n1634#2,3:391\n1761#2,3:394\n230#2,2:397\n1761#2,3:399\n774#2:402\n865#2,2:403\n1740#2,3:405\n774#2:408\n865#2,2:409\n1761#2,3:411\n774#2:414\n865#2,2:415\n*S KotlinDebug\n*F\n+ 1 DiplomacyTurnManager.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyTurnManager\n*L\n35#1:387\n35#1:388,2\n35#1:390\n35#1:391,3\n47#1:394,3\n48#1:397,2\n145#1:399,3\n235#1:402\n235#1:403,2\n239#1:405,3\n241#1:408\n241#1:409,2\n249#1:411,3\n254#1:414\n254#1:415,2\n*E\n"})
public final class DiplomacyTurnManager {
    @NotNull
    public static final DiplomacyTurnManager INSTANCE = new DiplomacyTurnManager();
    private static final float SPEED_ADJUSTMENT_NORMALIZATION_FACTOR = 0.67f;

    private DiplomacyTurnManager() {
    }

    public final void nextTurn(@NotNull DiplomacyManager $this$nextTurn) {
        Intrinsics.checkNotNullParameter($this$nextTurn, "<this>");
        this.nextTurnTrades($this$nextTurn);
        this.removeUntenableTrades($this$nextTurn);
        $this$nextTurn.updateHasOpenBorders();
        this.nextTurnDiplomaticModifiers($this$nextTurn);
        this.nextTurnFlags($this$nextTurn);
        if ($this$nextTurn.getCivInfo().isCityState() && $this$nextTurn.getOtherCiv().isMajorCiv()) {
            this.nextTurnCityStateInfluence($this$nextTurn);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeUntenableTrades(DiplomacyManager $this$removeUntenableTrades) {
        for (Trade trade : CollectionsKt.toList((Iterable)$this$removeUntenableTrades.getTrades())) {
            Object object;
            TradeOfferType[] $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Object it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object object2 = $this$removeUntenableTrades.getCivInfo().getCivResourceSupply();
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                it = (ResourceSupplyList.ResourceSupply)t;
                bl = false;
                if (!(((ResourceSupplyList.ResourceSupply)it).getAmount() < 0 && !((ResourceSupplyList.ResourceSupply)it).getResource().isStockpiled())) continue;
                destination$iv$iv.add(t);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                it = (ResourceSupplyList.ResourceSupply)t;
                object = destination$iv$iv;
                bl = false;
                object.add(((ResourceSupplyList.ResourceSupply)it).getResource().getName());
            }
            List negativeCivResources = (List)destination$iv$iv;
            Iterator iterator2 = trade.getOurOffers().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            object2 = iterator2;
            while (object2.hasNext()) {
                boolean bl2;
                Iterable $this$any$iv;
                block9: {
                    Object e = object2.next();
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    TradeOffer offer = (TradeOffer)e;
                    $this$mapTo$iv$iv = new TradeOfferType[]{TradeOfferType.Luxury_Resource, TradeOfferType.Strategic_Resource};
                    if (!CollectionsKt.listOf($this$mapTo$iv$iv).contains((Object)offer.getType()) || !negativeCivResources.contains(offer.getName()) && $this$removeUntenableTrades.getCivInfo().getGameInfo().getRuleset().getTileResources().containsKey(offer.getName())) continue;
                    $this$removeUntenableTrades.getTrades().remove(trade);
                    DiplomacyManager diplomacyManager = $this$removeUntenableTrades.getOtherCiv().getDiplomacyManager($this$removeUntenableTrades.getCivInfo());
                    Intrinsics.checkNotNull(diplomacyManager);
                    ArrayList<Trade> otherCivTrades = diplomacyManager.getTrades();
                    CollectionsKt.removeAll((List)otherCivTrades, arg_0 -> DiplomacyTurnManager.removeUntenableTrades$lambda$2(trade, arg_0));
                    $this$any$iv = trade.getTheirOffers();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object t : $this$any$iv) {
                            it = (TradeOffer)t;
                            boolean bl22 = false;
                            if (!Intrinsics.areEqual(((TradeOffer)it).getName(), "Peace Treaty")) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    Object t2;
                    DiplomacyManager diplomacyManager;
                    block10: {
                        void $this$first$iv;
                        $this$any$iv = trade.getTheirOffers();
                        diplomacyManager = $this$removeUntenableTrades;
                        object = this;
                        boolean $i$f$first = false;
                        for (Object t2 : $this$first$iv) {
                            it = (TradeOffer)t2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(((TradeOffer)it).getName(), "Peace Treaty")) continue;
                            break block10;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Object t3 = t2;
                    super.remakePeaceTreaty(diplomacyManager, ((TradeOffer)t3).getDuration());
                }
                String[] stringArray = new String[]{"StatIcons/Acquire", $this$removeUntenableTrades.getOtherCiv().getCivName()};
                $this$removeUntenableTrades.getCivInfo().addNotification("One of our trades with [" + $this$removeUntenableTrades.getOtherCiv().getCivName() + "] has been cut short", new DiplomacyAction($this$removeUntenableTrades.getOtherCiv(), true), Notification.NotificationCategory.Trade, stringArray);
                stringArray = new String[]{"StatIcons/Acquire", $this$removeUntenableTrades.getCivInfo().getCivName()};
                $this$removeUntenableTrades.getOtherCiv().addNotification("One of our trades with [" + $this$removeUntenableTrades.getCivInfo().getCivName() + "] has been cut short", new DiplomacyAction($this$removeUntenableTrades.getCivInfo(), true), Notification.NotificationCategory.Trade, stringArray);
                $this$removeUntenableTrades.otherCivDiplomacy().setFlag(DiplomacyFlags.ResourceTradesCutShort, $this$removeUntenableTrades.getCivInfo().getGameInfo().getSpeed().getDealDuration() * 2);
                $this$removeUntenableTrades.getCivInfo().getCache().updateCivResources();
            }
        }
    }

    private final void remakePeaceTreaty(DiplomacyManager $this$remakePeaceTreaty, int durationLeft) {
        Trade treaty = new Trade();
        treaty.getOurOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, durationLeft, 4, null));
        treaty.getTheirOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, durationLeft, 4, null));
        $this$remakePeaceTreaty.getTrades().add(treaty);
        DiplomacyManager diplomacyManager = $this$remakePeaceTreaty.getOtherCiv().getDiplomacyManager($this$remakePeaceTreaty.getCivInfo());
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.getTrades().add(treaty);
    }

    private final void nextTurnCityStateInfluence(DiplomacyManager $this$nextTurnCityStateInfluence) {
        RelationshipLevel initialRelationshipLevel = $this$nextTurnCityStateInfluence.relationshipIgnoreAfraid();
        float restingPoint = $this$nextTurnCityStateInfluence.getCityStateInfluenceRestingPoint$core();
        if ($this$nextTurnCityStateInfluence.getInfluence$core() > restingPoint) {
            float decrement = $this$nextTurnCityStateInfluence.getCityStateInfluenceDegrade$core();
            $this$nextTurnCityStateInfluence.setInfluence(Math.max(restingPoint, $this$nextTurnCityStateInfluence.getInfluence$core() - decrement));
        } else if ($this$nextTurnCityStateInfluence.getInfluence$core() < restingPoint) {
            float increment = this.getCityStateInfluenceRecovery($this$nextTurnCityStateInfluence);
            $this$nextTurnCityStateInfluence.setInfluence(Math.min(restingPoint, $this$nextTurnCityStateInfluence.getInfluence$core() + increment));
        }
        if (!$this$nextTurnCityStateInfluence.getCivInfo().isDefeated()) {
            String[] stringArray;
            String text2;
            Sequence<NotificationAction> notificationActions = $this$nextTurnCityStateInfluence.getCivInfo().getCityStateFunctions().getNotificationActions();
            if ($this$nextTurnCityStateInfluence.getTurnsToRelationshipChange() == 1) {
                text2 = "Your relationship with [" + $this$nextTurnCityStateInfluence.getCivInfo().getCivName() + "] is about to degrade";
                stringArray = new String[]{$this$nextTurnCityStateInfluence.getCivInfo().getCivName(), "OtherIcons/Diplomacy"};
                $this$nextTurnCityStateInfluence.getOtherCiv().addNotification(text2, notificationActions, Notification.NotificationCategory.Diplomacy, stringArray);
            }
            if (initialRelationshipLevel.compareTo((Enum)RelationshipLevel.Friend) >= 0 && initialRelationshipLevel != $this$nextTurnCityStateInfluence.relationshipIgnoreAfraid()) {
                text2 = "Your relationship with [" + $this$nextTurnCityStateInfluence.getCivInfo().getCivName() + "] degraded";
                stringArray = new String[]{$this$nextTurnCityStateInfluence.getCivInfo().getCivName(), "OtherIcons/Diplomacy"};
                $this$nextTurnCityStateInfluence.getOtherCiv().addNotification(text2, notificationActions, Notification.NotificationCategory.Diplomacy, stringArray);
            }
            if ($this$nextTurnCityStateInfluence.getInfluence() < 30.0f && !$this$nextTurnCityStateInfluence.hasFlag(DiplomacyFlags.NotifiedAfraid) && CityStateFunctions.getTributeWillingness$default($this$nextTurnCityStateInfluence.getCivInfo().getCityStateFunctions(), $this$nextTurnCityStateInfluence.getOtherCiv(), false, 2, null) > 0 && $this$nextTurnCityStateInfluence.getOtherCiv().isMajorCiv()) {
                $this$nextTurnCityStateInfluence.setFlag(DiplomacyFlags.NotifiedAfraid, 20);
                text2 = '[' + $this$nextTurnCityStateInfluence.getCivInfo().getCivName() + "] is afraid of your military power!";
                stringArray = new String[]{$this$nextTurnCityStateInfluence.getCivInfo().getCivName(), "OtherIcons/Diplomacy"};
                $this$nextTurnCityStateInfluence.getOtherCiv().addNotification(text2, notificationActions, Notification.NotificationCategory.Diplomacy, stringArray);
            }
        }
    }

    @Readonly
    private final float getCityStateInfluenceRecovery(DiplomacyManager $this$getCityStateInfluenceRecovery) {
        String religion;
        String string;
        if ($this$getCityStateInfluenceRecovery.getInfluence() >= $this$getCityStateInfluenceRecovery.getCityStateInfluenceRestingPoint$core()) {
            return 0.0f;
        }
        float increment = 1.0f;
        float modifierPercent = 0.0f;
        if (Civilization.hasUnique$default($this$getCityStateInfluenceRecovery.getOtherCiv(), UniqueType.CityStateInfluenceRecoversTwiceNormalRate, null, 2, null)) {
            modifierPercent += 100.0f;
        }
        if ($this$getCityStateInfluenceRecovery.getCivInfo().getCities().isEmpty() || Civilization.getCapital$default($this$getCityStateInfluenceRecovery.getCivInfo(), false, 1, null) == null) {
            string = null;
        } else {
            City city = Civilization.getCapital$default($this$getCityStateInfluenceRecovery.getCivInfo(), false, 1, null);
            Intrinsics.checkNotNull(city);
            string = religion = city.getReligion().getMajorityReligionName();
        }
        if (religion != null) {
            Religion religion2 = $this$getCityStateInfluenceRecovery.getOtherCiv().getReligionManager().getReligion();
            if (Intrinsics.areEqual(religion, religion2 != null ? religion2.getName() : null)) {
                modifierPercent += 50.0f;
            }
        }
        return Math.max(0.0f, increment) * FormattingExtensionsKt.toPercent(Math.max(0.0f, modifierPercent));
    }

    private final void nextTurnFlags(DiplomacyManager $this$nextTurnFlags) {
        Set<String> set = $this$nextTurnFlags.getFlagsCountdown$core().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        block20: for (String flag : CollectionsKt.toList((Iterable)set)) {
            block42: {
                Map map2 = $this$nextTurnFlags.getFlagsCountdown$core();
                Integer n = $this$nextTurnFlags.getFlagsCountdown$core().get(flag);
                Intrinsics.checkNotNull(n);
                map2.put(flag, ((Number)n).intValue() - 1);
                if (Intrinsics.areEqual(flag, "ProvideMilitaryUnit") && $this$nextTurnFlags.getCivInfo().isMajorCiv() && $this$nextTurnFlags.getOtherCiv().isCityState()) {
                    boolean bl;
                    block41: {
                        Iterable $this$any$iv = $this$nextTurnFlags.getCivInfo().getGameInfo().getCivilizations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Civilization it = (Civilization)element$iv;
                                boolean bl2 = false;
                                if (!($this$nextTurnFlags.getCivInfo().isAtWarWith(it) && $this$nextTurnFlags.getOtherCiv().isAtWarWith(it))) continue;
                                bl = true;
                                break block41;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        Iterator iterator2 = Civilization.getMatchingUniques$default($this$nextTurnFlags.getCivInfo(), UniqueType.CityStateMoreGiftedUnits, null, 2, null).iterator();
                        while (iterator2.hasNext()) {
                            Unique unique = (Unique)iterator2.next();
                            Map map3 = $this$nextTurnFlags.getFlagsCountdown$core();
                            Integer n2 = $this$nextTurnFlags.getFlagsCountdown$core().get("ProvideMilitaryUnit");
                            Intrinsics.checkNotNull(n2);
                            map3.put("ProvideMilitaryUnit", ((Number)n2).intValue() - Integer.parseInt(unique.getParams().get(0)) + 1);
                            Integer n3 = $this$nextTurnFlags.getFlagsCountdown$core().get("ProvideMilitaryUnit");
                            Intrinsics.checkNotNull(n3);
                            if (((Number)n3).intValue() > 0) continue;
                            ((Map)$this$nextTurnFlags.getFlagsCountdown$core()).put("ProvideMilitaryUnit", 0);
                            break;
                        }
                    }
                }
                if (Intrinsics.areEqual(flag, "ResearchAgreement")) {
                    $this$nextTurnFlags.setTotalOfScienceDuringRA$core($this$nextTurnFlags.getTotalOfScienceDuringRA$core() + (int)$this$nextTurnFlags.getCivInfo().getStats().getStatsForNextTurn().getScience());
                }
                Integer n4 = $this$nextTurnFlags.getFlagsCountdown$core().get(flag);
                int n5 = 50;
                if (n4 != null && n4 == n5) {
                    String string = flag;
                    if (Intrinsics.areEqual(string, "RememberAttackedProtectedMinor")) {
                        $this$nextTurnFlags.addModifier(DiplomaticModifiers.AttackedProtectedMinor, 5.0f);
                    } else if (Intrinsics.areEqual(string, "RememberBulliedProtectedMinor")) {
                        $this$nextTurnFlags.addModifier(DiplomaticModifiers.BulliedProtectedMinor, 5.0f);
                    }
                }
                Integer n6 = $this$nextTurnFlags.getFlagsCountdown$core().get(flag);
                if (n6 == null || n6 != 0) break block42;
                switch (flag) {
                    case "ResearchAgreement": {
                        if ($this$nextTurnFlags.otherCivDiplomacy().hasFlag(DiplomacyFlags.ResearchAgreement)) break;
                        this.scienceFromResearchAgreement($this$nextTurnFlags);
                        break;
                    }
                    case "DefensivePact": {
                        $this$nextTurnFlags.setDiplomaticStatus(DiplomaticStatus.Peace);
                        break;
                    }
                    case "ProvideMilitaryUnit": {
                        if ($this$nextTurnFlags.getCivInfo().getCities().isEmpty() || $this$nextTurnFlags.getOtherCiv().getCities().isEmpty()) continue block20;
                        $this$nextTurnFlags.getOtherCiv().getCityStateFunctions().giveMilitaryUnitToPatron($this$nextTurnFlags.getCivInfo());
                        break;
                    }
                    case "RecentlyAttacked": {
                        $this$nextTurnFlags.getCivInfo().getCityStateFunctions().askForUnitGifts($this$nextTurnFlags.getOtherCiv());
                        break;
                    }
                    case "RememberDestroyedProtectedMinor": {
                        $this$nextTurnFlags.removeModifier$core(DiplomaticModifiers.DestroyedProtectedMinor);
                        break;
                    }
                    case "RememberAttackedProtectedMinor": {
                        $this$nextTurnFlags.removeModifier$core(DiplomaticModifiers.AttackedProtectedMinor);
                        break;
                    }
                    case "RememberBulliedProtectedMinor": {
                        $this$nextTurnFlags.removeModifier$core(DiplomaticModifiers.BulliedProtectedMinor);
                        break;
                    }
                    case "RememberSidedWithProtectedMinor": {
                        $this$nextTurnFlags.removeModifier$core(DiplomaticModifiers.SidedWithProtectedMinor);
                        break;
                    }
                    default: {
                        for (Demand demand : Demand.getEntries()) {
                            if (!Intrinsics.areEqual(demand.getAgreedToDemand().name(), flag)) continue;
                            $this$nextTurnFlags.addModifier(demand.getFulfilledPromiseDiplomacyModifier(), 10.0f);
                        }
                    }
                }
                $this$nextTurnFlags.getFlagsCountdown$core().remove(flag);
                continue;
            }
            if (!Intrinsics.areEqual(flag, "WaryOf")) continue;
            Integer n = $this$nextTurnFlags.getFlagsCountdown$core().get(flag);
            Intrinsics.checkNotNull(n);
            if (((Number)n).intValue() >= -10) continue;
            $this$nextTurnFlags.getFlagsCountdown$core().remove(flag);
        }
    }

    private final void scienceFromResearchAgreement(DiplomacyManager $this$scienceFromResearchAgreement) {
        int scienceFromResearchAgreement = Math.min($this$scienceFromResearchAgreement.getTotalOfScienceDuringRA$core(), $this$scienceFromResearchAgreement.otherCivDiplomacy().getTotalOfScienceDuringRA$core());
        TechManager techManager = $this$scienceFromResearchAgreement.getCivInfo().getTech();
        techManager.setScienceFromResearchAgreements(techManager.getScienceFromResearchAgreements() + scienceFromResearchAgreement);
        techManager = $this$scienceFromResearchAgreement.getOtherCiv().getTech();
        techManager.setScienceFromResearchAgreements(techManager.getScienceFromResearchAgreements() + scienceFromResearchAgreement);
        $this$scienceFromResearchAgreement.setTotalOfScienceDuringRA$core(0);
        $this$scienceFromResearchAgreement.otherCivDiplomacy().setTotalOfScienceDuringRA$core(0);
    }

    private final void nextTurnTrades(DiplomacyManager $this$nextTurnTrades) {
        for (Trade trade : CollectionsKt.toList((Iterable)$this$nextTurnTrades.getTrades())) {
            Iterable $this$any$iv;
            TradeOffer it;
            boolean bl;
            boolean $i$f$all;
            Iterable $this$all$iv;
            TradeOffer offer;
            Object $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            int $i$f$filter;
            Iterable $this$filter$iv;
            block19: {
                $this$filter$iv = CollectionsKt.union(trade.getOurOffers(), trade.getTheirOffers());
                $i$f$filter = 0;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object t : $this$filterTo$iv$iv) {
                    TradeOffer it2 = (TradeOffer)t;
                    boolean bl2 = false;
                    if (!(it2.getDuration() > 0)) continue;
                    destination$iv$iv.add(t);
                }
                for (Object e : (List)destination$iv$iv) {
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    offer = (TradeOffer)e;
                    $i$f$filter = offer.getDuration();
                    offer.setDuration($i$f$filter + -1);
                }
                $this$all$iv = trade.getOurOffers();
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (TradeOffer)element$iv;
                        boolean bl3 = false;
                        if (it.getDuration() <= 0) continue;
                        bl = false;
                        break block19;
                    }
                    bl = true;
                }
            }
            if (bl) {
                boolean bl2;
                block20: {
                    $this$all$iv = trade.getTheirOffers();
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (TradeOffer)element$iv;
                            boolean bl5 = false;
                            if (it.getDuration() <= 0) continue;
                            bl2 = false;
                            break block20;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    Object element$iv;
                    $this$nextTurnTrades.getTrades().remove(trade);
                    Iterable $this$filter$iv2 = CollectionsKt.union(trade.getOurOffers(), trade.getTheirOffers());
                    $i$f$filter = 0;
                    element$iv = $this$filter$iv2;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object t : $this$filterTo$iv$iv) {
                        TradeOffer it2 = (TradeOffer)t;
                        boolean bl6 = false;
                        if (!(it2.getDuration() == 0)) continue;
                        destination$iv$iv.add(t);
                    }
                    for (Object e : (List)destination$iv$iv) {
                        boolean bl3;
                        block21: {
                            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                            TradeOffer offer2 = (TradeOffer)e;
                            String direction = trade.getTheirOffers().contains((Object)offer2) ? "from" : "to";
                            $this$filterTo$iv$iv = new String[]{$this$nextTurnTrades.getOtherCiv().getCivName(), "StatIcons/Acquire"};
                            $this$nextTurnTrades.getCivInfo().addNotification('[' + offer2.getName() + "] " + direction + " [" + $this$nextTurnTrades.getOtherCiv().getCivName() + "] has ended", new DiplomacyAction($this$nextTurnTrades.getOtherCiv(), true), Notification.NotificationCategory.Trade, (String)$this$filterTo$iv$iv);
                            $this$nextTurnTrades.getCivInfo().updateStatsForNextTurn();
                            $this$filterTo$iv$iv = CollectionsKt.union(trade.getTheirOffers(), trade.getOurOffers());
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    TradeOffer tradeOffer = (TradeOffer)element$iv2;
                                    boolean bl8 = false;
                                    if (!(tradeOffer.getType() == TradeOfferType.Luxury_Resource || tradeOffer.getType() == TradeOfferType.Strategic_Resource)) continue;
                                    bl3 = true;
                                    break block21;
                                }
                                bl3 = false;
                            }
                        }
                        if (!bl3) continue;
                        $this$nextTurnTrades.getCivInfo().getCache().updateCivResources();
                    }
                }
            }
            $this$filter$iv = trade.getTheirOffers();
            $i$f$filter = 0;
            $this$any$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                TradeOffer it4 = (TradeOffer)t;
                boolean bl9 = false;
                if (!(it4.getDuration() <= 3)) continue;
                destination$iv$iv.add(t);
            }
            for (Object e : (List)destination$iv$iv) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                offer = (TradeOffer)e;
                if (offer.getDuration() == 3) {
                    String[] stringArray = new String[]{$this$nextTurnTrades.getOtherCiv().getCivName(), "StatIcons/Acquire"};
                    $this$nextTurnTrades.getCivInfo().addNotification('[' + offer.getName() + "] from [" + $this$nextTurnTrades.getOtherCiv().getCivName() + "] will end in [3] turns", new DiplomacyAction($this$nextTurnTrades.getOtherCiv(), true), Notification.NotificationCategory.Trade, stringArray);
                    continue;
                }
                if (offer.getDuration() != 1) continue;
                String[] stringArray = new String[]{$this$nextTurnTrades.getOtherCiv().getCivName(), "StatIcons/Acquire"};
                $this$nextTurnTrades.getCivInfo().addNotification('[' + offer.getName() + "] from [" + $this$nextTurnTrades.getOtherCiv().getCivName() + "] will end next turn", new DiplomacyAction($this$nextTurnTrades.getOtherCiv(), true), Notification.NotificationCategory.Trade, stringArray);
            }
        }
    }

    private final void nextTurnDiplomaticModifiers(DiplomacyManager $this$nextTurnDiplomaticModifiers) {
        if ($this$nextTurnDiplomaticModifiers.getDiplomaticStatus() == DiplomaticStatus.Peace) {
            this.accumulateToAtMost($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.YearsOfPeace, 0.5f, 30.0f);
        } else {
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.YearsOfPeace, 0.5f);
        }
        int openBorders = 0;
        if ($this$nextTurnDiplomaticModifiers.getHasOpenBorders()) {
            ++openBorders;
        }
        if ($this$nextTurnDiplomaticModifiers.otherCivDiplomacy().getHasOpenBorders()) {
            ++openBorders;
        }
        if (openBorders > 0) {
            DiplomacyTurnManager.accumulateToAtMost$default(this, $this$nextTurnDiplomaticModifiers, DiplomaticModifiers.OpenBorders, (float)openBorders / 8.0f, 0.0f, 4, null);
        } else {
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.OpenBorders, 0.125f);
        }
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DeclaredWarOnUs, 0.125f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.WarMongerer, 0.5f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.CapturedOurCities, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.BetrayedDeclarationOfFriendship, 0.125f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.BetrayedDefensivePact, 0.0625f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.RefusedToNotSettleCitiesNearUs, 0.25f);
        for (Demand demand : Demand.getEntries()) {
            this.revertToZero($this$nextTurnDiplomaticModifiers, demand.getBetrayedPromiseDiplomacyMpodifier(), 0.125f);
        }
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.UnacceptableDemands, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.StealingTerritory, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DenouncedOurAllies, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DenouncedOurEnemies, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.Denunciation, 0.125f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.SpiedOnUs, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.StoleOurAlly, 0.5f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.GaveUsUnits, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.LiberatedCity, 0.125f);
        if ($this$nextTurnDiplomaticModifiers.hasModifier(DiplomaticModifiers.GaveUsGifts)) {
            float giftLoss = ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Ally ? 1.0f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Friend ? 1.5f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Favorable ? 2.0f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Neutral ? 2.5f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Competitor ? 5.0f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Enemy ? 7.5f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Unforgivable ? 10.0f : 2.5f))))))) * $this$nextTurnDiplomaticModifiers.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getGoldGiftDegradationMultiplier();
            float amountLost = RangesKt.coerceAtLeast(Math.abs($this$nextTurnDiplomaticModifiers.getModifier$core(DiplomaticModifiers.GaveUsGifts)) * giftLoss / (float)100, giftLoss / (float)5);
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.GaveUsGifts, amountLost);
        }
        $this$nextTurnDiplomaticModifiers.setFriendshipBasedModifier$core();
        $this$nextTurnDiplomaticModifiers.setDefensivePactBasedModifier$core();
        $this$nextTurnDiplomaticModifiers.setReligionBasedModifier$core();
        if (!$this$nextTurnDiplomaticModifiers.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) {
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DeclarationOfFriendship, 0.5f);
        }
        if (!$this$nextTurnDiplomaticModifiers.hasFlag(DiplomacyFlags.DefensivePact)) {
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DefensivePact, 1.0f);
        }
        if (!$this$nextTurnDiplomaticModifiers.getOtherCiv().isCityState()) {
            return;
        }
        if ($this$nextTurnDiplomaticModifiers.isRelationshipLevelLT(RelationshipLevel.Friend)) {
            if ($this$nextTurnDiplomaticModifiers.hasFlag(DiplomacyFlags.ProvideMilitaryUnit)) {
                $this$nextTurnDiplomaticModifiers.removeFlag(DiplomacyFlags.ProvideMilitaryUnit);
            }
            return;
        }
        Integer[] amountLost = new Integer[]{-1, 0, 1};
        int variance = ((Number)CollectionsKt.random((Collection)CollectionsKt.listOf(amountLost), Random.Default)).intValue();
        List<Unique> provideMilitaryUnitUniques = SequencesKt.toList(SequencesKt.filter(CityStateFunctions.Companion.getCityStateBonuses($this$nextTurnDiplomaticModifiers.getOtherCiv().getCityStateType(), $this$nextTurnDiplomaticModifiers.relationshipIgnoreAfraid(), UniqueType.CityStateMilitaryUnits), arg_0 -> DiplomacyTurnManager.nextTurnDiplomaticModifiers$lambda$0($this$nextTurnDiplomaticModifiers, arg_0)));
        if (provideMilitaryUnitUniques.isEmpty()) {
            $this$nextTurnDiplomaticModifiers.removeFlag(DiplomacyFlags.ProvideMilitaryUnit);
        }
        for (Unique unique : provideMilitaryUnitUniques) {
            if ($this$nextTurnDiplomaticModifiers.hasFlag(DiplomacyFlags.ProvideMilitaryUnit) && $this$nextTurnDiplomaticModifiers.getFlag(DiplomacyFlags.ProvideMilitaryUnit) <= Integer.parseInt(unique.getParams().get(0))) continue;
            $this$nextTurnDiplomaticModifiers.setFlag(DiplomacyFlags.ProvideMilitaryUnit, Integer.parseInt(unique.getParams().get(0)) + variance);
        }
    }

    private final void revertToZero(DiplomacyManager $this$revertToZero, DiplomaticModifiers modifier, float amount) {
        if (!$this$revertToZero.hasModifier(modifier)) {
            return;
        }
        float currentAmount = $this$revertToZero.getModifier$core(modifier);
        float speedAdjustedAmount = 0.67f * amount / $this$revertToZero.getCivInfo().getGameInfo().getSpeed().getModifier();
        if (speedAdjustedAmount >= Math.abs(currentAmount)) {
            $this$revertToZero.getDiplomaticModifiers().remove(modifier.name());
        } else if (currentAmount > 0.0f) {
            $this$revertToZero.addModifier(modifier, -speedAdjustedAmount);
        } else {
            $this$revertToZero.addModifier(modifier, speedAdjustedAmount);
        }
    }

    private final void accumulateToAtMost(DiplomacyManager $this$accumulateToAtMost, DiplomaticModifiers modifier, float amount, float maxAmount) {
        float currentAmount = $this$accumulateToAtMost.getModifier$core(modifier);
        if (currentAmount >= maxAmount) {
            return;
        }
        float speedAdjustedAmount = 0.67f * amount / $this$accumulateToAtMost.getCivInfo().getGameInfo().getSpeed().getModifier();
        if (speedAdjustedAmount >= maxAmount - currentAmount) {
            $this$accumulateToAtMost.setModifier(modifier, maxAmount);
        } else {
            $this$accumulateToAtMost.addModifier(modifier, speedAdjustedAmount);
        }
    }

    static /* synthetic */ void accumulateToAtMost$default(DiplomacyTurnManager diplomacyTurnManager, DiplomacyManager diplomacyManager, DiplomaticModifiers diplomaticModifiers, float f, float f2, int n, Object object) {
        if ((n & 4) != 0) {
            f2 = Float.MAX_VALUE;
        }
        diplomacyTurnManager.accumulateToAtMost(diplomacyManager, diplomaticModifiers, f, f2);
    }

    private static final boolean removeUntenableTrades$lambda$2(Trade $trade, Trade it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.equalTrade($trade.reverse());
    }

    private static final boolean nextTurnDiplomaticModifiers$lambda$0(DiplomacyManager $this_nextTurnDiplomaticModifiers, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.conditionalsApply($this_nextTurnDiplomaticModifiers.getCivInfo().getState());
    }
}

