/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.components.tilegroups.layers.UnitSpriteSlot;
import com.unciv.ui.images.ImageGetter;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a\u0004\u0018\u00010\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0006\u0010!\u001a\u00020\tJ\u001a\u0010\"\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\tH\u0014J\u0006\u0010&\u001a\u00020\tR\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerUnitSprite;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "<init>", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "act", "", "delta", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "civilianSlot", "Lcom/unciv/ui/components/tilegroups/layers/UnitSpriteSlot;", "militarySlot", "getSpriteSlot", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "showMilitaryUnit", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "updateSlot", "currentSlot", "isShown", "dim", "doUpdate", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "determineVisibility", "reset", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerUnitSprite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerUnitSprite.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerUnitSprite\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class TileLayerUnitSprite
extends TileLayer {
    @Nullable
    private UnitSpriteSlot civilianSlot;
    @Nullable
    private UnitSpriteSlot militarySlot;

    public TileLayerUnitSprite(@NotNull TileGroup tileGroup, float size) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size);
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return null;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        if (this.civilianSlot == null && this.militarySlot == null) {
            return;
        }
        super.draw(batch, parentAlpha);
    }

    @Nullable
    public final UnitSpriteSlot getSpriteSlot(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return unit.isCivilian() ? this.civilianSlot : this.militarySlot;
    }

    private final boolean showMilitaryUnit(Civilization viewingCiv) {
        return this.getTileGroup().isForceVisible() || viewingCiv.getViewableInvisibleUnitsTiles().contains(this.getTileGroup().getTile()) || !this.getTileGroup().getTile().hasEnemyInvisibleUnit(viewingCiv);
    }

    private final UnitSpriteSlot updateSlot(UnitSpriteSlot currentSlot, MapUnit unit, boolean isShown) {
        String location = "";
        String nationName = "";
        if (unit != null && isShown && UncivGame.Companion.getCurrent().getSettings().getShowPixelUnits()) {
            location = this.getStrings().getUnitImageLocation(unit);
            nationName = unit.getCiv().getCivName() + '-';
        }
        if (currentSlot == null && Intrinsics.areEqual(location, "")) {
            return null;
        }
        UnitSpriteSlot unitSpriteSlot = currentSlot;
        if (Intrinsics.areEqual(unitSpriteSlot != null ? unitSpriteSlot.getCurrentImageLocation() : null, nationName + location)) {
            return currentSlot;
        }
        if (Intrinsics.areEqual(location, "") || !ImageGetter.INSTANCE.imageExists(location)) {
            Object object = currentSlot;
            if (object != null && (object = ((UnitSpriteSlot)object).getSpriteGroup()) != null) {
                ((Actor)object).remove();
            }
            return null;
        }
        UnitSpriteSlot unitSpriteSlot2 = currentSlot;
        if (unitSpriteSlot2 == null) {
            UnitSpriteSlot unitSpriteSlot3;
            UnitSpriteSlot $this$updateSlot_u24lambda_u240 = unitSpriteSlot3 = new UnitSpriteSlot();
            boolean bl = false;
            this.addActor($this$updateSlot_u24lambda_u240.getSpriteGroup());
            unitSpriteSlot2 = unitSpriteSlot3;
        }
        UnitSpriteSlot slot = unitSpriteSlot2;
        slot.setCurrentImageLocation(nationName + location);
        slot.getSpriteGroup().clear();
        MapUnit mapUnit = unit;
        Intrinsics.checkNotNull(mapUnit);
        Nation nation = mapUnit.getCiv().getNation();
        Object object = new Color[]{null, nation.getInnerColor(), nation.getOuterColor()};
        ArrayList<Image> pixelUnitImages = ImageGetter.INSTANCE.getLayeredImageColored(location, (Color[])object);
        Iterator<Image> iterator2 = pixelUnitImages.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        object = iterator2;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Image pixelUnitImage = (Image)e;
            slot.getSpriteGroup().addActor(pixelUnitImage);
            TileLayer.setHexagonSize$default(this, pixelUnitImage, null, 1, null);
        }
        return slot;
    }

    public final void dim() {
        this.getColor().a = 0.5f;
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        boolean isPixelUnitsEnabled = UncivGame.Companion.getCurrent().getSettings().getShowPixelUnits();
        boolean isViewable = viewingCiv == null || this.isViewable(viewingCiv);
        boolean isVisibleMilitary = viewingCiv == null || this.showMilitaryUnit(viewingCiv);
        boolean isCivilianSlotShown = isPixelUnitsEnabled && isViewable;
        boolean isMilitarySlotShown = isPixelUnitsEnabled && isViewable && isVisibleMilitary;
        this.civilianSlot = this.updateSlot(this.civilianSlot, this.getTileGroup().getTile().getCivilianUnit(), isCivilianSlotShown);
        this.militarySlot = this.updateSlot(this.militarySlot, this.getTileGroup().getTile().getMilitaryUnit(), isMilitarySlotShown);
    }

    @Override
    protected void determineVisibility() {
        this.setVisible(this.civilianSlot != null || this.militarySlot != null);
    }

    public final void reset() {
        Object object;
        Object object2 = this.civilianSlot;
        if (object2 != null && (object2 = ((UnitSpriteSlot)object2).getSpriteGroup()) != null) {
            ((Actor)object2).remove();
        }
        if ((object = this.militarySlot) != null && (object = ((UnitSpriteSlot)object).getSpriteGroup()) != null) {
            ((Actor)object).remove();
        }
        this.civilianSlot = null;
        this.militarySlot = null;
    }
}

