/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.RulesetError;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.ConsoleAction;
import com.unciv.ui.screens.devconsole.ConsoleErrorException;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.devconsole.DevConsoleResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTriggerAction;", "Lcom/unciv/ui/screens/devconsole/ConsoleAction;", "topLevelCommand", "", "<init>", "(Ljava/lang/String;)V", "Companion", "core"})
public final class ConsoleTriggerAction
extends ConsoleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ConsoleTriggerAction(@NotNull String topLevelCommand) {
        Intrinsics.checkNotNullParameter(topLevelCommand, "topLevelCommand");
        super(ConsoleTriggerAction.Companion.getFormat(topLevelCommand), ConsoleTriggerAction.Companion.getAction(topLevelCommand));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J(\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002J:\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion;", "", "<init>", "()V", "getFormat", "", "topLevelCommand", "getAction", "Lkotlin/Function2;", "Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "", "Lcom/unciv/ui/screens/devconsole/CliInput;", "Lcom/unciv/ui/screens/devconsole/DevConsoleResponse;", "getCiv", "Lcom/unciv/logic/civilization/Civilization;", "console", "paramStack", "Lkotlin/collections/ArrayDeque;", "getUnique", "Lkotlin/Pair;", "Lcom/unciv/models/ruleset/unique/Unique;", "targetType", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "getUniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "param", "ConsoleRulesetObject", "core"})
    @SourceDebugExtension(value={"SMAP\nConsoleTriggerAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleTriggerAction.kt\ncom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,130:1\n1#2:131\n1563#3:132\n1634#3,3:133\n1740#3,3:138\n37#4,2:136\n37#4,2:141\n*S KotlinDebug\n*F\n+ 1 ConsoleTriggerAction.kt\ncom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion\n*L\n78#1:132\n78#1:133,3\n89#1:138,3\n78#1:136,2\n100#1:141,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String getFormat(String topLevelCommand) {
            String string;
            String string2 = topLevelCommand;
            if (((CharSequence)string2).length() > 0) {
                void c;
                char c2 = string2.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string3 = String.valueOf((char)c);
                Intrinsics.checkNotNull(string3, "null cannot be cast to non-null type java.lang.String");
                String string4 = string3.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
                String string5 = string2;
                int n = 1;
                String string6 = string5.substring(n);
                Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
                string = stringBuilder2.append(string6).toString();
            } else {
                string = string2;
            }
            String capitalized = string;
            return topLevelCommand + " activatetrigger <triggeredUnique|triggered" + capitalized + "UniqueTemplate> [uniqueParam]...";
        }

        private final Function2<DevConsolePopup, List<CliInput>, DevConsoleResponse> getAction(String topLevelCommand) {
            UniqueTarget targetType = Intrinsics.areEqual(topLevelCommand, "unit") ? UniqueTarget.UnitTriggerable : UniqueTarget.Triggerable;
            return (arg_0, arg_1) -> Companion.getAction$lambda$0(topLevelCommand, targetType, arg_0, arg_1);
        }

        private final Civilization getCiv(DevConsolePopup console, String topLevelCommand, ArrayDeque<CliInput> paramStack) {
            if (!Intrinsics.areEqual(topLevelCommand, "civ")) {
                return null;
            }
            CliInput cliInput = paramStack.firstOrNull();
            if (cliInput == null) {
                return null;
            }
            CliInput name = cliInput;
            Civilization civilization = console.getCivByNameOrNull$core(name);
            if (civilization == null) {
                return console.getScreen().getSelectedCiv();
            }
            Civilization civ = civilization;
            paramStack.removeFirst();
            return civ;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Unique, String> getUnique(DevConsolePopup console, String topLevelCommand, ArrayDeque<CliInput> paramStack, UniqueTarget targetType) {
            String replaceWith;
            boolean onlyDeprecated;
            RulesetErrorList errors;
            Unique unique;
            block10: {
                boolean bl;
                RulesetError it;
                CliInput cliInput = paramStack.removeFirstOrNull();
                if (cliInput == null || (cliInput = cliInput.toMethod(CliInput.Method.Quoted)) == null) {
                    throw new ConsoleErrorException("Parameter triggeredUnique missing");
                }
                CliInput uniqueText = cliInput;
                UniqueType uniqueType = this.getUniqueType(uniqueText, targetType);
                if (!((Collection)paramStack).isEmpty() && uniqueText.equals(uniqueType.getText())) {
                    void $this$toTypedArray$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = paramStack;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        CliInput cliInput2 = (CliInput)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(((CliInput)((Object)it)).originalUnquoted());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] params = thisCollection$iv.toArray(new String[0]);
                    uniqueText = new CliInput(TranslationsKt.fillPlaceholders(uniqueType.getPlaceholderText(), Arrays.copyOf(params, params.length)), CliInput.Method.Quoted);
                }
                unique = new Unique(uniqueText.getContent(), targetType, "DevConsole");
                UniqueValidator validator = new UniqueValidator(console.getGameInfo$core().getRuleset());
                errors = validator.checkUnique(unique, false, new ConsoleRulesetObject(targetType), true);
                if (!errors.isNotOK()) {
                    return TuplesKt.to(unique, errors.getErrorText(true));
                }
                Iterable $this$all$iv = errors;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (RulesetError)element$iv;
                        boolean bl3 = false;
                        if (it.getErrorSeverityToReport() == RulesetErrorSeverity.ErrorOptionsOnly && StringsKt.contains$default((CharSequence)it.getText(), "deprecated", false, 2, null)) continue;
                        bl = false;
                        break block10;
                    }
                    bl = onlyDeprecated = true;
                }
            }
            if (!onlyDeprecated) {
                throw new ConsoleErrorException(errors.getErrorText(true));
            }
            Object object = unique.getType();
            String string = object != null && (object = object.getDeprecationAnnotation()) != null && (object = object.replaceWith()) != null ? object.expression() : (replaceWith = null);
            if (replaceWith != null) {
                List<String> originalPlaceholders = TranslationsKt.getPlaceholderParameters(unique.getText());
                if (originalPlaceholders.size() == TranslationsKt.getPlaceholderParameters(replaceWith).size()) {
                    Collection $this$toTypedArray$iv = originalPlaceholders;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    replaceWith = TranslationsKt.fillPlaceholders(replaceWith, Arrays.copyOf(stringArray, stringArray.length));
                }
                console.getTextField$core().setText(topLevelCommand + " activatetrigger \"" + replaceWith + '\"');
                console.getTextField$core().setCursorPosition(1000);
            }
            return TuplesKt.to(unique, errors.getErrorText(true));
        }

        private final UniqueType getUniqueType(CliInput param, UniqueTarget targetType) {
            CliInput filterText = new CliInput(TranslationsKt.getPlaceholderText(param.getContent()), param.getMethod());
            List<UniqueType> uniqueTypes = SequencesKt.toList(SequencesKt.take(SequencesKt.filter(CollectionsKt.asSequence((Iterable)UniqueType.getEntries()), arg_0 -> Companion.getUniqueType$lambda$0(param, filterText, arg_0)), 4));
            if (uniqueTypes.isEmpty()) {
                throw new ConsoleErrorException("" + '`' + param + "` not found in UniqueTypes");
            }
            if (uniqueTypes.size() > 1) {
                throw new ConsoleErrorException("" + '`' + param + "` has ambiguous UniqueType: " + CollectionsKt.joinToString$default(uniqueTypes, null, null, null, 3, null, Companion::getUniqueType$lambda$1, 23, null) + '?');
            }
            UniqueType uniqueType = CollectionsKt.first(uniqueTypes);
            if (uniqueType.canAcceptUniqueTarget(targetType)) {
                return uniqueType;
            }
            throw new ConsoleErrorException("" + '`' + param + "` is not a Triggerable");
        }

        private static final DevConsoleResponse getAction$lambda$0(String $topLevelCommand, UniqueTarget $targetType, DevConsolePopup console, List params) {
            Tile ex3;
            MapUnit ex22;
            City city;
            Intrinsics.checkNotNullParameter(console, "console");
            Intrinsics.checkNotNullParameter(params, "params");
            ArrayDeque<CliInput> paramStack = new ArrayDeque<CliInput>(params);
            try {
                city = console.getSelectedCity$core();
            }
            catch (ConsoleErrorException ex22) {
                if (Intrinsics.areEqual($topLevelCommand, "city")) {
                    throw ex22;
                }
                city = null;
            }
            City city2 = city;
            try {
                ex22 = console.getSelectedUnit$core();
            }
            catch (ConsoleErrorException ex3) {
                if (Intrinsics.areEqual($topLevelCommand, "unit")) {
                    throw ex3;
                }
                ex22 = null;
            }
            MapUnit unit = ex22;
            try {
                ex3 = console.getSelectedTile$core();
            }
            catch (ConsoleErrorException ex4) {
                if (Intrinsics.areEqual($topLevelCommand, "tile")) {
                    throw ex4;
                }
                ex3 = null;
            }
            Tile tile = ex3;
            Civilization civilization = Companion.getCiv(console, $topLevelCommand, paramStack);
            if (civilization == null) {
                City city3 = city2;
                civilization = city3 != null ? city3.getCiv() : null;
                if (civilization == null) {
                    MapUnit mapUnit = unit;
                    civilization = mapUnit != null ? mapUnit.getCiv() : null;
                    if (civilization == null) {
                        Tile tile2 = tile;
                        civilization = tile2 != null ? tile2.getOwner() : null;
                        if (civilization == null) {
                            throw new ConsoleErrorException("A trigger command needs a Civilization from some source");
                        }
                    }
                }
            }
            Civilization civ = civilization;
            Pair<Unique, String> pair = Companion.getUnique(console, $topLevelCommand, paramStack, $targetType);
            Unique unique = pair.component1();
            String hint = pair.component2();
            return !UniqueTriggerActivation.INSTANCE.triggerUnique(unique, civ, city2, unit, tile, null, "due to cheating") ? DevConsoleResponse.Companion.error("The `triggerUnique` call failed\n" + hint) : (((CharSequence)hint).length() == 0 ? DevConsoleResponse.Companion.getOK() : DevConsoleResponse.Companion.hint(hint));
        }

        private static final boolean getUniqueType$lambda$0(CliInput $param, CliInput $filterText, UniqueType it) {
            Intrinsics.checkNotNullParameter((Object)it, "it");
            return Intrinsics.areEqual(new CliInput(it.getPlaceholderText(), $param.getMethod()), $filterText);
        }

        private static final CharSequence getUniqueType$lambda$1(UniqueType it) {
            Intrinsics.checkNotNullParameter((Object)it, "it");
            return it.getText();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion$ConsoleRulesetObject;", "Lcom/unciv/models/ruleset/RulesetObject;", "targetType", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "<init>", "(Lcom/unciv/models/ruleset/unique/UniqueTarget;)V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getUniqueTarget", "makeLink", "core"})
        private static final class ConsoleRulesetObject
        extends RulesetObject {
            @NotNull
            private final UniqueTarget targetType;
            @NotNull
            private String name;

            public ConsoleRulesetObject(@NotNull UniqueTarget targetType) {
                Intrinsics.checkNotNullParameter((Object)targetType, "targetType");
                this.targetType = targetType;
                this.name = "DevConsole";
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @Override
            public void setName(@NotNull String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.name = string;
            }

            @Override
            @NotNull
            public UniqueTarget getUniqueTarget() {
                return this.targetType;
            }

            @Override
            @NotNull
            public String makeLink() {
                return "";
            }
        }
    }
}

