/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.tools.texturepacker.TexturePacker;
import com.badlogic.gdx.utils.Json;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u0010J(\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unciv/app/desktop/ImagePacker;", "", "<init>", "()V", "builtinImageSourcePath", "", "builtinAtlasDestinationPath", "modsBasePath", "imagesPathBase", "existCheck2", "settingsFileName", "suffixUsingLinear", "atlasListFileName", "imageExtensions", "", "getDefaultSettings", "Lcom/badlogic/gdx/tools/texturepacker/TexturePacker$Settings;", "packImages", "", "isRunFromJAR", "", "dataDirectory", "packImagesPerMod", "input", "output", "defaultSettings", "packImagesIfOutdated", "packFileName", "imageFolders", "Lkotlin/sequences/Sequence;", "Lcom/unciv/app/desktop/ImagePacker$ImageFolderResult;", "parent", "Ljava/io/File;", "ImageFolderResult", "desktop"})
@SourceDebugExtension(value={"SMAP\nImagePacker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePacker.kt\ncom/unciv/app/desktop/ImagePacker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,163:1\n2296#2,2:164\n*S KotlinDebug\n*F\n+ 1 ImagePacker.kt\ncom/unciv/app/desktop/ImagePacker\n*L\n135#1:164,2\n*E\n"})
public final class ImagePacker {
    @NotNull
    public static final ImagePacker INSTANCE = new ImagePacker();
    @NotNull
    private static final String builtinImageSourcePath = "..";
    @NotNull
    private static final String builtinAtlasDestinationPath = ".";
    @NotNull
    private static final String modsBasePath = "mods";
    @NotNull
    private static final String imagesPathBase = "Images";
    @NotNull
    private static final String existCheck2 = "Images.Icons";
    @NotNull
    private static final String settingsFileName = "TexturePacker.settings";
    @NotNull
    private static final String suffixUsingLinear = "Icons";
    @NotNull
    private static final String atlasListFileName = "Atlases.json";
    @NotNull
    private static final List<String> imageExtensions;

    private ImagePacker() {
    }

    private final TexturePacker.Settings getDefaultSettings() {
        TexturePacker.Settings settings;
        TexturePacker.Settings $this$getDefaultSettings_u24lambda_u240 = settings = new TexturePacker.Settings();
        boolean bl = false;
        $this$getDefaultSettings_u24lambda_u240.maxWidth = 2048;
        $this$getDefaultSettings_u24lambda_u240.maxHeight = 2048;
        $this$getDefaultSettings_u24lambda_u240.combineSubdirectories = true;
        $this$getDefaultSettings_u24lambda_u240.pot = true;
        $this$getDefaultSettings_u24lambda_u240.fast = true;
        $this$getDefaultSettings_u24lambda_u240.paddingX = 8;
        $this$getDefaultSettings_u24lambda_u240.paddingY = 8;
        $this$getDefaultSettings_u24lambda_u240.duplicatePadding = true;
        $this$getDefaultSettings_u24lambda_u240.filterMin = Texture.TextureFilter.MipMapLinearLinear;
        $this$getDefaultSettings_u24lambda_u240.filterMag = Texture.TextureFilter.MipMapLinearLinear;
        return settings;
    }

    public final void packImages(boolean isRunFromJAR, @NotNull String dataDirectory) {
        File modDirectory;
        Intrinsics.checkNotNullParameter(dataDirectory, "dataDirectory");
        long startTime = System.currentTimeMillis();
        TexturePacker.Settings defaultSettings = this.getDefaultSettings();
        if (!isRunFromJAR) {
            this.packImagesPerMod(builtinImageSourcePath, builtinAtlasDestinationPath, defaultSettings);
        }
        if ((modDirectory = new File(dataDirectory, modsBasePath)).exists()) {
            File[] fileArray = modDirectory.listFiles();
            Intrinsics.checkNotNull(fileArray);
            for (File mod : fileArray) {
                if (mod.isHidden()) continue;
                try {
                    String string = mod.getPath();
                    Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
                    String string2 = mod.getPath();
                    Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
                    this.packImagesPerMod(string, string2, defaultSettings);
                }
                catch (Throwable ex) {
                    Throwable innerException = ex;
                    while (innerException.getCause() != null && innerException.getCause() != innerException) {
                        Intrinsics.checkNotNull(innerException.getCause());
                    }
                    if (innerException == ex) {
                        Log.INSTANCE.error("Exception in ImagePacker for mod " + mod.getName() + ": " + ex.getMessage(), new Object[0]);
                        continue;
                    }
                    Log.INSTANCE.error("Exception in ImagePacker for mod " + mod.getName() + ": " + ex.getMessage() + " (" + innerException.getMessage() + ')', new Object[0]);
                }
            }
        }
        long texturePackingTime = System.currentTimeMillis() - startTime;
        Object[] objectArray = new Object[]{texturePackingTime};
        LogKt.debug("Packing textures - %sms", objectArray);
    }

    public final void packImagesPerMod(@NotNull String input2, @NotNull String output2, @NotNull TexturePacker.Settings defaultSettings) {
        Intrinsics.checkNotNullParameter(input2, "input");
        Intrinsics.checkNotNullParameter(output2, "output");
        Intrinsics.checkNotNullParameter(defaultSettings, "defaultSettings");
        File baseDir = new File(input2);
        if (!new File(baseDir, imagesPathBase).exists() && !new File(baseDir, existCheck2).exists()) {
            return;
        }
        List atlasList = new ArrayList();
        Iterator<ImageFolderResult> iterator2 = this.imageFolders(baseDir).iterator();
        while (iterator2.hasNext()) {
            ImageFolderResult imageFolderResult = iterator2.next();
            String file = imageFolderResult.component1();
            String packFileName = imageFolderResult.component2();
            ((Collection)atlasList).add(packFileName);
            defaultSettings.filterMag = StringsKt.endsWith$default(file, suffixUsingLinear, false, 2, null) ? Texture.TextureFilter.Linear : Texture.TextureFilter.MipMapLinearLinear;
            this.packImagesIfOutdated(defaultSettings, file, output2, packFileName);
        }
        File listFile = new File(output2, atlasListFileName);
        if (atlasList.isEmpty()) {
            listFile.delete();
        } else {
            FilesKt.writeText$default(listFile, CollectionsKt.joinToString$default(CollectionsKt.sorted(atlasList), ",", "[", "]", 0, null, null, 56, null), null, 2, null);
        }
    }

    public static /* synthetic */ void packImagesPerMod$default(ImagePacker imagePacker, String string, String string2, TexturePacker.Settings settings, int n, Object object) {
        if ((n & 4) != 0) {
            settings = imagePacker.getDefaultSettings();
        }
        imagePacker.packImagesPerMod(string, string2, settings);
    }

    private final void packImagesIfOutdated(TexturePacker.Settings defaultSettings, String input2, String output2, String packFileName) {
        TexturePacker.Settings settings;
        File settingsFile;
        File atlasFile = new File(output2, packFileName + ".atlas");
        if (atlasFile.exists() && new File(output2, packFileName + ".png").exists()) {
            boolean bl;
            block5: {
                long atlasModTime = atlasFile.lastModified();
                Sequence<File> $this$none$iv = ImagePacker.packImagesIfOutdated$listTree(new File(input2));
                boolean $i$f$none = false;
                Iterator<File> iterator2 = $this$none$iv.iterator();
                while (iterator2.hasNext()) {
                    BasicFileAttributes attr;
                    File element$iv;
                    File it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(Files.readAttributes(it.toPath(), BasicFileAttributes.class, new LinkOption[0]), "readAttributes(...)");
                    long createdAt = attr.creationTime().toMillis();
                    if (!(!(!imageExtensions.contains(FilesKt.getExtension(it)) && !Intrinsics.areEqual(it.getName(), settingsFileName) || it.lastModified() <= atlasModTime && createdAt <= atlasModTime))) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        if ((settingsFile = new File(input2, settingsFileName)).exists()) {
            File file = settingsFile;
            Charset charset = Charsets.UTF_8;
            settings = new Json().fromJson(TexturePacker.Settings.class, new InputStreamReader((InputStream)new FileInputStream(file), charset));
        } else {
            settings = defaultSettings;
        }
        TexturePacker.Settings settings2 = settings;
        TexturePacker.process(settings2, input2, output2, packFileName);
    }

    private final Sequence<ImageFolderResult> imageFolders(File parent) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super ImageFolderResult>, Continuation<? super Unit>, Object>(parent, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ File $parent;
            {
                this.$parent = $parent;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        v0 = this.$parent.listFiles();
                        Intrinsics.checkNotNull(v0);
                        var3_4 = v0;
                        var4_5 = 0;
                        var5_6 = var3_4.length;
lbl11:
                        // 2 sources

                        while (var4_5 < var5_6) {
                            folder = var3_4[var4_5];
                            if (folder.isDirectory()) {
                                Intrinsics.checkNotNull(folder);
                                if (Intrinsics.areEqual(FilesKt.getNameWithoutExtension(folder), "Images")) {
                                    atlasName = Intrinsics.areEqual(folder.getName(), "Images") != false ? "game" : FilesKt.getExtension(folder);
                                    v1 = folder.getPath();
                                    Intrinsics.checkNotNullExpressionValue(v1, "getPath(...)");
                                    this.L$0 = $this$sequence;
                                    this.L$1 = var3_4;
                                    this.L$2 = SpillingKt.nullOutSpilledVariable(folder);
                                    this.L$3 = SpillingKt.nullOutSpilledVariable(atlasName);
                                    this.I$0 = var4_5;
                                    this.I$1 = var5_6;
                                    this.label = 1;
                                    v2 = $this$sequence.yield(new ImageFolderResult(v1, atlasName), this);
                                    if (v2 == var8_3) {
                                        return var8_3;
                                    }
                                }
                            }
                            ** GOTO lbl39
                        }
                        break;
                    }
                    case 1: {
                        var5_6 = this.I$1;
                        var4_5 = this.I$0;
                        atlasName = (String)this.L$3;
                        folder = (File)this.L$2;
                        var3_4 = (File[])this.L$1;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl39:
                        // 2 sources

                        ++var4_5;
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super ImageFolderResult>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super ImageFolderResult> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final Sequence packImagesIfOutdated$listTree$lambda$0(File it) {
        Intrinsics.checkNotNull(it);
        return ImagePacker.packImagesIfOutdated$listTree(it);
    }

    private static final Sequence<File> packImagesIfOutdated$listTree(File $this$packImagesIfOutdated_u24listTree) {
        Sequence<File> sequence;
        if ($this$packImagesIfOutdated_u24listTree.isFile()) {
            sequence = SequencesKt.sequenceOf($this$packImagesIfOutdated_u24listTree);
        } else if ($this$packImagesIfOutdated_u24listTree.isDirectory()) {
            File[] fileArray = $this$packImagesIfOutdated_u24listTree.listFiles();
            Intrinsics.checkNotNull(fileArray);
            sequence = SequencesKt.flatMap(ArraysKt.asSequence(fileArray), ImagePacker::packImagesIfOutdated$listTree$lambda$0);
        } else {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    static {
        String[] stringArray = new String[]{"png", "jpg", "jpeg"};
        imageExtensions = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/unciv/app/desktop/ImagePacker$ImageFolderResult;", "", "folder", "", "atlasName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFolder", "()Ljava/lang/String;", "getAtlasName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "desktop"})
    private static final class ImageFolderResult {
        @NotNull
        private final String folder;
        @NotNull
        private final String atlasName;

        public ImageFolderResult(@NotNull String folder, @NotNull String atlasName) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            Intrinsics.checkNotNullParameter(atlasName, "atlasName");
            this.folder = folder;
            this.atlasName = atlasName;
        }

        @NotNull
        public final String getFolder() {
            return this.folder;
        }

        @NotNull
        public final String getAtlasName() {
            return this.atlasName;
        }

        @NotNull
        public final String component1() {
            return this.folder;
        }

        @NotNull
        public final String component2() {
            return this.atlasName;
        }

        @NotNull
        public final ImageFolderResult copy(@NotNull String folder, @NotNull String atlasName) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            Intrinsics.checkNotNullParameter(atlasName, "atlasName");
            return new ImageFolderResult(folder, atlasName);
        }

        public static /* synthetic */ ImageFolderResult copy$default(ImageFolderResult imageFolderResult, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = imageFolderResult.folder;
            }
            if ((n & 2) != 0) {
                string2 = imageFolderResult.atlasName;
            }
            return imageFolderResult.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ImageFolderResult(folder=" + this.folder + ", atlasName=" + this.atlasName + ')';
        }

        public int hashCode() {
            int result2 = this.folder.hashCode();
            result2 = result2 * 31 + this.atlasName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImageFolderResult)) {
                return false;
            }
            ImageFolderResult imageFolderResult = (ImageFolderResult)other;
            if (!Intrinsics.areEqual(this.folder, imageFolderResult.folder)) {
                return false;
            }
            return Intrinsics.areEqual(this.atlasName, imageFolderResult.atlasName);
        }
    }
}

