/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.unciv.logic.map.mapunit.MapUnitCache;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.UniqueFlag;
import com.unciv.models.ruleset.unique.UniqueParameterType;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.utils.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/unciv/app/desktop/UniqueDocsWriter;", "", "<init>", "()V", "toLink", "", "string", "escapeHtml", "indent", "", "write", "", "writeUniqueTypes", "writeCountables", "Companion", "desktop"})
@SourceDebugExtension(value={"SMAP\nUniqueDocsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueDocsWriter.kt\ncom/unciv/app/desktop/UniqueDocsWriter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,205:1\n776#2,2:206\n793#2,4:208\n614#2:218\n1586#3:212\n1661#3,3:213\n37#4,2:216\n*S KotlinDebug\n*F\n+ 1 UniqueDocsWriter.kt\ncom/unciv/app/desktop/UniqueDocsWriter\n*L\n94#1:206,2\n94#1:208,4\n152#1:218\n130#1:212\n130#1:213,3\n130#1:216,2\n*E\n"})
public final class UniqueDocsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String uniqueTypesFileName = "../../docs/Modders/uniques.md";
    @NotNull
    private static final String countablesFileName = "../../docs/Modders/Unique-parameters.md";
    @NotNull
    private static final String countablesBeginMarker = "[//]: # (Countables automatically generated BEGIN)";
    @NotNull
    private static final String countablesEndMarker = "[//]: # (Countables automatically generated END)";
    private static final boolean showUniqueOnOneTarget = false;
    private static final boolean showInheritedTargets = false;

    @NotNull
    public final String toLink(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        char[] cArray = new char[]{' '};
        return '#' + CollectionsKt.joinToString$default(StringsKt.split$default((CharSequence)string, cArray, false, 0, 6, null), "-", null, null, 0, null, UniqueDocsWriter::toLink$lambda$0, 30, null);
    }

    private final String escapeHtml(String $this$escapeHtml, int indent) {
        StringBuilder stringBuilder;
        int n = $this$escapeHtml.length() + indent + 6;
        StringBuilder $this$escapeHtml_u24lambda_u240 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        boolean inCodeBlock = false;
        int n2 = $this$escapeHtml.length();
        block7: for (int i = 0; i < n2; ++i) {
            char c = $this$escapeHtml.charAt(i);
            switch (c) {
                case '`': {
                    inCodeBlock = !inCodeBlock;
                    StringBuilder stringBuilder2 = $this$escapeHtml_u24lambda_u240.append('`');
                    continue block7;
                }
                case '&': {
                    StringBuilder stringBuilder2 = $this$escapeHtml_u24lambda_u240.append("&amp;");
                    continue block7;
                }
                case '<': {
                    StringBuilder stringBuilder2 = $this$escapeHtml_u24lambda_u240.append(inCodeBlock ? "<" : "&lt;");
                    continue block7;
                }
                case '>': {
                    StringBuilder stringBuilder2 = $this$escapeHtml_u24lambda_u240.append(inCodeBlock ? ">" : "&gt;");
                    continue block7;
                }
                case '\n': {
                    StringBuilder stringBuilder2 = $this$escapeHtml_u24lambda_u240.append("\n\n" + StringsKt.repeat("\t", indent));
                    continue block7;
                }
                default: {
                    StringBuilder stringBuilder2 = $this$escapeHtml_u24lambda_u240.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ String escapeHtml$default(UniqueDocsWriter uniqueDocsWriter, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return uniqueDocsWriter.escapeHtml(string, n);
    }

    public final void write() {
        this.writeUniqueTypes();
        this.writeCountables();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeUniqueTypes() {
        Object object;
        Map.Entry $this$associateWithTo$iv$iv2;
        Sequence $this$associateWith$iv = CollectionsKt.asSequence((Iterable)UniqueTarget.getEntries());
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence sequence = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        Iterator<Object> iterator2 = $this$associateWithTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            void target;
            Object element$iv$iv = iterator2.next();
            UniqueTarget uniqueTarget = (UniqueTarget)((Object)element$iv$iv);
            Object t = element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            List list2 = SequencesKt.toList(SequencesKt.distinct(SequencesKt.flatMap(UniqueDocsWriter.Companion.allTargets((UniqueTarget)target), UniqueDocsWriter::writeUniqueTypes$lambda$1$0)));
            object.put(t, list2);
        }
        Map targetTypesToUniques = destination$iv$iv;
        int capacity = 25 + targetTypesToUniques.size() + UniqueType.getEntries().size() * 16;
        ArrayList lines2 = new ArrayList(capacity);
        ((Collection)lines2).add("# Uniques");
        ((Collection)lines2).add("An overview of uniques can be found [here](../Developers/Uniques.md)");
        ((Collection)lines2).add("\nSimple unique parameters are explained by mouseover. Complex parameters are explained in [Unique parameter types](Unique-parameters.md)");
        ((Collection)lines2).add("");
        for (Map.Entry $this$associateWithTo$iv$iv2 : targetTypesToUniques.entrySet()) {
            UniqueTarget targetType = (UniqueTarget)((Object)$this$associateWithTo$iv$iv2.getKey());
            List uniqueTypes = (List)$this$associateWithTo$iv$iv2.getValue();
            if (uniqueTypes.isEmpty()) continue;
            ((Collection)lines2).add("## " + targetType.name() + " uniques");
            if (((CharSequence)targetType.getDocumentationString()).length() > 0) {
                ((Collection)lines2).add("!!! note \"\"\n\n    " + targetType.getDocumentationString() + '\n');
            }
            for (UniqueType uniqueType : uniqueTypes) {
                if (uniqueType.getDeprecationAnnotation() != null) continue;
                String uniqueText = targetType.getModifierType() != UniqueTarget.ModifierType.None ? "&lt;" + uniqueType.getText() + "&gt;" : uniqueType.getText();
                ((Collection)lines2).add("??? example  \"" + uniqueText + '\"');
                if (uniqueType.getDocDescription() != null) {
                    Collection collection = lines2;
                    StringBuilder stringBuilder = new StringBuilder().append('\t');
                    String string = uniqueType.getDocDescription();
                    Intrinsics.checkNotNull(string);
                    collection.add(stringBuilder.append(this.escapeHtml(string, 1)).append('\n').toString());
                }
                if (!((Collection)uniqueType.getParameterTypeMap()).isEmpty()) {
                    void $this$toTypedArray$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = uniqueType.getParameterTypeMap();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        List list3 = (List)item$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl = false;
                        object.add(((UniqueParameterType)((Object)CollectionsKt.first(it))).getDocExample());
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] paramExamples = thisCollection$iv.toArray(new String[0]);
                    ((Collection)lines2).add("\tExample: \"" + TranslationsKt.fillPlaceholders(uniqueText, Arrays.copyOf(paramExamples, paramExamples.length)) + "\"\n");
                }
                if (uniqueType.getFlags().contains((Object)UniqueFlag.AcceptsSpeedModifier)) {
                    ((Collection)lines2).add("\tThis unique's effect can be modified with &lt;" + UniqueType.ModifiedByGameSpeed.getText() + "&gt;\n");
                }
                if (uniqueType.getFlags().contains((Object)UniqueFlag.AcceptsGameProgressModifier)) {
                    ((Collection)lines2).add("\tThis unique's effect can be modified with &lt;" + UniqueType.ModifiedByGameProgress.getText() + "&gt;\n");
                }
                if (MapUnitCache.Companion.getUnitMovementUniques().contains((Object)uniqueType)) {
                    ((Collection)lines2).add("\tDue to performance considerations, this unique is cached, thus conditionals that may change within a turn may not work.\n");
                }
                if (uniqueType.getFlags().contains((Object)UniqueFlag.NoConditionals)) {
                    ((Collection)lines2).add("\tThis unique does not support conditionals.\n");
                }
                if (uniqueType.getFlags().contains((Object)UniqueFlag.HiddenToUsers)) {
                    ((Collection)lines2).add("\tThis unique is automatically hidden from users.\n");
                }
                ((Collection)lines2).add("\tApplicable to: " + SequencesKt.joinToString$default(SequencesKt.sorted(UniqueDocsWriter.Companion.allTargets(uniqueType)), null, null, null, 0, null, null, 63, null));
                ((Collection)lines2).add("");
            }
        }
        ((Collection)lines2).add("");
        Sequence $this$sortedBy$iv = CollectionsKt.asSequence((Iterable)UniqueParameterType.getEntries());
        boolean $i$f$sortedBy = false;
        Iterator iterator3 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                UniqueParameterType it = (UniqueParameterType)((Object)a);
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getParameterName());
                it = (UniqueParameterType)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getParameterName()));
            }
        }).iterator();
        while (iterator3.hasNext()) {
            UniqueParameterType paramType = (UniqueParameterType)((Object)iterator3.next());
            if (paramType.getDocDescription() == null) continue;
            String string = paramType.getDocDescription();
            Intrinsics.checkNotNull(string);
            String punctuation = CharsKt.getCategory(StringsKt.last(string)) == CharsKt.getCategory('.') ? "" : ".";
            ((Collection)lines2).add("*[" + paramType.getParameterName() + "]: " + paramType.getDocDescription() + punctuation);
        }
        FilesKt.writeText$default(new File(uniqueTypesFileName), CollectionsKt.joinToString$default(lines2, "\n", null, null, 0, null, null, 62, null), null, 2, null);
    }

    private final void writeCountables() {
        Object[] objectArray;
        int truncateEnd;
        String string;
        File file = new File(countablesFileName);
        try {
            string = FilesKt.readText(file, Charsets.UTF_8);
        }
        catch (Throwable ex) {
            Log.INSTANCE.error("Can't read ../../docs/Modders/Unique-parameters.md", ex);
            return;
        }
        String oldContent = string;
        int truncateBegin = StringsKt.indexOf$default((CharSequence)oldContent, countablesBeginMarker, 0, false, 6, null);
        if (truncateBegin < 0) {
            Object[] ex = new Object[]{countablesBeginMarker, countablesFileName};
            Log.INSTANCE.error("Can't find `%s` in %s", ex);
        }
        if ((truncateEnd = StringsKt.indexOf$default((CharSequence)oldContent, countablesEndMarker, 0, false, 6, null)) < 0) {
            objectArray = new Object[]{countablesEndMarker, countablesFileName};
            Log.INSTANCE.error("Can't find `%s` in %s", objectArray);
        }
        if (truncateBegin < 0 || truncateEnd < 0) {
            return;
        }
        if (truncateEnd < truncateBegin) {
            objectArray = new Object[]{countablesEndMarker, countablesFileName};
            Log.INSTANCE.error("Inverted Countables markers in %s", objectArray);
            return;
        }
        StringBuilder newContent = new StringBuilder(oldContent.length());
        newContent.append(oldContent, 0, truncateBegin + 50);
        newContent.append('\n');
        for (Countables countable : Countables.getEntries()) {
            if (countable.getDeprecationAnnotation() != null) continue;
            newContent.append("-   " + countable.getDocumentationHeader()).append('\n');
            newContent.append("    - Example: `Only available <when number of [" + countable.getExample() + "] is more than [0]>`").append('\n');
            for (String extraLine : countable.getDocumentationStrings()) {
                newContent.append("    - ");
                newContent.append(extraLine).append('\n');
            }
        }
        newContent.append('\n');
        newContent.append(oldContent, truncateEnd, oldContent.length());
        try {
            String string2 = newContent.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            FilesKt.writeText(file, string2, Charsets.UTF_8);
        }
        catch (Throwable ex) {
            Log.INSTANCE.error("Can't write ../../docs/Modders/Unique-parameters.md", ex);
            return;
        }
    }

    private static final CharSequence toLink$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return string;
    }

    private static final Sequence writeUniqueTypes$lambda$1$0(UniqueTarget inheritedTarget) {
        Intrinsics.checkNotNullParameter((Object)inheritedTarget, "inheritedTarget");
        return UniqueDocsWriter.Companion.allUniqueTypes(inheritedTarget);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000eH\u0002J\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\r*\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/app/desktop/UniqueDocsWriter$Companion;", "", "<init>", "()V", "uniqueTypesFileName", "", "countablesFileName", "countablesBeginMarker", "countablesEndMarker", "showUniqueOnOneTarget", "", "showInheritedTargets", "allTargets", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "Lcom/unciv/models/ruleset/unique/UniqueType;", "allUniqueTypes", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        private final Sequence<UniqueTarget> allTargets(UniqueTarget $this$allTargets) {
            return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UniqueTarget>, Continuation<? super Unit>, Object>($this$allTargets, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ UniqueTarget $this_allTargets;
                {
                    this.$this_allTargets = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    SequenceScope sequenceScope = (SequenceScope)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$sequence;
                            ResultKt.throwOnFailure($result);
                            this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                            this.label = 1;
                            Object object2 = $this$sequence.yield(this.$this_allTargets, this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    Function2<SequenceScope<? super UniqueTarget>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                public final Object invoke(SequenceScope<? super UniqueTarget> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        private final Sequence<UniqueTarget> allTargets(UniqueType $this$allTargets) {
            return SequencesKt.distinct(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)$this$allTargets.getTargetTypes()), Companion::allTargets$lambda$0));
        }

        private final Sequence<UniqueType> allUniqueTypes(UniqueTarget $this$allUniqueTypes) {
            return SequencesKt.filter(CollectionsKt.asSequence((Iterable)UniqueType.getEntries()), arg_0 -> Companion.allUniqueTypes$lambda$0($this$allUniqueTypes, arg_0));
        }

        private static final Sequence allTargets$lambda$0(UniqueTarget it) {
            Intrinsics.checkNotNullParameter((Object)it, "it");
            return Companion.allTargets(it);
        }

        private static final boolean allUniqueTypes$lambda$0(UniqueTarget $this_allUniqueTypes, UniqueType it) {
            Intrinsics.checkNotNullParameter((Object)it, "it");
            return it.getTargetTypes().contains((Object)$this_allUniqueTypes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

