/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.civilization.MotivationToAttackAutomation;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0002J\"\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\n\u001a\u00020\u0007H\u0003J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000fH\u0003J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/unciv/logic/automation/civilization/UseGoldAutomation;", "", "<init>", "()V", "useGold", "", "civ", "Lcom/unciv/logic/civilization/Civilization;", "useGoldForCityStates", "maybeBuyCityTiles", "civInfo", "getHighlyDesirableTilesToCityMap", "Ljava/util/SortedMap;", "Lcom/unciv/logic/map/tile/Tile;", "", "Lcom/unciv/logic/city/City;", "isHighlyDesirableTile", "", "it", "city", "tryGainInfluence", "cityState", "core"})
@SourceDebugExtension(value={"SMAP\nUseGoldAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseGoldAutomation.kt\ncom/unciv/logic/automation/civilization/UseGoldAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,179:1\n1080#2:180\n777#2:181\n873#2,2:182\n1300#2,2:184\n1315#2,4:186\n2439#2,14:191\n777#2:205\n873#2,2:206\n1#3:190\n383#4,7:208\n2296#5,2:215\n*S KotlinDebug\n*F\n+ 1 UseGoldAutomation.kt\ncom/unciv/logic/automation/civilization/UseGoldAutomation\n*L\n27#1:180\n57#1:181\n57#1:182,2\n58#1:184,2\n58#1:186,4\n79#1:191,14\n129#1:205\n129#1:206,2\n135#1:208,7\n146#1:215,2\n*E\n"})
public final class UseGoldAutomation {
    @NotNull
    public static final UseGoldAutomation INSTANCE = new UseGoldAutomation();

    private UseGoldAutomation() {
    }

    public final void useGold(@NotNull Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Iterator<IsPartOfGameInfoSerialization> iterator2 = civ.getUnits().getCivUnits().iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = iterator2.next();
            UnitAutomation.INSTANCE.tryUpgradeUnit$core(unit);
        }
        if (civ.isMajorCiv()) {
            this.useGoldForCityStates(civ);
        }
        Iterable $this$sortedByDescending$iv = civ.getCities();
        boolean $i$f$sortedByDescending = false;
        for (City city : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                City it = (City)b;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getCityStats().getCurrentCityStats().getProduction());
                it = (City)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(it.getCityStats().getCurrentCityStats().getProduction()));
            }
        })) {
            IConstruction construction = city.getCityConstructions().getCurrentConstruction();
            if (!(construction instanceof INonPerpetualConstruction)) continue;
            Integer n = ((INonPerpetualConstruction)construction).getStatBuyCost(city, Stat.Gold);
            if (n == null) {
                continue;
            }
            int statBuyCost = n;
            if (!city.getCityConstructions().isConstructionPurchaseAllowed((INonPerpetualConstruction)construction, Stat.Gold, statBuyCost) || civ.getGold() < statBuyCost || ((INonPerpetualConstruction)construction).getHurryCostModifier() > 10) continue;
            CityConstructions.purchaseConstruction$default(city.getCityConstructions(), (INonPerpetualConstruction)construction, 0, true, null, null, 24, null);
        }
        this.maybeBuyCityTiles(civ);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void useGoldForCityStates(Civilization civ) {
        Object v0;
        Object $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<Civilization> knownCityStates = SequencesKt.toList(SequencesKt.filter(civ.getKnownCivs(), arg_0 -> UseGoldAutomation.useGoldForCityStates$lambda$0(civ, arg_0)));
        if (civ.getGold() >= 330 && civ.getHappiness() > 0 && Civilization.hasUnique$default(civ, UniqueType.CityStateCanBeBoughtForGold, null, 2, null)) {
            for (Civilization cityState : CollectionsKt.toList((Iterable)knownCityStates)) {
                if (cityState.getCityStateFunctions().canBeMarriedBy(civ)) {
                    cityState.getCityStateFunctions().diplomaticMarriage(civ);
                }
                if (civ.getHappiness() > 0) continue;
            }
        }
        if (civ.getGold() < 500) return;
        if (CollectionsKt.none((Iterable)knownCityStates)) {
            return;
        }
        Object object = knownCityStates;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getAllyCiv(), civ))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        Iterator result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        destination$iv$iv = $this$associateWith$iv;
        Map destination$iv$iv2 = (Map)((Object)result$iv);
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Civilization bl = (Civilization)element$iv$iv;
            Object e = element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            Integer n = NextTurnAutomation.INSTANCE.valueCityStateAlliance$core(civ, (Civilization)it, true);
            map2.put(e, n);
        }
        Object object2 = destination$iv$iv2.entrySet();
        result$iv = object2.iterator();
        if (!result$iv.hasNext()) {
            v0 = null;
        } else {
            $this$associateWithTo$iv$iv = result$iv.next();
            if (!result$iv.hasNext()) {
                v0 = $this$associateWithTo$iv$iv;
            } else {
                Map.Entry it = (Map.Entry)$this$associateWithTo$iv$iv;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object e = result$iv.next();
                    Map.Entry it2 = (Map.Entry)e;
                    $i$a$-maxByOrNull-UseGoldAutomation$useGoldForCityStates$cityState$3 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    $this$associateWithTo$iv$iv = e;
                    n = n2;
                } while (result$iv.hasNext());
                v0 = $this$associateWithTo$iv$iv;
            }
        }
        Map.Entry entry = v0;
        if (entry == null) return;
        Object it = object2 = entry;
        boolean bl = false;
        if (((Number)it.getValue()).intValue() <= 0) return;
        boolean bl3 = true;
        if (!bl3) return;
        Object object3 = object2;
        object = object3;
        if (object == null) return;
        Civilization civilization = (Civilization)object.getKey();
        Civilization cityState = civilization;
        if (cityState == null) return;
        this.tryGainInfluence(civ, cityState);
    }

    private final void maybeBuyCityTiles(Civilization civInfo) {
        if (civInfo.getGold() <= 0) {
            return;
        }
        if (civInfo.getGameInfo().getTurns() < (int)(civInfo.getGameInfo().getSpeed().getScienceCostModifier() * (float)20)) {
            return;
        }
        SortedMap<Tile, Set<City>> highlyDesirableTiles = this.getHighlyDesirableTilesToCityMap(civInfo);
        for (Map.Entry highlyDesirableTile : ((Map)highlyDesirableTiles).entrySet()) {
            Object t;
            Object v = highlyDesirableTile.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
            Iterable $this$minBy$iv = (Iterable)v;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                Tile tile = it.getCenterTile();
                Object k = highlyDesirableTile.getKey();
                Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
                int minValue$iv = tile.aerialDistanceTo((Tile)k);
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    boolean bl2 = false;
                    Tile tile2 = it2.getCenterTile();
                    Object k2 = highlyDesirableTile.getKey();
                    Intrinsics.checkNotNullExpressionValue(k2, "<get-key>(...)");
                    int v$iv = tile2.aerialDistanceTo((Tile)k2);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            City cityWithLeastCostToBuy = (City)t;
            BFS bfs = new BFS(cityWithLeastCostToBuy.getCenterTile(), arg_0 -> UseGoldAutomation.maybeBuyCityTiles$lambda$1(cityWithLeastCostToBuy, arg_0));
            Object k = highlyDesirableTile.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
            bfs.stepUntilDestination((Tile)k);
            Object k3 = highlyDesirableTile.getKey();
            Intrinsics.checkNotNullExpressionValue(k3, "<get-key>(...)");
            List<Tile> tilesThatNeedBuying = CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.filter(bfs.getPathTo((Tile)k3), UseGoldAutomation::maybeBuyCityTiles$lambda$2)));
            boolean ranOutOfMoney = false;
            int goldSpent = 0;
            for (Tile tileThatNeedsBuying : tilesThatNeedBuying) {
                int goldCostOfTile = cityWithLeastCostToBuy.getExpansion().getGoldCostOfTile(tileThatNeedsBuying);
                if (civInfo.getGold() >= goldCostOfTile) {
                    cityWithLeastCostToBuy.getExpansion().buyTile(tileThatNeedsBuying);
                    goldSpent += goldCostOfTile;
                    continue;
                }
                ranOutOfMoney = true;
                break;
            }
            if (!ranOutOfMoney) continue;
            for (Tile tileThatNeedsBuying : tilesThatNeedBuying) {
                cityWithLeastCostToBuy.getExpansion().relinquishOwnership(tileThatNeedsBuying);
            }
            civInfo.addGold(goldSpent);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final SortedMap<Tile, Set<City>> getHighlyDesirableTilesToCityMap(Civilization civInfo) {
        void $this$filterTo$iv$iv;
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                Tile it = (Tile)b;
                boolean bl = false;
                Tile tile = it;
                it = (Tile)a;
                Comparable comparable = Boolean.valueOf((tile != null ? tile.getNaturalWonder() : null) != null);
                bl = false;
                Tile tile2 = it;
                return ComparisonsKt.compareValues(comparable, (tile2 != null ? tile2.getNaturalWonder() : null) != null);
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Object object = it;
                    ResourceType resourceType = object != null && (object = ((Tile)object).getTileResource()) != null ? ((TileResource)object).getResourceType() : null;
                    it = (Tile)a;
                    Comparable comparable = Boolean.valueOf(resourceType == ResourceType.Luxury);
                    bl = false;
                    Object object2 = it;
                    n = ComparisonsKt.compareValues(comparable, (object2 != null && (object2 = ((Tile)object2).getTileResource()) != null ? ((TileResource)object2).getResourceType() : null) == ResourceType.Luxury);
                }
                return n;
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Object object = it;
                    ResourceType resourceType = object != null && (object = ((Tile)object).getTileResource()) != null ? ((TileResource)object).getResourceType() : null;
                    it = (Tile)a;
                    Comparable comparable = Boolean.valueOf(resourceType == ResourceType.Strategic);
                    bl = false;
                    Object object2 = it;
                    n = ComparisonsKt.compareValues(comparable, (object2 != null && (object2 = ((Tile)object2).getTileResource()) != null ? ((TileResource)object2).getResourceType() : null) == ResourceType.Strategic);
                }
                return n;
            }
        };
        SortedMap highlyDesirableTiles = new TreeMap(new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Tile tile = it;
                    it = (Tile)b;
                    Comparable comparable = Integer.valueOf(tile != null ? tile.hashCode() : 0);
                    bl = false;
                    Tile tile2 = it;
                    n = ComparisonsKt.compareValues(comparable, tile2 != null ? tile2.hashCode() : 0);
                }
                return n;
            }
        });
        Iterable $this$filter$iv = civInfo.getCities();
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            City it = (City)element$iv$iv;
            boolean bl = false;
            if (!(!it.isPuppet() && !it.isBeingRazed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (City city : (List)destination$iv$iv) {
            Sequence<Tile> highlyDesirableTilesInCity = SequencesKt.filter(city.getCenterTile().getTilesAtDistance(2), arg_0 -> UseGoldAutomation.getHighlyDesirableTilesToCityMap$lambda$5(civInfo, city, arg_0));
            object2 = highlyDesirableTilesInCity.iterator();
            while (object2.hasNext()) {
                Object object3;
                void $this$getOrPut$iv;
                Tile highlyDesirableTileInCity = (Tile)object2.next();
                Map map2 = highlyDesirableTiles;
                Tile key$iv = highlyDesirableTileInCity;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                Set desirableTiles = (Set)object3;
                desirableTiles.add(city);
            }
        }
        return highlyDesirableTiles;
    }

    @Readonly
    private final boolean isHighlyDesirableTile(Tile it, Civilization civInfo, City city) {
        boolean bl;
        block4: {
            if (!it.isVisible(civInfo)) {
                return false;
            }
            if (it.getOwner() != null) {
                return false;
            }
            Sequence<Tile> $this$none$iv = it.getNeighbors();
            boolean $i$f$none = false;
            Iterator<Tile> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile neighbor = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(neighbor.getCity(), city)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (bl) {
            return false;
        }
        return UseGoldAutomation.isHighlyDesirableTile$hasNaturalWonder(it) || UseGoldAutomation.isHighlyDesirableTile$hasLuxury(it, civInfo) || UseGoldAutomation.isHighlyDesirableTile$hasHighYields(it, civInfo);
    }

    private final void tryGainInfluence(Civilization civInfo, Civilization cityState) {
        boolean stopSpending;
        if (civInfo.getGold() < 500) {
            return;
        }
        DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(civInfo);
        Intrinsics.checkNotNull(diplomacyManager);
        float influence = diplomacyManager.getInfluence();
        boolean bl = stopSpending = influence > (float)(60 + 2 * NextTurnAutomation.INSTANCE.valueCityStateAlliance$core(civInfo, cityState, true));
        if (influence < 10.0f || stopSpending) {
            return;
        }
        if (civInfo.getGold() >= 1000) {
            cityState.getCityStateFunctions().receiveGoldGift(civInfo, 1000);
        } else {
            cityState.getCityStateFunctions().receiveGoldGift(civInfo, 500);
        }
    }

    private static final boolean useGoldForCityStates$lambda$0(Civilization $civ, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isCityState() && MotivationToAttackAutomation.INSTANCE.hasAtLeastMotivationToAttack($civ, it, 0.0f) <= 0.0f;
    }

    private static final boolean maybeBuyCityTiles$lambda$1(City $cityWithLeastCostToBuy, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOwner() == null || Intrinsics.areEqual(it.getOwningCity(), $cityWithLeastCostToBuy);
    }

    private static final boolean maybeBuyCityTiles$lambda$2(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOwner() == null;
    }

    private static final boolean getHighlyDesirableTilesToCityMap$lambda$5(Civilization $civInfo, City $city, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.isHighlyDesirableTile(it, $civInfo, $city);
    }

    @Readonly
    private static final boolean isHighlyDesirableTile$hasNaturalWonder(Tile $it) {
        return $it.getNaturalWonder() != null;
    }

    @Readonly
    private static final boolean isHighlyDesirableTile$hasLuxury(Tile $it, Civilization $civInfo) {
        TileResource resource = $it.getTileResource();
        return $civInfo.canSeeResource(resource) && resource.getResourceType() == ResourceType.Luxury && $civInfo.getResourceAmount(resource) < 2;
    }

    @Readonly
    private static final boolean isHighlyDesirableTile$hasHighYields(Tile $it, Civilization $civInfo) {
        Stats tileStats = TileStatFunctions.getTileStats$default($it.getStats(), $civInfo, null, 2, null);
        return tileStats.getFood() + tileStats.getProduction() >= 3.0f;
    }
}

