/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/city/GreatPersonPointsBreakdown;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;)V", "city", "Lcom/unciv/logic/city/City;", "(Lcom/unciv/logic/city/City;)V", "allNames", "", "", "getAllNames", "()Ljava/util/Set;", "basePoints", "Ljava/util/ArrayList;", "Lcom/unciv/logic/city/GreatPersonPointsBreakdown$Entry;", "Lkotlin/collections/ArrayList;", "getBasePoints", "()Ljava/util/ArrayList;", "percentBonuses", "getPercentBonuses", "sum", "Lcom/unciv/models/Counter;", "AllGPPercentageEntry", "Entry", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGreatPersonPointsBreakdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GreatPersonPointsBreakdown.kt\ncom/unciv/logic/city/GreatPersonPointsBreakdown\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n777#2:165\n873#2,2:166\n*S KotlinDebug\n*F\n+ 1 GreatPersonPointsBreakdown.kt\ncom/unciv/logic/city/GreatPersonPointsBreakdown\n*L\n148#1:165\n148#1:166,2\n*E\n"})
public final class GreatPersonPointsBreakdown {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final Set<String> allNames;
    @NotNull
    private final ArrayList<Entry> basePoints;
    @NotNull
    private final ArrayList<Entry> percentBonuses;
    public static final int fixedPointFactor = 1000;

    private GreatPersonPointsBreakdown(Ruleset ruleset) {
        this.ruleset = ruleset;
        this.allNames = new LinkedHashSet();
        this.basePoints = new ArrayList();
        this.percentBonuses = new ArrayList();
    }

    @NotNull
    public final Set<String> getAllNames() {
        return this.allNames;
    }

    @NotNull
    public final ArrayList<Entry> getBasePoints() {
        return this.basePoints;
    }

    @NotNull
    public final ArrayList<Entry> getPercentBonuses() {
        return this.percentBonuses;
    }

    public GreatPersonPointsBreakdown(@NotNull City city) {
        Object specialistName;
        Intrinsics.checkNotNullParameter(city, "city");
        this(city.getRuleset());
        Entry specialists = new Entry("Specialists", null, false, null, 14, null);
        for (Map.Entry object2 : ((Map)city.getPopulation().getNewSpecialists()).entrySet()) {
            Specialist specialist;
            specialistName = (String)object2.getKey();
            int amount = ((Number)object2.getValue()).intValue();
            if (!this.ruleset.getSpecialists().containsKey(specialistName)) continue;
            Intrinsics.checkNotNull(this.ruleset.getSpecialists().get(specialistName));
            specialists.getCounter().add(specialist.getGreatPersonPoints().times(amount));
        }
        this.basePoints.add(specialists);
        Iterator<Building> iterator2 = this.allNames;
        Set<String> set = specialists.getCounter().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        CollectionsKt.addAll(iterator2, (Iterable)set);
        iterator2 = city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (building.getGreatPersonPoints().isEmpty()) continue;
            this.basePoints.add(new Entry(building.getName(), building.makeLink(), false, building.getGreatPersonPoints(), 4, null));
            specialistName = this.allNames;
            Set<String> set2 = building.getGreatPersonPoints().keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            CollectionsKt.addAll(specialistName, (Iterable)set2);
        }
        iterator2 = GreatPersonPointsBreakdown.Companion.getPercentagesApplyingToAllGP(city).iterator();
        while (iterator2.hasNext()) {
            AllGPPercentageEntry allGPPercentageEntry = (AllGPPercentageEntry)((Object)iterator2.next());
            Entry bonusEntry = new Entry(allGPPercentageEntry.getSource(), allGPPercentageEntry.getPediaLink(), true, null, 8, null);
            Iterator<String> amount = this.allNames.iterator();
            while (amount.hasNext()) {
                String name;
                Intrinsics.checkNotNullExpressionValue(amount.next(), "next(...)");
                bonusEntry.getCounter().add(name, allGPPercentageEntry.getBonus());
            }
            this.percentBonuses.add(bonusEntry);
        }
        GameContext stateForConditionals = city.getState();
        Iterator<Unique> iterator3 = city.getCiv().getMatchingUniques(UniqueType.GreatPersonEarnedFaster, stateForConditionals).iterator();
        while (iterator3.hasNext()) {
            Unique unique = iterator3.next();
            String gppName = unique.getParams().get(0);
            if (!this.allNames.contains(gppName)) continue;
            Entry bonusEntry = new Entry(GreatPersonPointsBreakdown.Companion.getUniqueSourceName(unique), GreatPersonPointsBreakdown.Companion.guessPediaLink(unique), false, null, 12, null);
            bonusEntry.getCounter().add(gppName, Integer.parseInt(unique.getParams().get(1)));
            this.percentBonuses.add(bonusEntry);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final Counter<String> sum() {
        void $this$filterTo$iv$iv;
        Counter<String> result2 = new Counter<String>(null, 1, null);
        Iterator<Entry> iterator2 = this.basePoints.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Entry> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Entry entry;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            result2.add(entry.getCounter().times(1000));
        }
        Counter<String> bonuses = new Counter<String>(null, 1, null);
        Iterator<Entry> iterator4 = this.percentBonuses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        Iterator<Object> iterator5 = iterator4;
        while (iterator5.hasNext()) {
            Entry entry;
            Intrinsics.checkNotNullExpressionValue(iterator5.next(), "next(...)");
            bonuses.add(entry.getCounter());
        }
        Set set = result2.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!((Map)bonuses).containsKey(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String key : (List)destination$iv$iv) {
            result2.add(key, ((Number)result2.get(key)).intValue() * ((Number)bonuses.get(key)).intValue() / 100);
        }
        Set set2 = result2.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        for (String key : CollectionsKt.toSet(set2)) {
            ((Map)result2).put(key, (((Number)result2.get(key)).intValue() + 500) / 1000);
        }
        Set set3 = result2.keySet();
        Intrinsics.checkNotNullExpressionValue(set3, "<get-keys>(...)");
        for (String key : CollectionsKt.toSet(set3)) {
            if (((Map)this.ruleset.getUnits()).containsKey(key)) continue;
            result2.remove(key);
        }
        return result2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/unciv/logic/city/GreatPersonPointsBreakdown$AllGPPercentageEntry;", "", "source", "", "pediaLink", "bonus", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;I)V", "getSource", "()Ljava/lang/String;", "getPediaLink", "getBonus", "()I", "core"})
    private static final class AllGPPercentageEntry {
        @NotNull
        private final String source;
        @Nullable
        private final String pediaLink;
        private final int bonus;

        public AllGPPercentageEntry(@NotNull String source, @Nullable String pediaLink, int bonus) {
            Intrinsics.checkNotNullParameter(source, "source");
            this.source = source;
            this.pediaLink = pediaLink;
            this.bonus = bonus;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @Nullable
        public final String getPediaLink() {
            return this.pediaLink;
        }

        public final int getBonus() {
            return this.bonus;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/logic/city/GreatPersonPointsBreakdown$Companion;", "", "<init>", "()V", "fixedPointFactor", "", "getUniqueSourceName", "", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "guessPediaLink", "getPercentagesApplyingToAllGP", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/city/GreatPersonPointsBreakdown$AllGPPercentageEntry;", "city", "Lcom/unciv/logic/city/City;", "getGreatPersonPercentageBonus", "core"})
    @SourceDebugExtension(value={"SMAP\nGreatPersonPointsBreakdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GreatPersonPointsBreakdown.kt\ncom/unciv/logic/city/GreatPersonPointsBreakdown$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Pure
        private final String getUniqueSourceName(Unique unique) {
            String string = unique.getSourceObjectName();
            if (string == null) {
                string = "Bonus";
            }
            return string;
        }

        @Pure
        private final String guessPediaLink(Unique unique) {
            if (unique.getSourceObjectName() == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            UniqueTarget uniqueTarget = unique.getSourceObjectType();
            Intrinsics.checkNotNull((Object)uniqueTarget);
            return stringBuilder.append(uniqueTarget.name()).append('/').append(unique.getSourceObjectName()).toString();
        }

        @Readonly
        private final Sequence<AllGPPercentageEntry> getPercentagesApplyingToAllGP(City city) {
            return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super AllGPPercentageEntry>, Continuation<? super Unit>, Object>(city, null){
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ City $city;
                {
                    this.$city = $city;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (SequenceScope)this.L$0;
                    var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            var3_4 = City.getMatchingUniques$default(this.$city, UniqueType.GreatPersonPointPercentage, null, false, 6, null).iterator();
lbl7:
                            // 4 sources

                            while (var3_4.hasNext()) {
                                unique = (Unique)var3_4.next();
                                if (!City.matchesFilter$default(this.$city, unique.getParams().get(1), null, false, 6, null)) continue;
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                                this.label = 1;
                                v0 = $this$sequence.yield(new AllGPPercentageEntry(com.unciv.logic.city.GreatPersonPointsBreakdown$Companion.access$getUniqueSourceName(GreatPersonPointsBreakdown.Companion, unique), com.unciv.logic.city.GreatPersonPointsBreakdown$Companion.access$guessPediaLink(GreatPersonPointsBreakdown.Companion, unique), Integer.parseInt(unique.getParams().get(0))), this);
                                if (v0 != var9_3) continue;
                                return var9_3;
                            }
                            break;
                        }
                        case 1: {
                            unique = (Unique)this.L$2;
                            var3_4 = (Iterator<T>)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
                            ** GOTO lbl7
                        }
                    }
                    civ = this.$city.getCiv();
                    var4_5 = civ.getKnownCivs().iterator();
                    while (var4_5.hasNext()) {
                        otherCiv = var4_5.next();
                        v1 = civ.getDiplomacyManager(otherCiv);
                        Intrinsics.checkNotNull(v1);
                        if (!v1.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) continue;
                        boostUniques = SequencesKt.plus(Civilization.getMatchingUniques$default(civ, UniqueType.GreatPersonBoostWithFriendship, null, 2, null), Civilization.getMatchingUniques$default(otherCiv, UniqueType.GreatPersonBoostWithFriendship, null, 2, null));
                        var7_8 = boostUniques.iterator();
lbl33:
                        // 3 sources

                        while (var7_8.hasNext()) {
                            unique = (Unique)var7_8.next();
                            this.L$0 = $this$sequence;
                            this.L$1 = civ;
                            this.L$2 = var4_5;
                            this.L$3 = SpillingKt.nullOutSpilledVariable(otherCiv);
                            this.L$4 = SpillingKt.nullOutSpilledVariable(boostUniques);
                            this.L$5 = var7_8;
                            this.L$6 = SpillingKt.nullOutSpilledVariable(unique);
                            this.label = 2;
                            v2 = $this$sequence.yield(new AllGPPercentageEntry("Declaration of Friendship", null, Integer.parseInt(unique.getParams().get(0))), this);
                            if (v2 != var9_3) continue;
                            return var9_3;
                        }
                    }
                    {
                        break;
                        case 2: {
                            unique = (Unique)this.L$6;
                            var7_8 = (Iterator<T>)this.L$5;
                            boostUniques = (Sequence<T>)this.L$4;
                            otherCiv = (Civilization)this.L$3;
                            var4_5 = (Iterator<Civilization>)this.L$2;
                            civ = (Civilization)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
                            ** GOTO lbl33
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    Function2<SequenceScope<? super AllGPPercentageEntry>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                public final Object invoke(SequenceScope<? super AllGPPercentageEntry> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Readonly
        public final int getGreatPersonPercentageBonus(@NotNull City city) {
            Intrinsics.checkNotNullParameter(city, "city");
            Sequence<AllGPPercentageEntry> sequence = this.getPercentagesApplyingToAllGP(city);
            int n = 0;
            Iterator<AllGPPercentageEntry> iterator2 = sequence.iterator();
            while (iterator2.hasNext()) {
                void it;
                AllGPPercentageEntry allGPPercentageEntry;
                AllGPPercentageEntry allGPPercentageEntry2 = allGPPercentageEntry = iterator2.next();
                int n2 = n;
                boolean bl = false;
                int n3 = it.getBonus();
                n = n2 + n3;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/unciv/logic/city/GreatPersonPointsBreakdown$Entry;", "", "source", "", "pediaLink", "isAllGP", "", "counter", "Lcom/unciv/models/Counter;", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLcom/unciv/models/Counter;)V", "getSource", "()Ljava/lang/String;", "getPediaLink", "()Z", "getCounter", "()Lcom/unciv/models/Counter;", "core"})
    public static final class Entry {
        @NotNull
        private final String source;
        @Nullable
        private final String pediaLink;
        private final boolean isAllGP;
        @NotNull
        private final Counter<String> counter;

        public Entry(@NotNull String source, @Nullable String pediaLink, boolean isAllGP, @NotNull Counter<String> counter) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(counter, "counter");
            this.source = source;
            this.pediaLink = pediaLink;
            this.isAllGP = isAllGP;
            this.counter = counter;
        }

        public /* synthetic */ Entry(String string, String string2, boolean bl, Counter counter, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                counter = new Counter(null, 1, null);
            }
            this(string, string2, bl, counter);
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @Nullable
        public final String getPediaLink() {
            return this.pediaLink;
        }

        public final boolean isAllGP() {
            return this.isAllGP;
        }

        @NotNull
        public final Counter<String> getCounter() {
            return this.counter;
        }
    }
}

