/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.models.UncivSound;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.unit.BaseUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\bf\u0018\u0000 \u00192\u00020\u0001:\u0006\u0019\u001a\u001b\u001c\u001d\u001eJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\rH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u000fH\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\rH\u0002R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f\u00c0\u0006\u0003"}, d2={"Lcom/unciv/logic/files/IMediaFinder;", "", "supportedMediaExtensions", "", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "mediaSubFolderName", "getMediaSubFolderName", "()Ljava/lang/String;", "getRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "getInternalMediaNames", "Lkotlin/sequences/Sequence;", "folder", "Lcom/badlogic/gdx/files/FileHandle;", "findMedia", "name", "listMediaFolders", "listMediaFiles", "getModMediaFolder", "modName", "directoryExists", "", "listModFolders", "Companion", "Sounds", "Music", "Voices", "Images", "LabeledSounds", "core"})
@SourceDebugExtension(value={"SMAP\nIMediaFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IMediaFinder.kt\ncom/unciv/logic/files/IMediaFinder\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n184#2,2:263\n1586#3:265\n1661#3,3:266\n1586#3:269\n1661#3,3:270\n*S KotlinDebug\n*F\n+ 1 IMediaFinder.kt\ncom/unciv/logic/files/IMediaFinder\n*L\n90#1:263,2\n89#1:265\n89#1:266,3\n105#1:269\n105#1:270,3\n*E\n"})
public interface IMediaFinder {
    @NotNull
    public static final Companion Companion = com.unciv.logic.files.IMediaFinder$Companion.$$INSTANCE;

    @NotNull
    public Set<String> getSupportedMediaExtensions();

    @NotNull
    public String getMediaSubFolderName();

    @Nullable
    default public Ruleset getRuleset() {
        GameInfo gameInfo = UncivGame.Companion.getGameInfoOrNull();
        return gameInfo != null ? gameInfo.getRuleset() : null;
    }

    @NotNull
    default public Sequence<String> getInternalMediaNames(@NotNull FileHandle folder) {
        Intrinsics.checkNotNullParameter(folder, "folder");
        throw new UnsupportedOperationException("Using IMediaFinder.listMediaFiles from a jar requires overriding getInternalMediaNames");
    }

    @Nullable
    default public FileHandle findMedia(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name, "name");
            Sequence $this$firstOrNull$iv = SequencesKt.flatMapIterable(this.listMediaFolders(), arg_0 -> IMediaFinder.findMedia$lambda$0(this, name, arg_0));
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                FileHandle it = (FileHandle)element$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    default public Sequence<FileHandle> listMediaFolders() {
        return SequencesKt.filter(SequencesKt.plus(this.listModFolders(), Gdx.files.internal(this.getMediaSubFolderName())), arg_0 -> IMediaFinder.listMediaFolders$lambda$0(this, arg_0));
    }

    @NotNull
    default public Sequence<FileHandle> listMediaFiles() {
        return SequencesKt.flatMap(this.listMediaFolders(), arg_0 -> IMediaFinder.listMediaFiles$lambda$0(this, arg_0));
    }

    @NotNull
    default public FileHandle getModMediaFolder(@NotNull String modName) {
        Intrinsics.checkNotNullParameter(modName, "modName");
        FileHandle fileHandle = UncivGame.Companion.getCurrent().getFiles().getModFolder(modName).child(this.getMediaSubFolderName());
        Intrinsics.checkNotNullExpressionValue(fileHandle, "child(...)");
        return fileHandle;
    }

    private boolean directoryExists(FileHandle $this$directoryExists) {
        return $this$directoryExists.type() != Files.FileType.Internal ? $this$directoryExists.exists() && $this$directoryExists.isDirectory() : (Gdx.app.getType() == Application.ApplicationType.Android ? $this$directoryExists.isDirectory() : (IMediaFinder.Companion.isRunFromJar() ? $this$directoryExists.exists() : $this$directoryExists.exists() && $this$directoryExists.isDirectory()));
    }

    private Sequence<FileHandle> listModFolders() {
        return SequencesKt.map(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ IMediaFinder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                void $this$sequence;
                SequenceScope sequenceScope = (SequenceScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        Ruleset ruleset = this.this$0.getRuleset();
                        if (ruleset == null) break;
                        Ruleset $this$invokeSuspend_u24lambda_u240 = ruleset;
                        int n = 0;
                        this.L$0 = $this$sequence;
                        this.L$1 = SpillingKt.nullOutSpilledVariable($this$invokeSuspend_u24lambda_u240);
                        this.I$0 = n;
                        this.label = 1;
                        Object object2 = $this$sequence.yieldAll((Iterable)$this$invokeSuspend_u24lambda_u240.getMods(), (Continuation<? super Unit>)this);
                        if (object2 == object) {
                            return object;
                        }
                        break;
                    }
                    case 1: {
                        int n = this.I$0;
                        Ruleset $this$invokeSuspend_u24lambda_u240 = (Ruleset)this.L$1;
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        break;
                    }
                }
                if (!UncivGame.Companion.isCurrentInitialized()) return Unit.INSTANCE;
                this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                this.L$1 = null;
                this.label = 2;
                Object object3 = $this$sequence.yieldAll((Iterable)UncivGame.Companion.getCurrent().getSettings().getVisualMods(), (Continuation<? super Unit>)this);
                if (object3 != object) return Unit.INSTANCE;
                return object;
                {
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), arg_0 -> IMediaFinder.listModFolders$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static Iterable findMedia$lambda$0(IMediaFinder this$0, String $name, FileHandle folder) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(folder, "folder");
        Iterable $this$map$iv = this$0.getSupportedMediaExtensions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(folder.child($name + (String)it));
        }
        return (List)destination$iv$iv;
    }

    private static boolean listMediaFolders$lambda$0(IMediaFinder this$0, FileHandle it) {
        Intrinsics.checkNotNull(it);
        return this$0.directoryExists(it);
    }

    /*
     * WARNING - void declaration
     */
    private static Iterable listMediaFiles$lambda$0$0(IMediaFinder this$0, FileHandle $folder, String name) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$map$iv = this$0.getSupportedMediaExtensions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void ext;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($folder.child(name + (String)ext));
        }
        return (List)destination$iv$iv;
    }

    private static boolean listMediaFiles$lambda$0$1(FileHandle it) {
        return it.exists();
    }

    private static Sequence listMediaFiles$lambda$0(IMediaFinder this$0, FileHandle folder) {
        Sequence<Object> sequence;
        Intrinsics.checkNotNullParameter(folder, "folder");
        if (folder.type() == Files.FileType.Internal && IMediaFinder.Companion.isRunFromJar()) {
            sequence = SequencesKt.filter(SequencesKt.flatMapIterable(this$0.getInternalMediaNames(folder), arg_0 -> IMediaFinder.listMediaFiles$lambda$0$0(this$0, folder, arg_0)), IMediaFinder::listMediaFiles$lambda$0$1);
        } else {
            FileHandle[] fileHandleArray = folder.list();
            Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
            sequence = ArraysKt.asSequence((Object[])fileHandleArray);
        }
        return sequence;
    }

    private static FileHandle listModFolders$lambda$0(IMediaFinder this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getModMediaFolder(it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\b\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Companion;", "", "<init>", "()V", "supportedAudioExtensions", "", "", "supportedImageExtensions", "isRunFromJar", "", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        private final Set<String> supportedAudioExtensions() {
            String[] stringArray = new String[]{".mp3", ".ogg", ".wav"};
            return SetsKt.setOf(stringArray);
        }

        private final Set<String> supportedImageExtensions() {
            String[] stringArray = new String[]{".png", ".jpg", ".jpeg"};
            return SetsKt.setOf(stringArray);
        }

        private final boolean isRunFromJar() {
            return Gdx.app.getType() == Application.ApplicationType.Desktop && this.getClass().getPackage().getSpecificationVersion() != null;
        }

        public static final /* synthetic */ Set access$supportedAudioExtensions(Companion $this) {
            return $this.supportedAudioExtensions();
        }

        public static final /* synthetic */ Set access$supportedImageExtensions(Companion $this) {
            return $this.supportedImageExtensions();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static Ruleset getRuleset(@NotNull IMediaFinder $this) {
            return $this.getRuleset();
        }

        @Deprecated
        @NotNull
        public static Sequence<String> getInternalMediaNames(@NotNull IMediaFinder $this, @NotNull FileHandle folder) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            return $this.getInternalMediaNames(folder);
        }

        @Deprecated
        @Nullable
        public static FileHandle findMedia(@NotNull IMediaFinder $this, @NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return $this.findMedia(name);
        }

        @Deprecated
        @NotNull
        public static Sequence<FileHandle> listMediaFolders(@NotNull IMediaFinder $this) {
            return $this.listMediaFolders();
        }

        @Deprecated
        @NotNull
        public static Sequence<FileHandle> listMediaFiles(@NotNull IMediaFinder $this) {
            return $this.listMediaFiles();
        }

        @Deprecated
        @NotNull
        public static FileHandle getModMediaFolder(@NotNull IMediaFinder $this, @NotNull String modName) {
            Intrinsics.checkNotNullParameter(modName, "modName");
            return $this.getModMediaFolder(modName);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Images;", "Lcom/unciv/logic/files/IMediaFinder;", "<init>", "()V", "mediaSubFolderName", "", "getMediaSubFolderName", "()Ljava/lang/String;", "supportedMediaExtensions", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "core"})
    public static class Images
    implements IMediaFinder {
        @NotNull
        private final String mediaSubFolderName;
        @NotNull
        private final Set<String> supportedMediaExtensions = com.unciv.logic.files.IMediaFinder$Companion.access$supportedImageExtensions(Companion);

        public Images() {
            this.mediaSubFolderName = "ExtraImages";
        }

        @Override
        @NotNull
        public String getMediaSubFolderName() {
            return this.mediaSubFolderName;
        }

        @Override
        @NotNull
        public Set<String> getSupportedMediaExtensions() {
            return this.supportedMediaExtensions;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\t0\bJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/logic/files/IMediaFinder$LabeledSounds;", "Lcom/unciv/logic/files/IMediaFinder$Sounds;", "<init>", "()V", "cache", "", "", "getLabeledSounds", "Lkotlin/sequences/Sequence;", "", "listMediaFolders", "Lcom/badlogic/gdx/files/FileHandle;", "fillCache", "", "cacheBuiltins", "cacheMods", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nIMediaFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IMediaFinder.kt\ncom/unciv/logic/files/IMediaFinder$LabeledSounds\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1#2:263\n*E\n"})
    public static final class LabeledSounds
    extends Sounds {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, String> cache = new LinkedHashMap();
        @NotNull
        private static final Map<String, String> prettifyUncivSoundNames;
        @NotNull
        private static final Set<String> exclusions;

        @NotNull
        public final Sequence<Map.Entry<String, String>> getLabeledSounds() {
            this.fillCache();
            return MapsKt.asSequence(this.cache);
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFolders() {
            throw new UnsupportedOperationException("LabeledSounds does not support the normal IMediaFinder API");
        }

        private final void fillCache() {
            if (!this.cache.isEmpty()) {
                return;
            }
            this.cacheBuiltins();
            this.cacheMods();
            for (String sound : exclusions) {
                this.cache.remove(sound);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void cacheBuiltins() {
            this.cache.putAll(prettifyUncivSoundNames);
            Iterator<Object> iterator2 = Sounds.Companion.uncivSoundNames().iterator();
            while (iterator2.hasNext()) {
                String string;
                String sound = iterator2.next();
                if (this.cache.containsKey(sound)) continue;
                Map<String, String> map2 = this.cache;
                String string2 = sound;
                if (((CharSequence)string2).length() > 0) {
                    void p0;
                    char c = string2.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)p0));
                    String string3 = string2;
                    int n = 1;
                    String string4 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                    string = stringBuilder2.append(string4).toString();
                } else {
                    string = string2;
                }
                string2 = string;
                map2.put(sound, string2);
            }
            iterator2 = Sounds.Companion.unitAttackSounds().iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                BaseUnit unit = (BaseUnit)pair.component1();
                String sound = (String)pair.component2();
                this.cache.put(sound, '[' + unit.getName() + "] Attack Sound");
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void cacheMods() {
            if (!UncivGame.Companion.isCurrentInitialized()) {
                return;
            }
            Iterator<FileHandle> iterator2 = super.listMediaFolders().iterator();
            while (iterator2.hasNext()) {
                FileHandle[] fileHandleArray;
                FileHandle folder = iterator2.next();
                if (folder.type() == Files.FileType.Internal) continue;
                String mod = folder.parent().name();
                Ruleset ruleset = (Ruleset)RulesetCache.INSTANCE.get((Object)mod);
                if (ruleset != null) {
                    fileHandleArray = ruleset.getUnits().values().iterator();
                    while (fileHandleArray.hasNext()) {
                        String sound;
                        Object e = fileHandleArray.next();
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        BaseUnit unit = (BaseUnit)e;
                        if (unit.getAttackSound() == null || this.cache.containsKey(sound)) continue;
                        StringBuilder stringBuilder = new StringBuilder();
                        Intrinsics.checkNotNull(mod);
                        this.cache.put(sound, stringBuilder.append(StringsKt.take(mod, 32)).append(": {[").append(unit.getName()).append("] Attack Sound}").toString());
                    }
                }
                Intrinsics.checkNotNullExpressionValue(folder.list(), "list(...)");
                for (FileHandle file : fileHandleArray) {
                    String string;
                    String sound = file.nameWithoutExtension();
                    if (this.cache.containsKey(sound)) continue;
                    Map<String, String> map2 = this.cache;
                    StringBuilder stringBuilder = new StringBuilder();
                    Intrinsics.checkNotNull(mod);
                    StringBuilder stringBuilder2 = stringBuilder.append(StringsKt.take(mod, 32)).append(": ");
                    Intrinsics.checkNotNull(sound);
                    String string2 = sound;
                    if (((CharSequence)string2).length() > 0) {
                        void p0;
                        char c = string2.charAt(0);
                        StringBuilder stringBuilder3 = new StringBuilder();
                        StringBuilder stringBuilder4 = stringBuilder2;
                        boolean bl = false;
                        String string3 = CharsKt.titlecase((char)p0);
                        stringBuilder2 = stringBuilder4;
                        StringBuilder stringBuilder5 = stringBuilder3.append((Object)string3);
                        String string4 = string2;
                        int n = 1;
                        String string5 = string4.substring(n);
                        Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                        string = stringBuilder5.append(string5).toString();
                    } else {
                        string = string2;
                    }
                    string2 = stringBuilder2.append(string).append(" {}").toString();
                    map2.put(sound, string2);
                }
            }
        }

        static {
            Object[] objectArray = new Pair[]{TuplesKt.to("", "None"), TuplesKt.to("notification1", "Notification [1]"), TuplesKt.to("notification2", "Notification [2]"), TuplesKt.to("coin", "Buy"), TuplesKt.to("construction", "Create"), TuplesKt.to("paper", "Pick a tech"), TuplesKt.to("policy", "Adopt policy"), TuplesKt.to("setup", "Set up"), TuplesKt.to("swap", "Swap units")};
            prettifyUncivSoundNames = MapsKt.mapOf(objectArray);
            objectArray = new String[]{"nuke", "fire", "slider"};
            exclusions = SetsKt.setOf(objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/unciv/logic/files/IMediaFinder$LabeledSounds$Companion;", "", "<init>", "()V", "prettifyUncivSoundNames", "", "", "getPrettifyUncivSoundNames", "()Ljava/util/Map;", "exclusions", "", "getExclusions", "()Ljava/util/Set;", "core"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<String, String> getPrettifyUncivSoundNames() {
                return prettifyUncivSoundNames;
            }

            @NotNull
            public final Set<String> getExclusions() {
                return exclusions;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Music;", "Lcom/unciv/logic/files/IMediaFinder;", "<init>", "()V", "mediaSubFolderName", "", "getMediaSubFolderName", "()Ljava/lang/String;", "supportedMediaExtensions", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "names", "Lkotlin/sequences/Sequence;", "getNames", "()Lkotlin/sequences/Sequence;", "getInternalMediaNames", "folder", "Lcom/badlogic/gdx/files/FileHandle;", "core"})
    public static class Music
    implements IMediaFinder {
        @NotNull
        private final String mediaSubFolderName;
        @NotNull
        private final Set<String> supportedMediaExtensions = com.unciv.logic.files.IMediaFinder$Companion.access$supportedAudioExtensions(Companion);
        @NotNull
        private final Sequence<String> names = SequencesKt.sequenceOf("Thatched Villagers - Ambient");

        public Music() {
            this.mediaSubFolderName = "music";
        }

        @Override
        @NotNull
        public String getMediaSubFolderName() {
            return this.mediaSubFolderName;
        }

        @Override
        @NotNull
        public Set<String> getSupportedMediaExtensions() {
            return this.supportedMediaExtensions;
        }

        @NotNull
        public final Sequence<String> getNames() {
            return this.names;
        }

        @Override
        @NotNull
        public Sequence<String> getInternalMediaNames(@NotNull FileHandle folder) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            return this.names;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Sounds;", "Lcom/unciv/logic/files/IMediaFinder;", "<init>", "()V", "mediaSubFolderName", "", "getMediaSubFolderName", "()Ljava/lang/String;", "supportedMediaExtensions", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "uncivSoundNames", "", "getUncivSoundNames", "()Ljava/util/List;", "uncivSoundNames$delegate", "Lkotlin/Lazy;", "unitAttackSounds", "getUnitAttackSounds", "unitAttackSounds$delegate", "getInternalMediaNames", "Lkotlin/sequences/Sequence;", "folder", "Lcom/badlogic/gdx/files/FileHandle;", "Companion", "core"})
    public static class Sounds
    implements IMediaFinder {
        @NotNull
        protected static final Companion Companion = new Companion(null);
        @NotNull
        private final String mediaSubFolderName;
        @NotNull
        private final Set<String> supportedMediaExtensions = com.unciv.logic.files.IMediaFinder$Companion.access$supportedAudioExtensions(Companion);
        @NotNull
        private final Lazy uncivSoundNames$delegate = LazyKt.lazy(Sounds::uncivSoundNames_delegate$lambda$0);
        @NotNull
        private final Lazy unitAttackSounds$delegate = LazyKt.lazy(Sounds::unitAttackSounds_delegate$lambda$0);

        public Sounds() {
            this.mediaSubFolderName = "sounds";
        }

        @Override
        @NotNull
        public String getMediaSubFolderName() {
            return this.mediaSubFolderName;
        }

        @Override
        @NotNull
        public Set<String> getSupportedMediaExtensions() {
            return this.supportedMediaExtensions;
        }

        private final List<String> getUncivSoundNames() {
            Lazy lazy = this.uncivSoundNames$delegate;
            return (List)lazy.getValue();
        }

        private final List<String> getUnitAttackSounds() {
            Lazy lazy = this.unitAttackSounds$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public Sequence<String> getInternalMediaNames(@NotNull FileHandle folder) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            return SequencesKt.plus(CollectionsKt.asSequence((Iterable)this.getUncivSoundNames()), (Iterable)this.getUnitAttackSounds());
        }

        private static final List uncivSoundNames_delegate$lambda$0() {
            return SequencesKt.toList(Companion.uncivSoundNames());
        }

        private static final String unitAttackSounds_delegate$lambda$0$0(Pair it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return (String)it.getSecond();
        }

        private static final List unitAttackSounds_delegate$lambda$0() {
            return SequencesKt.toList(SequencesKt.map(Companion.unitAttackSounds(), Sounds::unitAttackSounds_delegate$lambda$0$0));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\b0\u0005\u00a8\u0006\n"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Sounds$Companion;", "", "<init>", "()V", "uncivSoundNames", "Lkotlin/sequences/Sequence;", "", "unitAttackSounds", "Lkotlin/Pair;", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "core"})
        protected static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Sequence<String> uncivSoundNames() {
                return SequencesKt.map(CollectionsKt.asSequence(KClasses.getDeclaredMemberProperties(Reflection.getOrCreateKotlinClass(UncivSound.Companion.class))), Companion::uncivSoundNames$lambda$0);
            }

            @NotNull
            public final Sequence<Pair<BaseUnit, String>> unitAttackSounds() {
                Ruleset ruleset = (Ruleset)RulesetCache.INSTANCE.get((Object)BaseRuleset.Civ_V_GnK.getFullName());
                if (ruleset == null) {
                    return SequencesKt.emptySequence();
                }
                Ruleset ruleset2 = ruleset;
                Collection<BaseUnit> collection = ruleset2.getUnits().values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                return SequencesKt.map(SequencesKt.distinctBy(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), Companion::unitAttackSounds$lambda$0), Companion::unitAttackSounds$lambda$1), Companion::unitAttackSounds$lambda$2);
            }

            private static final String uncivSoundNames$lambda$0(KProperty1 it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Object v = it.get(UncivSound.Companion);
                Intrinsics.checkNotNull(v, "null cannot be cast to non-null type com.unciv.models.UncivSound");
                return ((UncivSound)v).getFileName();
            }

            private static final boolean unitAttackSounds$lambda$0(BaseUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getAttackSound() != null;
            }

            private static final String unitAttackSounds$lambda$1(BaseUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getAttackSound();
            }

            private static final Pair unitAttackSounds$lambda$2(BaseUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                String string = it.getAttackSound();
                Intrinsics.checkNotNull(string);
                return TuplesKt.to(it, string);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Voices;", "Lcom/unciv/logic/files/IMediaFinder;", "<init>", "()V", "mediaSubFolderName", "", "getMediaSubFolderName", "()Ljava/lang/String;", "supportedMediaExtensions", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "core"})
    public static class Voices
    implements IMediaFinder {
        @NotNull
        private final String mediaSubFolderName;
        @NotNull
        private final Set<String> supportedMediaExtensions = com.unciv.logic.files.IMediaFinder$Companion.access$supportedAudioExtensions(Companion);

        public Voices() {
            this.mediaSubFolderName = "voices";
        }

        @Override
        @NotNull
        public String getMediaSubFolderName() {
            return this.mediaSubFolderName;
        }

        @Override
        @NotNull
        public Set<String> getSupportedMediaExtensions() {
            return this.supportedMediaExtensions;
        }
    }
}

