/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.mapgenerator.Perlin;
import com.unciv.logic.map.tile.Tile;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000f2\b\b\u0002\u0010\u0015\u001a\u00020\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\u000fJ4\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0018j\b\u0012\u0004\u0012\u00020\u0011`\u00192\u0006\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u001d\u001a\u00020\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "", "<init>", "()V", "RNG", "Lkotlin/random/Random;", "getRNG", "()Lkotlin/random/Random;", "setRNG", "(Lkotlin/random/Random;)V", "seedRNG", "", "seed", "", "getPerlinNoise", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "nOctaves", "", "persistence", "lacunarity", "scale", "chooseSpreadOutLocations", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "number", "suitableTiles", "", "mapRadius", "core"})
@SourceDebugExtension(value={"SMAP\nMapGenerationRandomness.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapGenerationRandomness.kt\ncom/unciv/logic/map/mapgenerator/MapGenerationRandomness\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n383#2,7:105\n1068#3:112\n1586#3:113\n1661#3,3:114\n296#3,2:117\n*S KotlinDebug\n*F\n+ 1 MapGenerationRandomness.kt\ncom/unciv/logic/map/mapgenerator/MapGenerationRandomness\n*L\n62#1:105,7\n82#1:112\n82#1:113\n82#1:114,3\n84#1:117,2\n*E\n"})
public final class MapGenerationRandomness {
    @NotNull
    private Random RNG = RandomKt.Random(42);

    @NotNull
    public final Random getRNG() {
        return this.RNG;
    }

    public final void setRNG(@NotNull Random random) {
        Intrinsics.checkNotNullParameter(random, "<set-?>");
        this.RNG = random;
    }

    public final void seedRNG(long seed) {
        this.RNG = RandomKt.Random(seed);
    }

    public static /* synthetic */ void seedRNG$default(MapGenerationRandomness mapGenerationRandomness, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 42L;
        }
        mapGenerationRandomness.seedRNG(l);
    }

    public final double getPerlinNoise(@NotNull Tile tile, double seed, int nOctaves, double persistence, double lacunarity, double scale) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Vector2 worldCoords = HexMath.INSTANCE.hex2WorldCoords(tile.getPosition());
        return Perlin.INSTANCE.noise3d(worldCoords.x, worldCoords.y, seed, nOctaves, persistence, lacunarity, scale);
    }

    public static /* synthetic */ double getPerlinNoise$default(MapGenerationRandomness mapGenerationRandomness, Tile tile, double d, int n, double d2, double d3, double d4, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 6;
        }
        if ((n2 & 8) != 0) {
            d2 = 0.5;
        }
        if ((n2 & 0x10) != 0) {
            d3 = 2.0;
        }
        if ((n2 & 0x20) != 0) {
            d4 = 30.0;
        }
        return mapGenerationRandomness.getPerlinNoise(tile, d, n, d2, d3, d4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<Tile> chooseSpreadOutLocations(int number, @NotNull List<Tile> suitableTiles, int mapRadius) {
        Set answer$iv;
        Intrinsics.checkNotNullParameter(suitableTiles, "suitableTiles");
        if (number <= 0) {
            return new ArrayList<Tile>(0);
        }
        float sparsityFactor = (float)Math.pow(HexMath.INSTANCE.getHexagonalRadiusForArea(suitableTiles.size()) / (float)mapRadius, 0.333f);
        int initialDistance = number == 1 || number * 5 >= suitableTiles.size() * 3 ? 1 : RangesKt.coerceAtLeast(MathKt.roundToInt((float)mapRadius * 0.666f / (float)Math.pow(HexMath.INSTANCE.getHexagonalRadiusForArea(number), 0.9f) * sparsityFactor), 1);
        HashMap baseTerrainsToChosenTiles = new HashMap();
        LinkedHashMap<String, Set<Tile>> suitableTilesGrouped = new LinkedHashMap<String, Set<Tile>>(8);
        for (Tile tile : suitableTiles) {
            Object object;
            void $this$getOrPut$iv;
            String terrain = tile.getBaseTerrain();
            if (!((Map)baseTerrainsToChosenTiles).containsKey(terrain)) {
                ((Map)baseTerrainsToChosenTiles).put(terrain, 0);
            }
            Map map2 = suitableTilesGrouped;
            String key$iv = terrain;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(tile);
        }
        for (int distanceBetweenResources = initialDistance; 0 < distanceBetweenResources; --distanceBetweenResources) {
            LinkedHashMap<String, Set<Tile>> availableTiles = MapGenerationRandomness.chooseSpreadOutLocations$deepClone(suitableTilesGrouped);
            ArrayList<Tile> chosenTiles = new ArrayList<Tile>(number);
            for (Object k : baseTerrainsToChosenTiles.keySet()) {
                Intrinsics.checkNotNullExpressionValue(k, "next(...)");
                String terrain = (String)k;
                ((Map)baseTerrainsToChosenTiles).put(terrain, 0);
            }
            int i = 1;
            if (i <= number) {
                while (true) {
                    String firstKeyWithTilesLeft;
                    Object v5;
                    block13: {
                        void $this$firstOrNull$iv;
                        Iterable $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable $this$sortedBy$iv;
                        Set set = baseTerrainsToChosenTiles.entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
                        Iterable $i$f$getOrPut = set;
                        boolean $i$f$sortedBy = false;
                        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                            public final int compare(T a, T b) {
                                Map.Entry it = (Map.Entry)a;
                                boolean bl = false;
                                Comparable comparable = (Integer)it.getValue();
                                it = (Map.Entry)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
                            }
                        });
                        boolean $i$f$map = false;
                        answer$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Map.Entry entry = (Map.Entry)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add((String)it.getKey());
                        }
                        List orderedKeys = (List)destination$iv$iv;
                        $this$mapTo$iv$iv = orderedKeys;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            Set<Tile> set2 = availableTiles.get(it);
                            Intrinsics.checkNotNull(set2);
                            boolean bl2 = !((Collection)set2).isEmpty();
                            if (!bl2) continue;
                            v5 = element$iv;
                            break block13;
                        }
                        v5 = null;
                    }
                    if ((String)v5 == null) break;
                    Set<Tile> set = availableTiles.get(firstKeyWithTilesLeft);
                    Intrinsics.checkNotNull(set);
                    Tile chosenTile = (Tile)CollectionsKt.random((Collection)set, this.RNG);
                    Set<Tile> closeTiles = SequencesKt.toSet(chosenTile.getTilesInDistance(distanceBetweenResources));
                    Iterator<Set<Tile>> iterator2 = availableTiles.values().iterator();
                    while (iterator2.hasNext()) {
                        Set<Tile> availableSet;
                        Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                        availableSet.removeAll((Collection)closeTiles);
                    }
                    chosenTiles.add(chosenTile);
                    Map map3 = baseTerrainsToChosenTiles;
                    Object v = baseTerrainsToChosenTiles.get(firstKeyWithTilesLeft);
                    Intrinsics.checkNotNull(v);
                    map3.put(firstKeyWithTilesLeft, ((Number)v).intValue() + 1);
                    if (i == number) break;
                    ++i;
                }
            }
            if (chosenTiles.size() != number && distanceBetweenResources != 1) continue;
            if (distanceBetweenResources < initialDistance) {
                Object[] objectArray = new Object[]{distanceBetweenResources, initialDistance};
                LogKt.debug("chooseSpreadOutLocations: distance %d < initial %d", objectArray);
            }
            return chosenTiles;
        }
        throw new Exception("Unreachable code reached!");
    }

    private static final LinkedHashMap<String, Set<Tile>> chooseSpreadOutLocations$deepClone(LinkedHashMap<String, Set<Tile>> $this$chooseSpreadOutLocations_u24deepClone) {
        LinkedHashMap<String, Set<Tile>> result2 = new LinkedHashMap<String, Set<Tile>>($this$chooseSpreadOutLocations_u24deepClone.size());
        for (Map.Entry entry : ((Map)$this$chooseSpreadOutLocations_u24deepClone).entrySet()) {
            String key = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            ((Map)result2).put(key, CollectionsKt.toMutableSet(value));
        }
        return result2;
    }
}

