/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.mapregions;

import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegionsKt;
import com.unciv.logic.map.mapgenerator.mapregions.TileDataMap;
import com.unciv.logic.map.mapgenerator.resourceplacement.MapRegionResources;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u000fH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/StartNormalizer;", "", "<init>", "()V", "normalizeStart", "", "startTile", "Lcom/unciv/logic/map/tile/Tile;", "tileMap", "Lcom/unciv/logic/map/TileMap;", "tileData", "Lcom/unciv/logic/map/mapgenerator/mapregions/TileDataMap;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "isMinorCiv", "", "normalizeProduction", "placeStrategicBalanceResources", "addProductionBonuses", "calculateFoodBonusesNeeded", "", "minorCiv", "placeFoodBonuses", "foodBonusesNeeded", "getPotentialYield", "", "tile", "stat", "Lcom/unciv/models/stats/Stat;", "unimproved", "core"})
@SourceDebugExtension(value={"SMAP\nStartNormalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartNormalizer.kt\ncom/unciv/logic/map/mapgenerator/mapregions/StartNormalizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,320:1\n546#2,6:321\n296#2,2:328\n777#2:337\n873#2,2:338\n777#2:340\n873#2,2:341\n777#2:343\n873#2,2:344\n777#2:346\n873#2,2:347\n296#2,2:355\n296#2:357\n1807#2,3:358\n297#2:361\n777#2:363\n873#2,2:364\n1021#2,2:366\n1033#2,2:368\n777#2:370\n873#2,2:371\n1#3:327\n507#4,7:330\n1297#5,3:349\n1297#5,3:352\n614#5:362\n*S KotlinDebug\n*F\n+ 1 StartNormalizer.kt\ncom/unciv/logic/map/mapgenerator/mapregions/StartNormalizer\n*L\n26#1:321,6\n73#1:328,2\n87#1:337\n87#1:338,2\n109#1:340\n109#1:341,2\n155#1:343\n155#1:344,2\n164#1:346\n164#1:347,2\n225#1:355,2\n248#1:357\n253#1:358,3\n248#1:361\n277#1:363\n277#1:364,2\n296#1:366,2\n300#1:368,2\n312#1:370\n312#1:371,2\n86#1:330,7\n189#1:349,3\n191#1:352,3\n264#1:362\n*E\n"})
public final class StartNormalizer {
    @NotNull
    public static final StartNormalizer INSTANCE = new StartNormalizer();

    private StartNormalizer() {
    }

    public final void normalizeStart(@NotNull Tile startTile, @NotNull TileMap tileMap, @NotNull TileDataMap tileData, @NotNull Ruleset ruleset, boolean isMinorCiv) {
        Intrinsics.checkNotNullParameter(startTile, "startTile");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(tileData, "tileData");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Iterator<Tile> iterator2 = startTile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Terrain lastTerrain;
            Terrain terrain;
            Tile tile;
            block4: {
                tile = iterator2.next();
                List<Terrain> $this$lastOrNull$iv = tile.getTerrainFeatureObjects();
                boolean $i$f$lastOrNull = false;
                ListIterator<Terrain> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Terrain element$iv;
                    Terrain it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!it.getImpassable()) continue;
                    terrain = element$iv;
                    break block4;
                }
                terrain = null;
            }
            if ((lastTerrain = (Terrain)terrain) == null) continue;
            tile.removeTerrainFeature(lastTerrain.getName());
        }
        if (!isMinorCiv && tileMap.getMapParameters().strategicBalanceGetter()) {
            this.placeStrategicBalanceResources(startTile, ruleset, tileData);
        }
        this.normalizeProduction(startTile, isMinorCiv, ruleset, tileData);
        int foodBonusesNeeded = this.calculateFoodBonusesNeeded(startTile, isMinorCiv, ruleset, tileMap);
        this.placeFoodBonuses(isMinorCiv, startTile, ruleset, foodBonusesNeeded);
        if (isMinorCiv) {
            return;
        }
        this.addProductionBonuses(startTile, ruleset);
    }

    /*
     * Unable to fully structure code
     */
    private final void normalizeProduction(Tile startTile, boolean isMinorCiv, Ruleset ruleset, TileDataMap tileData) {
        block16: {
            block15: {
                block14: {
                    var6_5 = startTile.getNeighbors();
                    var7_7 = 0;
                    var8_10 = var6_5.iterator();
                    while (var8_10.hasNext()) {
                        var9_14 = var8_10.next();
                        var10_18 = var9_14;
                        var20_26 = var7_7;
                        $i$a$-sumOfInt-StartNormalizer$normalizeProduction$innerProduction$1 = false;
                        var21_27 = (int)StartNormalizer.getPotentialYield$default(StartNormalizer.INSTANCE, (Tile)it, Stat.Production, false, 4, null);
                        var7_7 = var20_26 + var21_27;
                    }
                    innerProduction = var7_7;
                    var7_8 = startTile.getTilesAtDistance(2);
                    var8_11 = 0;
                    var9_14 = var7_8.iterator();
                    while (var9_14.hasNext()) {
                        it = var9_14.next();
                        $i$a$-sumOfInt-StartNormalizer$normalizeProduction$innerProduction$1 = (Tile)it;
                        var20_26 = var8_11;
                        $i$a$-sumOfInt-StartNormalizer$normalizeProduction$outerProduction$1 = false;
                        var21_27 = (int)StartNormalizer.getPotentialYield$default(StartNormalizer.INSTANCE, (Tile)it, Stat.Production, false, 4, null);
                        var8_11 = var20_26 + var21_27;
                    }
                    outerProduction = var8_11;
                    var8_12 = startTile.getTilesInDistanceRange(new IntRange(1, 2));
                    var9_15 = 0;
                    it = var8_12.iterator();
                    while (it.hasNext()) {
                        it = it.next();
                        $i$a$-sumOfInt-StartNormalizer$normalizeProduction$outerProduction$1 = (Tile)it;
                        var20_26 = var9_15;
                        $i$a$-sumOfInt-StartNormalizer$normalizeProduction$earlyProduction$1 = false;
                        var21_27 = StartNormalizer.INSTANCE.getPotentialYield((Tile)it, Stat.Food, true) > 0.0f ? (int)StartNormalizer.INSTANCE.getPotentialYield((Tile)it, Stat.Production, true) : 0;
                        var9_15 = var20_26 + var21_27;
                    }
                    earlyProduction = var9_15;
                    if (innerProduction != 0 && (innerProduction >= 2 || outerProduction >= 8) && (!isMinorCiv || innerProduction >= 4)) break block15;
                    hillSpot = (Tile)CollectionsKt.randomOrNull((Collection)SequencesKt.toList(SequencesKt.filter(startTile.getNeighbors(), (Function1<Tile, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, normalizeProduction$lambda$3(com.unciv.logic.map.tile.Tile ), (Lcom/unciv/logic/map/tile/Tile;)Ljava/lang/Boolean;)())), Random.Default);
                    v0 = ruleset.getTerrains().values();
                    Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
                    it = v0;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (Terrain)element$iv;
                        $i$a$-firstOrNull-StartNormalizer$normalizeProduction$hillEquivalent$1 = false;
                        if (it.getType() != TerrainType.TerrainFeature || !(it.getProduction() >= 2.0f)) ** GOTO lbl-1000
                        Intrinsics.checkNotNull(it);
                        if (!IHasUniques.hasUnique$default(it, UniqueType.RareFeature, null, 2, null)) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                        if (!v1) continue;
                        v2 = element$iv;
                        break block14;
                    }
                    v2 = null;
                }
                it = v2;
                v3 = hillEquivalent = it != null ? it.getName() : null;
                if (hillSpot != null && hillEquivalent != null) {
                    hillSpot.addTerrainFeature(hillEquivalent);
                }
            }
            if (isMinorCiv || innerProduction >= 3 || earlyProduction >= 6) break block16;
            v4 = ruleset.getEras().values();
            Intrinsics.checkNotNullExpressionValue(v4, "<get-values>(...)");
            it = ((Iterable)v4).iterator();
            if (!it.hasNext()) {
                throw new NoSuchElementException();
            }
            it = (Era)it.next();
            $i$a$-maxOf-StartNormalizer$normalizeProduction$lastEraNumber$1 = false;
            it = it.getEraNumber();
            while (it.hasNext()) {
                it = (Era)it.next();
                $i$a$-maxOf-StartNormalizer$normalizeProduction$lastEraNumber$1 = false;
                it = it.getEraNumber();
                if (it >= it) continue;
                it = it;
            }
            lastEraNumber = it;
            $this$filterValues$iv = ruleset.getEras();
            $i$f$filterValues = false;
            result$iv = new LinkedHashMap<K, V>();
            for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
                it = (Era)entry$iv.getValue();
                $i$a$-filterValues-StartNormalizer$normalizeProduction$earlyEras$1 = false;
                if (!(it.getEraNumber() <= lastEraNumber / 3)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            earlyEras = result$iv;
            v5 = ruleset.getTileResources().values();
            Intrinsics.checkNotNullExpressionValue(v5, "<get-values>(...)");
            $this$filter$iv = v5;
            $i$f$filter = false;
            $i$a$-maxOf-StartNormalizer$normalizeProduction$lastEraNumber$1 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TileResource)element$iv$iv;
                $i$a$-filter-StartNormalizer$normalizeProduction$validResources$1 = false;
                if (it.getResourceType() != ResourceType.Strategic) ** GOTO lbl-1000
                if (it.getRevealedBy() == null) ** GOTO lbl-1000
                v6 = ((Map)ruleset.getTechnologies()).get(it.getRevealedBy());
                Intrinsics.checkNotNull(v6);
                if (earlyEras.containsKey(((Technology)v6).era())) lbl-1000:
                // 2 sources

                {
                    v7 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v7 = false;
                }
                if (!v7) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            validResources = CollectionsKt.shuffled((List)destination$iv$iv);
            candidateTiles = SequencesKt.shuffled(startTile.getTilesAtDistance(2));
            for (T v8 : validResources) {
                Intrinsics.checkNotNullExpressionValue(v8, "next(...)");
                resource = (TileResource)v8;
                resourcesAdded = MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, resource, 1, candidateTiles, 0.0f, false, 0, 0, false, 240, null);
                if (resourcesAdded <= 0) continue;
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void placeStrategicBalanceResources(Tile startTile, Ruleset ruleset, TileDataMap tileData) {
        void $this$filterTo$iv$iv;
        Sequence<Tile> candidateTiles = SequencesKt.plus(SequencesKt.shuffled(startTile.getTilesInDistanceRange(new IntRange(1, 2))), SequencesKt.shuffled(startTile.getTilesAtDistance(3)));
        Collection<TileResource> collection = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileResource it = (TileResource)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!IHasUniques.hasUnique$default(it, UniqueType.StrategicBalanceResource, null, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Object e : (List)destination$iv$iv) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            TileResource resource = (TileResource)e;
            if (MapRegionResources.tryAddingResourceToTiles$default(MapRegionResources.INSTANCE, tileData, resource, 1, candidateTiles, 0.0f, false, 0, 0, true, 240, null) != 0) continue;
            List<Tile> resourceTiles = MapRegionsKt.isWaterOnlyResource(resource, ruleset) ? SequencesKt.toList(SequencesKt.filter(candidateTiles, StartNormalizer::placeStrategicBalanceResources$lambda$1)) : SequencesKt.toList(SequencesKt.filter(candidateTiles, StartNormalizer::placeStrategicBalanceResources$lambda$2));
            MapRegionResources.placeResourcesInTiles$default(MapRegionResources.INSTANCE, tileData, 999, resourceTiles, CollectionsKt.listOf(resource), 0, 0, true, 48, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addProductionBonuses(Tile startTile, Ruleset ruleset) {
        void $this$filterTo$iv$iv;
        List<Tile> grassTypePlots = SequencesKt.toMutableList(SequencesKt.filter(startTile.getTilesInDistanceRange(new IntRange(1, 2)), StartNormalizer::addProductionBonuses$lambda$0));
        List<Tile> plainsTypePlots = SequencesKt.toList(SequencesKt.filter(startTile.getTilesInDistanceRange(new IntRange(1, 2)), StartNormalizer::addProductionBonuses$lambda$1));
        int productionBonusesNeeded = grassTypePlots.size() >= 9 && plainsTypePlots.isEmpty() ? 2 : (grassTypePlots.size() >= 6 && plainsTypePlots.size() <= 4 ? 1 : 0);
        Collection<TileResource> collection = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileResource it = (TileResource)element$iv$iv;
            boolean bl = false;
            if (!(it.getResourceType() == ResourceType.Bonus && it.getProduction() > 0.0f)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List productionBonuses = (List)destination$iv$iv;
        if (!((Collection)productionBonuses).isEmpty()) {
            while (productionBonusesNeeded > 0 && !((Collection)grassTypePlots).isEmpty()) {
                void $this$filterTo$iv$iv2;
                Tile plot = (Tile)CollectionsKt.random((Collection)grassTypePlots, Random.Default);
                grassTypePlots.remove(plot);
                if (plot.getTileResource() != null) continue;
                Iterable $this$filter$iv2 = productionBonuses;
                boolean $i$f$filter2 = false;
                Iterable $i$f$filterTo2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    TileResource it = (TileResource)element$iv$iv;
                    boolean bl = false;
                    if (!it.generatesNaturallyOn(plot)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                TileResource bonusToPlace = (TileResource)CollectionsKt.randomOrNull((List)destination$iv$iv2, Random.Default);
                if (bonusToPlace == null) continue;
                plot.setTileResource(bonusToPlace);
                --productionBonusesNeeded;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateFoodBonusesNeeded(Tile startTile, boolean minorCiv, Ruleset ruleset, TileMap tileMap) {
        int bonusesNeeded;
        void $this$count$iv;
        int n;
        Object it;
        int n2;
        Object object;
        Sequence<Tile> sequence = startTile.getNeighbors();
        int n3 = 0;
        Iterator<Tile> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            Tile tile = object;
            n2 = n3;
            boolean bl = false;
            n = (int)((float)Math.pow(StartNormalizer.getPotentialYield$default(INSTANCE, (Tile)it, Stat.Food, false, 4, null), 2) / (float)4);
            n3 = n2 + n;
        }
        int innerFood = n3;
        Sequence<Tile> sequence2 = startTile.getTilesAtDistance(2);
        int n4 = 0;
        object = sequence2.iterator();
        while (object.hasNext()) {
            void it2;
            it = object.next();
            Tile bl = (Tile)it;
            n2 = n4;
            boolean bl2 = false;
            n = (int)((float)Math.pow(StartNormalizer.getPotentialYield$default(INSTANCE, (Tile)it2, Stat.Food, false, 4, null), 2) / (float)4);
            n4 = n2 + n;
        }
        int outerFood = n4;
        int totalFood = innerFood + outerFood;
        Sequence<Tile> $this$count$iv2 = startTile.getNeighbors();
        boolean $i$f$count22 = false;
        int count$iv = 0;
        Iterator<Tile> bl2 = $this$count$iv2.iterator();
        while (bl2.hasNext()) {
            Tile element$iv = bl2.next();
            Tile it3 = element$iv;
            boolean bl = false;
            if (!(INSTANCE.getPotentialYield(it3, Stat.Food, true) >= 2.0f) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int innerNativeTwoFood = count$iv;
        Sequence<Tile> $i$f$count22 = startTile.getTilesAtDistance(2);
        boolean $i$f$count = false;
        int count$iv2 = 0;
        for (Object element$iv : $this$count$iv) {
            Tile it4 = (Tile)element$iv;
            boolean bl = false;
            if (!(INSTANCE.getPotentialYield(it4, Stat.Food, true) >= 2.0f) || ++count$iv2 >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int outerNativeTwoFood = count$iv2;
        int totalNativeTwoFood = innerNativeTwoFood + outerNativeTwoFood;
        int n5 = minorCiv ? (totalFood < 12 || innerFood < 4 ? 2 : (totalFood < 16 || innerFood < 9 ? 1 : 0)) : (innerFood == 0 && totalFood < 4 ? 5 : (totalFood < 6 ? 4 : (totalFood < 8 || totalFood < 12 && innerFood < 5 ? 3 : (totalFood < 17 && innerFood < 9 || totalNativeTwoFood < 2 ? 2 : (bonusesNeeded = totalFood < 24 && innerFood < 11 || totalNativeTwoFood == 2 || innerNativeTwoFood == 0 || totalFood < 20 ? 1 : 0)))));
        if (tileMap.getMapParameters().legendaryStartGetter()) {
            bonusesNeeded += 2;
        }
        if (!minorCiv && bonusesNeeded < 3 && totalNativeTwoFood == 0) {
            Tile spot;
            Object v2;
            block10: {
                Collection<Terrain> collection = ruleset.getTerrains().values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Terrain it5 = (Terrain)element$iv;
                    boolean bl = false;
                    if (!(it5.getType() == TerrainType.Land && it5.getFood() >= 2.0f)) continue;
                    v2 = element$iv;
                    break block10;
                }
                v2 = null;
            }
            Terrain terrain = v2;
            String twoFoodTerrain = terrain != null ? terrain.getName() : null;
            Sequence<Tile> candidateInnerSpots = SequencesKt.filter(startTile.getNeighbors(), StartNormalizer::calculateFoodBonusesNeeded$lambda$5);
            Sequence<Tile> candidateOuterSpots = SequencesKt.filter(startTile.getTilesAtDistance(2), StartNormalizer::calculateFoodBonusesNeeded$lambda$6);
            Tile tile = SequencesKt.firstOrNull(SequencesKt.shuffled(candidateInnerSpots));
            if (tile == null) {
                tile = spot = SequencesKt.firstOrNull(SequencesKt.shuffled(candidateOuterSpots));
            }
            if (twoFoodTerrain != null && spot != null) {
                spot.setBaseTerrain(twoFoodTerrain);
            } else {
                bonusesNeeded = 3;
            }
        }
        return bonusesNeeded;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void placeFoodBonuses(boolean minorCiv, Tile startTile, Ruleset ruleset, int foodBonusesNeeded) {
        block19: {
            bonusesStillNeeded = foodBonusesNeeded;
            v0 = ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
            $this$firstOrNull$iv = v0;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                block18: {
                    it = (Terrain)element$iv;
                    $i$a$-firstOrNull-StartNormalizer$placeFoodBonuses$oasisEquivalent$1 = false;
                    if (it.getType() != TerrainType.TerrainFeature) ** GOTO lbl-1000
                    Intrinsics.checkNotNull(it);
                    if (!IHasUniques.hasUnique$default(it, UniqueType.RareFeature, null, 2, null) || !(it.getFood() >= 2.0f) || !(it.getFood() + it.getProduction() + it.getGold() >= 3.0f)) ** GOTO lbl-1000
                    $this$any$iv = it.getOccursOn();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            base = (String)element$iv /* !! */ ;
                            $i$a$-any-StartNormalizer$placeFoodBonuses$oasisEquivalent$1$1 = false;
                            v2 = ruleset.getTerrains().get(base);
                            Intrinsics.checkNotNull(v2);
                            if (!(v2.getType() == TerrainType.Land)) continue;
                            v1 = true;
                            break block18;
                        }
                        v1 = false;
                    }
                }
                if (v1) {
                    v3 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v3 = false;
                }
                if (!v3) continue;
                v4 = element$iv;
                break block19;
            }
            v4 = null;
        }
        oasisEquivalent = v4;
        canPlaceOasis = oasisEquivalent != null;
        placedInFirst = 0;
        placedInSecond = 0;
        rangeForBonuses = minorCiv != false ? 2 : 3;
        $this$sortedBy$iv = SequencesKt.shuffled(SequencesKt.filter(startTile.getTilesInDistanceRange(new IntRange(1, rangeForBonuses)), (Function1<Tile, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, placeFoodBonuses$lambda$1(com.unciv.models.ruleset.tile.Terrain com.unciv.logic.map.tile.Tile ), (Lcom/unciv/logic/map/tile/Tile;)Ljava/lang/Boolean;)((Terrain)oasisEquivalent)));
        $i$f$sortedBy = false;
        candidatePlots = SequencesKt.toMutableList(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(startTile){
            final /* synthetic */ Tile $startTile$inlined;
            {
                this.$startTile$inlined = tile;
            }

            public final int compare(T a, T b) {
                Tile it = (Tile)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$startTile$inlined));
                it = (Tile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$startTile$inlined));
            }
        }));
        while (bonusesStillNeeded > 0 && ((Collection)candidatePlots).isEmpty() == false) {
            plot = CollectionsKt.first(candidatePlots);
            candidatePlots.remove(plot);
            if (plot.getBaseTerrain().hasUnique(UniqueType.BlocksResources, new GameContext(null, null, null, null, null, null, plot, null, null, null, false, 1983, null))) continue;
            v5 = ruleset.getTileResources().values();
            Intrinsics.checkNotNullExpressionValue(v5, "<get-values>(...)");
            $this$filter$iv = v5;
            $i$f$filter = false;
            element$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TileResource)element$iv$iv;
                $i$a$-filter-StartNormalizer$placeFoodBonuses$validBonuses$1 = false;
                if (!(it.getResourceType() == ResourceType.Bonus && it.getFood() >= 1.0f && it.generatesNaturallyOn(plot) != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            validBonuses = (List)destination$iv$iv;
            if (!canPlaceOasis) ** GOTO lbl-1000
            v6 = oasisEquivalent;
            Intrinsics.checkNotNull(v6);
            if (v6.getOccursOn().contains(plot.getLastTerrain().getName())) {
                v7 = true;
            } else lbl-1000:
            // 2 sources

            {
                v7 = goodPlotForOasis = false;
            }
            if (!(((Collection)validBonuses).isEmpty() == false) && !goodPlotForOasis) continue;
            if (goodPlotForOasis) {
                v8 = oasisEquivalent;
                Intrinsics.checkNotNull(v8);
                plot.addTerrainFeature(v8.getName());
                canPlaceOasis = false;
            } else {
                v9 = CollectionsKt.random(validBonuses, Random.Default);
                Intrinsics.checkNotNullExpressionValue(v9, "random(...)");
                Tile.setTileResource$default(plot, (TileResource)v9, null, null, 6, null);
            }
            if (plot.aerialDistanceTo(startTile) == 1) {
                if (++placedInFirst == 2) {
                    $this$sortBy$iv = candidatePlots;
                    $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        CollectionsKt.sortWith($this$sortBy$iv, new Comparator(startTile){
                            final /* synthetic */ Tile $startTile$inlined;
                            {
                                this.$startTile$inlined = tile;
                            }

                            public final int compare(T a, T b) {
                                Tile it = (Tile)a;
                                boolean bl = false;
                                Comparable comparable = Integer.valueOf(Math.abs(it.aerialDistanceTo(this.$startTile$inlined) * 10 - 22));
                                it = (Tile)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues(comparable2, Math.abs(it.aerialDistanceTo(this.$startTile$inlined) * 10 - 22));
                            }
                        });
                    }
                }
            } else if (plot.aerialDistanceTo(startTile) == 2 && ++placedInSecond == 3) {
                $this$sortByDescending$iv = candidatePlots;
                $i$f$sortByDescending = false;
                if ($this$sortByDescending$iv.size() > 1) {
                    CollectionsKt.sortWith($this$sortByDescending$iv, new Comparator(startTile){
                        final /* synthetic */ Tile $startTile$inlined;
                        {
                            this.$startTile$inlined = tile;
                        }

                        public final int compare(T a, T b) {
                            Tile it = (Tile)b;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(Math.abs(it.aerialDistanceTo(this.$startTile$inlined) * 10 - 17));
                            it = (Tile)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues(comparable2, Math.abs(it.aerialDistanceTo(this.$startTile$inlined) * 10 - 17));
                        }
                    });
                }
            }
            --bonusesStillNeeded;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final float getPotentialYield(Tile tile, Stat stat, boolean unimproved) {
        Float bestImprovementYield;
        Float f;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        float baseYield = TileStatFunctions.getTileStats$default(tile.getStats(), null, null, 2, null).get(stat);
        if (unimproved) {
            return baseYield;
        }
        Ruleset ruleset = tile.getTileMap().getRuleset();
        Intrinsics.checkNotNull(ruleset);
        Collection<TileImprovement> collection = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileImprovement it = (TileImprovement)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!(!IHasUniques.hasUnique$default(it, UniqueType.GreatImprovement, null, 2, null) && it.getUniqueTo() == null && it.getTerrainsCanBeBuiltOn().contains(tile.getLastTerrain().getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator2 = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator2.hasNext()) {
            f = null;
        } else {
            TileImprovement it = (TileImprovement)iterator2.next();
            boolean bl = false;
            float f2 = it.get(stat);
            while (iterator2.hasNext()) {
                TileImprovement it2 = (TileImprovement)iterator2.next();
                $i$a$-maxOfOrNull-StartNormalizer$getPotentialYield$bestImprovementYield$2 = false;
                float f3 = it2.get(stat);
                f2 = Math.max(f2, f3);
            }
            f = Float.valueOf(f2);
        }
        Float f4 = bestImprovementYield = f;
        return baseYield + (f4 != null ? f4.floatValue() : 0.0f);
    }

    static /* synthetic */ float getPotentialYield$default(StartNormalizer startNormalizer, Tile tile, Stat stat, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return startNormalizer.getPotentialYield(tile, stat, bl);
    }

    private static final boolean normalizeProduction$lambda$3(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isLand() && it.getTerrainFeatures().isEmpty() && !Tile.isAdjacentTo$default(it, "Fresh water", null, 2, null) && !it.isImpassible();
    }

    private static final boolean placeStrategicBalanceResources$lambda$1(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isWater() && !it.isImpassible();
    }

    private static final boolean placeStrategicBalanceResources$lambda$2(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isLand() && !it.isImpassible();
    }

    private static final boolean addProductionBonuses$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isLand() && INSTANCE.getPotentialYield(it, Stat.Food, true) >= 2.0f && StartNormalizer.getPotentialYield$default(INSTANCE, it, Stat.Production, false, 4, null) == 0.0f;
    }

    private static final boolean addProductionBonuses$lambda$1(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isLand() && StartNormalizer.getPotentialYield$default(INSTANCE, it, Stat.Food, false, 4, null) >= 2.0f && INSTANCE.getPotentialYield(it, Stat.Production, true) >= 1.0f;
    }

    private static final boolean calculateFoodBonusesNeeded$lambda$5(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isLand() && !it.isImpassible() && it.getTerrainFeatures().isEmpty() && it.getResource() == null;
    }

    private static final boolean calculateFoodBonusesNeeded$lambda$6(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isLand() && !it.isImpassible() && it.getTerrainFeatures().isEmpty() && it.getResource() == null;
    }

    private static final boolean placeFoodBonuses$lambda$1(Terrain $oasisEquivalent, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getResource() == null && !CollectionsKt.contains((Iterable)it.getTerrainFeatureObjects(), $oasisEquivalent);
    }
}

