/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapunit.movement;

import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.PathingMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.MovementCost;
import com.unciv.logic.map.mapunit.movement.PathfindingCache;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.UnitMovementMemoryType;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.InternalState;
import yairm210.purity.annotations.Readonly;

@InternalState
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0003abcB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J|\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020 2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+2\u001c\b\u0002\u0010,\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010 0-j\n\u0012\u0006\u0012\u0004\u0018\u00010 `.2$\b\u0002\u0010/\u001a\u001e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020(00j\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020(`22\b\b\u0002\u00103\u001a\u00020 H\u0007J \u00104\u001a\b\u0012\u0004\u0012\u00020\"052\u0006\u00106\u001a\u00020\"2\b\b\u0002\u00107\u001a\u00020 H\u0007J\u0010\u00108\u001a\u00020\"2\u0006\u00109\u001a\u00020\"H\u0007J\u000e\u0010:\u001a\u00020\"2\u0006\u00106\u001a\u00020\"J\u0010\u0010;\u001a\u00020 2\u0006\u00106\u001a\u00020\"H\u0007J\u0010\u0010<\u001a\u00020 2\u0006\u00106\u001a\u00020\"H\u0007J'\u0010=\u001a\u00020 2\u0006\u00106\u001a\u00020\"2\u0014\b\u0001\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020 0?H\u0083\bJ\u0018\u0010@\u001a\b\u0012\u0004\u0012\u00020\"0A2\b\b\u0002\u00103\u001a\u00020 H\u0007J\u0010\u0010B\u001a\u00020 2\u0006\u00106\u001a\u00020\"H\u0007J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020\"0AH\u0007J\u001a\u0010D\u001a\u00020 2\u0006\u0010E\u001a\u00020\"2\b\b\u0002\u0010F\u001a\u00020 H\u0003J\u0006\u0010G\u001a\u00020HJ\u0018\u0010I\u001a\u00020H2\u0006\u00106\u001a\u00020\"2\b\b\u0002\u0010)\u001a\u00020 J\u0018\u0010J\u001a\u00020H2\u0006\u00106\u001a\u00020\"2\b\b\u0002\u0010K\u001a\u00020 J\u0010\u0010L\u001a\u00020H2\u0006\u00106\u001a\u00020\"H\u0002J\u0010\u0010M\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0003J.\u0010N\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010O\u001a\u00020 2\b\b\u0002\u0010P\u001a\u00020 2\b\b\u0002\u00103\u001a\u00020 H\u0007J0\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010O\u001a\u00020 2\b\b\u0002\u0010P\u001a\u00020 2\b\b\u0002\u00103\u001a\u00020 H\u0007J\u001a\u0010S\u001a\u0004\u0018\u00010R2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u0003H\u0003J\u0018\u0010T\u001a\u00020 2\u0006\u00106\u001a\u00020\"2\u0006\u0010U\u001a\u000201H\u0003J\u001a\u0010V\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u00103\u001a\u00020 H\u0007Jh\u0010W\u001a\u00020$2\b\b\u0002\u0010)\u001a\u00020 2 \b\u0002\u0010X\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010-j\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u0001`.2(\b\u0002\u0010/\u001a\"\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020(\u0018\u000100j\u0010\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020(\u0018\u0001`22\b\b\u0002\u00103\u001a\u00020 H\u0007J\u0018\u0010Y\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u0001052\u0006\u0010Z\u001a\u00020\"H\u0007JB\u0010[\u001a>\u0012\u0004\u0012\u00020\"\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\"0-j\b\u0012\u0004\u0012\u00020\"`.00j\u001e\u0012\u0004\u0012\u00020\"\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\"0-j\b\u0012\u0004\u0012\u00020\"`.`2J\u001e\u0010\\\u001a\b\u0012\u0004\u0012\u00020\"0]2\u0006\u0010^\u001a\u00020\"2\u0006\u0010_\u001a\u00020\"H\u0002J\u0006\u0010`\u001a\u00020HR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000bR!\u0010\f\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\u000e\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0012\u0012\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0015\u0010\u0010R!\u0010\u0017\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u0012\u0012\u0004\b\u0018\u0010\u000b\u001a\u0004\b\u0019\u0010\u0010R!\u0010\u001b\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0012\u0012\u0004\b\u001c\u0010\u000b\u001a\u0004\b\u001d\u0010\u0010\u00a8\u0006d\u00b2\u0006\n\u0010e\u001a\u00020 X\u008a\u0084\u0002"}, d2={"Lcom/unciv/logic/map/mapunit/movement/UnitMovement;", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "<init>", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "pathfindingCache", "Lcom/unciv/logic/map/mapunit/movement/PathfindingCache;", "getPathfindingCache$annotations", "()V", "aStarPathing", "Lcom/unciv/logic/map/PathingMap;", "getAStarPathing$annotations", "getAStarPathing", "()Lcom/unciv/logic/map/PathingMap;", "aStarPathing$delegate", "Lkotlin/Lazy;", "aStarPathingWithoutZoneControl", "getAStarPathingWithoutZoneControl$annotations", "getAStarPathingWithoutZoneControl", "aStarPathingWithoutZoneControl$delegate", "aStarPathingWithoutEscort", "getAStarPathingWithoutEscort$annotations", "getAStarPathingWithoutEscort", "aStarPathingWithoutEscort$delegate", "roadPathing", "getRoadPathing$annotations", "getRoadPathing", "roadPathing$delegate", "isUnknownTileWeShouldAssumeToBePassable", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "getMovementToTilesAtPosition", "Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "position", "Lcom/unciv/logic/map/HexCoord;", "unitMovement", "", "considerZoneOfControl", "tilesToIgnoreBitset", "Ljava/util/BitSet;", "canPassThroughCache", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "movementCostCache", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "includeOtherEscortUnit", "getShortestPath", "", "destination", "avoidDamagingTerrain", "getTileToMoveToThisTurn", "finalDestination", "headTowards", "canReach", "canReachInCurrentTurn", "canReachCommon", "specificFunction", "Lkotlin/Function1;", "getReachableTilesInCurrentTurn", "Lkotlin/sequences/Sequence;", "canUnitSwapTo", "getUnitSwappableTiles", "canUnitSwapToReachableTile", "reachableTile", "checkEscorted", "teleportToClosestMoveableTile", "", "moveToTile", "swapMoveToTile", "keepEscorting", "swapMoveEscortPair", "isCityCenterCannotEnter", "canMoveTo", "assumeCanPassThrough", "allowSwap", "getCannotMoveToReason", "Lcom/unciv/logic/map/mapunit/movement/UnitMovement$CannotMoveToReason;", "getAirUnitCannotMoveToReason", "canParadropOn", "distance", "canPassThrough", "getDistanceToTiles", "passThroughCacheNew", "getRoadPath", "destinationTile", "getAerialPathsToCities", "getPathBetweenTiles", "", "from", "to", "clearPathfindingCache", "ParentTileAndTotalMovement", "UnreachableDestinationException", "CannotMoveToReason", "core", "unitSpecificAllowOcean"})
@SourceDebugExtension(value={"SMAP\nUnitMovement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitMovement.kt\ncom/unciv/logic/map/mapunit/movement/UnitMovement\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,971:1\n328#1,10:1021\n328#1,10:1031\n383#2,7:972\n383#2,7:981\n540#2:1042\n525#2,6:1043\n2296#3,2:979\n1253#3,2:990\n1944#3,14:1007\n184#3,2:1049\n1276#3,2:1076\n832#4:988\n862#4:989\n863#4:992\n2439#4,14:993\n1404#4:1051\n1496#4,5:1052\n1068#4:1057\n296#4,2:1058\n975#4,7:1060\n546#4,6:1067\n777#4:1073\n873#4,2:1074\n1#5:1041\n*S KotlinDebug\n*F\n+ 1 UnitMovement.kt\ncom/unciv/logic/map/mapunit/movement/UnitMovement\n*L\n317#1:1021,10\n323#1:1031,10\n114#1:972,7\n242#1:981,7\n355#1:1042\n355#1:1043,6\n160#1:979,2\n261#1:990,2\n298#1:1007,14\n436#1:1049,2\n775#1:1076,2\n261#1:988\n261#1:989\n261#1:992\n284#1:993,14\n442#1:1051\n442#1:1052,5\n443#1:1057\n443#1:1058,2\n502#1:1060,7\n503#1:1067,6\n718#1:1073\n718#1:1074,2\n*E\n"})
public final class UnitMovement {
    @NotNull
    private final MapUnit unit;
    @NotNull
    private final PathfindingCache pathfindingCache;
    @NotNull
    private final Lazy aStarPathing$delegate;
    @NotNull
    private final Lazy aStarPathingWithoutZoneControl$delegate;
    @NotNull
    private final Lazy aStarPathingWithoutEscort$delegate;
    @NotNull
    private final Lazy roadPathing$delegate;

    public UnitMovement(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
        this.pathfindingCache = new PathfindingCache(this.unit);
        this.aStarPathing$delegate = LazyKt.lazy(() -> UnitMovement.aStarPathing_delegate$lambda$0(this));
        this.aStarPathingWithoutZoneControl$delegate = LazyKt.lazy(() -> UnitMovement.aStarPathingWithoutZoneControl_delegate$lambda$0(this));
        this.aStarPathingWithoutEscort$delegate = LazyKt.lazy(() -> UnitMovement.aStarPathingWithoutEscort_delegate$lambda$0(this));
        this.roadPathing$delegate = LazyKt.lazy(() -> UnitMovement.roadPathing_delegate$lambda$0(this));
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    @Cache
    private static /* synthetic */ void getPathfindingCache$annotations() {
    }

    private final PathingMap getAStarPathing() {
        Lazy lazy = this.aStarPathing$delegate;
        return (PathingMap)lazy.getValue();
    }

    @Cache
    private static /* synthetic */ void getAStarPathing$annotations() {
    }

    private final PathingMap getAStarPathingWithoutZoneControl() {
        Lazy lazy = this.aStarPathingWithoutZoneControl$delegate;
        return (PathingMap)lazy.getValue();
    }

    @Cache
    private static /* synthetic */ void getAStarPathingWithoutZoneControl$annotations() {
    }

    private final PathingMap getAStarPathingWithoutEscort() {
        Lazy lazy = this.aStarPathingWithoutEscort$delegate;
        return (PathingMap)lazy.getValue();
    }

    @Cache
    private static /* synthetic */ void getAStarPathingWithoutEscort$annotations() {
    }

    private final PathingMap getRoadPathing() {
        Lazy lazy = this.roadPathing$delegate;
        return (PathingMap)lazy.getValue();
    }

    @Cache
    private static /* synthetic */ void getRoadPathing$annotations() {
    }

    @Readonly
    public final boolean isUnknownTileWeShouldAssumeToBePassable(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return !this.unit.getCiv().hasExplored(tile);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final PathsToTilesWithinTurn getMovementToTilesAtPosition(@NotNull HexCoord position, float unitMovement, boolean considerZoneOfControl, @Nullable BitSet tilesToIgnoreBitset, @NotNull ArrayList<Boolean> canPassThroughCache, @NotNull HashMap<Integer, Float> movementCostCache, boolean includeOtherEscortUnit) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(canPassThroughCache, "canPassThroughCache");
        Intrinsics.checkNotNullParameter(movementCostCache, "movementCostCache");
        if (UncivGame.Companion.getCurrent().getSettings().getUseAStarPathfinding()) {
            if (!considerZoneOfControl && !includeOtherEscortUnit) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            PathingMap pathingMap = !considerZoneOfControl ? this.getAStarPathingWithoutZoneControl() : (includeOtherEscortUnit || !this.unit.isEscorting() ? this.getAStarPathing() : this.getAStarPathingWithoutEscort());
            return pathingMap.getMovementToTilesAtPosition();
        }
        PathsToTilesWithinTurn distanceToTiles = new PathsToTilesWithinTurn();
        Tile currentUnitTile = this.unit.getCurrentTile();
        Tile unitTile = Intrinsics.areEqual(position, currentUnitTile.getPosition()) ? currentUnitTile : currentUnitTile.getTileMap().get(position);
        ((Map)distanceToTiles).put(unitTile, new ParentTileAndTotalMovement(unitTile, unitTile, 0.0f));
        if (unitMovement == 0.0f || this.unit.getCache().getCannotMove()) {
            return distanceToTiles;
        }
        if (includeOtherEscortUnit && this.unit.isEscorting()) {
            MapUnit mapUnit = this.unit.getOtherEscortUnit();
            if (Intrinsics.areEqual(mapUnit != null ? Float.valueOf(mapUnit.getCurrentMovement()) : null, 0.0f)) {
                return distanceToTiles;
            }
        }
        List tilesToCheck = CollectionsKt.listOf(unitTile);
        while (!((Collection)tilesToCheck).isEmpty()) {
            ArrayList updatedTiles = new ArrayList();
            for (Tile tileToCheck : tilesToCheck) {
                Iterator<Tile> iterator2 = tileToCheck.getNeighbors().iterator();
                while (iterator2.hasNext()) {
                    float usableMovement;
                    float f;
                    ParentTileAndTotalMovement currentBestPath;
                    float totalDistanceToTile;
                    float f2;
                    Tile neighbor = iterator2.next();
                    if (tilesToIgnoreBitset != null) {
                        if (tilesToIgnoreBitset.get(neighbor.getZeroBasedIndex())) continue;
                    }
                    if (!neighbor.isExplored(this.unit.getCiv())) {
                        Object object = distanceToTiles.get((Object)tileToCheck);
                        Intrinsics.checkNotNull(object);
                        f2 = ((ParentTileAndTotalMovement)object).getTotalMovement() + 1.0f;
                    } else if (!CollectionExtensionsKt.getOrPut(canPassThroughCache, neighbor.getZeroBasedIndex(), () -> UnitMovement.getMovementToTilesAtPosition$lambda$0(this, neighbor)).booleanValue()) {
                        f2 = unitMovement;
                    } else {
                        Object object;
                        void $this$getOrPut$iv;
                        int key = HexMath.INSTANCE.tilesAndNeighborUniqueIndex(tileToCheck, neighbor);
                        Map map2 = movementCostCache;
                        Integer key$iv = key;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            Float answer$iv = Float.valueOf(MovementCost.INSTANCE.getMovementCostBetweenAdjacentTilesEscort(this.unit, tileToCheck, neighbor, considerZoneOfControl, includeOtherEscortUnit));
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        float movementCost = ((Number)object).floatValue();
                        Object object2 = distanceToTiles.get((Object)tileToCheck);
                        Intrinsics.checkNotNull(object2);
                        f2 = totalDistanceToTile = ((ParentTileAndTotalMovement)object2).getTotalMovement() + movementCost;
                    }
                    if ((currentBestPath = (ParentTileAndTotalMovement)distanceToTiles.get((Object)neighbor)) != null && !(currentBestPath.getTotalMovement() > totalDistanceToTile)) continue;
                    if (includeOtherEscortUnit && this.unit.isEscorting()) {
                        MapUnit mapUnit = this.unit.getOtherEscortUnit();
                        Intrinsics.checkNotNull(mapUnit);
                        f = Math.min(unitMovement, mapUnit.getCurrentMovement());
                    } else {
                        f = usableMovement = unitMovement;
                    }
                    if (totalDistanceToTile < usableMovement - 0.05f) {
                        ((Collection)updatedTiles).add(neighbor);
                    } else {
                        totalDistanceToTile = usableMovement;
                    }
                    ((Map)distanceToTiles).put(neighbor, new ParentTileAndTotalMovement(neighbor, tileToCheck, totalDistanceToTile));
                }
            }
            tilesToCheck = updatedTiles;
        }
        return distanceToTiles;
    }

    public static /* synthetic */ PathsToTilesWithinTurn getMovementToTilesAtPosition$default(UnitMovement unitMovement, HexCoord hexCoord, float f, boolean bl, BitSet bitSet, ArrayList arrayList, HashMap hashMap, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bitSet = null;
        }
        if ((n & 0x10) != 0) {
            arrayList = new ArrayList<Boolean>();
        }
        if ((n & 0x20) != 0) {
            hashMap = new HashMap<Integer, Float>();
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        return unitMovement.getMovementToTilesAtPosition(hexCoord, f, bl, bitSet, arrayList, hashMap, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<Tile> getShortestPath(@NotNull Tile destination, boolean avoidDamagingTerrain) {
        boolean bl;
        block22: {
            List<Tile> damageFreePath;
            Intrinsics.checkNotNullParameter(destination, "destination");
            if (this.unit.getCache().getCannotMove()) {
                return CollectionsKt.emptyList();
            }
            if (UncivGame.Companion.getCurrent().getSettings().getUseAStarPathfinding()) {
                List list2 = PathingMap.getShortestPath$default(this.getAStarPathing(), destination, 0, 2, null);
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                return list2;
            }
            if (!avoidDamagingTerrain && this.unit.getCiv().getPassThroughImpassableUnlocked() && this.unit.getBaseUnit().isLandUnit() && !((Collection)(damageFreePath = this.getShortestPath(destination, true))).isEmpty()) {
                return damageFreePath;
            }
            Sequence<Tile> $this$none$iv = destination.getNeighbors();
            boolean $i$f$none = false;
            Iterator<Tile> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(this.isUnknownTileWeShouldAssumeToBePassable(it) || UnitMovement.canPassThrough$default(this, it, false, 2, null))) continue;
                bl = false;
                break block22;
            }
            bl = true;
        }
        if (bl) {
            this.pathfindingCache.setShortestPathCache(destination, CollectionsKt.emptyList());
            return CollectionsKt.emptyList();
        }
        List<Tile> cachedPath = this.pathfindingCache.getShortestPathCache(destination);
        if (!((Collection)cachedPath).isEmpty()) {
            return cachedPath;
        }
        Tile currentTile = this.unit.getTile();
        if (Intrinsics.areEqual(currentTile.getPosition(), destination.getPosition())) {
            this.pathfindingCache.setShortestPathCache(destination, CollectionsKt.listOf(currentTile));
            return CollectionsKt.listOf(currentTile);
        }
        List tilesToCheck = CollectionsKt.listOf(currentTile);
        HashMap movementTreeParents = new HashMap();
        ((Map)movementTreeParents).put(currentTile, null);
        int distance = 1;
        float unitMaxMovement = MapUnit.getMaxMovement$default(this.unit, false, 1, null);
        ArrayList<Tile> newTilesToCheck = new ArrayList<Tile>();
        BitSet visitedTilesBitset = new BitSet(currentTile.getTileMap().getTileList().size());
        visitedTilesBitset.set(currentTile.getZeroBasedIndex());
        Civilization civilization = this.unit.getCiv();
        ArrayList passThroughCacheNew = new ArrayList(currentTile.getTileMap().getTileList().size());
        HashMap movementCostCache = new HashMap();
        HashMap canMoveToCache = new HashMap();
        while (true) {
            void $this$filterNotTo$iv$iv;
            Object distanceToTilesThisTurn;
            Comparator comparator;
            Function1[] function1Array;
            newTilesToCheck.clear();
            if (this.unit.getType().isLandUnit()) {
                function1Array = new Function1[]{UnitMovement::getShortestPath$lambda$2, arg_0 -> UnitMovement.getShortestPath$lambda$3(destination, arg_0), new Function1<Tile, Boolean>(this){
                    final /* synthetic */ UnitMovement this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, Intrinsics.Kotlin.class, "isUnfriendlyCityState", "getShortestPath$isUnfriendlyCityState(Lcom/unciv/logic/map/mapunit/movement/UnitMovement;Lcom/unciv/logic/map/tile/Tile;)Z", 0);
                    }

                    public final Boolean invoke(Tile p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return UnitMovement.access$getShortestPath$isUnfriendlyCityState(this.this$0, p0);
                    }
                }};
                comparator = ComparisonsKt.compareBy(function1Array);
            } else {
                function1Array = new Function1[]{arg_0 -> UnitMovement.getShortestPath$lambda$4(destination, arg_0), new Function1<Tile, Boolean>(this){
                    final /* synthetic */ UnitMovement this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, Intrinsics.Kotlin.class, "isUnfriendlyCityState", "getShortestPath$isUnfriendlyCityState(Lcom/unciv/logic/map/mapunit/movement/UnitMovement;Lcom/unciv/logic/map/tile/Tile;)Z", 0);
                    }

                    public final Boolean invoke(Tile p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return UnitMovement.access$getShortestPath$isUnfriendlyCityState(this.this$0, p0);
                    }
                }};
                comparator = ComparisonsKt.compareBy(function1Array);
            }
            Comparator comparison2 = comparator;
            List<Tile> tilesByPreference = CollectionsKt.sortedWith(tilesToCheck, comparison2);
            for (Tile tileToCheck : tilesByPreference) {
                distanceToTilesThisTurn = distance == 1 ? UnitMovement.getDistanceToTiles$default(this, true, passThroughCacheNew, movementCostCache, false, 8, null) : UnitMovement.getMovementToTilesAtPosition$default(this, tileToCheck.getPosition(), unitMaxMovement, false, visitedTilesBitset, passThroughCacheNew, movementCostCache, false, 64, null);
                Iterator<Tile> iterator3 = ((PathsToTilesWithinTurn)distanceToTilesThisTurn).keySet().iterator();
                while (iterator3.hasNext()) {
                    Object path;
                    Tile reachableTile;
                    Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                    if (avoidDamagingTerrain && this.unit.getDamageFromTerrain(reachableTile) > 0 || this.unit.isCivilian() && this.unit.isAutomated() && reachableTile.isEnemyTerritory(civilization)) continue;
                    if (Intrinsics.areEqual(reachableTile, destination)) {
                        Tile[] tileArray = new Tile[]{destination};
                        path = CollectionsKt.mutableListOf(tileArray);
                        Tile intermediateTile = tileToCheck;
                        while (!Intrinsics.areEqual(intermediateTile, currentTile)) {
                            path.add(intermediateTile);
                            Object v = movementTreeParents.get(intermediateTile);
                            Intrinsics.checkNotNull(v);
                            intermediateTile = (Tile)v;
                        }
                        CollectionsKt.reverse(path);
                        this.pathfindingCache.setShortestPathCache(destination, (List<Tile>)path);
                        return path;
                    }
                    if (movementTreeParents.containsKey(reachableTile)) continue;
                    if (!this.isUnknownTileWeShouldAssumeToBePassable(reachableTile)) {
                        Object object;
                        void $this$getOrPut$iv;
                        path = canMoveToCache;
                        Tile key$iv = reachableTile;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl3 = false;
                            Boolean answer$iv = UnitMovement.canMoveTo$default(this, reachableTile, false, false, false, 14, null);
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        if (!((Boolean)object).booleanValue()) continue;
                    }
                    ((Map)movementTreeParents).put(reachableTile, tileToCheck);
                    newTilesToCheck.add(reachableTile);
                }
            }
            if (newTilesToCheck.isEmpty()) {
                this.pathfindingCache.setShortestPathCache(destination, CollectionsKt.emptyList());
                return CollectionsKt.emptyList();
            }
            Iterator iterator2 = newTilesToCheck.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<Tile> iterator5 = iterator2;
            while (iterator5.hasNext()) {
                Tile tile;
                Intrinsics.checkNotNullExpressionValue(iterator5.next(), "next(...)");
                visitedTilesBitset.set(tile.getZeroBasedIndex());
            }
            Iterable $this$filterNot$iv = newTilesToCheck;
            boolean $i$f$filterNot = false;
            distanceToTilesThisTurn = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                boolean bl2;
                block23: {
                    Tile tile = (Tile)element$iv$iv;
                    boolean bl5 = false;
                    Sequence<Tile> $this$all$iv = tile.getNeighbors();
                    boolean $i$f$all = false;
                    Iterator<Tile> iterator6 = $this$all$iv.iterator();
                    while (iterator6.hasNext()) {
                        Tile element$iv;
                        Tile it = element$iv = iterator6.next();
                        boolean bl6 = false;
                        if (visitedTilesBitset.get(it.getZeroBasedIndex())) continue;
                        bl2 = false;
                        break block23;
                    }
                    bl2 = true;
                }
                if (bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tilesToCheck = (List)destination$iv$iv;
            ++distance;
        }
    }

    public static /* synthetic */ List getShortestPath$default(UnitMovement unitMovement, Tile tile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return unitMovement.getShortestPath(tile, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final Tile getTileToMoveToThisTurn(@NotNull Tile finalDestination) {
        Tile tile;
        Tile tile2;
        Intrinsics.checkNotNullParameter(finalDestination, "finalDestination");
        Tile currentTile = this.unit.getTile();
        if (Intrinsics.areEqual(currentTile, finalDestination)) {
            return currentTile;
        }
        if ((this.unit.getBaseUnit().getMovesLikeAirUnits() || this.unit.isPreparingParadrop()) && UnitMovement.canMoveTo$default(this, finalDestination, false, false, false, 14, null)) {
            return finalDestination;
        }
        PathsToTilesWithinTurn distanceToTiles = UnitMovement.getDistanceToTiles$default(this, false, null, null, false, 15, null);
        if (!distanceToTiles.containsKey((Object)finalDestination)) {
            Tile tile3 = (Tile)CollectionsKt.firstOrNull(UnitMovement.getShortestPath$default(this, finalDestination, false, 2, null));
            if (tile3 == null) {
                throw new UnreachableDestinationException(this.unit + ' ' + this.unit.getCurrentTile() + " cannot reach " + finalDestination);
            }
            Tile shortestDestination = tile3;
            if (!((Map)distanceToTiles).containsKey(shortestDestination)) {
                Object t;
                Set<Tile> set = distanceToTiles.keySet();
                Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
                Iterable $this$minBy$iv = set;
                boolean $i$f$minByOrThrow = false;
                Iterator iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = minElem$iv;
                } else {
                    Tile it = (Tile)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = it.aerialDistanceTo(finalDestination);
                    do {
                        Object e$iv = iterator$iv.next();
                        Tile it2 = (Tile)e$iv;
                        $i$a$-minByOrThrow-UnitMovement$getTileToMoveToThisTurn$1 = false;
                        int v$iv = it2.aerialDistanceTo(finalDestination);
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = minElem$iv;
                }
                return (Tile)t;
            }
            return shortestDestination;
        }
        if (UnitMovement.canMoveTo$default(this, finalDestination, false, false, false, 14, null)) {
            return finalDestination;
        }
        Sequence<Tile> destinationNeighbors = finalDestination.getNeighbors();
        if (SequencesKt.contains(destinationNeighbors, tile2 = currentTile)) {
            tile = currentTile;
        } else {
            Object v4;
            void $this$minByOrNull$iv;
            Sequence<Tile> iterator$iv = SequencesKt.filter(destinationNeighbors, arg_0 -> UnitMovement.getTileToMoveToThisTurn$lambda$1(distanceToTiles, this, arg_0));
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv2 = $this$minByOrNull$iv.iterator();
            if (!iterator$iv2.hasNext()) {
                v4 = null;
            } else {
                Object minElem$iv = iterator$iv2.next();
                if (!iterator$iv2.hasNext()) {
                    v4 = minElem$iv;
                } else {
                    Tile it = (Tile)minElem$iv;
                    boolean bl = false;
                    float minValue$iv = ((ParentTileAndTotalMovement)MapsKt.getValue(distanceToTiles, it)).getTotalMovement();
                    do {
                        Object e$iv = iterator$iv2.next();
                        Tile it3 = (Tile)e$iv;
                        $i$a$-minByOrNull-UnitMovement$getTileToMoveToThisTurn$3 = false;
                        float v$iv = ((ParentTileAndTotalMovement)MapsKt.getValue(distanceToTiles, it3)).getTotalMovement();
                        if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv2.hasNext());
                    v4 = minElem$iv;
                }
            }
            if ((tile = (Tile)v4) == null) {
                tile = currentTile;
            }
        }
        return tile;
    }

    @NotNull
    public final Tile headTowards(@NotNull Tile destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Tile destinationTileThisTurn = this.getTileToMoveToThisTurn(destination);
        UnitMovement.moveToTile$default(this, destinationTileThisTurn, false, 2, null);
        return this.unit.getCurrentTile();
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final boolean canReach(@NotNull Tile destination) {
        boolean bl;
        void this_$iv;
        Intrinsics.checkNotNullParameter(destination, "destination");
        UnitMovement unitMovement = this;
        Tile destination$iv = destination;
        boolean $i$f$canReachCommon = false;
        if (this_$iv.unit.getCache().getCannotMove()) {
            bl = Intrinsics.areEqual(destination$iv, this_$iv.unit.getTile());
        } else if (this_$iv.unit.getBaseUnit().getMovesLikeAirUnits()) {
            bl = this_$iv.unit.getCurrentTile().aerialDistanceTo(destination$iv) <= this_$iv.unit.getMaxMovementForAirUnits();
        } else if (this_$iv.unit.isPreparingParadrop()) {
            bl = super.canParadropOn(destination$iv, this_$iv.unit.getCurrentTile().aerialDistanceTo(destination$iv));
        } else {
            Tile it = destination$iv;
            boolean bl2 = false;
            bl = CollectionsKt.any(UnitMovement.getShortestPath$default(this, it, false, 2, null));
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final boolean canReachInCurrentTurn(@NotNull Tile destination) {
        boolean bl;
        void this_$iv;
        Intrinsics.checkNotNullParameter(destination, "destination");
        UnitMovement unitMovement = this;
        Tile destination$iv = destination;
        boolean $i$f$canReachCommon = false;
        if (this_$iv.unit.getCache().getCannotMove()) {
            bl = Intrinsics.areEqual(destination$iv, this_$iv.unit.getTile());
        } else if (this_$iv.unit.getBaseUnit().getMovesLikeAirUnits()) {
            bl = this_$iv.unit.getCurrentTile().aerialDistanceTo(destination$iv) <= this_$iv.unit.getMaxMovementForAirUnits();
        } else if (this_$iv.unit.isPreparingParadrop()) {
            bl = super.canParadropOn(destination$iv, this_$iv.unit.getCurrentTile().aerialDistanceTo(destination$iv));
        } else {
            Tile it = destination$iv;
            boolean bl2 = false;
            bl = UnitMovement.getDistanceToTiles$default(this, false, null, null, false, 15, null).containsKey((Object)it);
        }
        return bl;
    }

    @Readonly
    private final boolean canReachCommon(Tile destination, @Readonly Function1<? super Tile, Boolean> specificFunction) {
        boolean $i$f$canReachCommon = false;
        return this.unit.getCache().getCannotMove() ? Intrinsics.areEqual(destination, this.unit.getTile()) : (this.unit.getBaseUnit().getMovesLikeAirUnits() ? this.unit.getCurrentTile().aerialDistanceTo(destination) <= this.unit.getMaxMovementForAirUnits() : (this.unit.isPreparingParadrop() ? this.canParadropOn(destination, this.unit.getCurrentTile().aerialDistanceTo(destination)) : specificFunction.invoke(destination).booleanValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final Sequence<Tile> getReachableTilesInCurrentTurn(boolean includeOtherEscortUnit) {
        Sequence<Tile> sequence;
        if (this.unit.getCache().getCannotMove()) {
            sequence = SequencesKt.sequenceOf(this.unit.getTile());
        } else if (this.unit.getBaseUnit().getMovesLikeAirUnits()) {
            sequence = this.unit.getTile().getTilesInDistanceRange(new IntRange(1, this.unit.getMaxMovementForAirUnits()));
        } else if (this.unit.isPreparingParadrop()) {
            Map<String, Integer> map2 = this.unit.getCache().getParadropDestinationTileFilters();
            Tile tile = this.unit.getTile();
            Iterator iterator2 = ((Iterable)map2.entrySet()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry it22 = (Map.Entry)iterator2.next();
            boolean bl = false;
            int it22 = ((Number)it22.getValue()).intValue();
            while (iterator2.hasNext()) {
                Map.Entry it32 = (Map.Entry)iterator2.next();
                $i$a$-maxOf-UnitMovement$getReachableTilesInCurrentTurn$1 = false;
                int it32 = ((Number)it32.getValue()).intValue();
                if (it22 >= it32) continue;
                it22 = it32;
            }
            int n = it22;
            sequence = SequencesKt.filter(tile.getTilesInDistance(n), arg_0 -> UnitMovement.getReachableTilesInCurrentTurn$lambda$1(this, arg_0));
        } else if (includeOtherEscortUnit && this.unit.isEscorting()) {
            void $this$filterTo$iv$iv;
            MapUnit mapUnit = this.unit.getOtherEscortUnit();
            Intrinsics.checkNotNull(mapUnit);
            Set<Tile> otherUnitTiles = SequencesKt.toSet(mapUnit.getMovement().getReachableTilesInCurrentTurn(false));
            Map $this$filter$iv = UnitMovement.getDistanceToTiles$default(this.unit.getMovement(), false, null, null, false, 15, null);
            boolean $i$f$filter = false;
            Map it32 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator3.next();
                boolean bl = false;
                if (!otherUnitTiles.contains(it.getKey())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            sequence = CollectionsKt.asSequence(destination$iv$iv.keySet());
        } else {
            Set<Tile> set = UnitMovement.getDistanceToTiles$default(this.unit.getMovement(), false, null, null, false, 15, null).keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            sequence = CollectionsKt.asSequence((Iterable)set);
        }
        return sequence;
    }

    public static /* synthetic */ Sequence getReachableTilesInCurrentTurn$default(UnitMovement unitMovement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return unitMovement.getReachableTilesInCurrentTurn(bl);
    }

    @Readonly
    public final boolean canUnitSwapTo(@NotNull Tile destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        return this.canReachInCurrentTurn(destination) && UnitMovement.canUnitSwapToReachableTile$default(this, destination, false, 2, null);
    }

    @Readonly
    @NotNull
    public final Sequence<Tile> getUnitSwappableTiles() {
        return SequencesKt.filter(UnitMovement.getReachableTilesInCurrentTurn$default(this, false, 1, null), arg_0 -> UnitMovement.getUnitSwappableTiles$lambda$0(this, arg_0));
    }

    @Readonly
    private final boolean canUnitSwapToReachableTile(Tile reachableTile, boolean checkEscorted) {
        if (this.unit.getBaseUnit().getMovesLikeAirUnits()) {
            return false;
        }
        if (Intrinsics.areEqual(reachableTile, this.unit.getTile())) {
            return false;
        }
        if (this.unit.getCache().getCannotMove()) {
            return false;
        }
        MapUnit escortedUnit = checkEscorted && this.unit.isEscorting() ? this.unit.getOtherEscortUnit() : null;
        MapUnit mapUnit = UnitMovement.canUnitSwapToReachableTile$getMatchInReachableTile(this.unit, reachableTile);
        if (mapUnit == null) {
            MapUnit mapUnit2 = escortedUnit;
            mapUnit = mapUnit2 != null ? UnitMovement.canUnitSwapToReachableTile$getMatchInReachableTile(mapUnit2, reachableTile) : null;
            if (mapUnit == null) {
                return false;
            }
        }
        MapUnit otherUnit = mapUnit;
        Tile ourPosition = this.unit.getTile();
        if (!Intrinsics.areEqual(otherUnit.getOwner(), this.unit.getOwner()) || otherUnit.getCache().getCannotMove() || !otherUnit.getMovement().canReachInCurrentTurn(ourPosition)) {
            return false;
        }
        if (!UnitMovement.canMoveTo$default(this, reachableTile, false, true, false, 10, null)) {
            return false;
        }
        if (!UnitMovement.canMoveTo$default(otherUnit.getMovement(), ourPosition, false, true, false, 10, null)) {
            return false;
        }
        if (escortedUnit == null) {
            return true;
        }
        if (UnitMovement.canMoveTo$default(escortedUnit.getMovement(), reachableTile, false, false, false, 2, null)) {
            return true;
        }
        return escortedUnit.getMovement().canUnitSwapToReachableTile(reachableTile, false);
    }

    static /* synthetic */ boolean canUnitSwapToReachableTile$default(UnitMovement unitMovement, Tile tile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return unitMovement.canUnitSwapToReachableTile(tile, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void teleportToClosestMoveableTile() {
        Object element$iv;
        this.unit.stopEscorting();
        if (this.unit.isTransported()) {
            return;
        }
        Tile allowedTile = null;
        int distance = 0;
        if (UnitMovement.canPassThrough$default(this, this.unit.getTile(), false, 2, null) && !this.isCityCenterCannotEnter(this.unit.getTile())) {
            return;
        }
        while (allowedTile == null && distance < 5) {
            Object object;
            block11: {
                Sequence<Tile> $this$firstOrNull$iv = SequencesKt.filter(this.unit.getTile().getTilesAtDistance(++distance), arg_0 -> UnitMovement.teleportToClosestMoveableTile$lambda$0(this, arg_0));
                boolean $i$f$firstOrNull = false;
                Iterator<Tile> iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    if (!this.getPathBetweenTiles(this.unit.getCurrentTile(), it).contains(it)) continue;
                    object = element$iv;
                    break block11;
                }
                object = null;
            }
            allowedTile = (Tile)object;
        }
        Tile origin2 = this.unit.getTile();
        if (allowedTile == null) {
            Object v1;
            block12: {
                void $this$firstOrNull$iv;
                Iterable $this$sortedBy$iv;
                Iterator $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = this.unit.getCiv().getCities();
                boolean $i$f$flatMapSequence = false;
                element$iv = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapSequenceTo = false;
                Iterator iterator3 = $this$flatMapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv$iv = iterator3.next();
                    City it = (City)element$iv$iv;
                    boolean bl = false;
                    Sequence<Tile> list$iv$iv = it.getTiles();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(origin2){
                    final /* synthetic */ Tile $origin$inlined;
                    {
                        this.$origin$inlined = tile;
                    }

                    public final int compare(T a, T b) {
                        Tile it = (Tile)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$origin$inlined));
                        it = (Tile)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$origin$inlined));
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Tile it = (Tile)element$iv2;
                    boolean bl = false;
                    if (!UnitMovement.canMoveTo$default(this, it, false, false, false, 14, null)) continue;
                    v1 = element$iv2;
                    break block12;
                }
                v1 = null;
            }
            allowedTile = v1;
        }
        if (allowedTile != null) {
            this.unit.removeFromTile();
            this.unit.putInTile(allowedTile);
            if (this.unit.isSleeping() || this.unit.isFortified() || this.unit.isGuarding()) {
                this.unit.setAction(null);
            }
            this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitTeleported);
            List<MapUnit> payloadUnits = SequencesKt.toList(SequencesKt.filter(origin2.getUnits(), arg_0 -> UnitMovement.teleportToClosestMoveableTile$lambda$5(this, arg_0)));
            for (MapUnit payload : payloadUnits) {
                payload.removeFromTile();
                payload.putInTile(allowedTile);
                payload.setTransported(true);
                payload.setMostRecentMoveType(UnitMovementMemoryType.UnitTeleported);
            }
        } else {
            MapUnit.destroy$default(this.unit, false, 1, null);
        }
    }

    public final void moveToTile(@NotNull Tile destination, boolean considerZoneOfControl) {
        Object v2;
        PathsToTilesWithinTurn distanceToTiles;
        MapUnit escortUnit;
        block21: {
            List movableTiles;
            MapUnit mapUnit;
            Intrinsics.checkNotNullParameter(destination, "destination");
            if (Intrinsics.areEqual(destination, this.unit.getTile()) || this.unit.isDestroyed()) {
                return;
            }
            if (this.unit.isEscorting()) {
                MapUnit mapUnit2 = this.unit.getOtherEscortUnit();
                mapUnit = mapUnit2;
                Intrinsics.checkNotNull(mapUnit2);
            } else {
                mapUnit = escortUnit = null;
            }
            if (this.unit.getBaseUnit().getMovesLikeAirUnits()) {
                if (!Intrinsics.areEqual(this.unit.getAction(), UnitActionType.Automate.getValue())) {
                    this.unit.setAction(null);
                }
                this.unit.removeFromTile();
                this.unit.setTransported(false);
                this.unit.putInTile(destination);
                this.unit.setCurrentMovement(0.0f);
                this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitTeleported);
                return;
            }
            if (this.unit.isPreparingParadrop()) {
                this.unit.setAction(null);
                this.unit.removeFromTile();
                this.unit.putInTile(destination);
                this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitTeleported);
                this.unit.useMovementPoints(1.0f);
                MapUnit mapUnit3 = this.unit;
                mapUnit3.setAttacksThisTurn(mapUnit3.getAttacksThisTurn() + 1);
                if (this.unit.canGarrison() && (this.unit.getTile().isCityCenter() || destination.isCityCenter()) && Civilization.hasUnique$default(this.unit.getCiv(), UniqueType.UnitsInCitiesNoMaintenance, null, 2, null)) {
                    this.unit.getCiv().updateStatsForNextTurn();
                }
                return;
            }
            distanceToTiles = UnitMovement.getDistanceToTiles$default(this, considerZoneOfControl, null, null, false, 14, null);
            List<Tile> pathToDestination = distanceToTiles.getPathToTile(destination);
            Iterable $this$takeWhile$iv = pathToDestination;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                Tile it = (Tile)item$iv;
                boolean bl = false;
                if (!UnitMovement.canPassThrough$default(this, it, false, 2, null)) break;
                list$iv.add(item$iv);
            }
            List $this$lastOrNull$iv = movableTiles = (List)list$iv;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!UnitMovement.canMoveTo$default(this, it, false, false, false, 14, null)) continue;
                v2 = element$iv;
                break block21;
            }
            v2 = null;
        }
        Tile tile = v2;
        if (tile == null) {
            return;
        }
        Tile lastReachableTile = tile;
        this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitMoved);
        List<Tile> pathToLastReachableTile = distanceToTiles.getPathToTile(lastReachableTile);
        if (this.unit.isFortified() || this.unit.isGuarding() || this.unit.isSetUpForSiege() || this.unit.isSleeping()) {
            this.unit.setAction(null);
        }
        Tile origin2 = this.unit.getTile();
        boolean needToFindNewRoute = false;
        Tile lastReachedEnterableTile = this.unit.getTile();
        Tile previousTile = this.unit.getTile();
        float passingMovementSpent = 0.0f;
        for (Tile tile2 : pathToLastReachableTile) {
            if (!UnitMovement.canPassThrough$default(this.unit.getMovement(), tile2, false, 2, null)) {
                needToFindNewRoute = true;
                break;
            }
            if (!this.unit.getCiv().getGameInfo().getGameParameters().getGodMode()) {
                passingMovementSpent += MovementCost.getMovementCostBetweenAdjacentTiles$default(MovementCost.INSTANCE, this.unit, previousTile, tile2, false, 8, null);
            }
            if (UnitMovement.canMoveTo$default(this.unit.getMovement(), tile2, true, false, false, 12, null)) {
                lastReachedEnterableTile = tile2;
                this.unit.useMovementPoints(passingMovementSpent);
                this.unit.removeFromTile();
                this.unit.putInTile(tile2);
                if (escortUnit != null) {
                    UnitMovement.moveToTile$default(escortUnit.getMovement(), tile2, false, 2, null);
                    this.unit.startEscorting();
                }
                passingMovementSpent = 0.0f;
            }
            previousTile = tile2;
            if (!this.unit.isDestroyed() && !(this.unit.getCurrentMovement() - passingMovementSpent < 0.05f)) continue;
        }
        Tile finalTileReached = lastReachedEnterableTile;
        if (this.unit.getCurrentMovement() < 0.05f) {
            this.unit.setCurrentMovement(0.0f);
        }
        List<MapUnit> payloadUnits = SequencesKt.toList(SequencesKt.filter(origin2.getUnits(), arg_0 -> UnitMovement.moveToTile$lambda$2(this, arg_0)));
        for (MapUnit payload : payloadUnits) {
            payload.removeFromTile();
            for (Tile tile3 : pathToLastReachableTile) {
                payload.moveThroughTile(tile3);
                if (!Intrinsics.areEqual(tile3, finalTileReached)) continue;
            }
            payload.putInTile(finalTileReached);
            payload.setTransported(true);
            payload.setMostRecentMoveType(UnitMovementMemoryType.UnitMoved);
        }
        if (this.unit.canGarrison() && (origin2.isCityCenter() || finalTileReached.isCityCenter()) && Civilization.hasUnique$default(this.unit.getCiv(), UniqueType.UnitsInCitiesNoMaintenance, null, 2, null)) {
            this.unit.getCiv().updateStatsForNextTurn();
        }
        if (needToFindNewRoute && !Intrinsics.areEqual(this.unit.getCurrentTile(), origin2)) {
            this.moveToTile(destination, considerZoneOfControl);
        }
        this.unit.updateUniques();
    }

    public static /* synthetic */ void moveToTile$default(UnitMovement unitMovement, Tile tile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        unitMovement.moveToTile(tile, bl);
    }

    public final void swapMoveToTile(@NotNull Tile destination, boolean keepEscorting) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (keepEscorting && this.unit.isEscorting()) {
            this.swapMoveEscortPair(destination);
            return;
        }
        this.unit.stopEscorting();
        MapUnit mapUnit = this.unit.isCivilian() ? destination.getCivilianUnit() : destination.getMilitaryUnit();
        if (mapUnit == null) {
            return;
        }
        MapUnit otherUnit = mapUnit;
        otherUnit.stopEscorting();
        Tile ourOldPosition = this.unit.getTile();
        Tile theirOldPosition = otherUnit.getTile();
        List<MapUnit> ourPayload = SequencesKt.toList(SequencesKt.filter(ourOldPosition.getUnits(), arg_0 -> UnitMovement.swapMoveToTile$lambda$0(this, arg_0)));
        List<MapUnit> theirPayload = SequencesKt.toList(SequencesKt.filter(theirOldPosition.getUnits(), arg_0 -> UnitMovement.swapMoveToTile$lambda$1(otherUnit, arg_0)));
        otherUnit.removeFromTile();
        for (MapUnit payload : theirPayload) {
            payload.removeFromTile();
        }
        UnitMovement.moveToTile$default(this.unit.getMovement(), destination, false, 2, null);
        this.unit.removeFromTile();
        for (MapUnit payload : ourPayload) {
            payload.removeFromTile();
        }
        otherUnit.putInTile(theirOldPosition);
        for (MapUnit payload : theirPayload) {
            payload.putInTile(theirOldPosition);
            payload.setTransported(true);
        }
        UnitMovement.moveToTile$default(otherUnit.getMovement(), ourOldPosition, false, 2, null);
        this.unit.putInTile(theirOldPosition);
        for (MapUnit payload : ourPayload) {
            payload.putInTile(theirOldPosition);
            payload.setTransported(true);
        }
        otherUnit.setMostRecentMoveType(UnitMovementMemoryType.UnitMoved);
        this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitMoved);
    }

    public static /* synthetic */ void swapMoveToTile$default(UnitMovement unitMovement, Tile tile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        unitMovement.swapMoveToTile(tile, bl);
    }

    private final void swapMoveEscortPair(Tile destination) {
        block3: {
            MapUnit mapUnit;
            MapUnit mapUnit2 = this.unit.getOtherEscortUnit();
            if (mapUnit2 == null) {
                return;
            }
            MapUnit escortedUnit = mapUnit2;
            MapUnit mapUnit3 = destination.getMilitaryUnit();
            if (mapUnit3 != null) {
                MapUnit mapUnit4;
                MapUnit it = mapUnit4 = mapUnit3;
                boolean bl = false;
                mapUnit = it.isEscorting() ? mapUnit4 : null;
            } else {
                mapUnit = null;
            }
            MapUnit destinationWasEscortingUnit = mapUnit;
            this.unit.stopEscorting();
            UnitMovement.swapMoveEscortPair$swapOrMoveToDestination(this.unit, destination);
            UnitMovement.swapMoveEscortPair$swapOrMoveToDestination(escortedUnit, destination);
            this.unit.startEscorting();
            MapUnit mapUnit5 = destinationWasEscortingUnit;
            if (mapUnit5 == null) break block3;
            mapUnit5.startEscorting();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean isCityCenterCannotEnter(Tile tile) {
        if (!tile.isCityCenter()) return false;
        if (Intrinsics.areEqual(tile.getOwner(), this.unit.getCiv())) return false;
        City city = tile.getCity();
        Intrinsics.checkNotNull(city);
        if (city.getHasJustBeenConquered()) return false;
        return true;
    }

    @Readonly
    public final boolean canMoveTo(@NotNull Tile tile, boolean assumeCanPassThrough, boolean allowSwap, boolean includeOtherEscortUnit) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return this.getCannotMoveToReason(tile, assumeCanPassThrough, allowSwap, includeOtherEscortUnit) == null;
    }

    public static /* synthetic */ boolean canMoveTo$default(UnitMovement unitMovement, Tile tile, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return unitMovement.canMoveTo(tile, bl, bl2, bl3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    @Nullable
    public final CannotMoveToReason getCannotMoveToReason(@NotNull Tile tile, boolean assumeCanPassThrough, boolean allowSwap, boolean includeOtherEscortUnit) {
        boolean bl;
        block16: {
            block18: {
                block17: {
                    block13: {
                        block15: {
                            block14: {
                                Intrinsics.checkNotNullParameter(tile, "tile");
                                if (this.unit.getBaseUnit().getMovesLikeAirUnits()) {
                                    return this.getAirUnitCannotMoveToReason(tile, this.unit);
                                }
                                if (!assumeCanPassThrough && !UnitMovement.canPassThrough$default(this, tile, false, 2, null)) {
                                    return CannotMoveToReason.CannotPassThrough;
                                }
                                if (this.isCityCenterCannotEnter(tile)) {
                                    return CannotMoveToReason.CannotEnterCityCenter;
                                }
                                if (includeOtherEscortUnit && this.unit.isEscorting()) {
                                    MapUnit mapUnit = this.unit.getOtherEscortUnit();
                                    Intrinsics.checkNotNull(mapUnit);
                                    if (!mapUnit.getMovement().canMoveTo(tile, assumeCanPassThrough, allowSwap, false)) {
                                        return CannotMoveToReason.EscortCannotMove;
                                    }
                                }
                                if (!this.unit.isCivilian()) break block13;
                                if (tile.getCivilianUnit() == null) break block14;
                                if (!allowSwap) break block15;
                                MapUnit mapUnit = tile.getCivilianUnit();
                                Intrinsics.checkNotNull(mapUnit);
                                if (!Intrinsics.areEqual(mapUnit.getOwner(), this.unit.getOwner())) break block15;
                            }
                            if (tile.getMilitaryUnit() == null) return null;
                            MapUnit mapUnit = tile.getMilitaryUnit();
                            Intrinsics.checkNotNull(mapUnit);
                            if (Intrinsics.areEqual(mapUnit.getOwner(), this.unit.getOwner())) {
                                return null;
                            }
                        }
                        bl = false;
                        break block16;
                    }
                    if (tile.getMilitaryUnit() == null) break block17;
                    if (!allowSwap) break block18;
                    MapUnit mapUnit = tile.getMilitaryUnit();
                    Intrinsics.checkNotNull(mapUnit);
                    if (!Intrinsics.areEqual(mapUnit.getOwner(), this.unit.getOwner())) break block18;
                }
                if (tile.getCivilianUnit() == null) return null;
                MapUnit mapUnit = tile.getCivilianUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (Intrinsics.areEqual(mapUnit.getOwner(), this.unit.getOwner())) return null;
                Civilization civilization = this.unit.getCiv();
                MapUnit mapUnit2 = tile.getCivilianUnit();
                Intrinsics.checkNotNull(mapUnit2);
                if (civilization.isAtWarWith(mapUnit2.getCiv())) {
                    return null;
                }
            }
            bl = false;
        }
        boolean tileIsEmpty = bl;
        if (tileIsEmpty) return null;
        return CannotMoveToReason.TileIsNotEmpty;
    }

    public static /* synthetic */ CannotMoveToReason getCannotMoveToReason$default(UnitMovement unitMovement, Tile tile, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return unitMovement.getCannotMoveToReason(tile, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final CannotMoveToReason getAirUnitCannotMoveToReason(Tile tile, MapUnit unit) {
        if (tile.isCityCenter()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = tile.getAirUnits();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MapUnit it = (MapUnit)element$iv$iv;
                boolean bl = false;
                if (!(!it.isTransported())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int n = ((List)destination$iv$iv).size();
            City city = tile.getCity();
            Intrinsics.checkNotNull(city);
            if (n < city.getMaxAirUnits()) {
                City city2 = tile.getCity();
                if (Intrinsics.areEqual(city2 != null ? city2.getCiv() : null, unit.getCiv())) {
                    return null;
                }
            }
        }
        if (tile.getMilitaryUnit() != null) {
            MapUnit mapUnit = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            MapUnit unitAtDestination = mapUnit;
            if (unitAtDestination.canTransport(unit)) {
                return null;
            }
        }
        return CannotMoveToReason.NoAirUnitTransport;
    }

    @Readonly
    private final boolean canParadropOn(Tile destination, int distance) {
        if (this.unit.getCache().getCannotMove()) {
            return false;
        }
        if (destination.isImpassible() || !this.unit.getCiv().getViewableTiles().contains(destination)) {
            return false;
        }
        for (Map.Entry<String, Integer> entry : this.unit.getCache().getParadropDestinationTileFilters().entrySet()) {
            String tileFilter = entry.getKey();
            int distanceAllowed = ((Number)entry.getValue()).intValue();
            if (distance > distanceAllowed || !destination.matchesFilter(tileFilter, this.unit.getCiv())) continue;
            return true;
        }
        return false;
    }

    @Readonly
    public final boolean canPassThrough(@NotNull Tile tile, boolean includeOtherEscortUnit) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!(!tile.isImpassible() || this.unit.getCache().getCanPassThroughImpassableTiles() || this.unit.getCache().getCanEnterIceTiles() && tile.getTerrainFeatures().contains("Ice") || this.unit.getCiv().getPassThroughImpassableUnlocked() && this.unit.getCiv().getPassableImpassables().contains(tile.getLastTerrain().getName()))) {
            return false;
        }
        if (tile.isLand() && this.unit.getBaseUnit().isWaterUnit() && !tile.isCityCenter()) {
            return false;
        }
        Lazy<Boolean> unitSpecificAllowOcean$delegate = LazyKt.lazy(() -> UnitMovement.canPassThrough$lambda$0(this));
        if (tile.isWater() && this.unit.getBaseUnit().isLandUnit() && !this.unit.getCache().getCanMoveOnWater()) {
            if (!this.unit.getCiv().getTech().getUnitsCanEmbark()) {
                return false;
            }
            if (this.unit.getCache().getCannotEmbark()) {
                return false;
            }
            if (tile.isOcean() && !this.unit.getCiv().getTech().getEmbarkedUnitsCanEnterOcean() && !UnitMovement.canPassThrough$lambda$1(unitSpecificAllowOcean$delegate)) {
                return false;
            }
        }
        if (tile.isOcean() && !this.unit.getCiv().getTech().getAllUnitsCanEnterOcean() && !UnitMovement.canPassThrough$lambda$1(unitSpecificAllowOcean$delegate) && this.unit.getCache().getCannotEnterOceanTiles()) {
            return false;
        }
        if (this.unit.getCache().getCanEnterCityStates()) {
            Civilization civilization = tile.getOwner();
            boolean bl = civilization != null ? civilization.isCityState() : false;
            if (bl) {
                return true;
            }
        }
        if (!this.unit.getCache().getCanEnterForeignTerrain() && !tile.canCivPassThrough(this.unit.getCiv())) {
            return false;
        }
        MapUnit firstUnit = tile.getFirstUnit();
        if (firstUnit != null && !Intrinsics.areEqual(this.unit.getCiv(), firstUnit.getCiv())) {
            if ((!this.unit.getBaseUnit().isLandUnit() || !tile.isWater() || this.unit.getCache().getCanMoveOnWater()) && firstUnit.isCivilian() && this.unit.getCiv().isAtWarWith(firstUnit.getCiv())) {
                return true;
            }
            if (this.unit.getCiv().isAtWarWith(firstUnit.getCiv())) {
                return false;
            }
        }
        if (includeOtherEscortUnit && this.unit.isEscorting()) {
            MapUnit mapUnit = this.unit.getOtherEscortUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (!mapUnit.getMovement().canPassThrough(tile, false)) {
                return false;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean canPassThrough$default(UnitMovement unitMovement, Tile tile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return unitMovement.canPassThrough(tile, bl);
    }

    @Readonly
    @NotNull
    public final PathsToTilesWithinTurn getDistanceToTiles(boolean considerZoneOfControl, @Nullable ArrayList<Boolean> passThroughCacheNew, @Nullable HashMap<Integer, Float> movementCostCache, boolean includeOtherEscortUnit) {
        HashMap hashMap;
        if (UncivGame.Companion.getCurrent().getSettings().getUseAStarPathfinding()) {
            if (!considerZoneOfControl && !includeOtherEscortUnit) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            PathingMap pathingMap = !considerZoneOfControl ? this.getAStarPathingWithoutZoneControl() : (includeOtherEscortUnit || !this.unit.isEscorting() ? this.getAStarPathing() : this.getAStarPathingWithoutEscort());
            return pathingMap.getMovementToTilesAtPosition();
        }
        HexCoord hexCoord = this.unit.getCurrentTile().getPosition();
        float f = this.unit.getCurrentMovement();
        ArrayList arrayList = passThroughCacheNew;
        if (arrayList == null) {
            arrayList = new ArrayList(this.unit.getTile().getTileMap().getTileList().size());
        }
        if ((hashMap = movementCostCache) == null) {
            hashMap = new HashMap();
        }
        PathsToTilesWithinTurn distanceToTiles = this.getMovementToTilesAtPosition(hexCoord, f, considerZoneOfControl, null, arrayList, hashMap, includeOtherEscortUnit);
        return distanceToTiles;
    }

    public static /* synthetic */ PathsToTilesWithinTurn getDistanceToTiles$default(UnitMovement unitMovement, boolean bl, ArrayList arrayList, HashMap hashMap, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            arrayList = null;
        }
        if ((n & 4) != 0) {
            hashMap = null;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return unitMovement.getDistanceToTiles(bl, arrayList, hashMap, bl2);
    }

    @Readonly
    @Nullable
    public final List<Tile> getRoadPath(@NotNull Tile destinationTile) {
        Intrinsics.checkNotNullParameter(destinationTile, "destinationTile");
        return PathingMap.getShortestPath$default(this.getRoadPathing(), destinationTile, 0, 2, null);
    }

    @NotNull
    public final HashMap<Tile, ArrayList<Tile>> getAerialPathsToCities() {
        ArrayList<Tile> tilesToCheck = new ArrayList<Tile>();
        HashMap tilesReached = new HashMap();
        Tile startingTile = this.unit.getCurrentTile();
        tilesToCheck.add(startingTile);
        ((Map)tilesReached).put(startingTile, startingTile);
        while (!((Collection)tilesToCheck).isEmpty()) {
            Iterator<Object> iterator2;
            ArrayList<Tile> newTilesToCheck = new ArrayList<Tile>();
            Intrinsics.checkNotNullExpressionValue(tilesToCheck.iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                Tile currentTileToCheck = (Tile)object;
                Sequence<Tile> reachableTiles = SequencesKt.filter(currentTileToCheck.getTilesInDistance(this.unit.getRange()), arg_0 -> UnitMovement.getAerialPathsToCities$lambda$0(this, arg_0));
                Iterator<Tile> iterator3 = reachableTiles.iterator();
                while (iterator3.hasNext()) {
                    Tile reachableTile = iterator3.next();
                    if (tilesReached.containsKey(reachableTile)) continue;
                    ((Map)tilesReached).put(reachableTile, currentTileToCheck);
                    newTilesToCheck.add(reachableTile);
                }
            }
            tilesToCheck = newTilesToCheck;
        }
        HashMap<Tile, ArrayList<Tile>> pathsToCities = new HashMap<Tile, ArrayList<Tile>>();
        for (Object object : tilesReached.keySet()) {
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Tile city = (Tile)object;
            ArrayList<Tile> path = new ArrayList<Tile>();
            Tile currentCity = city;
            while (!Intrinsics.areEqual(currentCity, startingTile)) {
                path.add(currentCity);
                Object v = tilesReached.get(currentCity);
                Intrinsics.checkNotNull(v);
                currentCity = (Tile)v;
            }
            CollectionsKt.reverse((List)path);
            ((Map)pathsToCities).put(city, path);
        }
        pathsToCities.remove(startingTile);
        return pathsToCities;
    }

    private final Set<Tile> getPathBetweenTiles(Tile from, Tile to) {
        boolean tmp = this.unit.getCache().getCanEnterForeignTerrain();
        this.unit.getCache().setCanEnterForeignTerrain(true);
        BFS bfs = new BFS(from, arg_0 -> UnitMovement.getPathBetweenTiles$lambda$0(this, arg_0));
        bfs.stepUntilDestination(to);
        this.unit.getCache().setCanEnterForeignTerrain(tmp);
        return bfs.getReachedTiles();
    }

    public final void clearPathfindingCache() {
        this.pathfindingCache.clear();
        this.getAStarPathing().clear();
        this.getAStarPathingWithoutZoneControl().clear();
        this.getAStarPathingWithoutEscort().clear();
        this.getRoadPathing().clear();
    }

    private static final PathingMap aStarPathing_delegate$lambda$0(UnitMovement this$0) {
        return PathingMap.Companion.createUnitPathingMap$default(PathingMap.Companion, this$0.unit, false, false, 6, null);
    }

    private static final PathingMap aStarPathingWithoutZoneControl_delegate$lambda$0(UnitMovement this$0) {
        return PathingMap.Companion.createUnitPathingMap$default(PathingMap.Companion, this$0.unit, false, false, 4, null);
    }

    private static final PathingMap aStarPathingWithoutEscort_delegate$lambda$0(UnitMovement this$0) {
        return PathingMap.Companion.createUnitPathingMap$default(PathingMap.Companion, this$0.unit, false, false, 2, null);
    }

    private static final PathingMap roadPathing_delegate$lambda$0(UnitMovement this$0) {
        return PathingMap.Companion.createRoadPathingMap(this$0.unit.getCiv(), this$0.unit.getCurrentTile());
    }

    private static final boolean getMovementToTilesAtPosition$lambda$0(UnitMovement this$0, Tile $neighbor) {
        return UnitMovement.canPassThrough$default(this$0, $neighbor, false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getShortestPath$isUnfriendlyCityState(UnitMovement this$0, Tile tile) {
        Civilization it = tile.getOwner();
        boolean bl = false;
        if (it == null) return false;
        if (!it.isCityState()) return false;
        DiplomacyManager diplomacyManager = it.getDiplomacyManager(this$0.unit.getCiv());
        if (diplomacyManager == null) return false;
        if (!diplomacyManager.isRelationshipLevelLT(RelationshipLevel.Friend)) return false;
        return true;
    }

    private static final Comparable getShortestPath$lambda$2(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Boolean.valueOf(!it.isLand());
    }

    private static final Comparable getShortestPath$lambda$3(Tile $destination, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.valueOf(it.aerialDistanceTo($destination));
    }

    private static final Comparable getShortestPath$lambda$4(Tile $destination, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.valueOf(it.aerialDistanceTo($destination));
    }

    private static final boolean getTileToMoveToThisTurn$lambda$1(PathsToTilesWithinTurn $distanceToTiles, UnitMovement this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $distanceToTiles.containsKey((Object)it) && UnitMovement.canMoveTo$default(this$0, it, false, false, false, 14, null);
    }

    private static final boolean getReachableTilesInCurrentTurn$lambda$1(UnitMovement this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.unit.getMovement().canParadropOn(it, it.aerialDistanceTo(this$0.unit.getTile()));
    }

    private static final boolean getUnitSwappableTiles$lambda$0(UnitMovement this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return UnitMovement.canUnitSwapToReachableTile$default(this$0, it, false, 2, null);
    }

    private static final MapUnit canUnitSwapToReachableTile$getMatchInReachableTile(MapUnit $this$canUnitSwapToReachableTile_u24getMatchInReachableTile, Tile $reachableTile) {
        return $this$canUnitSwapToReachableTile_u24getMatchInReachableTile.isCivilian() ? $reachableTile.getCivilianUnit() : $reachableTile.getMilitaryUnit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean teleportToClosestMoveableTile$lambda$0(UnitMovement this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!UnitMovement.canMoveTo$default(this$0, it, false, false, false, 14, null)) return false;
        Civilization civilization = it.getOwner();
        if (civilization == null) return true;
        if (!civilization.isAtWarWith(this$0.unit.getCiv())) return true;
        return false;
    }

    private static final boolean teleportToClosestMoveableTile$lambda$5(UnitMovement this$0, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isTransported() && this$0.unit.canTransport(it);
    }

    private static final boolean moveToTile$lambda$2(UnitMovement this$0, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isTransported() && this$0.unit.canTransport(it);
    }

    private static final boolean swapMoveToTile$lambda$0(UnitMovement this$0, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isTransported() && this$0.unit.isTransportTypeOf(it);
    }

    private static final boolean swapMoveToTile$lambda$1(MapUnit $otherUnit, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isTransported() && $otherUnit.isTransportTypeOf(it);
    }

    private static final boolean swapMoveEscortPair$needsSwapTo(MapUnit $this$swapMoveEscortPair_u24needsSwapTo, Tile $destination) {
        return ($this$swapMoveEscortPair_u24needsSwapTo.isCivilian() ? $destination.getCivilianUnit() : $destination.getMilitaryUnit()) != null;
    }

    private static final void swapMoveEscortPair$swapOrMoveToDestination(MapUnit $this$swapMoveEscortPair_u24swapOrMoveToDestination, Tile $destination) {
        if (UnitMovement.swapMoveEscortPair$needsSwapTo($this$swapMoveEscortPair_u24swapOrMoveToDestination, $destination)) {
            UnitMovement.swapMoveToTile$default($this$swapMoveEscortPair_u24swapOrMoveToDestination.getMovement(), $destination, false, 2, null);
        } else {
            UnitMovement.moveToTile$default($this$swapMoveEscortPair_u24swapOrMoveToDestination.getMovement(), $destination, false, 2, null);
        }
    }

    private static final boolean canPassThrough$lambda$1(Lazy<Boolean> $unitSpecificAllowOcean$delegate) {
        Lazy<Boolean> lazy = $unitSpecificAllowOcean$delegate;
        return lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canPassThrough$lambda$0(UnitMovement this$0) {
        Unique it;
        if (!this$0.unit.getCiv().getTech().getSpecificUnitsCanEnterOcean()) return false;
        Sequence $this$any$iv = Civilization.getMatchingUniques$default(this$0.unit.getCiv(), UniqueType.UnitsMayEnterOcean, null, 2, null);
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Unique)element$iv;
            boolean bl = false;
        } while (!MapUnit.matchesFilter$default(this$0.unit, it.getParams().get(0), false, 2, null));
        return true;
    }

    private static final boolean getAerialPathsToCities$lambda$0(UnitMovement this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return UnitMovement.canMoveTo$default(this$0.unit.getMovement(), it, false, false, false, 14, null);
    }

    private static final boolean getPathBetweenTiles$lambda$0(UnitMovement this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return UnitMovement.canPassThrough$default(this$0, it, false, 2, null);
    }

    public static final /* synthetic */ boolean access$getShortestPath$isUnfriendlyCityState(UnitMovement this$0, Tile tile) {
        return UnitMovement.getShortestPath$isUnfriendlyCityState(this$0, tile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/unciv/logic/map/mapunit/movement/UnitMovement$CannotMoveToReason;", "", "<init>", "(Ljava/lang/String;I)V", "CannotPassThrough", "CannotEnterCityCenter", "EscortCannotMove", "TileIsNotEmpty", "NoAirUnitTransport", "core"})
    public static final class CannotMoveToReason
    extends Enum<CannotMoveToReason> {
        public static final /* enum */ CannotMoveToReason CannotPassThrough = new CannotMoveToReason();
        public static final /* enum */ CannotMoveToReason CannotEnterCityCenter = new CannotMoveToReason();
        public static final /* enum */ CannotMoveToReason EscortCannotMove = new CannotMoveToReason();
        public static final /* enum */ CannotMoveToReason TileIsNotEmpty = new CannotMoveToReason();
        public static final /* enum */ CannotMoveToReason NoAirUnitTransport = new CannotMoveToReason();
        private static final /* synthetic */ CannotMoveToReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CannotMoveToReason[] values() {
            return (CannotMoveToReason[])$VALUES.clone();
        }

        public static CannotMoveToReason valueOf(String value) {
            return Enum.valueOf(CannotMoveToReason.class, value);
        }

        @NotNull
        public static EnumEntries<CannotMoveToReason> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cannotMoveToReasonArray = new CannotMoveToReason[]{CannotMoveToReason.CannotPassThrough, CannotMoveToReason.CannotEnterCityCenter, CannotMoveToReason.EscortCannotMove, CannotMoveToReason.TileIsNotEmpty, CannotMoveToReason.NoAirUnitTransport};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/unciv/logic/map/mapunit/movement/UnitMovement$ParentTileAndTotalMovement;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "parentTile", "totalMovement", "", "<init>", "(Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/map/tile/Tile;F)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getParentTile", "getTotalMovement", "()F", "core"})
    public static final class ParentTileAndTotalMovement {
        @NotNull
        private final Tile tile;
        @NotNull
        private final Tile parentTile;
        private final float totalMovement;

        public ParentTileAndTotalMovement(@NotNull Tile tile, @NotNull Tile parentTile, float totalMovement) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(parentTile, "parentTile");
            this.tile = tile;
            this.parentTile = parentTile;
            this.totalMovement = totalMovement;
        }

        @NotNull
        public final Tile getTile() {
            return this.tile;
        }

        @NotNull
        public final Tile getParentTile() {
            return this.parentTile;
        }

        public final float getTotalMovement() {
            return this.totalMovement;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/mapunit/movement/UnitMovement$UnreachableDestinationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "<init>", "(Ljava/lang/String;)V", "core"})
    public static final class UnreachableDestinationException
    extends Exception {
        public UnreachableDestinationException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter(msg, "msg");
            super(msg);
        }
    }
}

