/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.event.Event;
import com.unciv.logic.event.EventBus;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.multiplayer.GameUpdateResult;
import com.unciv.logic.multiplayer.MultiplayerGamePreview;
import com.unciv.logic.multiplayer.MultiplayerGamePreviewKt;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateEnded;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateFailed;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateStarted;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateUnchanged;
import com.unciv.logic.multiplayer.MultiplayerGameUpdated;
import com.unciv.logic.multiplayer.MultiplayerKt;
import com.unciv.logic.multiplayer.storage.MultiplayerServer;
import com.unciv.models.UncivSound;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.extensions.TimeExtensionsKt;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.LogKt;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\"H\u0086@\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020(H\u0082@\u00a2\u0006\u0002\u0010)J\u0016\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0014\u0010/\u001a\u00020\"2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u00101\u001a\u000202H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lcom/unciv/logic/multiplayer/MultiplayerGamePreview;", "", "fileHandle", "Lcom/badlogic/gdx/files/FileHandle;", "preview", "Lcom/unciv/logic/GameInfoPreview;", "lastOnlineUpdate", "Ljava/time/Instant;", "<init>", "(Lcom/badlogic/gdx/files/FileHandle;Lcom/unciv/logic/GameInfoPreview;Ljava/time/Instant;)V", "getFileHandle", "()Lcom/badlogic/gdx/files/FileHandle;", "getPreview", "()Lcom/unciv/logic/GameInfoPreview;", "setPreview", "(Lcom/unciv/logic/GameInfoPreview;)V", "Ljava/util/concurrent/atomic/AtomicReference;", "getLastUpdate", "name", "", "kotlin.jvm.PlatformType", "getName", "()Ljava/lang/String;", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "loadPreviewFromFile", "setNewPreview", "", "gamePreview", "needsUpdate", "", "requestUpdate", "Lkotlinx/coroutines/Job;", "forceUpdate", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "update", "Lcom/unciv/logic/multiplayer/GameUpdateResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updatePreview", "gameInfo", "(Lcom/unciv/logic/GameInfoPreview;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "playMultiplayerTurnNotification", "gameInfoPreview", "equals", "other", "hashCode", "", "core"})
public final class MultiplayerGamePreview {
    @NotNull
    private final FileHandle fileHandle;
    @Nullable
    private GameInfoPreview preview;
    @NotNull
    private final AtomicReference<Instant> lastOnlineUpdate;
    private final String name;
    @Nullable
    private Throwable error;

    public MultiplayerGamePreview(@NotNull FileHandle fileHandle, @Nullable GameInfoPreview preview, @Nullable Instant lastOnlineUpdate) {
        Intrinsics.checkNotNullParameter(fileHandle, "fileHandle");
        this.fileHandle = fileHandle;
        this.preview = preview;
        this.lastOnlineUpdate = new AtomicReference<Instant>(lastOnlineUpdate);
        this.name = this.fileHandle.name();
        if (this.preview == null) {
            try {
                this.loadPreviewFromFile();
            }
            catch (Throwable e) {
                this.error = e;
            }
        }
    }

    public /* synthetic */ MultiplayerGamePreview(FileHandle fileHandle, GameInfoPreview gameInfoPreview, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            gameInfoPreview = null;
        }
        if ((n & 4) != 0) {
            instant = null;
        }
        this(fileHandle, gameInfoPreview, instant);
    }

    @NotNull
    public final FileHandle getFileHandle() {
        return this.fileHandle;
    }

    @Nullable
    public final GameInfoPreview getPreview() {
        return this.preview;
    }

    public final void setPreview(@Nullable GameInfoPreview gameInfoPreview) {
        this.preview = gameInfoPreview;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Instant getLastUpdate() {
        Instant instant;
        Instant lastFileUpdateTime = Instant.ofEpochMilli(this.fileHandle.lastModified());
        Instant lastOnlineUpdateTime = this.lastOnlineUpdate.get();
        if (lastOnlineUpdateTime != null) {
            Intrinsics.checkNotNull(lastFileUpdateTime);
            if (!TimeExtensionsKt.isLargerThan(lastFileUpdateTime, lastOnlineUpdateTime)) {
                instant = lastOnlineUpdateTime;
                return instant;
            }
        }
        Instant instant2 = lastFileUpdateTime;
        Intrinsics.checkNotNull(instant2);
        instant = instant2;
        return instant;
    }

    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Throwable getError() {
        return this.error;
    }

    public final void setError(@Nullable Throwable throwable) {
        this.error = throwable;
    }

    private final GameInfoPreview loadPreviewFromFile() {
        GameInfoPreview previewFromFile;
        this.preview = previewFromFile = UncivGame.Companion.getCurrent().getFiles().loadGamePreviewFromFile(this.fileHandle);
        return previewFromFile;
    }

    private final void setNewPreview(GameInfoPreview gamePreview) {
        UncivFiles.saveMultiplayerGamePreview$default(UncivGame.Companion.getCurrent().getFiles(), gamePreview, this.fileHandle, null, 4, null);
        this.preview = gamePreview;
        this.error = null;
    }

    private final boolean needsUpdate() {
        return this.preview == null || this.error != null;
    }

    @Nullable
    public final Object requestUpdate(boolean forceUpdate, @NotNull Continuation<? super Job> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(this, forceUpdate, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MultiplayerGamePreview this$0;
            final /* synthetic */ boolean $forceUpdate;
            {
                this.this$0 = $receiver;
                this.$forceUpdate = $forceUpdate;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        onUnchanged = (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.unciv.logic.multiplayer.MultiplayerGamePreview ), ()Lcom/unciv/logic/multiplayer/GameUpdateResult;)((MultiplayerGamePreview)this.this$0);
                        onError = (Function1<Throwable, GameUpdateResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$1(com.unciv.logic.multiplayer.MultiplayerGamePreview java.lang.Throwable ), (Ljava/lang/Throwable;)Lcom/unciv/logic/multiplayer/GameUpdateResult;)((MultiplayerGamePreview)this.this$0);
                        var5_6 = new Object[2];
                        var5_6[0] = this.this$0.getName();
                        v0 = this.this$0.getPreview();
                        var5_6[1] = v0 != null ? v0.getGameId() : null;
                        LogKt.debug("Starting multiplayer game update for %s with id %s", var5_6);
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ MultiplayerGamePreview this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        String string = this.this$0.getName();
                                        Intrinsics.checkNotNullExpressionValue(string, "<get-name>(...)");
                                        EventBus.INSTANCE.send((Event)new MultiplayerGameUpdateStarted(string));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        v1 = throttleInterval = this.$forceUpdate != false ? Duration.ZERO : MultiplayerGamePreviewKt.access$getUpdateThrottleInterval();
                        if (!this.$forceUpdate && !MultiplayerGamePreview.access$needsUpdate(this.this$0)) break;
                        this.L$0 = $this$coroutineScope;
                        this.L$1 = SpillingKt.nullOutSpilledVariable(onUnchanged);
                        this.L$2 = SpillingKt.nullOutSpilledVariable(onError);
                        this.L$3 = SpillingKt.nullOutSpilledVariable(throttleInterval);
                        this.label = 1;
                        v2 = MultiplayerKt.attemptAction(MultiplayerGamePreview.access$getLastOnlineUpdate$p(this.this$0), onUnchanged, onError, (Function1)new Function1<Continuation<? super GameUpdateResult>, Object>((Object)this.this$0){

                            public final Object invoke(Continuation<? super GameUpdateResult> $completion) {
                                return MultiplayerGamePreview.access$update((MultiplayerGamePreview)this.receiver, $completion);
                            }
                        }, this);
                        if (v2 == var9_3) {
                            return var9_3;
                        }
                        ** GOTO lbl32
                    }
                    case 1: {
                        throttleInterval = (Duration)this.L$3;
                        onError = (Function1<Throwable, GameUpdateResult>)this.L$2;
                        onUnchanged = (Function0)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        v3 = (GameUpdateResult)v2;
                        ** GOTO lbl52
                    }
                }
                v4 = MultiplayerGamePreview.access$getLastOnlineUpdate$p(this.this$0);
                Intrinsics.checkNotNull(throttleInterval);
                this.L$0 = $this$coroutineScope;
                this.L$1 = SpillingKt.nullOutSpilledVariable(onUnchanged);
                this.L$2 = SpillingKt.nullOutSpilledVariable(onError);
                this.L$3 = SpillingKt.nullOutSpilledVariable(throttleInterval);
                this.label = 2;
                v5 = MultiplayerKt.throttle(v4, throttleInterval, onUnchanged, onError, (Function1)new Function1<Continuation<? super GameUpdateResult>, Object>((Object)this.this$0){

                    public final Object invoke(Continuation<? super GameUpdateResult> $completion) {
                        return MultiplayerGamePreview.access$update((MultiplayerGamePreview)this.receiver, $completion);
                    }
                }, this);
                if (v5 == var9_3) {
                    return var9_3;
                }
                ** GOTO lbl51
                {
                    case 2: {
                        throttleInterval = (Duration)this.L$3;
                        onError = (Function1)this.L$2;
                        onUnchanged = (Function0)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl51:
                        // 2 sources

                        v3 = (GameUpdateResult)v5;
lbl52:
                        // 2 sources

                        updateResult = v3;
                        if (updateResult.getType() == GameUpdateResult.Type.CHANGED && updateResult.getStatus() != null) {
                            var8_8 = new Object[]{this.this$0.getName(), updateResult.getStatus().getGameId()};
                            LogKt.debug("Game update for %s with id %s had remote change", var8_8);
                            v6 = this.this$0.getName();
                            Intrinsics.checkNotNullExpressionValue(v6, "<get-name>(...)");
                            v7 = new MultiplayerGameUpdated(v6, updateResult.getStatus());
                        } else if (updateResult.getType() == GameUpdateResult.Type.FAILURE && updateResult.getError() != null) {
                            var8_8 = new Object[3];
                            var8_8[0] = this.this$0.getName();
                            v8 = this.this$0.getPreview();
                            var8_8[1] = v8 != null ? v8.getGameId() : null;
                            var8_8[2] = updateResult.getError();
                            LogKt.debug("Game update for %s with id %s failed: %s", var8_8);
                            v9 = this.this$0.getName();
                            Intrinsics.checkNotNullExpressionValue(v9, "<get-name>(...)");
                            v7 = new MultiplayerGameUpdateFailed(v9, updateResult.getError());
                        } else if (updateResult.getType() == GameUpdateResult.Type.UNCHANGED && updateResult.getStatus() != null) {
                            var8_8 = new Object[]{this.this$0.getName(), updateResult.getStatus().getGameId()};
                            LogKt.debug("Game update for %s with id %s had no changes", var8_8);
                            this.this$0.setError(null);
                            v10 = this.this$0.getName();
                            Intrinsics.checkNotNullExpressionValue(v10, "<get-name>(...)");
                            v7 = new MultiplayerGameUpdateUnchanged(v10, updateResult.getStatus());
                        } else {
                            throw new IllegalStateException("Unknown update event".toString());
                        }
                        updateEvent = v7;
                        return ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(updateEvent, null){
                            int label;
                            final /* synthetic */ MultiplayerGameUpdateEnded $updateEvent;
                            {
                                this.$updateEvent = $updateEvent;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        EventBus.INSTANCE.send((Event)this.$updateEvent);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Job>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final GameUpdateResult invokeSuspend$lambda$0(MultiplayerGamePreview this$0) {
                GameInfoPreview gameInfoPreview = this$0.getPreview();
                Intrinsics.checkNotNull(gameInfoPreview);
                return new GameUpdateResult(GameUpdateResult.Type.UNCHANGED, gameInfoPreview);
            }

            private static final GameUpdateResult invokeSuspend$lambda$1(MultiplayerGamePreview this$0, Throwable t) {
                this$0.setError(t);
                return new GameUpdateResult(t);
            }
        }, $completion);
    }

    public static /* synthetic */ Object requestUpdate$default(MultiplayerGamePreview multiplayerGamePreview, boolean bl, Continuation continuation2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return multiplayerGamePreview.requestUpdate(bl, continuation2);
    }

    /*
     * Unable to fully structure code
     */
    private final Object update(Continuation<? super GameUpdateResult> $completion) {
        if (!($completion instanceof update.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MultiplayerGamePreview this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MultiplayerGamePreview.access$update(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                if (this.preview != null) {
                    v0 = this.preview;
                    v1 = v0;
                    Intrinsics.checkNotNull(v0);
                } else {
                    v1 = this.loadPreviewFromFile();
                }
                curPreview = v1;
                serverIdentifier = curPreview.getGameParameters().getMultiplayerServerUrl();
                $continuation.L$0 = curPreview;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(serverIdentifier);
                $continuation.label = 1;
                v2 = new MultiplayerServer(serverIdentifier, null, 2, null).tryDownloadGamePreview(curPreview.getGameId(), $continuation);
                if (v2 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl32
            }
            case 1: {
                serverIdentifier = (String)$continuation.L$1;
                curPreview = (GameInfoPreview)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl32:
                // 2 sources

                if ((newPreview = (GameInfoPreview)v2).getTurns() == curPreview.getTurns() && Intrinsics.areEqual(newPreview.getCurrentPlayer(), curPreview.getCurrentPlayer())) {
                    return new GameUpdateResult(GameUpdateResult.Type.UNCHANGED, newPreview);
                }
                this.setNewPreview(newPreview);
                return new GameUpdateResult(GameUpdateResult.Type.CHANGED, newPreview);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object updatePreview(@NotNull GameInfoPreview gameInfo, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{gameInfo.getGameId()};
        LogKt.debug("Doing manual update of game %s", objectArray);
        this.lastOnlineUpdate.set(Instant.now());
        this.setNewPreview(gameInfo);
        Object object = ConcurrencyKt.withGLContext((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, gameInfo, null){
            int label;
            final /* synthetic */ MultiplayerGamePreview this$0;
            final /* synthetic */ GameInfoPreview $gameInfo;
            {
                this.this$0 = $receiver;
                this.$gameInfo = $gameInfo;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        String string = this.this$0.getName();
                        Intrinsics.checkNotNullExpressionValue(string, "<get-name>(...)");
                        EventBus.INSTANCE.send((Event)new MultiplayerGameUpdated(string, this.$gameInfo));
                        MultiplayerGamePreview.access$playMultiplayerTurnNotification(this.this$0, this.$gameInfo);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void playMultiplayerTurnNotification(GameInfoPreview gameInfoPreview) {
        if (!MultiplayerKt.isUsersTurn(gameInfoPreview)) {
            return;
        }
        if (UncivGame.Companion.isDeepLinkedGameLoading()) {
            return;
        }
        UncivSound sound = UncivGame.Companion.isCurrentGame(gameInfoPreview.getGameId()) ? UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getCurrentGameTurnNotificationSound() : UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getOtherGameTurnNotificationSound();
        SoundPlayer.INSTANCE.play(sound);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof MultiplayerGamePreview && Intrinsics.areEqual(this.fileHandle, ((MultiplayerGamePreview)other).fileHandle);
    }

    public int hashCode() {
        return this.fileHandle.hashCode();
    }

    public static final /* synthetic */ boolean access$needsUpdate(MultiplayerGamePreview $this) {
        return $this.needsUpdate();
    }

    public static final /* synthetic */ AtomicReference access$getLastOnlineUpdate$p(MultiplayerGamePreview $this) {
        return $this.lastOnlineUpdate;
    }

    public static final /* synthetic */ Object access$update(MultiplayerGamePreview $this, Continuation $completion) {
        return $this.update($completion);
    }

    public static final /* synthetic */ void access$playMultiplayerTurnNotification(MultiplayerGamePreview $this, GameInfoPreview gameInfoPreview) {
        $this.playMultiplayerTurnNotification(gameInfoPreview);
    }
}

