/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.simulation;

import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.simulation.MutableInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R)\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR)\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR)\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001f\u00a8\u0006'"}, d2={"Lcom/unciv/logic/simulation/SimulationStep;", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "statTurns", "", "", "<init>", "(Lcom/unciv/logic/GameInfo;Ljava/util/List;)V", "civilizationNames", "", "turns", "getTurns", "()I", "setTurns", "(I)V", "victoryType", "getVictoryType", "()Ljava/lang/String;", "setVictoryType", "(Ljava/lang/String;)V", "winner", "getWinner", "setWinner", "currentPlayer", "getCurrentPlayer", "setCurrentPlayer", "turnStatsPop", "", "Lcom/unciv/logic/simulation/MutableInt;", "getTurnStatsPop", "()Ljava/util/Map;", "turnStatsProd", "getTurnStatsProd", "turnStatsCities", "getTurnStatsCities", "saveTurnStats", "", "update", "core"})
@SourceDebugExtension(value={"SMAP\nSimulationStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimulationStep.kt\ncom/unciv/logic/simulation/SimulationStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n777#2:56\n873#2,2:57\n1586#2:59\n1661#2,3:60\n777#2:105\n873#2,2:106\n383#3,7:63\n383#3,7:70\n383#3,7:77\n383#3,7:84\n383#3,7:91\n383#3,7:98\n1#4:108\n*S KotlinDebug\n*F\n+ 1 SimulationStep.kt\ncom/unciv/logic/simulation/SimulationStep\n*L\n8#1:56\n8#1:57,2\n8#1:59\n8#1:60,3\n34#1:105\n34#1:106,2\n20#1:63,7\n21#1:70,7\n22#1:77,7\n24#1:84,7\n25#1:91,7\n26#1:98,7\n*E\n"})
public final class SimulationStep {
    @NotNull
    private final List<String> civilizationNames;
    private int turns;
    @Nullable
    private String victoryType;
    @Nullable
    private String winner;
    @NotNull
    private String currentPlayer;
    @NotNull
    private final Map<String, Map<Integer, MutableInt>> turnStatsPop;
    @NotNull
    private final Map<String, Map<Integer, MutableInt>> turnStatsProd;
    @NotNull
    private final Map<String, Map<Integer, MutableInt>> turnStatsCities;

    /*
     * WARNING - void declaration
     */
    public SimulationStep(@NotNull GameInfo gameInfo, @NotNull List<Integer> statTurns) {
        Object $this$mapTo$iv$iv;
        void $this$map$iv;
        Civilization it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        Intrinsics.checkNotNullParameter(statTurns, "statTurns");
        Iterable iterable = gameInfo.getCivilizations();
        SimulationStep simulationStep = this;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isSpectator() && it.isMajorCiv())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            it = (Civilization)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCivID());
        }
        simulationStep.civilizationNames = (List)destination$iv$iv;
        this.turns = gameInfo.getTurns();
        this.victoryType = gameInfo.getCurrentPlayerCivilization().getVictoryManager().getVictoryTypeAchieved();
        this.currentPlayer = gameInfo.getCurrentPlayer();
        this.turnStatsPop = new LinkedHashMap();
        this.turnStatsProd = new LinkedHashMap();
        this.turnStatsCities = new LinkedHashMap();
        for (String civ : this.civilizationNames) {
            Object object;
            Object object2;
            Object object3;
            Map answer$iv;
            Map<String, Map<Integer, MutableInt>> $this$getOrPut$iv;
            $this$mapTo$iv$iv = statTurns.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Object object4;
                Object object5;
                Object object6;
                Map $this$getOrPut$iv2;
                int turn = ((Number)$this$mapTo$iv$iv.next()).intValue();
                Map<String, Map<Integer, MutableInt>> $i$f$mapTo2 = this.turnStatsPop;
                Object key$iv = civ;
                boolean $i$f$getOrPut22 = false;
                Object value$iv = $this$getOrPut$iv2.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Map answer$iv2 = new LinkedHashMap();
                    $this$getOrPut$iv2.put(key$iv, answer$iv2);
                    object6 = answer$iv2;
                } else {
                    object6 = value$iv;
                }
                $this$getOrPut$iv2 = (Map)object6;
                key$iv = turn;
                MutableInt $i$f$getOrPut22 = new MutableInt(-1);
                $this$getOrPut$iv2.put(key$iv, $i$f$getOrPut22);
                $this$getOrPut$iv2 = this.turnStatsProd;
                key$iv = civ;
                boolean $i$f$getOrPut32 = false;
                value$iv = $this$getOrPut$iv2.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Map answer$iv3 = new LinkedHashMap();
                    $this$getOrPut$iv2.put(key$iv, answer$iv3);
                    object5 = answer$iv3;
                } else {
                    object5 = value$iv;
                }
                $this$getOrPut$iv2 = (Map)object5;
                key$iv = turn;
                MutableInt $i$f$getOrPut32 = new MutableInt(-1);
                $this$getOrPut$iv2.put(key$iv, $i$f$getOrPut32);
                $this$getOrPut$iv2 = this.turnStatsCities;
                key$iv = civ;
                boolean $i$f$getOrPut42 = false;
                value$iv = $this$getOrPut$iv2.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Map answer$iv4 = new LinkedHashMap();
                    $this$getOrPut$iv2.put(key$iv, answer$iv4);
                    object4 = answer$iv4;
                } else {
                    object4 = value$iv;
                }
                $this$getOrPut$iv2 = (Map)object4;
                key$iv = turn;
                MutableInt $i$f$getOrPut42 = new MutableInt(-1);
                $this$getOrPut$iv2.put(key$iv, $i$f$getOrPut42);
            }
            $this$mapTo$iv$iv = this.turnStatsPop;
            Object key$iv = civ;
            boolean $i$f$getOrPut52 = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put((String)key$iv, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            $this$getOrPut$iv = (Map<String, Map<Integer, MutableInt>>)object3;
            key$iv = -1;
            MutableInt $i$f$getOrPut52 = new MutableInt(-1);
            $this$getOrPut$iv.put((String)key$iv, (Map<Integer, MutableInt>)((Object)$i$f$getOrPut52));
            $this$getOrPut$iv = this.turnStatsProd;
            key$iv = civ;
            boolean $i$f$getOrPut62 = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put((String)key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            $this$getOrPut$iv = (Map<String, Map<Integer, MutableInt>>)object2;
            key$iv = -1;
            MutableInt $i$f$getOrPut62 = new MutableInt(-1);
            $this$getOrPut$iv.put((String)key$iv, (Map<Integer, MutableInt>)((Object)$i$f$getOrPut62));
            $this$getOrPut$iv = this.turnStatsCities;
            key$iv = civ;
            boolean $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put((String)key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map2 = (Map)object;
            Integer n = -1;
            MutableInt mutableInt = new MutableInt(-1);
            map2.put(n, mutableInt);
        }
    }

    public /* synthetic */ SimulationStep(GameInfo gameInfo, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(gameInfo, list2);
    }

    public final int getTurns() {
        return this.turns;
    }

    public final void setTurns(int n) {
        this.turns = n;
    }

    @Nullable
    public final String getVictoryType() {
        return this.victoryType;
    }

    public final void setVictoryType(@Nullable String string) {
        this.victoryType = string;
    }

    @Nullable
    public final String getWinner() {
        return this.winner;
    }

    public final void setWinner(@Nullable String string) {
        this.winner = string;
    }

    @NotNull
    public final String getCurrentPlayer() {
        return this.currentPlayer;
    }

    public final void setCurrentPlayer(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.currentPlayer = string;
    }

    @NotNull
    public final Map<String, Map<Integer, MutableInt>> getTurnStatsPop() {
        return this.turnStatsPop;
    }

    @NotNull
    public final Map<String, Map<Integer, MutableInt>> getTurnStatsProd() {
        return this.turnStatsProd;
    }

    @NotNull
    public final Map<String, Map<Integer, MutableInt>> getTurnStatsCities() {
        return this.turnStatsCities;
    }

    /*
     * WARNING - void declaration
     */
    public final void saveTurnStats(@NotNull GameInfo gameInfo) {
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.victoryType = gameInfo.getCurrentPlayerCivilization().getVictoryManager().getVictoryTypeAchieved();
        int turn = this.victoryType != null ? -1 : gameInfo.getTurns();
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv222 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isSpectator() && it.isMajorCiv())) continue;
            destination$iv$iv222.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv222) {
            int n;
            int n2;
            Iterator iterator22;
            $this$filterTo$iv$iv = civ.getCities();
            int destination$iv$iv222 = 0;
            for (Iterator iterator22 : $this$filterTo$iv$iv) {
                void it;
                Object element$iv$iv;
                element$iv$iv = (City)((Object)iterator22);
                n2 = destination$iv$iv222;
                boolean bl = false;
                n = it.getPopulation().getPopulation();
                destination$iv$iv222 = n2 + n;
            }
            int popsum = destination$iv$iv222;
            Map<Integer, MutableInt> map2 = this.turnStatsPop.get(civ.getCivID());
            Intrinsics.checkNotNull(map2);
            MutableInt mutableInt = map2.get(turn);
            Intrinsics.checkNotNull(mutableInt);
            mutableInt.set(popsum);
            Iterable destination$iv$iv222 = civ.getCities();
            int n3 = 0;
            iterator22 = destination$iv$iv222.iterator();
            while (iterator22.hasNext()) {
                void it;
                Object t = iterator22.next();
                City bl = (City)t;
                n2 = n3;
                boolean bl2 = false;
                n = MathKt.roundToInt(it.getCityStats().getCurrentCityStats().getProduction());
                n3 = n2 + n;
            }
            int prodsum = n3;
            Map<Integer, MutableInt> map3 = this.turnStatsProd.get(civ.getCivID());
            Intrinsics.checkNotNull(map3);
            MutableInt mutableInt2 = map3.get(turn);
            Intrinsics.checkNotNull(mutableInt2);
            mutableInt2.set(prodsum);
            int cityCnt = ((Collection)civ.getCities()).size();
            Map<Integer, MutableInt> map4 = this.turnStatsCities.get(civ.getCivID());
            Intrinsics.checkNotNull(map4);
            MutableInt mutableInt3 = map4.get(turn);
            Intrinsics.checkNotNull(mutableInt3);
            mutableInt3.set(cityCnt);
        }
    }

    public final void update(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.turns = gameInfo.getTurns();
        this.victoryType = gameInfo.getCurrentPlayerCivilization().getVictoryManager().getVictoryTypeAchieved();
        this.currentPlayer = gameInfo.getCurrentPlayer();
    }
}

