/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.metadata;

import com.badlogic.gdx.utils.JsonValue;
import com.unciv.models.metadata.GameSettings;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0004\u001a\u0014\u0010\t\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"CURRENT_VERSION", "", "doMigrations", "", "Lcom/unciv/models/metadata/GameSettings;", "json", "Lcom/badlogic/gdx/utils/JsonValue;", "isMigrationNecessary", "", "migrateMultiplayerSettings", "core"})
public final class GameSettingsMigrationsKt {
    private static final int CURRENT_VERSION = 2;

    public static final void doMigrations(@NotNull GameSettings $this$doMigrations, @NotNull JsonValue json) {
        Intrinsics.checkNotNullParameter($this$doMigrations, "<this>");
        Intrinsics.checkNotNullParameter(json, "json");
        if ($this$doMigrations.getVersion() == null) {
            GameSettingsMigrationsKt.migrateMultiplayerSettings($this$doMigrations, json);
            $this$doMigrations.setVersion(1);
        }
    }

    public static final boolean isMigrationNecessary(@NotNull GameSettings $this$isMigrationNecessary) {
        Intrinsics.checkNotNullParameter($this$isMigrationNecessary, "<this>");
        Integer n = $this$isMigrationNecessary.getVersion();
        int n2 = 2;
        return n == null || n != n2;
    }

    private static final void migrateMultiplayerSettings(GameSettings $this$migrateMultiplayerSettings, JsonValue json) {
        JsonValue delayInMinutes;
        JsonValue notification;
        JsonValue enabled;
        JsonValue server;
        JsonValue userId = json.get("userId");
        if (userId != null && userId.isString()) {
            GameSettings.GameSettingsMultiplayer gameSettingsMultiplayer = $this$migrateMultiplayerSettings.getMultiplayer();
            String string = userId.asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            gameSettingsMultiplayer.setUserId(string);
        }
        if ((server = json.get("multiplayerServer")) != null && server.isString()) {
            GameSettings.GameSettingsMultiplayer gameSettingsMultiplayer = $this$migrateMultiplayerSettings.getMultiplayer();
            String string = server.asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            gameSettingsMultiplayer.setServer(string);
        }
        if ((enabled = json.get("multiplayerTurnCheckerEnabled")) != null && enabled.isBoolean()) {
            $this$migrateMultiplayerSettings.getMultiplayer().setTurnCheckerEnabled(enabled.asBoolean());
        }
        if ((notification = json.get("multiplayerTurnCheckerPersistentNotificationEnabled")) != null && notification.isBoolean()) {
            $this$migrateMultiplayerSettings.getMultiplayer().setTurnCheckerPersistentNotificationEnabled(notification.asBoolean());
        }
        if ((delayInMinutes = json.get("multiplayerTurnCheckerDelayInMinutes")) != null && delayInMinutes.isNumber()) {
            GameSettings.GameSettingsMultiplayer gameSettingsMultiplayer = $this$migrateMultiplayerSettings.getMultiplayer();
            Duration duration = Duration.ofMinutes(delayInMinutes.asLong());
            Intrinsics.checkNotNullExpressionValue(duration, "ofMinutes(...)");
            gameSettingsMultiplayer.setTurnCheckerDelay(duration);
        }
    }
}

