/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.PerpetualStatConversion;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.stats.Stat;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\rH\u0017J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/unciv/models/ruleset/PerpetualConstruction;", "Lcom/unciv/models/ruleset/IConstruction;", "name", "", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getDescription", "shouldBeDisplayed", "", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "getProductionTooltip", "city", "Lcom/unciv/logic/city/City;", "withIcon", "getStockpiledResourceRequirements", "Lcom/unciv/models/Counter;", "state", "Lcom/unciv/models/ruleset/unique/GameContext;", "isBuildable", "getResourceRequirementsPerTurn", "requiredResources", "", "Companion", "core"})
public class PerpetualConstruction
implements IConstruction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @NotNull
    private final String description;
    @NotNull
    private static final PerpetualStatConversion science = new PerpetualStatConversion(Stat.Science);
    @NotNull
    private static final PerpetualStatConversion gold = new PerpetualStatConversion(Stat.Gold);
    @NotNull
    private static final PerpetualStatConversion culture = new PerpetualStatConversion(Stat.Culture);
    @NotNull
    private static final PerpetualStatConversion faith = new PerpetualStatConversion(Stat.Faith);
    @NotNull
    private static final PerpetualConstruction idle = new PerpetualConstruction(){

        public boolean isBuildable(CityConstructions cityConstructions) {
            Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
            return true;
        }
    };
    @NotNull
    private static final Map<String, PerpetualConstruction> perpetualConstructionsMap;

    public PerpetualConstruction(@NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(description, "description");
        this.name = name;
        this.description = description;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Override
    public boolean shouldBeDisplayed(@NotNull CityConstructions cityConstructions) {
        Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
        return this.isBuildable(cityConstructions);
    }

    @Readonly
    @NotNull
    public String getProductionTooltip(@NotNull City city, boolean withIcon) {
        Intrinsics.checkNotNullParameter(city, "city");
        return "";
    }

    public static /* synthetic */ String getProductionTooltip$default(PerpetualConstruction perpetualConstruction, City city, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getProductionTooltip");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return perpetualConstruction.getProductionTooltip(city, bl);
    }

    @Override
    @NotNull
    public Counter<String> getStockpiledResourceRequirements(@NotNull GameContext state) {
        Intrinsics.checkNotNullParameter(state, "state");
        return Counter.Companion.getZERO();
    }

    @Override
    public boolean isBuildable(@NotNull CityConstructions cityConstructions) {
        Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
        throw new Exception("Impossible!");
    }

    @Override
    @NotNull
    public Counter<String> getResourceRequirementsPerTurn(@Nullable GameContext state) {
        return Counter.Companion.getZERO();
    }

    @Override
    @NotNull
    public Set<String> requiredResources(@NotNull GameContext state) {
        Intrinsics.checkNotNullParameter(state, "state");
        return SetsKt.emptySet();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(science.getName(), science), TuplesKt.to(gold.getName(), gold), TuplesKt.to(culture.getName(), culture), TuplesKt.to(faith.getName(), faith), TuplesKt.to(idle.getName(), idle)};
        perpetualConstructionsMap = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/unciv/models/ruleset/PerpetualConstruction$Companion;", "", "<init>", "()V", "science", "Lcom/unciv/models/ruleset/PerpetualStatConversion;", "getScience", "()Lcom/unciv/models/ruleset/PerpetualStatConversion;", "gold", "getGold", "culture", "getCulture", "faith", "getFaith", "idle", "Lcom/unciv/models/ruleset/PerpetualConstruction;", "getIdle", "()Lcom/unciv/models/ruleset/PerpetualConstruction;", "perpetualConstructionsMap", "", "", "getPerpetualConstructionsMap", "()Ljava/util/Map;", "isNamePerpetual", "", "name", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PerpetualStatConversion getScience() {
            return science;
        }

        @NotNull
        public final PerpetualStatConversion getGold() {
            return gold;
        }

        @NotNull
        public final PerpetualStatConversion getCulture() {
            return culture;
        }

        @NotNull
        public final PerpetualStatConversion getFaith() {
            return faith;
        }

        @NotNull
        public final PerpetualConstruction getIdle() {
            return idle;
        }

        @NotNull
        public final Map<String, PerpetualConstruction> getPerpetualConstructionsMap() {
            return perpetualConstructionsMap;
        }

        public final boolean isNamePerpetual(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return ((CharSequence)name).length() == 0 || this.getPerpetualConstructionsMap().containsKey(name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

