/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.logic.GameInfo;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.unique.UniqueTarget;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/unciv/models/ruleset/RuinReward;", "Lcom/unciv/models/ruleset/RulesetObject;", "<init>", "()V", "notification", "", "getNotification", "()Ljava/lang/String;", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "excludedDifficulties", "", "getExcludedDifficulties", "()Ljava/util/List;", "weight", "", "getWeight", "()I", "color", "getColor", "makeLink", "isUnavailableBySettings", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "core"})
public final class RuinReward
extends RulesetObject {
    @NotNull
    private final String notification;
    @NotNull
    private final List<String> excludedDifficulties = CollectionsKt.emptyList();
    private final int weight;
    @NotNull
    private final String color;

    public RuinReward() {
        this.notification = "";
        this.weight = 1;
        this.color = "";
    }

    @NotNull
    public final String getNotification() {
        return this.notification;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Ruins;
    }

    @NotNull
    public final List<String> getExcludedDifficulties() {
        return this.excludedDifficulties;
    }

    public final int getWeight() {
        return this.weight;
    }

    @NotNull
    public final String getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public String makeLink() {
        return "";
    }

    @Override
    public boolean isUnavailableBySettings(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        return this.excludedDifficulties.contains(gameInfo.getDifficulty()) || super.isUnavailableBySettings(gameInfo);
    }
}

