/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.nation;

import com.badlogic.gdx.graphics.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Pure;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"getRelativeLuminance", "", "color", "Lcom/badlogic/gdx/graphics/Color;", "getContrastRatio", "color1", "color2", "core"})
public final class NationKt {
    @Pure
    public static final double getRelativeLuminance(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        double r = NationKt.getRelativeLuminance$getRelativeChannelLuminance(color.r);
        double g = NationKt.getRelativeLuminance$getRelativeChannelLuminance(color.g);
        double b = NationKt.getRelativeLuminance$getRelativeChannelLuminance(color.b);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    public static final double getContrastRatio(@NotNull Color color1, @NotNull Color color2) {
        Intrinsics.checkNotNullParameter(color1, "color1");
        Intrinsics.checkNotNullParameter(color2, "color2");
        double innerColorLuminance = NationKt.getRelativeLuminance(color1);
        double outerColorLuminance = NationKt.getRelativeLuminance(color2);
        return innerColorLuminance > outerColorLuminance ? (innerColorLuminance + 0.05) / (outerColorLuminance + 0.05) : (outerColorLuminance + 0.05) / (innerColorLuminance + 0.05);
    }

    @Pure
    private static final double getRelativeLuminance$getRelativeChannelLuminance(float channel2) {
        return (double)channel2 < 0.03928 ? (double)channel2 / 12.92 : Math.pow(((double)channel2 + 0.055) / 1.055, 2.4);
    }
}

