/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.audio;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.multiplayer.storage.DropBox;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.audio.MusicTrackController;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.concurrent.TimersKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u001d\u0018\u0000 m2\u00020\u0001:\u0003mnoB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0%J\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020#0'J\b\u0010*\u001a\u00020\u0010H\u0002J\u001c\u0010+\u001a\u00020#2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!J\u0006\u0010-\u001a\u00020\u001cJ\u0006\u0010.\u001a\u00020\u001cJ\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\"00J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\"00J\b\u00106\u001a\u00020#H\u0002J\b\u00107\u001a\u00020#H\u0002J\b\u00108\u001a\u00020#H\u0002J\b\u00109\u001a\u00020#H\u0002J\b\u0010:\u001a\u00020#H\u0002J\b\u0010;\u001a\u00020#H\u0002J\u0018\u0010<\u001a\u00020#2\u0006\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020)H\u0002J(\u0010?\u001a\b\u0012\u0004\u0012\u00020@002\b\b\u0002\u0010A\u001a\u00020\u00102\u000e\b\u0002\u0010B\u001a\b\u0012\u0004\u0012\u00020@0%H\u0002J\u0016\u0010C\u001a\u0010\u0012\f\u0012\n D*\u0004\u0018\u00010@0@00H\u0002J(\u0010E\u001a\u0004\u0018\u00010@2\u0006\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u00102\f\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IH\u0002J\b\u0010K\u001a\u00020#H\u0002J\u0010\u0010K\u001a\u00020#2\u0006\u0010L\u001a\u00020\"H\u0002J\u001e\u0010M\u001a\u00020#2\u0016\u0010N\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011J*\u0010O\u001a\u00020\u001c2\b\b\u0002\u0010F\u001a\u00020\u00102\b\b\u0002\u0010G\u001a\u00020\u00102\u000e\b\u0002\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IJ \u0010P\u001a\u00020\u001c2\u0006\u0010Q\u001a\u00020@2\u000e\b\u0002\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IH\u0002J.\u0010O\u001a\u00020\u001c2\b\b\u0002\u0010F\u001a\u00020\u00102\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00100S2\u000e\b\u0002\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IJ\u000e\u0010P\u001a\u00020\u001c2\u0006\u0010L\u001a\u00020\"J\u001a\u0010T\u001a\u00020#2\b\b\u0002\u0010U\u001a\u00020\u00052\b\b\u0002\u0010V\u001a\u00020\u001cJ\u0006\u0010W\u001a\u00020#J\u0010\u0010X\u001a\u00020#2\b\b\u0002\u0010U\u001a\u00020\u0005J\u0010\u0010Y\u001a\u00020#2\b\b\u0002\u0010Z\u001a\u00020\u0005J\u000e\u0010[\u001a\u00020#2\u0006\u0010\\\u001a\u00020\u0005J\u0006\u0010]\u001a\u00020#J\u0006\u0010^\u001a\u00020#J\u0006\u0010_\u001a\u00020\u001cJ&\u0010`\u001a\u0010\u0012\f\u0012\n D*\u0004\u0018\u00010@0@002\u0006\u0010A\u001a\u00020\u00102\u0006\u0010a\u001a\u00020\u0010H\u0002J6\u0010b\u001a\u00020#2\u0006\u0010a\u001a\u00020\u00102\b\b\u0002\u0010A\u001a\u00020\u00102\b\b\u0002\u0010\\\u001a\u00020\u00052\b\b\u0002\u0010c\u001a\u00020\u001c2\b\b\u0002\u0010d\u001a\u00020\u001cJ\u000e\u0010e\u001a\u00020#2\u0006\u0010a\u001a\u00020\u0010J\u0006\u0010f\u001a\u00020\u001cJ&\u0010b\u001a\u00020#2\u0006\u0010g\u001a\u00020@2\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010c\u001a\u00020\u001c2\u0006\u0010d\u001a\u00020\u001cJ\u0006\u0010h\u001a\u00020#J\b\u0010i\u001a\u00020#H\u0002J\b\u0010j\u001a\u00020#H\u0002J\f\u0010k\u001a\u00020#*\u00020\u0018H\u0002J\b\u0010l\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006p"}, d2={"Lcom/unciv/ui/audio/MusicController;", "", "<init>", "()V", "baseVolume", "", "value", "silenceLength", "getSilenceLength", "()F", "setSilenceLength", "(F)V", "silenceLengthInTicks", "", "mods", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "state", "Lcom/unciv/ui/audio/MusicController$ControllerState;", "ticksOfSilence", "musicTimer", "Ljava/util/Timer;", "current", "Lcom/unciv/ui/audio/MusicTrackController;", "next", "overlay", "overlayPausing", "", "musicHistory", "Lkotlin/collections/ArrayDeque;", "onTrackChangeListeners", "", "Lkotlin/Function1;", "Lcom/unciv/ui/audio/MusicController$MusicTrackInfo;", "", "getAudioLoopCallback", "Lkotlin/Function0;", "getAudioExceptionHandler", "Lkotlin/Function2;", "", "Lcom/badlogic/gdx/audio/Music;", "currentlyPlaying", "onChange", "listener", "isMusicAvailable", "isPlaying", "getHistory", "Lkotlin/sequences/Sequence;", "getAllMusicFileInfo", "settings", "Lcom/unciv/models/metadata/GameSettings;", "getSettings", "()Lcom/unciv/models/metadata/GameSettings;", "clearCurrent", "clearNext", "startTimer", "stopTimer", "musicTimerTask", "shutdown", "audioExceptionHandler", "ex", "music", "getMusicFolders", "Lcom/badlogic/gdx/files/FileHandle;", "folder", "getDefault", "getAllMusicFiles", "kotlin.jvm.PlatformType", "chooseFile", "prefix", "suffix", "flags", "Ljava/util/EnumSet;", "Lcom/unciv/ui/audio/MusicTrackChooserFlags;", "fireOnChange", "trackInfo", "setModList", "newMods", "chooseTrack", "startTrack", "musicFile", "suffixes", "", "pause", "speedFactor", "onShutdown", "resumeFromShutdown", "resume", "fadeoutToSilence", "duration", "setVolume", "volume", "gracefulShutdown", "downloadDefaultFile", "isDefaultFileAvailable", "getMatchingFiles", "name", "playOverlay", "isLooping", "fadeIn", "playVoice", "isVoicesAvailable", "file", "stopOverlay", "pauseOverlay", "resumeOverlay", "overlayTick", "clearOverlay", "Companion", "MusicTrackInfo", "ControllerState", "core"})
public final class MusicController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float baseVolume;
    private int silenceLengthInTicks;
    @NotNull
    private HashSet<String> mods;
    @NotNull
    private ControllerState state;
    private int ticksOfSilence;
    @Nullable
    private Timer musicTimer;
    @Nullable
    private MusicTrackController current;
    @Nullable
    private MusicTrackController next;
    @Nullable
    private MusicTrackController overlay;
    private boolean overlayPausing;
    @NotNull
    private final ArrayDeque<String> musicHistory;
    @NotNull
    private List<Function1<MusicTrackInfo, Unit>> onTrackChangeListeners;
    @NotNull
    private static final Files.FileType musicLocation = Files.FileType.Local;
    @NotNull
    private static final String musicPath = "music";
    @NotNull
    private static final String modPath = "mods";
    @NotNull
    private static final String musicFallbackLocation = "/music/thatched-villagers.mp3";
    @NotNull
    private static final String musicFallbackLocalName = "music/Thatched Villagers - Ambient.mp3";
    private static final float maxVolume = 0.6f;
    private static final float ticksPerSecondGdx = 58.3f;
    private static final float ticksPerSecondOwn = 20.0f;
    private static final float defaultFadeDuration = 0.9f;
    private static final float defaultFadingStepGdx = 0.01905851f;
    private static final float defaultFadingStepOwn = 0.055555556f;
    private static final int musicHistorySize = 8;
    @NotNull
    private static final List<String> gdxSupportedFileExtensions;
    private static boolean needOwnTimer;
    private static float ticksPerSecond;
    private static float defaultFadingStep;

    public MusicController() {
        FileHandle newFallbackFile;
        FileHandle oldFallbackFile = UncivGame.Companion.getCurrent().getFiles().getLocalFile(StringsKt.removePrefix(musicFallbackLocation, (CharSequence)"/"));
        if (oldFallbackFile.exists() && !(newFallbackFile = UncivGame.Companion.getCurrent().getFiles().getLocalFile(musicFallbackLocalName)).exists()) {
            oldFallbackFile.moveTo(newFallbackFile);
        }
        this.baseVolume = this.getSettings().getMusicVolume();
        this.silenceLengthInTicks = MathKt.roundToInt((float)this.getSettings().getPauseBetweenTracks() * ticksPerSecond);
        this.mods = new HashSet();
        this.state = ControllerState.Idle;
        this.musicHistory = new ArrayDeque(8);
        this.onTrackChangeListeners = new ArrayList();
    }

    public final float getSilenceLength() {
        return (float)this.silenceLengthInTicks / ticksPerSecond;
    }

    public final void setSilenceLength(float value) {
        this.silenceLengthInTicks = (int)(ticksPerSecond * value);
    }

    @NotNull
    public final Function0<Unit> getAudioLoopCallback() {
        needOwnTimer = false;
        ticksPerSecond = 58.3f;
        defaultFadingStep = 0.01905851f;
        return () -> MusicController.getAudioLoopCallback$lambda$0(this);
    }

    @NotNull
    public final Function2<Throwable, Music, Unit> getAudioExceptionHandler() {
        return (arg_0, arg_1) -> MusicController.getAudioExceptionHandler$lambda$0(this, arg_0, arg_1);
    }

    private final String currentlyPlaying() {
        String string;
        if (this.state.getShowTrack()) {
            string = this.musicHistory.lastOrNull();
            if (string == null) {
                string = "";
            }
        } else {
            string = "";
        }
        return string;
    }

    public final void onChange(@Nullable Function1<? super MusicTrackInfo, Unit> listener) {
        if (listener == null) {
            this.onTrackChangeListeners.clear();
        } else {
            this.onTrackChangeListeners.add(listener);
        }
        this.fireOnChange();
    }

    public final boolean isMusicAvailable() {
        return SequencesKt.any(this.getAllMusicFiles());
    }

    public final boolean isPlaying() {
        MusicTrackController musicTrackController = this.current;
        return musicTrackController != null ? musicTrackController.isPlaying() : false;
    }

    @NotNull
    public final Sequence<MusicTrackInfo> getHistory() {
        return SequencesKt.map(CollectionsKt.asSequence((Iterable)this.musicHistory), MusicController::getHistory$lambda$0);
    }

    @NotNull
    public final Sequence<MusicTrackInfo> getAllMusicFileInfo() {
        return SequencesKt.map(this.getAllMusicFiles(), MusicController::getAllMusicFileInfo$lambda$0);
    }

    private final GameSettings getSettings() {
        return UncivGame.Companion.getCurrent().getSettings();
    }

    private final void clearCurrent() {
        MusicTrackController musicTrackController = this.current;
        if (musicTrackController != null) {
            musicTrackController.clear();
        }
        this.current = null;
    }

    private final void clearNext() {
        MusicTrackController musicTrackController = this.next;
        if (musicTrackController != null) {
            musicTrackController.clear();
        }
        this.next = null;
    }

    private final void startTimer() {
        Timer timer2;
        if (!needOwnTimer || this.musicTimer != null) {
            return;
        }
        long timerPeriod = MathKt.roundToInt(1000.0f / ticksPerSecond);
        String string = "MusicTimer";
        boolean bl = true;
        long l = 0L;
        Timer timer3 = timer2 = TimersKt.timer(string, bl);
        timer3.schedule(new TimerTask(this){
            final /* synthetic */ MusicController this$0;
            {
                this.this$0 = musicController;
            }

            public void run() {
                TimerTask $this$startTimer_u24lambda_u240 = this;
                boolean bl = false;
                MusicController.access$musicTimerTask(this.this$0);
            }
        }, l, timerPeriod);
        this.musicTimer = timer2;
    }

    private final void stopTimer() {
        if (this.musicTimer == null) {
            return;
        }
        Timer timer2 = this.musicTimer;
        if (timer2 != null) {
            timer2.cancel();
        }
        this.musicTimer = null;
    }

    private final void musicTimerTask() {
        MusicTrackController musicTrackController = this.overlay;
        if (musicTrackController != null) {
            this.overlayTick(musicTrackController);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                return;
            }
            case 2: 
            case 3: {
                if (this.current == null) {
                    if (this.next == null) {
                        this.ticksOfSilence = 0;
                        this.state = this.state == ControllerState.PlaySingle ? ControllerState.Shutdown : ControllerState.Silence;
                        this.fireOnChange();
                        break;
                    }
                    MusicTrackController musicTrackController2 = this.next;
                    Intrinsics.checkNotNull(musicTrackController2);
                    if (!musicTrackController2.getState().getCanPlay()) break;
                    this.current = this.next;
                    this.next = null;
                    MusicTrackController musicTrackController3 = this.current;
                    Intrinsics.checkNotNull(musicTrackController3);
                    if (!musicTrackController3.play()) {
                        this.ticksOfSilence = -this.silenceLengthInTicks - 1000;
                        this.state = ControllerState.Silence;
                        break;
                    }
                    this.fireOnChange();
                    break;
                }
                MusicTrackController musicTrackController4 = this.current;
                Intrinsics.checkNotNull(musicTrackController4);
                if (!musicTrackController4.isPlaying()) {
                    this.clearCurrent();
                    break;
                }
                MusicTrackController musicTrackController5 = this.current;
                if ((musicTrackController5 != null ? musicTrackController5.timerTick() : null) == MusicTrackController.State.Idle) {
                    this.clearCurrent();
                }
                MusicTrackController musicTrackController6 = this.next;
                if (musicTrackController6 != null) {
                    musicTrackController6.timerTick();
                }
                break;
            }
            case 4: {
                ++this.ticksOfSilence;
                if (this.ticksOfSilence <= this.silenceLengthInTicks) break;
                this.ticksOfSilence = 0;
                MusicController.chooseTrack$default(this, null, null, null, 7, null);
                break;
            }
            case 5: {
                MusicTrackController musicTrackController7 = this.current;
                if (musicTrackController7 != null ? !musicTrackController7.shutdownTick() : false) break;
                MusicTrackController musicTrackController8 = this.next;
                if (musicTrackController8 != null ? !musicTrackController8.shutdownTick() : false) break;
                this.state = ControllerState.Cleanup;
                break;
            }
            case 6: {
                this.shutdown();
                break;
            }
            case 7: 
            case 8: {
                MusicTrackController musicTrackController9 = this.current;
                if (musicTrackController9 != null) {
                    musicTrackController9.timerTick();
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void shutdown() {
        this.state = ControllerState.Idle;
        this.fireOnChange();
        this.stopTimer();
        this.clearNext();
        this.clearCurrent();
        this.clearOverlay();
        this.musicHistory.clear();
        Log.INSTANCE.debug("MusicController shut down.", new Object[0]);
    }

    private final void audioExceptionHandler(Throwable ex, Music music) {
        music.dispose();
        MusicTrackController musicTrackController = this.next;
        if (Intrinsics.areEqual(music, musicTrackController != null ? musicTrackController.getMusic() : null)) {
            this.clearNext();
        }
        MusicTrackController musicTrackController2 = this.current;
        if (Intrinsics.areEqual(music, musicTrackController2 != null ? musicTrackController2.getMusic() : null)) {
            this.clearCurrent();
        }
        MusicTrackController musicTrackController3 = this.overlay;
        if (Intrinsics.areEqual(music, musicTrackController3 != null ? musicTrackController3.getMusic() : null)) {
            this.clearOverlay();
        }
        Log.INSTANCE.error("Error playing music", ex);
        ThreadsKt.thread$default(false, true, null, null, 0, () -> MusicController.audioExceptionHandler$lambda$0(this), 29, null);
    }

    private final Sequence<FileHandle> getMusicFolders(String folder, Function0<? extends FileHandle> getDefault) {
        return SequencesKt.filter(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FileHandle>, Continuation<? super Unit>, Object>(this, getDefault, folder, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MusicController this$0;
            final /* synthetic */ Function0<FileHandle> $getDefault;
            final /* synthetic */ String $folder;
            {
                this.this$0 = $receiver;
                this.$getDefault = $getDefault;
                this.$folder = $folder;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yieldAll(SequencesKt.map(CollectionsKt.asSequence((Iterable)SetsKt.plus((Set)MusicController.access$getSettings(this.this$0).getVisualMods(), MusicController.access$getMods$p(this.this$0))), (Function1<String, FileHandle>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String java.lang.String ), (Ljava/lang/String;)Lcom/badlogic/gdx/files/FileHandle;)((String)this.$folder)), (Continuation<? super Unit>)this);
                        if (v0 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.label = 2;
                        v1 = $this$sequence.yield(this.$getDefault.invoke(), this);
                        if (v1 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super FileHandle>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super FileHandle> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final FileHandle invokeSuspend$lambda$0(String $folder, String it) {
                return com.unciv.ui.audio.MusicController$Companion.access$getFile(MusicController.Companion, "mods").child(it).child($folder);
            }
        }), MusicController::getMusicFolders$lambda$1);
    }

    static /* synthetic */ Sequence getMusicFolders$default(MusicController musicController, String string, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = musicPath;
        }
        if ((n & 2) != 0) {
            function0 = () -> MusicController.getMusicFolders$lambda$0(string);
        }
        return musicController.getMusicFolders(string, function0);
    }

    private final Sequence<FileHandle> getAllMusicFiles() {
        return SequencesKt.filter(SequencesKt.flatMap(MusicController.getMusicFolders$default(this, null, null, 3, null), MusicController::getAllMusicFiles$lambda$0), MusicController::getAllMusicFiles$lambda$1);
    }

    private final FileHandle chooseFile(String prefix, String suffix, EnumSet<MusicTrackChooserFlags> flags) {
        FileHandle defaultFile;
        if (flags.contains((Object)MusicTrackChooserFlags.PlayDefaultFile) && (defaultFile = MusicController.Companion.getFile(musicFallbackLocalName)).exists()) {
            return defaultFile;
        }
        boolean prefixMustMatch = flags.contains((Object)MusicTrackChooserFlags.PrefixMustMatch);
        boolean suffixMustMatch = flags.contains((Object)MusicTrackChooserFlags.SuffixMustMatch);
        Function1[] function1Array = new Function1[]{arg_0 -> MusicController.chooseFile$lambda$1(prefix, arg_0), arg_0 -> MusicController.chooseFile$lambda$2(suffix, arg_0), arg_0 -> MusicController.chooseFile$lambda$3(this, arg_0)};
        return SequencesKt.firstOrNull(SequencesKt.sortedWith(SequencesKt.shuffled(SequencesKt.filter(this.getAllMusicFiles(), arg_0 -> MusicController.chooseFile$lambda$0(prefixMustMatch, prefix, suffixMustMatch, suffix, arg_0))), ComparisonsKt.compareBy(function1Array)));
    }

    private final void fireOnChange() {
        if (this.onTrackChangeListeners.isEmpty()) {
            return;
        }
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MusicController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        MusicController.access$fireOnChange(this.this$0, MusicTrackInfo.Companion.parse(MusicController.access$currentlyPlaying(this.this$0)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void fireOnChange(MusicTrackInfo trackInfo) {
        try {
            for (Function1<MusicTrackInfo, Unit> listener : this.onTrackChangeListeners) {
                listener.invoke(trackInfo);
            }
        }
        catch (Throwable ex) {
            Log.INSTANCE.debug("onTrackChange event invoke failed", ex);
            this.onTrackChangeListeners.clear();
        }
    }

    public final void setModList(@NotNull HashSet<String> newMods) {
        Intrinsics.checkNotNullParameter(newMods, "newMods");
        this.mods = newMods;
    }

    public final boolean chooseTrack(@NotNull String prefix, @NotNull String suffix, @NotNull EnumSet<MusicTrackChooserFlags> flags) {
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        Intrinsics.checkNotNullParameter(flags, "flags");
        if (this.baseVolume == 0.0f) {
            return false;
        }
        FileHandle musicFile = this.chooseFile(prefix, suffix, flags);
        if (musicFile == null) {
            Object[] objectArray = new Object[]{prefix, suffix, flags};
            Log.INSTANCE.debug("No music found for prefix=%s, suffix=%s, flags=%s", objectArray);
            return false;
        }
        Object[] objectArray = new Object[]{musicFile.path(), prefix, suffix, flags};
        Log.INSTANCE.debug("Track chosen: %s for prefix=%s, suffix=%s, flags=%s", objectArray);
        return this.startTrack(musicFile, flags);
    }

    public static /* synthetic */ boolean chooseTrack$default(MusicController musicController, String string, String string2, EnumSet enumSet, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "Ambient";
        }
        if ((n & 4) != 0) {
            enumSet = MusicTrackChooserFlags.Companion.getDefault();
        }
        return musicController.chooseTrack(string, string2, enumSet);
    }

    private final boolean startTrack(FileHandle musicFile, EnumSet<MusicTrackChooserFlags> flags) {
        if (Intrinsics.areEqual(musicFile.path(), this.currentlyPlaying())) {
            return true;
        }
        if (!musicFile.exists()) {
            return false;
        }
        MusicTrackController musicTrackController = this.next;
        if (musicTrackController != null) {
            musicTrackController.clear();
        }
        MusicTrackController musicTrackController2 = this.next = new MusicTrackController(this.baseVolume * 0.6f, 0.0f, 2, null);
        Intrinsics.checkNotNull(musicTrackController2);
        musicTrackController2.load(musicFile, arg_0 -> MusicController.startTrack$lambda$0(this, arg_0), arg_0 -> MusicController.startTrack$lambda$1(musicFile, this, flags, arg_0));
        this.state = flags.contains((Object)MusicTrackChooserFlags.PlaySingle) ? ControllerState.PlaySingle : ControllerState.Playing;
        this.startTimer();
        return true;
    }

    static /* synthetic */ boolean startTrack$default(MusicController musicController, FileHandle fileHandle, EnumSet enumSet, int n, Object object) {
        if ((n & 2) != 0) {
            enumSet = MusicTrackChooserFlags.Companion.getDefault();
        }
        return musicController.startTrack(fileHandle, enumSet);
    }

    public final boolean chooseTrack(@NotNull String prefix, @NotNull List<String> suffixes, @NotNull EnumSet<MusicTrackChooserFlags> flags) {
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(suffixes, "suffixes");
        Intrinsics.checkNotNullParameter(flags, "flags");
        for (String suffix : suffixes) {
            if (!this.chooseTrack(prefix, suffix, flags)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean chooseTrack$default(MusicController musicController, String string, List list2, EnumSet enumSet, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            enumSet = MusicTrackChooserFlags.Companion.getNone();
        }
        return musicController.chooseTrack(string, list2, enumSet);
    }

    public final boolean startTrack(@NotNull MusicTrackInfo trackInfo) {
        Intrinsics.checkNotNullParameter(trackInfo, "trackInfo");
        if (((CharSequence)trackInfo.getTrack()).length() == 0) {
            return false;
        }
        MusicTrackInfo $this$startTrack_u24lambda_u242 = trackInfo;
        boolean bl = false;
        String path = ((CharSequence)$this$startTrack_u24lambda_u242.getMod()).length() == 0 ? "music/" + $this$startTrack_u24lambda_u242.getTrack() + '.' + $this$startTrack_u24lambda_u242.getType() : "mods/" + $this$startTrack_u24lambda_u242.getMod() + "/music/" + $this$startTrack_u24lambda_u242.getTrack() + '.' + $this$startTrack_u24lambda_u242.getType();
        FileHandle fileHandle = MusicController.Companion.getFile(path);
        Intrinsics.checkNotNullExpressionValue(fileHandle, "access$getFile(...)");
        return MusicController.startTrack$default(this, fileHandle, null, 2, null);
    }

    public final void pause(float speedFactor, boolean onShutdown) {
        Log.INSTANCE.debug("MusicTrackController.pause called", new Object[0]);
        if (!this.state.getCanPause()) {
            return;
        }
        this.state = onShutdown ? ControllerState.PauseOnShutdown : ControllerState.Pause;
        float fadingStep = defaultFadingStep * ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(speedFactor), RangesKt.rangeTo(0.001f, 1000.0f))).floatValue();
        MusicTrackController musicTrackController = this.current;
        if (musicTrackController != null) {
            musicTrackController.startFade(MusicTrackController.State.FadeOut, fadingStep);
        }
        MusicTrackController musicTrackController2 = this.next;
        if ((musicTrackController2 != null ? musicTrackController2.getState() : null) == MusicTrackController.State.FadeIn) {
            MusicTrackController musicTrackController3 = this.next;
            Intrinsics.checkNotNull(musicTrackController3);
            MusicTrackController.startFade$default(musicTrackController3, MusicTrackController.State.FadeOut, 0.0f, 2, null);
        }
        this.pauseOverlay();
    }

    public static /* synthetic */ void pause$default(MusicController musicController, float f, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        musicController.pause(f, bl);
    }

    public final void resumeFromShutdown() {
        if (this.state == ControllerState.PauseOnShutdown) {
            MusicController.resume$default(this, 0.0f, 1, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void resume(float speedFactor) {
        Log.INSTANCE.debug("MusicTrackController.resume called", new Object[0]);
        if (this.state != ControllerState.Pause && this.state != ControllerState.PauseOnShutdown || this.current == null) ** GOTO lbl-1000
        v0 = this.current;
        Intrinsics.checkNotNull(v0);
        if (!v0.getState().getCanPlay()) ** GOTO lbl-1000
        v1 = this.current;
        Intrinsics.checkNotNull(v1);
        if (v1.getMusic() != null) {
            fadingStep = MusicController.defaultFadingStep * ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(speedFactor), RangesKt.rangeTo(0.001f, 1000.0f))).floatValue();
            v2 = this.current;
            Intrinsics.checkNotNull(v2);
            v2.startFade(MusicTrackController.State.FadeIn, fadingStep);
            this.state = ControllerState.Playing;
            v3 = this.current;
            Intrinsics.checkNotNull(v3);
            v3.play();
        } else if (this.state == ControllerState.Cleanup || this.state == ControllerState.Pause) {
            MusicController.chooseTrack$default(this, null, null, null, 7, null);
        }
        this.resumeOverlay();
    }

    public static /* synthetic */ void resume$default(MusicController musicController, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        musicController.resume(f);
    }

    public final void fadeoutToSilence(float duration) {
        float fadingStep = 1.0f / ticksPerSecond / duration;
        MusicTrackController musicTrackController = this.current;
        if (musicTrackController != null) {
            musicTrackController.startFade(MusicTrackController.State.FadeOut, fadingStep);
        }
        MusicTrackController musicTrackController2 = this.next;
        if (musicTrackController2 != null) {
            musicTrackController2.startFade(MusicTrackController.State.FadeOut, fadingStep);
        }
        MusicTrackController musicTrackController3 = this.overlay;
        if (musicTrackController3 != null) {
            musicTrackController3.startFade(MusicTrackController.State.FadeOut, fadingStep);
        }
        this.state = ControllerState.Shutdown;
    }

    public static /* synthetic */ void fadeoutToSilence$default(MusicController musicController, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 4.5f;
        }
        musicController.fadeoutToSilence(f);
    }

    public final void setVolume(float volume) {
        this.baseVolume = volume;
        if ((double)volume < 0.01) {
            this.shutdown();
        } else if (this.isPlaying()) {
            MusicTrackController musicTrackController = this.current;
            Intrinsics.checkNotNull(musicTrackController);
            musicTrackController.setVolume(this.baseVolume * 0.6f);
        }
    }

    public final void gracefulShutdown() {
        if (this.state == ControllerState.Cleanup) {
            this.shutdown();
        } else {
            this.fadeoutToSilence(0.9f);
        }
    }

    public final void downloadDefaultFile() {
        InputStream file = DropBox.INSTANCE.downloadFile(musicFallbackLocation);
        MusicController.Companion.getFile(musicFallbackLocalName).write(file, false);
    }

    public final boolean isDefaultFileAvailable() {
        return MusicController.Companion.getFile(musicFallbackLocalName).exists();
    }

    private final Sequence<FileHandle> getMatchingFiles(String folder, String name) {
        return SequencesKt.flatMap(this.getMusicFolders(folder, () -> MusicController.getMatchingFiles$lambda$0(folder)), arg_0 -> MusicController.getMatchingFiles$lambda$1(name, arg_0));
    }

    public final void playOverlay(@NotNull String name, @NotNull String folder, float volume, boolean isLooping, boolean fadeIn) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(folder, "folder");
        Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, folder, name, volume, isLooping, fadeIn, null){
            int label;
            final /* synthetic */ MusicController this$0;
            final /* synthetic */ String $folder;
            final /* synthetic */ String $name;
            final /* synthetic */ float $volume;
            final /* synthetic */ boolean $isLooping;
            final /* synthetic */ boolean $fadeIn;
            {
                this.this$0 = $receiver;
                this.$folder = $folder;
                this.$name = $name;
                this.$volume = $volume;
                this.$isLooping = $isLooping;
                this.$fadeIn = $fadeIn;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        FileHandle fileHandle = (FileHandle)SequencesKt.firstOrNull(MusicController.access$getMatchingFiles(this.this$0, this.$folder, this.$name));
                        if (fileHandle == null) {
                            return Unit.INSTANCE;
                        }
                        FileHandle file = fileHandle;
                        this.this$0.playOverlay(file, this.$volume, this.$isLooping, this.$fadeIn);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public static /* synthetic */ void playOverlay$default(MusicController musicController, String string, String string2, float f, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "sounds";
        }
        if ((n & 4) != 0) {
            f = musicController.getSettings().getSoundEffectsVolume();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        musicController.playOverlay(string, string2, f, bl, bl2);
    }

    public final void playVoice(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        MusicController.playOverlay$default(this, name, "voices", this.getSettings().getVoicesVolume(), false, false, 24, null);
    }

    public final boolean isVoicesAvailable() {
        return SequencesKt.any(MusicController.getMusicFolders$default(this, "voices", null, 2, null));
    }

    public final void playOverlay(@NotNull FileHandle file, float volume, boolean isLooping, boolean fadeIn) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.clearOverlay();
        MusicTrackController.load$default(new MusicTrackController(volume, fadeIn ? 0.0f : 1.0f), file, null, arg_0 -> MusicController.playOverlay$lambda$0(isLooping, this, arg_0), 2, null);
    }

    public final void stopOverlay() {
        block0: {
            this.overlayPausing = false;
            MusicTrackController musicTrackController = this.overlay;
            if (musicTrackController == null) break block0;
            MusicTrackController.startFade$default(musicTrackController, MusicTrackController.State.FadeOut, 0.0f, 2, null);
        }
    }

    private final void pauseOverlay() {
        block0: {
            this.overlayPausing = true;
            MusicTrackController musicTrackController = this.overlay;
            if (musicTrackController == null) break block0;
            MusicTrackController.startFade$default(musicTrackController, MusicTrackController.State.FadeOut, 0.0f, 2, null);
        }
    }

    private final void resumeOverlay() {
        block1: {
            MusicTrackController musicTrackController = this.overlay;
            if (musicTrackController == null) break block1;
            MusicTrackController $this$resumeOverlay_u24lambda_u240 = musicTrackController;
            boolean bl = false;
            if (!$this$resumeOverlay_u24lambda_u240.getState().getCanPlay() || $this$resumeOverlay_u24lambda_u240.getState() == MusicTrackController.State.Playing) {
                return;
            }
            MusicTrackController.startFade$default($this$resumeOverlay_u24lambda_u240, MusicTrackController.State.FadeIn, 0.0f, 2, null);
            $this$resumeOverlay_u24lambda_u240.play();
        }
    }

    private final void overlayTick(MusicTrackController $this$overlayTick) {
        if (!$this$overlayTick.timerTick().getCanPlay()) {
            return;
        }
        if (!this.overlayPausing && !$this$overlayTick.isPlaying()) {
            this.clearOverlay();
        }
    }

    private final void clearOverlay() {
        MusicTrackController musicTrackController = this.overlay;
        if (musicTrackController != null) {
            musicTrackController.clear();
        }
        this.overlay = null;
    }

    private static final Unit getAudioLoopCallback$lambda$0(MusicController this$0) {
        this$0.musicTimerTask();
        return Unit.INSTANCE;
    }

    private static final Unit getAudioExceptionHandler$lambda$0(MusicController this$0, Throwable ex, Music music) {
        Intrinsics.checkNotNullParameter(ex, "ex");
        Intrinsics.checkNotNullParameter(music, musicPath);
        this$0.audioExceptionHandler(ex, music);
        return Unit.INSTANCE;
    }

    private static final MusicTrackInfo getHistory$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return MusicTrackInfo.Companion.parse(it);
    }

    private static final MusicTrackInfo getAllMusicFileInfo$lambda$0(FileHandle it) {
        String string = it.path();
        Intrinsics.checkNotNullExpressionValue(string, "path(...)");
        return MusicTrackInfo.Companion.parse(string);
    }

    private static final void audioExceptionHandler$lambda$0$0(MusicController this$0) {
        MusicController.chooseTrack$default(this$0, null, null, null, 7, null);
    }

    private static final Unit audioExceptionHandler$lambda$0(MusicController this$0) {
        Thread.sleep(2000L);
        Gdx.app.postRunnable(() -> MusicController.audioExceptionHandler$lambda$0$0(this$0));
        return Unit.INSTANCE;
    }

    private static final FileHandle getMusicFolders$lambda$0(String $folder) {
        FileHandle fileHandle = MusicController.Companion.getFile($folder);
        Intrinsics.checkNotNullExpressionValue(fileHandle, "access$getFile(...)");
        return fileHandle;
    }

    private static final boolean getMusicFolders$lambda$1(FileHandle it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.exists() && it.isDirectory();
    }

    private static final Sequence getAllMusicFiles$lambda$0(FileHandle it) {
        Intrinsics.checkNotNullParameter(it, "it");
        FileHandle[] fileHandleArray = it.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        return ArraysKt.asSequence((Object[])fileHandleArray);
    }

    private static final boolean getAllMusicFiles$lambda$1(FileHandle it) {
        return it.exists() && !it.isDirectory() && gdxSupportedFileExtensions.contains(it.extension());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean chooseFile$lambda$0(boolean $prefixMustMatch, String $prefix, boolean $suffixMustMatch, String $suffix, FileHandle it) {
        if ($prefixMustMatch) {
            String string = it.nameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
            if (!StringsKt.startsWith$default(string, $prefix, false, 2, null)) return false;
        }
        if (!$suffixMustMatch) return true;
        String string = it.nameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
        if (!StringsKt.endsWith$default(string, $suffix, false, 2, null)) return false;
        return true;
    }

    private static final Comparable chooseFile$lambda$1(String $prefix, FileHandle it) {
        String string = it.nameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
        return StringsKt.startsWith$default(string, $prefix, false, 2, null) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
    }

    private static final Comparable chooseFile$lambda$2(String $suffix, FileHandle it) {
        String string = it.nameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
        return StringsKt.endsWith$default(string, $suffix, false, 2, null) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
    }

    private static final Comparable chooseFile$lambda$3(MusicController this$0, FileHandle it) {
        return this$0.musicHistory.contains(it.path()) ? (Comparable)Integer.valueOf(1) : (Comparable)Integer.valueOf(0);
    }

    private static final Unit startTrack$lambda$0(MusicController this$0, MusicTrackController it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.ticksOfSilence = 0;
        this$0.state = ControllerState.Silence;
        this$0.next = null;
        return Unit.INSTANCE;
    }

    private static final Unit startTrack$lambda$1(FileHandle $musicFile, MusicController this$0, EnumSet $flags, MusicTrackController it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object[] objectArray = new Object[]{$musicFile.path()};
        Log.INSTANCE.debug("Music queued: %s", objectArray);
        if (this$0.musicHistory.size() >= 8) {
            this$0.musicHistory.removeFirst();
        }
        ArrayDeque<String> arrayDeque = this$0.musicHistory;
        String string = $musicFile.path();
        Intrinsics.checkNotNullExpressionValue(string, "path(...)");
        arrayDeque.addLast(string);
        it.play();
        float fadingStep = defaultFadingStep / (float)($flags.contains((Object)MusicTrackChooserFlags.SlowFade) ? 5 : 1);
        it.startFade(MusicTrackController.State.FadeIn, fadingStep);
        switch (WhenMappings.$EnumSwitchMapping$0[this$0.state.ordinal()]) {
            case 2: 
            case 3: {
                MusicTrackController musicTrackController = this$0.current;
                if (musicTrackController != null) {
                    musicTrackController.startFade(MusicTrackController.State.FadeOut, fadingStep);
                }
                break;
            }
            case 7: {
                MusicTrackController musicTrackController = this$0.current;
                if ((musicTrackController != null ? musicTrackController.getState() : null) != MusicTrackController.State.Idle) break;
                this$0.clearCurrent();
                break;
            }
        }
        return Unit.INSTANCE;
    }

    private static final FileHandle getMatchingFiles$lambda$1$0(FileHandle $it, String $name, String extension) {
        Intrinsics.checkNotNullParameter(extension, "extension");
        return $it.child($name + '.' + extension);
    }

    private static final boolean getMatchingFiles$lambda$1$1(FileHandle file) {
        return file.exists() && !file.isDirectory();
    }

    private static final FileHandle getMatchingFiles$lambda$0(String $folder) {
        FileHandle fileHandle = Gdx.files.internal($folder);
        Intrinsics.checkNotNullExpressionValue(fileHandle, "internal(...)");
        return fileHandle;
    }

    private static final Sequence getMatchingFiles$lambda$1(String $name, FileHandle it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)gdxSupportedFileExtensions), arg_0 -> MusicController.getMatchingFiles$lambda$1$0(it, $name, arg_0)), MusicController::getMatchingFiles$lambda$1$1);
    }

    private static final Unit playOverlay$lambda$0(boolean $isLooping, MusicController this$0, MusicTrackController it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Music music = it.getMusic();
        if (music != null) {
            music.setLooping($isLooping);
        }
        it.play();
        MusicTrackController.startFade$default(it, MusicTrackController.State.FadeIn, 0.0f, 2, null);
        this$0.overlay = it;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$musicTimerTask(MusicController $this) {
        $this.musicTimerTask();
    }

    public static final /* synthetic */ GameSettings access$getSettings(MusicController $this) {
        return $this.getSettings();
    }

    public static final /* synthetic */ HashSet access$getMods$p(MusicController $this) {
        return $this.mods;
    }

    public static final /* synthetic */ void access$fireOnChange(MusicController $this, MusicTrackInfo trackInfo) {
        $this.fireOnChange(trackInfo);
    }

    public static final /* synthetic */ String access$currentlyPlaying(MusicController $this) {
        return $this.currentlyPlaying();
    }

    public static final /* synthetic */ Sequence access$getMatchingFiles(MusicController $this, String folder, String name) {
        return $this.getMatchingFiles(folder, name);
    }

    static {
        String[] stringArray = new String[]{"mp3", "ogg", "wav"};
        gdxSupportedFileExtensions = CollectionsKt.listOf(stringArray);
        needOwnTimer = true;
        ticksPerSecond = 20.0f;
        defaultFadingStep = 0.055555556f;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00192\u0006\u0010\u001b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/unciv/ui/audio/MusicController$Companion;", "", "<init>", "()V", "musicLocation", "Lcom/badlogic/gdx/Files$FileType;", "musicPath", "", "modPath", "musicFallbackLocation", "musicFallbackLocalName", "maxVolume", "", "ticksPerSecondGdx", "ticksPerSecondOwn", "defaultFadeDuration", "defaultFadingStepGdx", "defaultFadingStepOwn", "musicHistorySize", "", "gdxSupportedFileExtensions", "", "getGdxSupportedFileExtensions", "()Ljava/util/List;", "getFile", "Lcom/badlogic/gdx/files/FileHandle;", "kotlin.jvm.PlatformType", "path", "needOwnTimer", "", "ticksPerSecond", "defaultFadingStep", "getDefaultFadingStep$core", "()F", "setDefaultFadingStep$core", "(F)V", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getGdxSupportedFileExtensions() {
            return gdxSupportedFileExtensions;
        }

        private final FileHandle getFile(String path) {
            return musicLocation == Files.FileType.External && Gdx.files.isExternalStorageAvailable() ? Gdx.files.external(path) : UncivGame.Companion.getCurrent().getFiles().getLocalFile(path);
        }

        public final float getDefaultFadingStep$core() {
            return defaultFadingStep;
        }

        public final void setDefaultFadingStep$core(float f) {
            defaultFadingStep = f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/audio/MusicController$ControllerState;", "", "canPause", "", "showTrack", "<init>", "(Ljava/lang/String;IZZ)V", "getCanPause", "()Z", "getShowTrack", "Idle", "Cleanup", "Playing", "PlaySingle", "Silence", "Pause", "PauseOnShutdown", "Shutdown", "core"})
    private static final class ControllerState
    extends Enum<ControllerState> {
        private final boolean canPause;
        private final boolean showTrack;
        public static final /* enum */ ControllerState Idle = new ControllerState("Idle", 0, false, false, 3, null);
        public static final /* enum */ ControllerState Cleanup = new ControllerState("Cleanup", 1, false, false, 3, null);
        public static final /* enum */ ControllerState Playing = new ControllerState(true, true);
        public static final /* enum */ ControllerState PlaySingle = new ControllerState(true, true);
        public static final /* enum */ ControllerState Silence = new ControllerState("Silence", 4, true, false, 2, null);
        public static final /* enum */ ControllerState Pause = new ControllerState("Pause", 5, false, true, 1, null);
        public static final /* enum */ ControllerState PauseOnShutdown = new ControllerState("PauseOnShutdown", 6, false, false, 3, null);
        public static final /* enum */ ControllerState Shutdown = new ControllerState("Shutdown", 7, false, false, 3, null);
        private static final /* synthetic */ ControllerState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ControllerState(boolean canPause, boolean showTrack) {
            this.canPause = canPause;
            this.showTrack = showTrack;
        }

        /* synthetic */ ControllerState(String string, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getCanPause() {
            return this.canPause;
        }

        public final boolean getShowTrack() {
            return this.showTrack;
        }

        public static ControllerState[] values() {
            return (ControllerState[])$VALUES.clone();
        }

        public static ControllerState valueOf(String value) {
            return Enum.valueOf(ControllerState.class, value);
        }

        @NotNull
        public static EnumEntries<ControllerState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = controllerStateArray = new ControllerState[]{ControllerState.Idle, ControllerState.Cleanup, ControllerState.Playing, ControllerState.PlaySingle, ControllerState.Silence, ControllerState.Pause, ControllerState.PauseOnShutdown, ControllerState.Shutdown};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u00020\u0003H\u0096\u0080\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/audio/MusicController$MusicTrackInfo;", "", "mod", "", "track", "type", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getMod", "()Ljava/lang/String;", "getTrack", "getType", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "Companion", "core"})
    public static final class MusicTrackInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String mod;
        @NotNull
        private final String track;
        @NotNull
        private final String type;

        public MusicTrackInfo(@NotNull String mod, @NotNull String track, @NotNull String type) {
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(track, "track");
            Intrinsics.checkNotNullParameter(type, "type");
            this.mod = mod;
            this.track = track;
            this.type = type;
        }

        @NotNull
        public final String getMod() {
            return this.mod;
        }

        @NotNull
        public final String getTrack() {
            return this.track;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public String toString() {
            return ((CharSequence)this.track).length() == 0 ? "\u2014Paused\u2014" : (((CharSequence)this.mod).length() == 0 ? this.track : this.mod + ": " + this.track);
        }

        @NotNull
        public final String component1() {
            return this.mod;
        }

        @NotNull
        public final String component2() {
            return this.track;
        }

        @NotNull
        public final String component3() {
            return this.type;
        }

        @NotNull
        public final MusicTrackInfo copy(@NotNull String mod, @NotNull String track, @NotNull String type) {
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(track, "track");
            Intrinsics.checkNotNullParameter(type, "type");
            return new MusicTrackInfo(mod, track, type);
        }

        public static /* synthetic */ MusicTrackInfo copy$default(MusicTrackInfo musicTrackInfo, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = musicTrackInfo.mod;
            }
            if ((n & 2) != 0) {
                string2 = musicTrackInfo.track;
            }
            if ((n & 4) != 0) {
                string3 = musicTrackInfo.type;
            }
            return musicTrackInfo.copy(string, string2, string3);
        }

        public int hashCode() {
            int result2 = this.mod.hashCode();
            result2 = result2 * 31 + this.track.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MusicTrackInfo)) {
                return false;
            }
            MusicTrackInfo musicTrackInfo = (MusicTrackInfo)other;
            if (!Intrinsics.areEqual(this.mod, musicTrackInfo.mod)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.track, musicTrackInfo.track)) {
                return false;
            }
            return Intrinsics.areEqual(this.type, musicTrackInfo.type);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/audio/MusicController$MusicTrackInfo$Companion;", "", "<init>", "()V", "parse", "Lcom/unciv/ui/audio/MusicController$MusicTrackInfo;", "fileName", "", "core"})
        @SourceDebugExtension(value={"SMAP\nMusicController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MusicController.kt\ncom/unciv/ui/audio/MusicController$MusicTrackInfo$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,689:1\n296#2,2:690\n*S KotlinDebug\n*F\n+ 1 MusicController.kt\ncom/unciv/ui/audio/MusicController$MusicTrackInfo$Companion\n*L\n96#1:690,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MusicTrackInfo parse(@NotNull String fileName) {
                String string;
                Object v0;
                String trackName;
                String modName;
                block3: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter(fileName, "fileName");
                    if (((CharSequence)fileName).length() == 0) {
                        return new MusicTrackInfo("", "", "");
                    }
                    char[] cArray = new char[]{'/'};
                    List fileNameParts = StringsKt.split$default((CharSequence)fileName, cArray, false, 0, 6, null);
                    modName = fileNameParts.size() > 1 && Intrinsics.areEqual(fileNameParts.get(0), MusicController.modPath) ? (String)fileNameParts.get(1) : "";
                    trackName = null;
                    trackName = (String)fileNameParts.get(fileNameParts.size() > 3 && Intrinsics.areEqual(fileNameParts.get(2), MusicController.musicPath) ? 3 : 1);
                    Iterable iterable = MusicController.Companion.getGdxSupportedFileExtensions();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default(trackName, '.' + it, false, 2, null)) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                if ((string = (String)v0) == null) {
                    string = "";
                }
                String type = string;
                trackName = StringsKt.removeSuffix(trackName, (CharSequence)('.' + type));
                return new MusicTrackInfo(modName, trackName, type);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ControllerState.values().length];
            try {
                nArray[ControllerState.Idle.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Playing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.PlaySingle.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Silence.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Shutdown.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Cleanup.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Pause.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.PauseOnShutdown.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

