/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.extensions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.models.UncivSound;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.popups.Popup;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J:\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0014\u0010\r\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0011\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0012\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0017\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0018\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0019\u00c0\u0006\u0003"}, d2={"Lcom/unciv/ui/components/extensions/MusicControls;", "", "addVolumeSlider", "", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "text", "", "initial", "", "silent", "", "onChange", "Lkotlin/Function1;", "addSoundEffectsVolumeSlider", "settings", "Lcom/unciv/models/metadata/GameSettings;", "addCitySoundsVolumeSlider", "addVoicesVolumeSlider", "addMusicVolumeSlider", "music", "Lcom/unciv/ui/audio/MusicController;", "addMusicPauseSlider", "addMusicCurrentlyPlaying", "addSimplePlayerControls", "addMusicControls", "core"})
public interface MusicControls {
    default public void addVolumeSlider(@NotNull Table $this$addVolumeSlider, @NotNull String text2, float initial, boolean silent, @NotNull Function1<? super Float, Unit> onChange) {
        Intrinsics.checkNotNullParameter($this$addVolumeSlider, "<this>");
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(onChange, "onChange");
        $this$addVolumeSlider.add(TranslationsKt.tr$default(text2, false, false, 3, null)).left().fillX();
        UncivSlider volumeSlider2 = new UncivSlider(0.0f, 1.0f, 0.05f, false, false, initial, silent ? UncivSound.Companion.getSilent() : UncivSound.Companion.getSlider(), null, new Function1<Float, String>((Object)UncivSlider.Companion){

            public final String invoke(float p0) {
                return ((UncivSlider.Companion)this.receiver).formatPercent(p0);
            }
        }, onChange, 152, null);
        $this$addVolumeSlider.add((Actor)volumeSlider2).pad(5.0f).row();
    }

    public static /* synthetic */ void addVolumeSlider$default(MusicControls musicControls, Table table2, String string, float f, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addVolumeSlider");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        musicControls.addVolumeSlider(table2, string, f, bl, function1);
    }

    default public void addSoundEffectsVolumeSlider(@NotNull Table $this$addSoundEffectsVolumeSlider, @NotNull GameSettings settings) {
        Intrinsics.checkNotNullParameter($this$addSoundEffectsVolumeSlider, "<this>");
        Intrinsics.checkNotNullParameter(settings, "settings");
        MusicControls.addVolumeSlider$default(this, $this$addSoundEffectsVolumeSlider, "Sound effects volume", settings.getSoundEffectsVolume(), false, arg_0 -> MusicControls.addSoundEffectsVolumeSlider$lambda$0(settings, arg_0), 4, null);
    }

    default public void addCitySoundsVolumeSlider(@NotNull Table $this$addCitySoundsVolumeSlider, @NotNull GameSettings settings) {
        Intrinsics.checkNotNullParameter($this$addCitySoundsVolumeSlider, "<this>");
        Intrinsics.checkNotNullParameter(settings, "settings");
        MusicControls.addVolumeSlider$default(this, $this$addCitySoundsVolumeSlider, "City ambient sound volume", settings.getCitySoundsVolume(), false, arg_0 -> MusicControls.addCitySoundsVolumeSlider$lambda$0(settings, arg_0), 4, null);
    }

    default public void addVoicesVolumeSlider(@NotNull Table $this$addVoicesVolumeSlider, @NotNull GameSettings settings) {
        Intrinsics.checkNotNullParameter($this$addVoicesVolumeSlider, "<this>");
        Intrinsics.checkNotNullParameter(settings, "settings");
        MusicControls.addVolumeSlider$default(this, $this$addVoicesVolumeSlider, "Leader voices volume", settings.getVoicesVolume(), false, arg_0 -> MusicControls.addVoicesVolumeSlider$lambda$0(settings, arg_0), 4, null);
    }

    default public void addMusicVolumeSlider(@NotNull Table $this$addMusicVolumeSlider, @NotNull GameSettings settings, @NotNull MusicController music) {
        Intrinsics.checkNotNullParameter($this$addMusicVolumeSlider, "<this>");
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(music, "music");
        this.addVolumeSlider($this$addMusicVolumeSlider, TranslationsKt.tr$default("Music volume", false, false, 3, null), settings.getMusicVolume(), true, arg_0 -> MusicControls.addMusicVolumeSlider$lambda$0(settings, music, arg_0));
    }

    default public void addMusicPauseSlider(@NotNull Table $this$addMusicPauseSlider, @NotNull GameSettings settings, @NotNull MusicController music) {
        Intrinsics.checkNotNullParameter($this$addMusicPauseSlider, "<this>");
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(music, "music");
        Function1<Float, String> getTipText = MusicControls::addMusicPauseSlider$lambda$0;
        $this$addMusicPauseSlider.add(TranslationsKt.tr$default("Pause between tracks", false, false, 3, null)).left().fillX();
        UncivSlider pauseLengthSlider = new UncivSlider(0.0f, 30.0f, 1.0f, false, false, MusicControls.addMusicPauseSlider$lengthToPos(music.getSilenceLength()), UncivSound.Companion.getSilent(), null, getTipText, arg_0 -> MusicControls.addMusicPauseSlider$lambda$1(music, settings, arg_0), 152, null);
        $this$addMusicPauseSlider.add((Actor)pauseLengthSlider).pad(5.0f).row();
    }

    default public void addMusicCurrentlyPlaying(@NotNull Table $this$addMusicCurrentlyPlaying, @NotNull MusicController music) {
        block0: {
            Intrinsics.checkNotNullParameter($this$addMusicCurrentlyPlaying, "<this>");
            Intrinsics.checkNotNullParameter(music, "music");
            WrappableLabel label = new WrappableLabel("", $this$addMusicCurrentlyPlaying.getWidth() - 10.0f, new Color(-3100673), 16, false, 16, null);
            label.setWrap(true);
            $this$addMusicCurrentlyPlaying.add((Actor)label).padTop(20.0f).colspan(2).fillX().row();
            music.onChange(arg_0 -> MusicControls.addMusicCurrentlyPlaying$lambda$0(label, arg_0));
            Popup popup2 = $this$addMusicCurrentlyPlaying.firstAscendant(Popup.class);
            if (popup2 == null) break block0;
            Popup $this$addMusicCurrentlyPlaying_u24lambda_u241 = popup2;
            boolean bl = false;
            $this$addMusicCurrentlyPlaying_u24lambda_u241.getCloseListeners().add(() -> MusicControls.addMusicCurrentlyPlaying$lambda$1$0(music));
        }
    }

    /*
     * WARNING - void declaration
     */
    default public void addSimplePlayerControls(@NotNull Table $this$addSimplePlayerControls, @NotNull MusicController music) {
        void $this$addSimplePlayerControls_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter($this$addSimplePlayerControls, "<this>");
        Intrinsics.checkNotNullParameter(music, "music");
        Table table3 = table2 = new Table();
        Table table4 = $this$addSimplePlayerControls;
        boolean bl = false;
        $this$addSimplePlayerControls_u24lambda_u240.defaults().space(25.0f);
        Color color = Color.GOLD;
        Intrinsics.checkNotNullExpressionValue(color, "GOLD");
        $this$addSimplePlayerControls_u24lambda_u240.add(ActivationExtensionsKt.onClick(MusicControls.addSimplePlayerControls$toImageButton("OtherIcons/Pause", color), () -> MusicControls.addSimplePlayerControls$lambda$0$0(music)));
        Color color2 = Color.LIME;
        Intrinsics.checkNotNullExpressionValue(color2, "LIME");
        $this$addSimplePlayerControls_u24lambda_u240.add(ActivationExtensionsKt.onClick(MusicControls.addSimplePlayerControls$toImageButton("OtherIcons/ForwardArrow", color2), () -> MusicControls.addSimplePlayerControls$lambda$0$1(music)));
        Color color3 = Color.VIOLET;
        Intrinsics.checkNotNullExpressionValue(color3, "VIOLET");
        $this$addSimplePlayerControls_u24lambda_u240.add(ActivationExtensionsKt.onClick(MusicControls.addSimplePlayerControls$toImageButton("OtherIcons/Loading", color3), () -> MusicControls.addSimplePlayerControls$lambda$0$2(music)));
        table4.add((Actor)table2).colspan(2).center().row();
    }

    default public void addMusicControls(@NotNull Table $this$addMusicControls, @NotNull GameSettings settings, @NotNull MusicController music) {
        Intrinsics.checkNotNullParameter($this$addMusicControls, "<this>");
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(music, "music");
        this.addMusicVolumeSlider($this$addMusicControls, settings, music);
        this.addMusicPauseSlider($this$addMusicControls, settings, music);
        this.addMusicCurrentlyPlaying($this$addMusicControls, music);
        this.addSimplePlayerControls($this$addMusicControls, music);
    }

    private static Unit addSoundEffectsVolumeSlider$lambda$0(GameSettings $settings, float it) {
        $settings.setSoundEffectsVolume(it);
        return Unit.INSTANCE;
    }

    private static Unit addCitySoundsVolumeSlider$lambda$0(GameSettings $settings, float it) {
        $settings.setCitySoundsVolume(it);
        return Unit.INSTANCE;
    }

    private static Unit addVoicesVolumeSlider$lambda$0(GameSettings $settings, float it) {
        $settings.setVoicesVolume(it);
        return Unit.INSTANCE;
    }

    private static Unit addMusicVolumeSlider$lambda$0(GameSettings $settings, MusicController $music, float it) {
        $settings.setMusicVolume(it);
        $music.setVolume(it);
        if (!$music.isPlaying()) {
            MusicController.chooseTrack$default($music, null, null, MusicTrackChooserFlags.Companion.getSetPlayDefault(), 3, null);
        }
        return Unit.INSTANCE;
    }

    private static float addMusicPauseSlider$posToLength(float pos) {
        float f;
        block1: {
            float f2;
            block0: {
                f2 = pos;
                boolean bl = 0.0f <= f2 ? f2 <= 10.0f : false;
                if (!bl) break block0;
                f = pos;
                break block1;
            }
            f = (11.0f <= f2 ? f2 <= 20.0f : false) ? pos * 2.0f - 10.0f : ((21.0f <= f2 ? f2 <= 26.0f : false) ? pos * 5.0f - 70.0f : pos * 15.0f - 330.0f);
        }
        return f;
    }

    private static float addMusicPauseSlider$lengthToPos(float length) {
        float f;
        block1: {
            float f2;
            block0: {
                f2 = length;
                boolean bl = 0.0f <= f2 ? f2 <= 10.0f : false;
                if (!bl) break block0;
                f = length;
                break block1;
            }
            f = (11.0f <= f2 ? f2 <= 30.0f : false) ? (length + 10.0f) / 2.0f : ((31.0f <= f2 ? f2 <= 60.0f : false) ? (length + 10.0f) / 5.0f : (length + 330.0f) / 15.0f);
        }
        return (float)Math.floor(f);
    }

    private static String addMusicPauseSlider$lambda$0(float it) {
        String string = "%.0f";
        Object[] objectArray = new Object[]{Float.valueOf(MusicControls.addMusicPauseSlider$posToLength(it))};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static Unit addMusicPauseSlider$lambda$1(MusicController $music, GameSettings $settings, float it) {
        $music.setSilenceLength(MusicControls.addMusicPauseSlider$posToLength(it));
        $settings.setPauseBetweenTracks((int)$music.getSilenceLength());
        return Unit.INSTANCE;
    }

    private static Unit addMusicCurrentlyPlaying$lambda$1$0(MusicController $music) {
        $music.onChange(null);
        return Unit.INSTANCE;
    }

    private static Unit addMusicCurrentlyPlaying$lambda$0(WrappableLabel $label, MusicController.MusicTrackInfo it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $label.setText(TranslationsKt.tr$default("Currently playing: [" + it + ']', false, false, 3, null));
        return Unit.INSTANCE;
    }

    private static Unit addSimplePlayerControls$lambda$0$0(MusicController $music) {
        MusicController.pause$default($music, 0.5f, false, 2, null);
        return Unit.INSTANCE;
    }

    private static Unit addSimplePlayerControls$lambda$0$1(MusicController $music) {
        $music.resume(0.5f);
        return Unit.INSTANCE;
    }

    private static Unit addSimplePlayerControls$lambda$0$2(MusicController $music) {
        MusicController.chooseTrack$default($music, null, null, MusicTrackChooserFlags.Companion.getNone(), 3, null);
        return Unit.INSTANCE;
    }

    private static Group addSimplePlayerControls$toImageButton(String $this$addSimplePlayerControls_u24toImageButton, Color overColor) {
        Color color = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
        return Scene2dExtensionsKt.toImageButton($this$addSimplePlayerControls_u24toImageButton, 30.0f, 30.0f, color, overColor);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static void addVolumeSlider(@NotNull MusicControls $this, @NotNull Table $receiver, @NotNull String text2, float initial, boolean silent, @NotNull Function1<? super Float, Unit> onChange) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(text2, "text");
            Intrinsics.checkNotNullParameter(onChange, "onChange");
            $this.addVolumeSlider($receiver, text2, initial, silent, onChange);
        }

        public static /* synthetic */ void addVolumeSlider$default(MusicControls musicControls, Table table2, String string, float f, boolean bl, Function1 function1, int n, Object object) {
            MusicControls.addVolumeSlider$default(musicControls, table2, string, f, bl, function1, n, object);
        }

        @Deprecated
        public static void addSoundEffectsVolumeSlider(@NotNull MusicControls $this, @NotNull Table $receiver, @NotNull GameSettings settings) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(settings, "settings");
            $this.addSoundEffectsVolumeSlider($receiver, settings);
        }

        @Deprecated
        public static void addCitySoundsVolumeSlider(@NotNull MusicControls $this, @NotNull Table $receiver, @NotNull GameSettings settings) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(settings, "settings");
            $this.addCitySoundsVolumeSlider($receiver, settings);
        }

        @Deprecated
        public static void addVoicesVolumeSlider(@NotNull MusicControls $this, @NotNull Table $receiver, @NotNull GameSettings settings) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(settings, "settings");
            $this.addVoicesVolumeSlider($receiver, settings);
        }

        @Deprecated
        public static void addMusicVolumeSlider(@NotNull MusicControls $this, @NotNull Table $receiver, @NotNull GameSettings settings, @NotNull MusicController music) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(settings, "settings");
            Intrinsics.checkNotNullParameter(music, "music");
            $this.addMusicVolumeSlider($receiver, settings, music);
        }

        @Deprecated
        public static void addMusicPauseSlider(@NotNull MusicControls $this, @NotNull Table $receiver, @NotNull GameSettings settings, @NotNull MusicController music) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(settings, "settings");
            Intrinsics.checkNotNullParameter(music, "music");
            $this.addMusicPauseSlider($receiver, settings, music);
        }

        @Deprecated
        public static void addMusicCurrentlyPlaying(@NotNull MusicControls $this, @NotNull Table $receiver, @NotNull MusicController music) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(music, "music");
            $this.addMusicCurrentlyPlaying($receiver, music);
        }

        @Deprecated
        public static void addSimplePlayerControls(@NotNull MusicControls $this, @NotNull Table $receiver, @NotNull MusicController music) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(music, "music");
            $this.addSimplePlayerControls($receiver, music);
        }

        @Deprecated
        public static void addMusicControls(@NotNull MusicControls $this, @NotNull Table $receiver, @NotNull GameSettings settings, @NotNull MusicController music) {
            Intrinsics.checkNotNullParameter($receiver, "$receiver");
            Intrinsics.checkNotNullParameter(settings, "settings");
            Intrinsics.checkNotNullParameter(music, "music");
            $this.addMusicControls($receiver, settings, music);
        }
    }
}

