/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.input;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.unciv.models.UncivSound;
import com.unciv.ui.components.input.ActivationActionMap;
import com.unciv.ui.components.input.ActivationListener;
import com.unciv.ui.components.input.ActivationTypes;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J4\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00112\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00150\u001aj\u0002`\u001bJ\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0018\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/unciv/ui/components/input/ActorAttachments;", "", "actor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/Actor;)V", "getActor", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "activationActions", "Lcom/unciv/ui/components/input/ActivationActionMap;", "activationListener", "Lcom/unciv/ui/components/input/ActivationListener;", "keyShortcuts", "Lcom/unciv/ui/components/input/ActorKeyShortcutDispatcher;", "getKeyShortcuts", "()Lcom/unciv/ui/components/input/ActorKeyShortcutDispatcher;", "activate", "", "type", "Lcom/unciv/ui/components/input/ActivationTypes;", "addActivationAction", "", "sound", "Lcom/unciv/models/UncivSound;", "noEquivalence", "action", "Lkotlin/Function0;", "Lcom/unciv/ui/components/input/ActivationAction;", "clearActivationActions", "Companion", "core"})
public final class ActorAttachments {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ActivationActionMap activationActions;
    @Nullable
    private ActivationListener activationListener;
    @NotNull
    private final ActorKeyShortcutDispatcher keyShortcuts;

    private ActorAttachments(Actor actor) {
        this.keyShortcuts = new ActorKeyShortcutDispatcher(actor);
    }

    @NotNull
    public final Actor getActor() {
        return this.keyShortcuts.getActor();
    }

    @NotNull
    public final ActorKeyShortcutDispatcher getKeyShortcuts() {
        return this.keyShortcuts;
    }

    public final boolean activate(@NotNull ActivationTypes type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        if (this.activationActions == null) {
            return false;
        }
        Actor actor = this.getActor();
        Disableable disableable = actor instanceof Disableable ? (Disableable)((Object)actor) : null;
        boolean bl = disableable != null ? disableable.isDisabled() : false;
        if (bl) {
            return false;
        }
        ActivationActionMap activationActionMap = this.activationActions;
        if (activationActionMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activationActions");
            activationActionMap = null;
        }
        return activationActionMap.activate(type);
    }

    public final void addActivationAction(@NotNull ActivationTypes type, @NotNull UncivSound sound, boolean noEquivalence, @NotNull Function0<Unit> action2) {
        ActivationActionMap activationActionMap;
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(sound, "sound");
        Intrinsics.checkNotNullParameter(action2, "action");
        if (this.activationActions == null) {
            this.activationActions = new ActivationActionMap();
        } else if (this.activationListener != null) {
            DelayedRemovalArray<EventListener> delayedRemovalArray = this.getActor().getListeners();
            Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "getListeners(...)");
            if (!CollectionsKt.contains((Iterable)delayedRemovalArray, this.activationListener)) {
                this.getActor().addListener(this.activationListener);
                ActivationActionMap activationActionMap2 = this.activationActions;
                if (activationActionMap2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("activationActions");
                    activationActionMap2 = null;
                }
                activationActionMap2.clearGestures();
            }
        }
        if ((activationActionMap = this.activationActions) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activationActions");
            activationActionMap = null;
        }
        activationActionMap.add(type, sound, noEquivalence, action2);
        if (!type.isGesture$core() || this.activationListener != null) {
            return;
        }
        this.activationListener = new ActivationListener();
        this.getActor().addListener(this.activationListener);
    }

    public static /* synthetic */ void addActivationAction$default(ActorAttachments actorAttachments, ActivationTypes activationTypes, UncivSound uncivSound, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            uncivSound = UncivSound.Companion.getClick();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        actorAttachments.addActivationAction(activationTypes, uncivSound, bl, function0);
    }

    public final void clearActivationActions(@NotNull ActivationTypes type, boolean noEquivalence) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)type, "type");
                if (this.activationActions == null) {
                    return;
                }
                ActivationActionMap activationActionMap = this.activationActions;
                if (activationActionMap == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("activationActions");
                    activationActionMap = null;
                }
                activationActionMap.clear(type, noEquivalence);
                if (this.activationListener == null) break block6;
                ActivationActionMap activationActionMap2 = this.activationActions;
                if (activationActionMap2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("activationActions");
                    activationActionMap2 = null;
                }
                if (!activationActionMap2.isNotEmpty()) break block7;
            }
            return;
        }
        this.getActor().removeListener(this.activationListener);
        this.activationListener = null;
    }

    public static /* synthetic */ void clearActivationActions$default(ActorAttachments actorAttachments, ActivationTypes activationTypes, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        actorAttachments.clearActivationActions(activationTypes, bl);
    }

    public /* synthetic */ ActorAttachments(Actor actor, DefaultConstructorMarker $constructor_marker) {
        this(actor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/components/input/ActorAttachments$Companion;", "", "<init>", "()V", "getOrNull", "Lcom/unciv/ui/components/input/ActorAttachments;", "actor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "get", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ActorAttachments getOrNull(@NotNull Actor actor) {
            Intrinsics.checkNotNullParameter(actor, "actor");
            return (ActorAttachments)actor.getUserObject();
        }

        @NotNull
        public final ActorAttachments get(@NotNull Actor actor) {
            Intrinsics.checkNotNullParameter(actor, "actor");
            if (actor.getUserObject() == null) {
                actor.setUserObject(new ActorAttachments(actor, null));
            }
            ActorAttachments actorAttachments = this.getOrNull(actor);
            Intrinsics.checkNotNull(actorAttachments);
            return actorAttachments;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

