/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ImmutableColor;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.images.ImageGetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0006\u0010\u001c\u001a\u00020\tJ\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u0019*\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u0019*\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\b\u0010 \u001a\u00020\tH\u0002J\u001a\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\u00162\u0006\u0010#\u001a\u00020$H\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerBorders;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "<init>", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "act", "", "delta", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "previousTileOwner", "Lcom/unciv/logic/civilization/Civilization;", "borderSegments", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerBorders$BorderSegment;", "Lkotlin/collections/HashMap;", "reset", "getLeftSharedNeighbor", "neighbor", "getRightSharedNeighbor", "updateBorders", "doUpdate", "viewingCiv", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "BorderSegment", "core"})
public final class TileLayerBorders
extends TileLayer {
    @Nullable
    private Civilization previousTileOwner;
    @NotNull
    private final HashMap<Tile, BorderSegment> borderSegments;

    public TileLayerBorders(@NotNull TileGroup tileGroup, float size) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size);
        this.borderSegments = new HashMap();
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return null;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    public final void reset() {
        if (!((Map)this.borderSegments).isEmpty()) {
            Iterator<BorderSegment> iterator2 = this.borderSegments.values().iterator();
            while (iterator2.hasNext()) {
                BorderSegment borderSegment;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                for (Image image : borderSegment.getImages()) {
                    image.remove();
                }
            }
            this.borderSegments.clear();
        }
    }

    private final Tile getLeftSharedNeighbor(Tile $this$getLeftSharedNeighbor, Tile neighbor) {
        return $this$getLeftSharedNeighbor.getTileMap().getClockPositionNeighborTile($this$getLeftSharedNeighbor, ($this$getLeftSharedNeighbor.getTileMap().getNeighborTileClockPosition($this$getLeftSharedNeighbor, neighbor) - 2) % 12);
    }

    private final Tile getRightSharedNeighbor(Tile $this$getRightSharedNeighbor, Tile neighbor) {
        return $this$getRightSharedNeighbor.getTileMap().getClockPositionNeighborTile($this$getRightSharedNeighbor, ($this$getRightSharedNeighbor.getTileMap().getNeighborTileClockPosition($this$getRightSharedNeighbor, neighbor) + 2) % 12);
    }

    private final void updateBorders() {
        Tile tile = this.getTileGroup().getTile();
        Civilization tileOwner = tile.getOwner();
        if (!Intrinsics.areEqual(this.previousTileOwner, tileOwner)) {
            this.reset();
        }
        this.previousTileOwner = tileOwner;
        if (tileOwner == null) {
            return;
        }
        Civilization civilization = tile.getOwner();
        Intrinsics.checkNotNull(civilization);
        ImmutableColor civOuterColor = civilization.getNation().getOuterColor();
        Civilization civilization2 = tile.getOwner();
        Intrinsics.checkNotNull(civilization2);
        ImmutableColor civInnerColor = civilization2.getNation().getInnerColor();
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            String string;
            boolean borderSegmentShouldBeRightConcave;
            boolean borderSegmentShouldBeLeftConcave;
            boolean shouldAddBorderSegment;
            boolean shouldRemoveBorderSegment;
            Tile neighbor;
            block17: {
                block19: {
                    block18: {
                        Civilization neighborOwner;
                        block16: {
                            neighbor = iterator2.next();
                            shouldRemoveBorderSegment = false;
                            shouldAddBorderSegment = false;
                            borderSegmentShouldBeLeftConcave = false;
                            borderSegmentShouldBeRightConcave = false;
                            neighborOwner = neighbor.getOwner();
                            if (!Intrinsics.areEqual(neighborOwner, tileOwner) || !this.borderSegments.containsKey(neighbor)) break block16;
                            shouldRemoveBorderSegment = true;
                            break block17;
                        }
                        if (Intrinsics.areEqual(neighborOwner, tileOwner)) break block17;
                        Tile leftSharedNeighbor = this.getLeftSharedNeighbor(tile, neighbor);
                        Tile rightSharedNeighbor = this.getRightSharedNeighbor(tile, neighbor);
                        borderSegmentShouldBeLeftConcave = leftSharedNeighbor == null || Intrinsics.areEqual(leftSharedNeighbor.getOwner(), tileOwner);
                        boolean bl = borderSegmentShouldBeRightConcave = rightSharedNeighbor == null || Intrinsics.areEqual(rightSharedNeighbor.getOwner(), tileOwner);
                        if (this.borderSegments.containsKey(neighbor)) break block18;
                        shouldAddBorderSegment = true;
                        break block17;
                    }
                    BorderSegment borderSegment = this.borderSegments.get(neighbor);
                    Intrinsics.checkNotNull(borderSegment);
                    if (borderSegmentShouldBeLeftConcave != borderSegment.isLeftConcave()) break block19;
                    BorderSegment borderSegment2 = this.borderSegments.get(neighbor);
                    Intrinsics.checkNotNull(borderSegment2);
                    if (borderSegmentShouldBeRightConcave == borderSegment2.isRightConcave()) break block17;
                }
                shouldRemoveBorderSegment = true;
                shouldAddBorderSegment = true;
            }
            if (shouldRemoveBorderSegment) {
                BorderSegment borderSegment = this.borderSegments.get(neighbor);
                Intrinsics.checkNotNull(borderSegment);
                for (Image image : borderSegment.getImages()) {
                    image.remove();
                }
                this.borderSegments.remove(neighbor);
            }
            if (!shouldAddBorderSegment) continue;
            List images2 = new ArrayList();
            BorderSegment borderSegment = new BorderSegment(images2, borderSegmentShouldBeLeftConcave, borderSegmentShouldBeRightConcave);
            ((Map)this.borderSegments).put(neighbor, borderSegment);
            if (borderSegment.isLeftConcave() && borderSegment.isRightConcave()) {
                string = "Concave";
            } else if (!borderSegment.isLeftConcave() && !borderSegment.isRightConcave()) {
                string = "Convex";
            } else if (!borderSegment.isLeftConcave() && borderSegment.isRightConcave()) {
                string = "ConvexConcave";
            } else if (borderSegment.isLeftConcave() && !borderSegment.isRightConcave()) {
                string = "ConcaveConvex";
            } else {
                throw new IllegalStateException("This shouldn't happen?".toString());
            }
            String borderShapeString = string;
            Vector2 relativeWorldPosition = tile.getTileMap().getNeighborTilePositionAsWorldCoords(tile, neighbor);
            int sign = relativeWorldPosition.x < 0.0f ? -1 : 1;
            float angle = (float)sign * (float)((double)((float)Math.atan((float)sign * relativeWorldPosition.y / relativeWorldPosition.x) * (float)180) / Math.PI - 90.0);
            Image innerBorderImage = TileLayer.setHexagonSize$default(this, ImageGetter.getImage$default(ImageGetter.INSTANCE, this.getStrings().orFallback(arg_0 -> TileLayerBorders.updateBorders$lambda$0(borderShapeString, arg_0)), null, 2, null), null, 1, null);
            this.addActor(innerBorderImage);
            images2.add(innerBorderImage);
            innerBorderImage.rotateBy(angle);
            innerBorderImage.setColor(civOuterColor);
            Image outerBorderImage = TileLayer.setHexagonSize$default(this, ImageGetter.getImage$default(ImageGetter.INSTANCE, this.getStrings().orFallback(arg_0 -> TileLayerBorders.updateBorders$lambda$1(borderShapeString, arg_0)), null, 2, null), null, 1, null);
            this.addActor(outerBorderImage);
            images2.add(outerBorderImage);
            outerBorderImage.rotateBy(angle);
            outerBorderImage.setColor(civInnerColor);
        }
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.updateBorders();
    }

    private static final String updateBorders$lambda$0(String $borderShapeString, TileSetStrings $this$orFallback) {
        Intrinsics.checkNotNullParameter($this$orFallback, "$this$orFallback");
        return $this$orFallback.getBorder($borderShapeString, "Inner");
    }

    private static final String updateBorders$lambda$1(String $borderShapeString, TileSetStrings $this$orFallback) {
        Intrinsics.checkNotNullParameter($this$orFallback, "$this$orFallback");
        return $this$orFallback.getBorder($borderShapeString, "Outer");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004J\n\u0010\u001a\u001a\u00020\u001bH\u00d6\u0081\u0004R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\u000e\"\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerBorders$BorderSegment;", "", "images", "", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "isLeftConcave", "", "isRightConcave", "<init>", "(Ljava/util/List;ZZ)V", "getImages", "()Ljava/util/List;", "setImages", "(Ljava/util/List;)V", "()Z", "setLeftConcave", "(Z)V", "setRightConcave", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "core"})
    public static final class BorderSegment {
        @NotNull
        private List<? extends Image> images;
        private boolean isLeftConcave;
        private boolean isRightConcave;

        public BorderSegment(@NotNull List<? extends Image> images2, boolean isLeftConcave, boolean isRightConcave) {
            Intrinsics.checkNotNullParameter(images2, "images");
            this.images = images2;
            this.isLeftConcave = isLeftConcave;
            this.isRightConcave = isRightConcave;
        }

        public /* synthetic */ BorderSegment(List list2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(list2, bl, bl2);
        }

        @NotNull
        public final List<Image> getImages() {
            return this.images;
        }

        public final void setImages(@NotNull List<? extends Image> list2) {
            Intrinsics.checkNotNullParameter(list2, "<set-?>");
            this.images = list2;
        }

        public final boolean isLeftConcave() {
            return this.isLeftConcave;
        }

        public final void setLeftConcave(boolean bl) {
            this.isLeftConcave = bl;
        }

        public final boolean isRightConcave() {
            return this.isRightConcave;
        }

        public final void setRightConcave(boolean bl) {
            this.isRightConcave = bl;
        }

        @NotNull
        public final List<Image> component1() {
            return this.images;
        }

        public final boolean component2() {
            return this.isLeftConcave;
        }

        public final boolean component3() {
            return this.isRightConcave;
        }

        @NotNull
        public final BorderSegment copy(@NotNull List<? extends Image> images2, boolean isLeftConcave, boolean isRightConcave) {
            Intrinsics.checkNotNullParameter(images2, "images");
            return new BorderSegment(images2, isLeftConcave, isRightConcave);
        }

        public static /* synthetic */ BorderSegment copy$default(BorderSegment borderSegment, List list2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = borderSegment.images;
            }
            if ((n & 2) != 0) {
                bl = borderSegment.isLeftConcave;
            }
            if ((n & 4) != 0) {
                bl2 = borderSegment.isRightConcave;
            }
            return borderSegment.copy(list2, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "BorderSegment(images=" + this.images + ", isLeftConcave=" + this.isLeftConcave + ", isRightConcave=" + this.isRightConcave + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.images).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isLeftConcave);
            result2 = result2 * 31 + Boolean.hashCode(this.isRightConcave);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BorderSegment)) {
                return false;
            }
            BorderSegment borderSegment = (BorderSegment)other;
            if (!Intrinsics.areEqual(this.images, borderSegment.images)) {
                return false;
            }
            if (this.isLeftConcave != borderSegment.isLeftConcave) {
                return false;
            }
            return this.isRightConcave == borderSegment.isRightConcave;
        }
    }
}

