/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0014J\u0006\u0010\u001b\u001a\u00020\u0010R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerImprovement;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "<init>", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "improvementPlusPillagedID", "", "value", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "improvementIcon", "getImprovementIcon", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "doUpdate", "", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "dimImprovement", "dim", "", "updateImprovementIcon", "show", "determineVisibility", "reset", "core"})
public final class TileLayerImprovement
extends TileLayer {
    @Nullable
    private String improvementPlusPillagedID;
    @Nullable
    private Actor improvementIcon;

    public TileLayerImprovement(@NotNull TileGroup tileGroup, float size) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size);
    }

    @Nullable
    public final Actor getImprovementIcon() {
        return this.improvementIcon;
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        boolean showResourcesAndImprovements = this.getTileGroup() instanceof WorldTileGroup ? UncivGame.Companion.getCurrent().getSettings().getShowResourcesAndImprovements() : true;
        this.updateImprovementIcon(viewingCiv, showResourcesAndImprovements);
    }

    public final void dimImprovement(boolean dim) {
        block0: {
            Object object = this.improvementIcon;
            if (object == null || (object = ((Actor)object).getColor()) == null) break block0;
            ((Color)object).a = dim ? 0.5f : 1.0f;
        }
    }

    private final void updateImprovementIcon(Civilization viewingCiv, boolean show) {
        block3: {
            String newImprovementPlusPillagedID;
            String improvementToShow = this.getTile().getShownImprovement(viewingCiv);
            String string = improvementToShow == null ? null : (newImprovementPlusPillagedID = this.getTile().getImprovementIsPillaged() ? improvementToShow + "-Pillaged" : improvementToShow);
            if (!Intrinsics.areEqual(this.improvementPlusPillagedID, newImprovementPlusPillagedID)) {
                this.improvementPlusPillagedID = newImprovementPlusPillagedID;
                Actor actor = this.improvementIcon;
                if (actor != null) {
                    actor.remove();
                }
                this.improvementIcon = null;
            }
            if (this.improvementPlusPillagedID != null && show && this.improvementIcon == null) {
                String string2 = improvementToShow;
                Intrinsics.checkNotNull(string2);
                Portrait icon = ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, string2, 0.0f, this.getTile().getImprovementIsPillaged(), 2, null);
                Scene2dExtensionsKt.center((Actor)icon, this.getTileGroup());
                icon.setX(icon.getX() - (float)22);
                icon.setY(icon.getY() - (float)12);
                this.addActor(icon);
                this.improvementIcon = icon;
            }
            Actor actor = this.improvementIcon;
            if (actor == null) break block3;
            actor.setVisible(show);
        }
    }

    @Override
    protected void determineVisibility() {
        Actor actor = this.improvementIcon;
        this.setVisible(actor != null ? actor.isVisible() : false);
    }

    public final void reset() {
        this.updateImprovementIcon(null, false);
    }
}

