/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.unciv.json.UncivJsonKt;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.utils.Log;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0002J\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0096\u0082\u0004J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u001a\u001a\n \u001b*\u0004\u0018\u00010\u00130\u0013*\u00020\u0004H\u0002J\u0014\u0010\u001c\u001a\u00020\u0002*\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/unciv/ui/images/AtlasPreview;", "", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "errorList", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;Lcom/unciv/models/ruleset/validation/RulesetErrorList;)V", "regionNames", "", "loadComplexRuleset", "", "loadSingleRuleset", "getFileNames", "", "controlFileExists", "", "controlFile", "Lcom/badlogic/gdx/files/FileHandle;", "(ZLcom/badlogic/gdx/files/FileHandle;Lcom/unciv/models/ruleset/validation/RulesetErrorList;)[Ljava/lang/String;", "imageExists", "name", "iterator", "", "logMissingAtlas", "folder", "kotlin.jvm.PlatformType", "relativePath", "Ljava/io/File;", "core"})
@SourceDebugExtension(value={"SMAP\nAtlasPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtlasPreview.kt\ncom/unciv/ui/images/AtlasPreview\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1661#2,3:122\n*S KotlinDebug\n*F\n+ 1 AtlasPreview.kt\ncom/unciv/ui/images/AtlasPreview\n*L\n68#1:122,3\n*E\n"})
public final class AtlasPreview
implements Iterable<String>,
KMappedMarker {
    @NotNull
    private final Set<String> regionNames;

    public AtlasPreview(@NotNull Ruleset ruleset, @NotNull RulesetErrorList errorList) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(errorList, "errorList");
        this.regionNames = new LinkedHashSet();
        if (((CharSequence)ruleset.getName()).length() > 0) {
            this.loadSingleRuleset(ruleset, errorList);
        } else {
            this.loadComplexRuleset(ruleset, errorList);
        }
        Log.INSTANCE.debug("Atlas preview for " + ruleset + ": " + this.regionNames.size() + " entries.", new Object[0]);
    }

    private final void loadComplexRuleset(Ruleset ruleset, RulesetErrorList errorList) {
        Iterator iterator2 = ruleset.getMods().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Ruleset componentRuleset;
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            String modName = (String)e;
            if ((Ruleset)RulesetCache.INSTANCE.get((Object)modName) == null) continue;
            this.loadSingleRuleset(componentRuleset, errorList);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadSingleRuleset(Ruleset ruleset, RulesetErrorList errorList) {
        boolean backwardsCompatibility;
        FileHandle folder = this.folder(ruleset);
        FileHandle controlFile = folder.child("Atlases.json");
        boolean controlFileExists = controlFile.exists();
        Set<String> fileNames = ArraysKt.toMutableSet(this.getFileNames(controlFileExists, controlFile, errorList));
        boolean bl = backwardsCompatibility = ((CharSequence)ruleset.getName()).length() > 0 && !fileNames.contains("game");
        if (backwardsCompatibility) {
            ((Collection)fileNames).add("game");
        }
        Iterator<String> iterator2 = fileNames.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv;
            String fileName;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            FileHandle file = folder.child(fileName + ".atlas");
            if (!file.exists()) {
                if (!controlFileExists || Intrinsics.areEqual(fileName, "game") && backwardsCompatibility) continue;
                this.logMissingAtlas(fileName, ruleset, errorList);
                continue;
            }
            TextureAtlas.TextureAtlasData data = new TextureAtlas.TextureAtlasData(file, file.parent(), false);
            if (data.getRegions().isEmpty()) {
                RulesetErrorList.add$default(errorList, file.name() + " contains no textures", null, null, null, 14, null);
            }
            Array<TextureAtlas.TextureAtlasData.Region> array = data.getRegions();
            Intrinsics.checkNotNullExpressionValue(array, "getRegions(...)");
            Iterable iterable = array;
            Collection destination$iv = this.regionNames;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                TextureAtlas.TextureAtlasData.Region region = (TextureAtlas.TextureAtlasData.Region)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                collection.add(it.name);
            }
        }
    }

    private final String[] getFileNames(boolean controlFileExists, FileHandle controlFile, RulesetErrorList errorList) {
        String[] fileNames;
        if (!controlFileExists) {
            return new String[0];
        }
        String[] stringArray = UncivJsonKt.json().fromJson(String[].class, controlFile);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if ((fileNames = stringArray).length == 0) {
            RulesetErrorList.add$default(errorList, "Atlases.json is empty", RulesetErrorSeverity.Warning, null, null, 12, null);
        }
        return fileNames;
    }

    public final boolean imageExists(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.regionNames.contains(name);
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.regionNames.iterator();
    }

    private final void logMissingAtlas(String name, Ruleset ruleset, RulesetErrorList errorList) {
        RulesetErrorList.add$default(errorList, "Atlases.json contains \"" + name + "\" but there is no corresponding atlas file.", null, null, null, 14, null);
        FileHandle imagesFolder = this.folder(ruleset).child(Intrinsics.areEqual(name, "game") ? "Images" : "Images." + name);
        if (!imagesFolder.exists() || !imagesFolder.isDirectory()) {
            return;
        }
        File file = imagesFolder.file();
        Intrinsics.checkNotNullExpressionValue(file, "file(...)");
        Iterator<File> iterator2 = FilesKt.walk$default(file, null, 1, null).iterator();
        while (iterator2.hasNext()) {
            File file2 = iterator2.next();
            if (file2.isDirectory() || file2.isHidden()) continue;
            if (!Intrinsics.areEqual(FilesKt.getExtension(file2), "png")) {
                RulesetErrorList.add$default(errorList, imagesFolder.name() + " contains " + this.relativePath(file2, ruleset) + " which does not have the png extension", RulesetErrorSeverity.WarningOptionsOnly, null, null, 12, null);
                continue;
            }
            try {
                byte[] bytes = FilesKt.readBytes(file2);
                Pixmap pixmap = new Pixmap(bytes, 0, bytes.length);
                pixmap.dispose();
            }
            catch (Throwable ex) {
                Throwable innerException = ex;
                while (innerException.getCause() != null && innerException.getCause() != innerException) {
                    Intrinsics.checkNotNull(innerException.getCause());
                }
                RulesetErrorList.add$default(errorList, "Cannot load " + this.relativePath(file2, ruleset) + ": " + innerException.getMessage(), null, null, null, 14, null);
            }
        }
    }

    private final FileHandle folder(Ruleset $this$folder) {
        FileHandle fileHandle = $this$folder.getFolderLocation();
        if (fileHandle == null) {
            fileHandle = Gdx.files.internal("");
        }
        return fileHandle;
    }

    private final String relativePath(File $this$relativePath, Ruleset ruleset) {
        String string = $this$relativePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        String string2 = this.folder(ruleset).file().getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        return StringsKt.removePrefix(StringsKt.removePrefix(string, (CharSequence)string2), (CharSequence)"/");
    }
}

