/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.objectdescriptions;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.NamedStats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.PortraitUnavailableWonderForTechTree;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\f*\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J4\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J(\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002J\u0014\u0010\"\u001a\u00020\u001f*\u00020#2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\f\u0010$\u001a\u00020\u001f*\u00020#H\u0002J\u0014\u0010%\u001a\u00020\u001f*\u00020#2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0011*\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006+"}, d2={"Lcom/unciv/ui/objectdescriptions/TechnologyDescriptions;", "", "<init>", "()V", "getDescription", "", "technology", "Lcom/unciv/models/ruleset/tech/Technology;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getTechEnabledIcons", "Lkotlin/sequences/Sequence;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "tech", "techIconSize", "", "getCivilopediaTextLines", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getEnabledBuildings", "Lcom/unciv/models/ruleset/Building;", "techName", "civInfo", "getObsoletedObjects", "Lcom/unciv/models/ruleset/RulesetStatsObject;", "getObsoletedIcon", "getFilteredBuildings", "predicate", "Lkotlin/Function1;", "", "getEnabledUnits", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "isImprovementStatsEnabledByTech", "Lcom/unciv/models/ruleset/unique/Unique;", "isTechConditional", "isRelatedToTech", "getAffectedImprovements", "Lcom/unciv/ui/objectdescriptions/TechnologyDescriptions$ImprovementAndUnique;", "getSeeAlsoObjects", "Lcom/unciv/models/ruleset/IRulesetObject;", "ImprovementAndUnique", "core"})
@SourceDebugExtension(value={"SMAP\nTechnologyDescriptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TechnologyDescriptions.kt\ncom/unciv/ui/objectdescriptions/TechnologyDescriptions\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,380:1\n2834#2,10:381\n2834#2,10:399\n1342#2,2:411\n1342#2,2:413\n1276#2,2:426\n1#3:391\n1915#4,2:392\n777#4:394\n873#4,2:395\n1915#4,2:397\n1915#4,2:409\n1915#4,2:415\n777#4:417\n873#4,2:418\n1807#4,3:420\n1807#4,3:423\n1807#4,3:428\n*S KotlinDebug\n*F\n+ 1 TechnologyDescriptions.kt\ncom/unciv/ui/objectdescriptions/TechnologyDescriptions\n*L\n57#1:381,10\n213#1:399,10\n242#1:411,2\n251#1:413,2\n292#1:426,2\n175#1:392,2\n181#1:394\n181#1:395,2\n188#1:397,2\n234#1:409,2\n260#1:415,2\n288#1:417\n288#1:418,2\n341#1:420,3\n350#1:423,3\n373#1:428,3\n*E\n"})
public final class TechnologyDescriptions {
    @NotNull
    public static final TechnologyDescriptions INSTANCE = new TechnologyDescriptions();

    private TechnologyDescriptions() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getDescription(@NotNull Technology technology, @NotNull Civilization viewingCiv) {
        Object obj;
        void $this$partition$iv;
        Sequence<Building> unit;
        Object object;
        Intrinsics.checkNotNullParameter(technology, "technology");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        Technology $this$getDescription_u24lambda_u240 = technology;
        boolean bl = false;
        Ruleset ruleset = viewingCiv.getGameInfo().getRuleset();
        ArrayList lineList = new ArrayList();
        for (FormattedLine pediaText : technology.getCivilopediaText()) {
            if (((CharSequence)pediaText.getText()).length() == 0 || pediaText.getHeader() != 0) continue;
            ((Collection)lineList).add(pediaText.getText());
        }
        DescriptionHelpersKt.uniquesToDescription$default($this$getDescription_u24lambda_u240, lineList, null, 2, null);
        CollectionsKt.addAll((Collection)lineList, SequencesKt.map(SequencesKt.filter(INSTANCE.getAffectedImprovements($this$getDescription_u24lambda_u240.getName(), ruleset), arg_0 -> TechnologyDescriptions.getDescription$lambda$0$0(viewingCiv, arg_0)), TechnologyDescriptions::getDescription$lambda$0$1));
        Sequence<BaseUnit> enabledUnits = INSTANCE.getEnabledUnits($this$getDescription_u24lambda_u240.getName(), ruleset, viewingCiv);
        if (SequencesKt.any(enabledUnits)) {
            ((Collection)lineList).add("{Units enabled}: ");
            object = enabledUnits.iterator();
            while (object.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(object.next(), "next(...)");
                ((Collection)lineList).add(" \u2022 " + TranslationsKt.tr$default(((RulesetObject)((Object)unit)).getName(), false, false, 3, null) + " (" + ((BaseUnit)((Object)unit)).getShortDescription(new Function1<Unique, Boolean>((Object)technology){

                    public final Boolean invoke(Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsRequirementForThisTech(p0);
                    }
                }) + ")\n");
            }
        }
        unit = INSTANCE.getEnabledBuildings($this$getDescription_u24lambda_u240.getName(), ruleset, viewingCiv);
        boolean $i$f$partition = false;
        Iterator<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Building it = (Building)element$iv;
            boolean bl2 = false;
            boolean bl3 = it.isAnyWonder() ? ((ArrayList)((Object)first$iv)).add(element$iv) : second$iv.add(element$iv);
        }
        object = new Pair(first$iv, second$iv);
        List wonders = (List)((Pair)object).component1();
        List regularBuildings = (List)((Pair)object).component2();
        if (!((Collection)regularBuildings).isEmpty()) {
            ((Collection)lineList).add("{Buildings enabled}: ");
            for (Object e : regularBuildings) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                Building building = (Building)e;
                ((Collection)lineList).add(" \u2022 " + TranslationsKt.tr$default(building.getName(), false, false, 3, null) + " (" + Building.getShortDescription$default(building, false, new Function1<Unique, Boolean>((Object)technology){

                    public final Boolean invoke(Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsNotRequirementForThisTech(p0);
                    }
                }, 1, null) + ")\n");
            }
        }
        if (!((Collection)wonders).isEmpty()) {
            ((Collection)lineList).add("{Wonders enabled}: ");
            for (Object object2 : wonders) {
                Intrinsics.checkNotNullExpressionValue(object2, "next(...)");
                Building wonder = (Building)object2;
                ((Collection)lineList).add(" \u2022 " + TranslationsKt.tr$default(wonder.getName(), false, false, 3, null) + " (" + Building.getShortDescription$default(wonder, false, new Function1<Unique, Boolean>((Object)technology){

                    public final Boolean invoke(Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsNotRequirementForThisTech(p0);
                    }
                }, 1, null) + ")\n");
            }
        }
        first$iv = INSTANCE.getObsoletedObjects($this$getDescription_u24lambda_u240.getName(), ruleset, viewingCiv).iterator();
        while (first$iv.hasNext()) {
            obj = (RulesetStatsObject)first$iv.next();
            ((Collection)lineList).add('[' + ((NamedStats)obj).getName() + "] obsoleted");
        }
        Collection<TileResource> collection = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Sequence<String> resourcesRevealed = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), arg_0 -> TechnologyDescriptions.getDescription$lambda$0$3($this$getDescription_u24lambda_u240, arg_0)), TechnologyDescriptions::getDescription$lambda$0$4);
        obj = resourcesRevealed.iterator();
        while (obj.hasNext()) {
            String resource = (String)obj.next();
            ((Collection)lineList).add("Reveals [" + resource + "] on the map");
        }
        Collection<TileImprovement> collection2 = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        List<TileImprovement> tileImprovements = SequencesKt.toList(SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), arg_0 -> TechnologyDescriptions.getDescription$lambda$0$5($this$getDescription_u24lambda_u240, arg_0)), arg_0 -> TechnologyDescriptions.getDescription$lambda$0$6(viewingCiv, arg_0)));
        if (!((Collection)tileImprovements).isEmpty()) {
            ((Collection)lineList).add("{Tile improvements enabled}: " + CollectionsKt.joinToString$default(tileImprovements, null, null, null, 0, null, TechnologyDescriptions::getDescription$lambda$0$7, 31, null));
        }
        return CollectionsKt.joinToString$default(lineList, "\n", null, null, 0, null, TechnologyDescriptions::getDescription$lambda$0$8, 30, null);
    }

    @NotNull
    public final Sequence<Group> getTechEnabledIcons(@NotNull Technology tech, @NotNull Civilization viewingCiv, float techIconSize) {
        Intrinsics.checkNotNullParameter(tech, "tech");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Group>, Continuation<? super Unit>, Object>(viewingCiv, tech, techIconSize, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Civilization $viewingCiv;
            final /* synthetic */ Technology $tech;
            final /* synthetic */ float $techIconSize;
            {
                this.$viewingCiv = $viewingCiv;
                this.$tech = $tech;
                this.$techIconSize = $techIconSize;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                block20: {
                    var2_2 = (SequenceScope)this.L$0;
                    var15_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            ruleset = this.$viewingCiv.getGameInfo().getRuleset();
                            techName = this.$tech.getName();
                            var5_6 /* !! */  = TechnologyDescriptions.access$getEnabledUnits(TechnologyDescriptions.INSTANCE, techName, ruleset, this.$viewingCiv).iterator();
lbl9:
                            // 3 sources

                            while (var5_6 /* !! */ .hasNext()) {
                                v0 = var5_6 /* !! */ .next();
                                Intrinsics.checkNotNullExpressionValue(v0, "next(...)");
                                unit = (BaseUnit)v0;
                                this.L$0 = $this$sequence;
                                this.L$1 = ruleset;
                                this.L$2 = techName;
                                this.L$3 = var5_6 /* !! */ ;
                                this.L$4 = SpillingKt.nullOutSpilledVariable(unit);
                                this.label = 1;
                                v1 = $this$sequence.yield(ImageGetter.INSTANCE.getConstructionPortrait(unit.getName(), this.$techIconSize), this);
                                if (v1 != var15_3) continue;
                                return var15_3;
                            }
                            break;
                        }
                        case 1: {
                            unit = (BaseUnit)this.L$4;
                            var5_6 /* !! */  = (Iterator<T>)this.L$3;
                            techName = (String)this.L$2;
                            ruleset = (Ruleset)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
                            ** GOTO lbl9
                        }
                    }
                    var5_6 /* !! */  = TechnologyDescriptions.access$getEnabledBuildings(TechnologyDescriptions.INSTANCE, techName, ruleset, this.$viewingCiv).iterator();
lbl32:
                    // 5 sources

                    while (var5_6 /* !! */ .hasNext()) {
                        block21: {
                            v2 = var5_6 /* !! */ .next();
                            Intrinsics.checkNotNullExpressionValue(v2, "next(...)");
                            building = (Building)v2;
                            if (!building.isWonder() || this.$viewingCiv.getTech().isResearched(techName)) break block20;
                            var8_9 = SequencesKt.filter(this.$viewingCiv.getGameInfo().getCities(), (Function1<City, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.unciv.logic.civilization.Civilization com.unciv.logic.city.City ), (Lcom/unciv/logic/city/City;)Ljava/lang/Boolean;)((Civilization)this.$viewingCiv));
                            $i$f$any = false;
                            for (T element$iv : $this$any$iv) {
                                it = (City)element$iv;
                                $i$a$-any-TechnologyDescriptions$getTechEnabledIcons$1$isAlreadyBuilt$2 = false;
                                if (!it.getCityConstructions().isBuilt(building.getName())) continue;
                                v3 = 1;
                                break block21;
                            }
                            v3 = 0;
                        }
                        isAlreadyBuilt = v3;
                        wonderConstructionPortrait = isAlreadyBuilt != 0 ? (Group)new PortraitUnavailableWonderForTechTree(building.getName(), this.$techIconSize) : ImageGetter.INSTANCE.getConstructionPortrait(building.getName(), this.$techIconSize);
                        this.L$0 = $this$sequence;
                        this.L$1 = ruleset;
                        this.L$2 = techName;
                        this.L$3 = var5_6 /* !! */ ;
                        this.L$4 = SpillingKt.nullOutSpilledVariable(building);
                        this.L$5 = SpillingKt.nullOutSpilledVariable(wonderConstructionPortrait);
                        this.I$0 = isAlreadyBuilt;
                        this.label = 2;
                        v4 = $this$sequence.yield(wonderConstructionPortrait, this);
                        if (v4 != var15_3) continue;
                        return var15_3;
                    }
                    {
                        break;
                        case 2: {
                            isAlreadyBuilt = this.I$0;
                            wonderConstructionPortrait = (Group)this.L$5;
                            building = (Building)this.L$4;
                            var5_6 /* !! */  = (Iterator)this.L$3;
                            techName = (String)this.L$2;
                            ruleset = (Ruleset)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v4 = $result;
                            ** GOTO lbl32
                        }
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = ruleset;
                this.L$2 = techName;
                this.L$3 = var5_6 /* !! */ ;
                this.L$4 = SpillingKt.nullOutSpilledVariable(building);
                this.L$5 = null;
                this.label = 3;
                v5 = $this$sequence.yield(ImageGetter.INSTANCE.getConstructionPortrait(building.getName(), this.$techIconSize), this);
                if (v5 != var15_3) ** GOTO lbl32
                return var15_3;
                {
                    case 3: {
                        building = (Building)this.L$4;
                        var5_6 /* !! */  = (Iterator)this.L$3;
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
                        ** GOTO lbl32
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = ruleset;
                this.L$2 = techName;
                this.L$3 = null;
                this.L$4 = null;
                this.L$5 = null;
                this.label = 4;
                v6 = $this$sequence.yieldAll(SequencesKt.mapNotNull(TechnologyDescriptions.access$getObsoletedObjects(TechnologyDescriptions.INSTANCE, techName, ruleset, this.$viewingCiv), (Function1<RulesetStatsObject, Group>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$2(float com.unciv.models.ruleset.RulesetStatsObject ), (Lcom/unciv/models/ruleset/RulesetStatsObject;)Lcom/badlogic/gdx/scenes/scene2d/Group;)((float)this.$techIconSize)), (Continuation<? super Unit>)this);
                if (v6 == var15_3) {
                    return var15_3;
                }
                ** GOTO lbl107
                {
                    case 4: {
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
lbl107:
                        // 2 sources

                        v7 = ruleset.getTileResources().values();
                        Intrinsics.checkNotNullExpressionValue(v7, "<get-values>(...)");
                        $this$filter$iv = v7;
                        $i$f$filter = false;
                        wonderConstructionPortrait = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (TileResource)element$iv$iv;
                            $i$a$-filter-TechnologyDescriptions$getTechEnabledIcons$1$2 = false;
                            if (!Intrinsics.areEqual(it.getRevealedBy(), techName)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        var5_6 /* !! */  = ((List)destination$iv$iv).iterator();
lbl122:
                        // 3 sources

                        while (var5_6 /* !! */ .hasNext()) {
                            v8 = var5_6 /* !! */ .next();
                            Intrinsics.checkNotNullExpressionValue(v8, "next(...)");
                            resource = (TileResource)v8;
                            this.L$0 = $this$sequence;
                            this.L$1 = ruleset;
                            this.L$2 = techName;
                            this.L$3 = var5_6 /* !! */ ;
                            this.L$4 = SpillingKt.nullOutSpilledVariable(resource);
                            this.label = 5;
                            v9 = $this$sequence.yield(ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resource.getName(), this.$techIconSize, 0, 4, null), this);
                            if (v9 != var15_3) continue;
                            return var15_3;
                        }
                        break;
                    }
                    case 5: {
                        resource = (TileResource)this.L$4;
                        var5_6 /* !! */  = (Iterator)this.L$3;
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v9 = $result;
                        ** GOTO lbl122
                    }
                }
                v10 = ruleset.getTileImprovements().values();
                Intrinsics.checkNotNullExpressionValue(v10, "<get-values>(...)");
                var5_6 /* !! */  = SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)v10), (Function1<TileImprovement, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$4(java.lang.String com.unciv.models.ruleset.tile.TileImprovement ), (Lcom/unciv/models/ruleset/tile/TileImprovement;)Ljava/lang/Boolean;)((String)techName)), (Function1<TileImprovement, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$5(com.unciv.logic.civilization.Civilization com.unciv.models.ruleset.tile.TileImprovement ), (Lcom/unciv/models/ruleset/tile/TileImprovement;)Ljava/lang/Boolean;)((Civilization)this.$viewingCiv)).iterator();
lbl147:
                // 3 sources

                while (var5_6 /* !! */ .hasNext()) {
                    v11 = var5_6 /* !! */ .next();
                    Intrinsics.checkNotNullExpressionValue(v11, "next(...)");
                    improvement = (TileImprovement)v11;
                    this.L$0 = $this$sequence;
                    this.L$1 = ruleset;
                    this.L$2 = techName;
                    this.L$3 = var5_6 /* !! */ ;
                    this.L$4 = SpillingKt.nullOutSpilledVariable(improvement);
                    this.label = 6;
                    v12 = $this$sequence.yield(ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, improvement.getName(), this.$techIconSize, false, 4, null), this);
                    if (v12 != var15_3) continue;
                    return var15_3;
                }
                {
                    break;
                    case 6: {
                        improvement = (TileImprovement)this.L$4;
                        var5_6 /* !! */  = (Iterator)this.L$3;
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v12 = $result;
                        ** GOTO lbl147
                    }
                }
                v13 = ruleset.getTileImprovements().values();
                Intrinsics.checkNotNullExpressionValue(v13, "<get-values>(...)");
                var5_6 /* !! */  = SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)v13), (Function1<TileImprovement, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$6(java.lang.String com.unciv.models.ruleset.tile.TileImprovement ), (Lcom/unciv/models/ruleset/tile/TileImprovement;)Ljava/lang/Boolean;)((String)techName)), (Function1<TileImprovement, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$7(com.unciv.logic.civilization.Civilization com.unciv.models.ruleset.tile.TileImprovement ), (Lcom/unciv/models/ruleset/tile/TileImprovement;)Ljava/lang/Boolean;)((Civilization)this.$viewingCiv)).iterator();
lbl172:
                // 3 sources

                while (var5_6 /* !! */ .hasNext()) {
                    v14 = var5_6 /* !! */ .next();
                    Intrinsics.checkNotNullExpressionValue(v14, "next(...)");
                    improvement = (TileImprovement)v14;
                    this.L$0 = $this$sequence;
                    this.L$1 = SpillingKt.nullOutSpilledVariable(ruleset);
                    this.L$2 = SpillingKt.nullOutSpilledVariable(techName);
                    this.L$3 = var5_6 /* !! */ ;
                    this.L$4 = SpillingKt.nullOutSpilledVariable(improvement);
                    this.label = 7;
                    v15 = $this$sequence.yield(ImageGetter.INSTANCE.getUniquePortrait(improvement.getName(), this.$techIconSize), this);
                    if (v15 != var15_3) continue;
                    return var15_3;
                }
                {
                    break;
                    case 7: {
                        improvement = (TileImprovement)this.L$4;
                        var5_6 /* !! */  = (Iterator)this.L$3;
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v15 = $result;
                        ** GOTO lbl172
                    }
                }
                var5_6 /* !! */  = this.$tech.getUniqueObjects().iterator();
lbl195:
                // 4 sources

                while (var5_6 /* !! */ .hasNext()) {
                    unique = (Unique)var5_6 /* !! */ .next();
                    if (unique.isHiddenToUsers()) continue;
                    this.L$0 = $this$sequence;
                    this.L$1 = SpillingKt.nullOutSpilledVariable(ruleset);
                    this.L$2 = SpillingKt.nullOutSpilledVariable(techName);
                    this.L$3 = var5_6 /* !! */ ;
                    this.L$4 = SpillingKt.nullOutSpilledVariable(unique);
                    this.label = 8;
                    v16 = $this$sequence.yield(unique.getType() == UniqueType.EnablesCivWideStatProduction ? ImageGetter.INSTANCE.getConstructionPortrait(unique.getParams().get(0), this.$techIconSize) : ImageGetter.INSTANCE.getUniquePortrait(unique.getText(), this.$techIconSize), this);
                    if (v16 != var15_3) continue;
                    return var15_3;
                }
                {
                    break;
                    case 8: {
                        unique = (Unique)this.L$4;
                        var5_6 /* !! */  = (Iterator)this.L$3;
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v16 = $result;
                        ** GOTO lbl195
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Group>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Group> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0(Civilization $viewingCiv, City it) {
                return !Intrinsics.areEqual(it.getCiv(), $viewingCiv);
            }

            private static final Group invokeSuspend$lambda$2(float $techIconSize, RulesetStatsObject it) {
                return TechnologyDescriptions.access$getObsoletedIcon(TechnologyDescriptions.INSTANCE, it, $techIconSize);
            }

            private static final boolean invokeSuspend$lambda$4(String $techName, TileImprovement it) {
                return Intrinsics.areEqual(it.getTechRequired(), $techName);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static final boolean invokeSuspend$lambda$5(Civilization $viewingCiv, TileImprovement it) {
                if (it.getUniqueTo() == null) return true;
                String string = it.getUniqueTo();
                Intrinsics.checkNotNull(string);
                if (!Civilization.matchesFilter$default($viewingCiv, string, null, false, 6, null)) return false;
                return true;
            }

            private static final boolean invokeSuspend$lambda$6(String $techName, TileImprovement it) {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = it.getUniqueObjects();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Unique u = (Unique)element$iv;
                            boolean bl2 = false;
                            if (!u.getAllParams().contains($techName)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static final boolean invokeSuspend$lambda$7(Civilization $viewingCiv, TileImprovement it) {
                if (it.getUniqueTo() == null) return true;
                String string = it.getUniqueTo();
                Intrinsics.checkNotNull(string);
                if (!Civilization.matchesFilter$default($viewingCiv, string, null, false, 6, null)) return false;
                return true;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FormattedLine> getCivilopediaTextLines(@NotNull Technology technology, @NotNull Ruleset ruleset) {
        List<IRulesetObject> seeAlsoObjects;
        List<RulesetStatsObject> obsoletedObjects;
        Object it;
        void $this$partition$iv;
        Sequence<Building> unit;
        Sequence<BaseUnit> enabledUnits;
        void $this$filterTo$iv$iv;
        Iterable element$iv2;
        Intrinsics.checkNotNullParameter(technology, "technology");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Technology $this$getCivilopediaTextLines_u24lambda_u240 = technology;
        boolean bl = false;
        ArrayList lineList = new ArrayList();
        Object object = ruleset.getEras().get($this$getCivilopediaTextLines_u24lambda_u240.era());
        if (object == null || (object = ((Era)object).getHexColor()) == null) {
            object = "";
        }
        Object eraColor = object;
        ((Collection)lineList).add(new FormattedLine($this$getCivilopediaTextLines_u24lambda_u240.era(), null, null, null, 0.0f, 0, 3, 0, 0.0f, (String)eraColor, false, false, false, false, 15806, null));
        ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        ((Collection)lineList).add(new FormattedLine("{Cost}: " + $this$getCivilopediaTextLines_u24lambda_u240.getCost() + '\u237e', null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        if (!((Collection)$this$getCivilopediaTextLines_u24lambda_u240.getPrerequisites()).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if ($this$getCivilopediaTextLines_u24lambda_u240.getPrerequisites().size() == 1) {
                String it2 = (String)CollectionsKt.first((Iterable)$this$getCivilopediaTextLines_u24lambda_u240.getPrerequisites());
                boolean bl2 = false;
                ((Collection)lineList).add(new FormattedLine("Required tech: [" + it2 + ']', "Technology/" + it2, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)lineList).add(new FormattedLine("Requires all of the following:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = $this$getCivilopediaTextLines_u24lambda_u240.getPrerequisites();
                boolean $i$f$forEach = false;
                for (Iterable element$iv2 : $this$forEach$iv) {
                    String it3 = (String)((Object)element$iv2);
                    boolean bl3 = false;
                    ((Collection)lineList).add(new FormattedLine(it3, "Technology/" + it3, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
            }
        }
        Collection<Technology> collection = ruleset.getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Technology it4 = (Technology)element$iv$iv;
            boolean bl4 = false;
            if (!it4.getPrerequisites().contains($this$getCivilopediaTextLines_u24lambda_u240.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List leadsTo = (List)destination$iv$iv;
        if (!((Collection)leadsTo).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if (leadsTo.size() == 1) {
                Technology it5 = (Technology)CollectionsKt.first(leadsTo);
                boolean bl5 = false;
                ((Collection)lineList).add(new FormattedLine("Leads to [" + it5.getName() + ']', it5.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)lineList).add(new FormattedLine("Leads to:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = leadsTo;
                boolean $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    Technology it6 = (Technology)element$iv3;
                    boolean bl6 = false;
                    ((Collection)lineList).add(new FormattedLine(it6.getName(), it6.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
            }
        }
        DescriptionHelpersKt.uniquesToCivilopediaTextLines$default($this$getCivilopediaTextLines_u24lambda_u240, lineList, null, false, null, 14, null);
        Sequence<ImprovementAndUnique> affectedImprovements = INSTANCE.getAffectedImprovements($this$getCivilopediaTextLines_u24lambda_u240.getName(), ruleset);
        if (SequencesKt.any(affectedImprovements)) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            Iterator<ImprovementAndUnique> $i$f$forEach = affectedImprovements.iterator();
            while ($i$f$forEach.hasNext()) {
                ImprovementAndUnique entry = $i$f$forEach.next();
                ((Collection)lineList).add(new FormattedLine(entry.getText(), entry.getImprovement().makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        if (SequencesKt.any(enabledUnits = INSTANCE.getEnabledUnits($this$getCivilopediaTextLines_u24lambda_u240.getName(), ruleset, null))) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{Units enabled}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterator<BaseUnit> iterator2 = enabledUnits.iterator();
            while (iterator2.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                ((Collection)lineList).add(new FormattedLine(TranslationsKt.tr$default(((RulesetObject)((Object)unit)).getName(), true, false, 2, null) + " (" + ((BaseUnit)((Object)unit)).getShortDescription(new Function1<Unique, Boolean>((Object)technology){

                    public final Boolean invoke(Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsRequirementForThisTech(p0);
                    }
                }) + ')', ((BaseUnit)((Object)unit)).makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        unit = INSTANCE.getEnabledBuildings($this$getCivilopediaTextLines_u24lambda_u240.getName(), ruleset, null);
        boolean $i$f$partition = false;
        Iterator first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv4 : $this$partition$iv) {
            it = (Building)element$iv4;
            boolean bl7 = false;
            boolean bl8 = ((Building)it).isAnyWonder() ? ((ArrayList)((Object)first$iv)).add(element$iv4) : second$iv.add(element$iv4);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List wonders = pair.component1();
        List regularBuildings = pair.component2();
        if (!((Collection)wonders).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{Wonders enabled}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            for (Object e : wonders) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                Building wonder = (Building)e;
                ((Collection)lineList).add(new FormattedLine(TranslationsKt.tr$default(wonder.getName(), true, false, 2, null) + " (" + Building.getShortDescription$default(wonder, false, new Function1<Unique, Boolean>((Object)technology){

                    public final Boolean invoke(Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsNotRequirementForThisTech(p0);
                    }
                }, 1, null) + ')', wonder.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        if (!((Collection)regularBuildings).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{Buildings enabled}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            for (Object e : regularBuildings) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                Building building = (Building)e;
                String text2 = TranslationsKt.tr$default(building.getName(), true, false, 2, null) + " (" + Building.getShortDescription$default(building, false, new Function1<Unique, Boolean>((Object)technology){

                    public final Boolean invoke(Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsNotRequirementForThisTech(p0);
                    }
                }, 1, null) + ')';
                Collection element$iv4 = lineList;
                it = building.makeLink();
                element$iv4.add(new FormattedLine(text2, (String)it, null, null, 0.0f, 0, 0, 0, 15.0f, null, false, false, false, false, 16124, null));
            }
        }
        if (!((Collection)(obsoletedObjects = SequencesKt.toList(INSTANCE.getObsoletedObjects($this$getCivilopediaTextLines_u24lambda_u240.getName(), ruleset, null)))).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            Iterable $this$forEach$iv = obsoletedObjects;
            boolean $i$f$forEach = false;
            for (Object element$iv5 : $this$forEach$iv) {
                RulesetStatsObject it7 = (RulesetStatsObject)element$iv5;
                boolean bl9 = false;
                ((Collection)lineList).add(new FormattedLine('[' + it7.getName() + "] obsoleted", it7.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        Collection<TileResource> collection2 = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Sequence<TileResource> revealedResources = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), arg_0 -> TechnologyDescriptions.getCivilopediaTextLines$lambda$0$7($this$getCivilopediaTextLines_u24lambda_u240, arg_0));
        if (SequencesKt.any(revealedResources)) {
            Object element$iv5;
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            Sequence<TileResource> $this$forEach$iv = revealedResources;
            boolean $i$f$forEach = false;
            element$iv5 = $this$forEach$iv.iterator();
            while (element$iv5.hasNext()) {
                Object element$iv6 = element$iv5.next();
                TileResource it8 = (TileResource)element$iv6;
                boolean bl10 = false;
                ((Collection)lineList).add(new FormattedLine("Reveals [" + it8.getName() + "] on the map", it8.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        Collection<TileImprovement> collection3 = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
        Sequence<TileImprovement> tileImprovements = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection3), arg_0 -> TechnologyDescriptions.getCivilopediaTextLines$lambda$0$9($this$getCivilopediaTextLines_u24lambda_u240, arg_0));
        if (SequencesKt.any(tileImprovements)) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{Tile improvements enabled}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Sequence<TileImprovement> $this$forEach$iv = tileImprovements;
            boolean $i$f$forEach = false;
            Iterator<TileImprovement> element$iv6 = $this$forEach$iv.iterator();
            while (element$iv6.hasNext()) {
                TileImprovement element$iv7;
                TileImprovement it9 = element$iv7 = element$iv6.next();
                boolean bl11 = false;
                ((Collection)lineList).add(new FormattedLine(it9.getName(), it9.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        if (!((Collection)(seeAlsoObjects = INSTANCE.getSeeAlsoObjects($this$getCivilopediaTextLines_u24lambda_u240, ruleset))).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{See also}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = seeAlsoObjects;
            boolean $i$f$forEach = false;
            for (Object element$iv8 : $this$forEach$iv) {
                IRulesetObject it10 = (IRulesetObject)element$iv8;
                boolean bl12 = false;
                ((Collection)lineList).add(new FormattedLine(it10.getName(), it10.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        return lineList;
    }

    private final Sequence<Building> getEnabledBuildings(String techName, Ruleset ruleset, Civilization civInfo) {
        return this.getFilteredBuildings(ruleset, civInfo, arg_0 -> TechnologyDescriptions.getEnabledBuildings$lambda$0(techName, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private final Sequence<RulesetStatsObject> getObsoletedObjects(String techName, Ruleset ruleset, Civilization civInfo) {
        v0 = this.getFilteredBuildings(ruleset, civInfo, (Function1<Building, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getObsoletedObjects$lambda$0(com.unciv.models.ruleset.Building ), (Lcom/unciv/models/ruleset/Building;)Ljava/lang/Boolean;)());
        v1 = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v1, "<get-values>(...)");
        v2 = SequencesKt.plus(v0, CollectionsKt.asSequence((Iterable)v1));
        v3 = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(v3, "<get-values>(...)");
        var4_4 = v3;
        var13_5 = v2;
        $i$f$filter = false;
        var6_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileImprovement)element$iv$iv;
            $i$a$-filter-TechnologyDescriptions$getObsoletedObjects$2 = false;
            if (it.getUniqueTo() == null) ** GOTO lbl-1000
            v4 = civInfo;
            if (v4 != null) {
                v5 = it.getUniqueTo();
                Intrinsics.checkNotNull(v5);
                v6 = Civilization.matchesFilter$default(v4, v5, null, false, 6, null);
            } else {
                v6 = false;
            }
            if (v6) lbl-1000:
            // 2 sources

            {
                v7 = true;
            } else {
                v7 = false;
            }
            if (!v7) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return SequencesKt.filter(SequencesKt.plus(var13_5, (List)destination$iv$iv), (Function1<RulesetStatsObject, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getObsoletedObjects$lambda$2(java.lang.String com.unciv.models.ruleset.RulesetStatsObject ), (Lcom/unciv/models/ruleset/RulesetStatsObject;)Ljava/lang/Boolean;)((String)techName));
    }

    private final Group getObsoletedIcon(RulesetStatsObject $this$getObsoletedIcon, float techIconSize) {
        Object object;
        Group group;
        Object object2 = $this$getObsoletedIcon;
        Group group2 = object2 instanceof Building ? ImageGetter.INSTANCE.getConstructionPortrait(((Building)$this$getObsoletedIcon).getName(), techIconSize) : (object2 instanceof TileResource ? ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, ((TileResource)$this$getObsoletedIcon).getName(), techIconSize, 0, 4, null) : (group = object2 instanceof TileImprovement ? (Group)ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, $this$getObsoletedIcon.getName(), techIconSize, false, 4, null) : null));
        if (group != null) {
            Object it = object2 = group;
            boolean bl = false;
            Actor closeImage = ImageGetter.INSTANCE.getRedCross(techIconSize / (float)2, 1.0f);
            Scene2dExtensionsKt.center(closeImage, (Actor)it);
            ((Group)it).addActor(closeImage);
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    private final Sequence<Building> getFilteredBuildings(Ruleset ruleset, Civilization civInfo, Function1<? super Building, Boolean> predicate) {
        Collection<Building> collection = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), arg_0 -> TechnologyDescriptions.getFilteredBuildings$lambda$0(predicate, civInfo, ruleset, arg_0));
    }

    private final Sequence<BaseUnit> getEnabledUnits(String techName, Ruleset ruleset, Civilization civInfo) {
        Collection<BaseUnit> collection = ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), arg_0 -> TechnologyDescriptions.getEnabledUnits$lambda$0(techName, civInfo, ruleset, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isImprovementStatsEnabledByTech(Unique $this$isImprovementStatsEnabledByTech, String techName) {
        Unique it;
        if ($this$isImprovementStatsEnabledByTech.getType() != UniqueType.Stats) {
            if ($this$isImprovementStatsEnabledByTech.getType() != UniqueType.ImprovementStatsOnTile) return false;
        }
        Iterable $this$any$iv = $this$isImprovementStatsEnabledByTech.getModifiers(UniqueType.ConditionalTech);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Unique)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual(it.getParams().get(0), techName));
        return true;
    }

    private final boolean isTechConditional(Unique $this$isTechConditional) {
        return $this$isTechConditional.getType() == UniqueType.ConditionalTech || $this$isTechConditional.getType() == UniqueType.ConditionalNoTech;
    }

    private final boolean isRelatedToTech(Unique $this$isRelatedToTech, String techName) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$isRelatedToTech.getModifiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    if (!(INSTANCE.isTechConditional(it) && Intrinsics.areEqual(it.getParams().get(0), techName))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Sequence<ImprovementAndUnique> getAffectedImprovements(String techName, Ruleset ruleset) {
        Collection<TileImprovement> collection = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)collection), arg_0 -> TechnologyDescriptions.getAffectedImprovements$lambda$0(techName, arg_0));
    }

    private final List<IRulesetObject> getSeeAlsoObjects(Technology $this$getSeeAlsoObjects, Ruleset ruleset) {
        return SequencesKt.toList(SequencesKt.filter(ruleset.allRulesetObjects(), arg_0 -> TechnologyDescriptions.getSeeAlsoObjects$lambda$0($this$getSeeAlsoObjects, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getDescription$lambda$0$0(Civilization $viewingCiv, ImprovementAndUnique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getImprovement().getUniqueTo() == null) return true;
        String string = it.getImprovement().getUniqueTo();
        Intrinsics.checkNotNull(string);
        if (!Civilization.matchesFilter$default($viewingCiv, string, null, false, 6, null)) return false;
        return true;
    }

    private static final String getDescription$lambda$0$1(ImprovementAndUnique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getText();
    }

    private static final boolean getDescription$lambda$0$3(Technology $this_run, TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getRevealedBy(), $this_run.getName());
    }

    private static final String getDescription$lambda$0$4(TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName();
    }

    private static final boolean getDescription$lambda$0$5(Technology $this_run, TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getTechRequired(), $this_run.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getDescription$lambda$0$6(Civilization $viewingCiv, TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getUniqueTo() == null) return true;
        String string = it.getUniqueTo();
        Intrinsics.checkNotNull(string);
        if (!Civilization.matchesFilter$default($viewingCiv, string, null, false, 6, null)) return false;
        return true;
    }

    private static final CharSequence getDescription$lambda$0$7(TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it.getName(), false, false, 3, null);
    }

    private static final CharSequence getDescription$lambda$0$8(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }

    private static final boolean getCivilopediaTextLines$lambda$0$7(Technology $this_run, TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getRevealedBy(), $this_run.getName());
    }

    private static final boolean getCivilopediaTextLines$lambda$0$9(Technology $this_run, TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getTechRequired(), $this_run.getName());
    }

    private static final boolean getEnabledBuildings$lambda$0(String $techName, Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SequencesKt.contains(it.requiredTechs(), $techName);
    }

    private static final boolean getObsoletedObjects$lambda$0(Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean getObsoletedObjects$lambda$2(String $techName, RulesetStatsObject obj) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Sequence $this$any$iv = IHasUniques.getMatchingUniques$default(obj, UniqueType.ObsoleteWith, null, 2, null);
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getParams().get(0), $techName)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getFilteredBuildings$lambda$0(Function1 $predicate, Civilization $civInfo, Ruleset $ruleset, Building it) {
        block7: {
            block6: {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if ((Boolean)$predicate.invoke(it) == false) return false;
                if (it.getUniqueTo() == null) break block6;
                Civilization civilization = $civInfo;
                if (civilization != null) {
                    String string = it.getUniqueTo();
                    Intrinsics.checkNotNull(string);
                    bl = Civilization.matchesFilter$default(civilization, string, null, false, 6, null);
                } else {
                    bl = false;
                }
                if (bl) break block7;
            }
            if (it.getUniqueTo() != null) return false;
            if ($civInfo != null) {
                if (!Intrinsics.areEqual($civInfo.getEquivalentBuilding(it), it)) return false;
            }
        }
        if (it.isHiddenFromCivilopedia($ruleset)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getEnabledUnits$lambda$0(String $techName, Civilization $civInfo, Ruleset $ruleset, BaseUnit it) {
        block7: {
            block6: {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (!SequencesKt.contains(it.requiredTechs(), $techName)) return false;
                if (it.getUniqueTo() == null) break block6;
                Civilization civilization = $civInfo;
                if (civilization != null) {
                    String string = it.getUniqueTo();
                    Intrinsics.checkNotNull(string);
                    bl = Civilization.matchesFilter$default(civilization, string, null, false, 6, null);
                } else {
                    bl = false;
                }
                if (bl) break block7;
            }
            if (it.getUniqueTo() != null) return false;
            if ($civInfo != null) {
                if (!Intrinsics.areEqual($civInfo.getEquivalentUnit(it), it)) return false;
            }
        }
        if (it.isHiddenFromCivilopedia($ruleset)) return false;
        return true;
    }

    private static final boolean getAffectedImprovements$lambda$0$0(String $techName, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.isImprovementStatsEnabledByTech(it, $techName);
    }

    private static final ImprovementAndUnique getAffectedImprovements$lambda$0$1(TileImprovement $improvement, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNull($improvement);
        return new ImprovementAndUnique($improvement, it);
    }

    private static final Sequence getAffectedImprovements$lambda$0(String $techName, TileImprovement improvement) {
        Intrinsics.checkNotNullParameter(improvement, "improvement");
        return SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)improvement.getUniqueObjects()), arg_0 -> TechnologyDescriptions.getAffectedImprovements$lambda$0$0($techName, arg_0)), arg_0 -> TechnologyDescriptions.getAffectedImprovements$lambda$0$1(improvement, arg_0));
    }

    private static final boolean getSeeAlsoObjects$lambda$0(Technology $this_getSeeAlsoObjects, IRulesetObject iRulesetObject) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(iRulesetObject, "iRulesetObject");
            Iterable $this$any$iv = iRulesetObject.getUniqueObjects();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    if (!(INSTANCE.isRelatedToTech(it, $this_getSeeAlsoObjects.getName()) && !INSTANCE.isImprovementStatsEnabledByTech(it, $this_getSeeAlsoObjects.getName()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Sequence access$getEnabledUnits(TechnologyDescriptions $this, String techName, Ruleset ruleset, Civilization civInfo) {
        return $this.getEnabledUnits(techName, ruleset, civInfo);
    }

    public static final /* synthetic */ Sequence access$getEnabledBuildings(TechnologyDescriptions $this, String techName, Ruleset ruleset, Civilization civInfo) {
        return $this.getEnabledBuildings(techName, ruleset, civInfo);
    }

    public static final /* synthetic */ Sequence access$getObsoletedObjects(TechnologyDescriptions $this, String techName, Ruleset ruleset, Civilization civInfo) {
        return $this.getObsoletedObjects(techName, ruleset, civInfo);
    }

    public static final /* synthetic */ Group access$getObsoletedIcon(TechnologyDescriptions $this, RulesetStatsObject $receiver, float techIconSize) {
        return $this.getObsoletedIcon($receiver, techIconSize);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\rH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/objectdescriptions/TechnologyDescriptions$ImprovementAndUnique;", "", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "<init>", "(Lcom/unciv/models/ruleset/tile/TileImprovement;Lcom/unciv/models/ruleset/unique/Unique;)V", "getImprovement", "()Lcom/unciv/models/ruleset/tile/TileImprovement;", "getUnique", "()Lcom/unciv/models/ruleset/unique/Unique;", "getText", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class ImprovementAndUnique {
        @NotNull
        private final TileImprovement improvement;
        @NotNull
        private final Unique unique;

        public ImprovementAndUnique(@NotNull TileImprovement improvement, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(improvement, "improvement");
            Intrinsics.checkNotNullParameter(unique, "unique");
            this.improvement = improvement;
            this.unique = unique;
        }

        @NotNull
        public final TileImprovement getImprovement() {
            return this.improvement;
        }

        @NotNull
        public final Unique getUnique() {
            return this.unique;
        }

        @NotNull
        public final String getText() {
            return '[' + this.unique.getParams().get(0) + "] from every [" + this.improvement.getName() + ']' + (this.unique.getType() == UniqueType.Stats ? "" : " on [" + this.unique.getParams().get(1) + "] tiles");
        }

        @NotNull
        public final TileImprovement component1() {
            return this.improvement;
        }

        @NotNull
        public final Unique component2() {
            return this.unique;
        }

        @NotNull
        public final ImprovementAndUnique copy(@NotNull TileImprovement improvement, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(improvement, "improvement");
            Intrinsics.checkNotNullParameter(unique, "unique");
            return new ImprovementAndUnique(improvement, unique);
        }

        public static /* synthetic */ ImprovementAndUnique copy$default(ImprovementAndUnique improvementAndUnique, TileImprovement tileImprovement, Unique unique, int n, Object object) {
            if ((n & 1) != 0) {
                tileImprovement = improvementAndUnique.improvement;
            }
            if ((n & 2) != 0) {
                unique = improvementAndUnique.unique;
            }
            return improvementAndUnique.copy(tileImprovement, unique);
        }

        @NotNull
        public String toString() {
            return "ImprovementAndUnique(improvement=" + this.improvement + ", unique=" + this.unique + ')';
        }

        public int hashCode() {
            int result2 = this.improvement.hashCode();
            result2 = result2 * 31 + this.unique.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImprovementAndUnique)) {
                return false;
            }
            ImprovementAndUnique improvementAndUnique = (ImprovementAndUnique)other;
            if (!Intrinsics.areEqual(this.improvement, improvementAndUnique.improvement)) {
                return false;
            }
            return Intrinsics.areEqual(this.unique, improvementAndUnique.unique);
        }
    }
}

