/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.badlogic.gdx.graphics.Color;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stat;
import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.CliInput$Companion$findCliInput$;
import com.unciv.ui.screens.devconsole.CliInput$find$;
import com.unciv.ui.screens.devconsole.ConsoleErrorException;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00000\u0001:\u000267B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u000e\u001a\u00020\u0003H\u0096\u0080\u0004J\u0012\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0082\u0004J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0014H\u0096\u0082\u0004J\n\u0010\u0015\u001a\u00020\u0010H\u0096\u0080\u0004J$\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0013J\u0006\u0010\u001e\u001a\u00020\u0013J\u0006\u0010\u001f\u001a\u00020\u0010J\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0013J\u0006\u0010%\u001a\u00020&J\"\u0010'\u001a\u0004\u0018\u0001H(\"\u0010\b\u0000\u0010(\u0018\u0001*\b\u0012\u0004\u0012\u0002H(0)H\u0086\b\u00a2\u0006\u0002\u0010*J \u0010+\u001a\u0002H(\"\u0010\b\u0000\u0010(\u0018\u0001*\b\u0012\u0004\u0012\u0002H(0)H\u0086\b\u00a2\u0006\u0002\u0010*J\u0016\u0010,\u001a\u0004\u0018\u00010\u00032\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.J\u001c\u0010/\u001a\u00020\u00032\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.2\u0006\u00100\u001a\u00020\u0003J%\u0010,\u001a\u0004\u0018\u0001H(\"\b\b\u0000\u0010(*\u0002012\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H(0.\u00a2\u0006\u0002\u00102J(\u0010/\u001a\u0002H(\"\n\b\u0000\u0010(\u0018\u0001*\u0002012\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H(0.H\u0086\b\u00a2\u0006\u0002\u00102J%\u0010,\u001a\u0004\u0018\u0001H(\"\b\b\u0000\u0010(*\u0002012\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H(03\u00a2\u0006\u0002\u00104J(\u0010/\u001a\u0002H(\"\n\b\u0000\u0010(\u0018\u0001*\u0002012\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H(03H\u0086\b\u00a2\u0006\u0002\u00104J\u0006\u00105\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/unciv/ui/screens/devconsole/CliInput;", "", "parameter", "", "method", "Lcom/unciv/ui/screens/devconsole/CliInput$Method;", "<init>", "(Ljava/lang/String;Lcom/unciv/ui/screens/devconsole/CliInput$Method;)V", "getMethod", "()Lcom/unciv/ui/screens/devconsole/CliInput$Method;", "content", "getContent", "()Ljava/lang/String;", "original", "toString", "compareTo", "", "other", "equals", "", "", "hashCode", "getAutocompleteString", "paramMethod", "upTo", "toAppend", "getDashedRepresentation", "toMethod", "startsWith", "isEmpty", "isNotEmpty", "originalLength", "originalUnquoted", "toInt", "toFloat", "", "toBoolean", "toStat", "Lcom/unciv/models/stats/Stat;", "enumValueOrNull", "T", "", "()Ljava/lang/Enum;", "enumValue", "findOrNull", "options", "", "find", "typeName", "Lcom/unciv/models/stats/INamed;", "(Ljava/lang/Iterable;)Lcom/unciv/models/stats/INamed;", "Lkotlin/sequences/Sequence;", "(Lkotlin/sequences/Sequence;)Lcom/unciv/models/stats/INamed;", "toStringAsPlaceholder", "Method", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCliInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliInput.kt\ncom/unciv/ui/screens/devconsole/CliInput\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,292:1\n151#1:293\n151#1:298\n174#1,2:313\n1401#2,2:294\n1401#2,2:296\n1401#2,2:299\n11705#2:301\n12052#2,3:302\n296#3,2:305\n296#3,2:307\n296#3,2:309\n184#4,2:311\n*S KotlinDebug\n*F\n+ 1 CliInput.kt\ncom/unciv/ui/screens/devconsole/CliInput\n*L\n147#1:293\n155#1:298\n183#1:313,2\n147#1:294,2\n151#1:296,2\n155#1:299,2\n156#1:301\n156#1:302,3\n160#1:305,2\n165#1:307,2\n170#1:309,2\n179#1:311,2\n*E\n"})
public final class CliInput
implements Comparable<CliInput> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Method method;
    @NotNull
    private final String content;
    @NotNull
    private final String original;
    @NotNull
    private static final CliInput empty = new CliInput("", null, 2, null);
    @NotNull
    private static final Regex repeatedWhiteSpaceRegex = new Regex("(?<=\\s)\\s+");
    @NotNull
    private static final Regex splitStringRegex = new Regex("\n            \"[^\"]+(?:\"|$)       # A quoted phrase, but the closing quote is optional at the end of the string\n            |                   # OR\n            \\S+                 # consecutive non-whitespace\n            |                   # OR\n            (?:(?<=\\s)$)        # a terminal empty string if preceded by whitespace\n        ", RegexOption.COMMENTS);

    public CliInput(@NotNull String parameter, @Nullable Method method) {
        String string;
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Method method2 = method;
        if (method2 == null) {
            method2 = CliInput.Companion.hasLeadingQuote(parameter) ? Method.Quoted : Method.Dashed;
        }
        this.method = method2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()]) {
            case 1: {
                string = CliInput.Companion.toDashedRepresentation(parameter);
                break;
            }
            case 2: {
                string = CliInput.Companion.toQuotedRepresentation(parameter);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.content = string;
        this.original = parameter;
    }

    public /* synthetic */ CliInput(String string, Method method, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            method = null;
        }
        this(string, method);
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public String toString() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()]) {
            case 1: {
                string = this.content;
                break;
            }
            case 2: {
                string = '\"' + this.content + '\"';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull CliInput other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.method == Method.Dashed && other.method == Method.Dashed ? this.content.compareTo(other.content) : (this.method == Method.Quoted && other.method == Method.Quoted ? StringsKt.compareTo(this.content, other.content, true) : (this.method == Method.Dashed ? this.content.compareTo(CliInput.Companion.toDashedRepresentation(other.original)) : CliInput.Companion.toDashedRepresentation(this.original).compareTo(other.content)));
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other instanceof CliInput ? this.compareTo((CliInput)other) == 0 : (other instanceof String ? this.compareTo(StringsKt.replace$default(StringsKt.replace$default((String)other, "[", "", false, 4, null), "]", "", false, 4, null), this.method) == 0 : false));
    }

    public int hashCode() {
        return this.getDashedRepresentation().hashCode();
    }

    private final String getAutocompleteString(Method paramMethod, int upTo, String toAppend) {
        if (paramMethod == Method.Dashed && this.method == Method.Dashed) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.content.substring(0, RangesKt.coerceAtMost(upTo, this.content.length()));
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return stringBuilder.append(string).append(toAppend).toString();
        }
        String source = this.method == Method.Quoted ? this.content : CliInput.Companion.toQuotedRepresentation(this.original);
        String suffix = ((CharSequence)toAppend).length() > 0 ? '\"' + toAppend : "";
        StringBuilder stringBuilder = new StringBuilder().append('\"');
        String string = source.substring(0, RangesKt.coerceAtMost(upTo, source.length()));
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return stringBuilder.append(string).append(suffix).toString();
    }

    static /* synthetic */ String getAutocompleteString$default(CliInput cliInput, Method method, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = cliInput.content.length();
        }
        if ((n2 & 4) != 0) {
            string = "";
        }
        return cliInput.getAutocompleteString(method, n, string);
    }

    private final String getDashedRepresentation() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()]) {
            case 1: {
                string = this.content;
                break;
            }
            case 2: {
                string = CliInput.Companion.toDashedRepresentation(this.original);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final CliInput toMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, "method");
        return this.method == method ? this : new CliInput(this.original, method);
    }

    @Override
    public final int compareTo(@NotNull String other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.compareTo(other, this.method);
    }

    public final int compareTo(@NotNull String other, @NotNull Method method) {
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter((Object)method, "method");
        return this.compareTo(new CliInput(other, method));
    }

    public final boolean startsWith(@NotNull CliInput other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.method == Method.Dashed && other.method == Method.Dashed ? StringsKt.startsWith$default(this.content, other.content, false, 2, null) : (this.method == Method.Quoted && other.method == Method.Quoted ? StringsKt.startsWith(this.content, other.content, true) : (this.method == Method.Dashed ? StringsKt.startsWith$default(this.content, CliInput.Companion.toDashedRepresentation(other.original), false, 2, null) : StringsKt.startsWith$default(CliInput.Companion.toDashedRepresentation(this.original), other.content, false, 2, null)));
    }

    public final boolean isEmpty() {
        return ((CharSequence)this.content).length() == 0;
    }

    public final boolean isNotEmpty() {
        return ((CharSequence)this.content).length() > 0;
    }

    public final int originalLength() {
        return this.original.length();
    }

    @NotNull
    public final String originalUnquoted() {
        return CliInput.Companion.removeOuterQuotes(this.original);
    }

    public final int toInt() {
        Integer n = StringsKt.toIntOrNull(this.content);
        if (n == null) {
            throw new ConsoleErrorException("" + '\'' + this + "' is not a valid number.");
        }
        return n;
    }

    public final float toFloat() {
        Float f = StringsKt.toFloatOrNull(this.content);
        if (f == null) {
            throw new ConsoleErrorException("" + '\'' + this + "' is not a valid number.");
        }
        return f.floatValue();
    }

    public final boolean toBoolean() {
        Boolean bl = StringsKt.toBooleanStrictOrNull(this.content);
        if (bl == null) {
            throw new ConsoleErrorException("" + '\'' + this + "' is not a valid boolean value.");
        }
        return bl;
    }

    @NotNull
    public final Stat toStat() {
        Stat stat;
        block2: {
            CliInput this_$iv = this;
            boolean $i$f$enumValueOrNull = false;
            Stat[] $this$firstOrNull$iv$iv = Stat.values();
            boolean $i$f$firstOrNull = false;
            for (Stat element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = element$iv$iv;
                boolean bl = false;
                if (!this_$iv.equals(it$iv.name())) continue;
                stat = element$iv$iv;
                break block2;
            }
            stat = null;
        }
        Stat stat2 = (Stat)((Enum)stat);
        if (stat2 == null) {
            throw new ConsoleErrorException("" + '\'' + this + "' is not an acceptable Stat.");
        }
        return stat2;
    }

    public final /* synthetic */ <T extends Enum<T>> T enumValueOrNull() {
        Enum enum_;
        block1: {
            boolean $i$f$enumValueOrNull = false;
            Intrinsics.reifiedOperationMarker(5, "T");
            Enum[] $this$firstOrNull$iv = new Enum[]{};
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Enum element$iv;
                Enum it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!this.equals(it.name())) continue;
                enum_ = element$iv;
                break block1;
            }
            enum_ = null;
        }
        return (T)enum_;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends Enum<T>> T enumValue() {
        Enum enum_;
        Enum[] $this$firstOrNull$iv$iv;
        Enum[] this_$iv;
        block3: {
            boolean $i$f$enumValue = false;
            this_$iv = this;
            boolean $i$f$enumValueOrNull = false;
            Intrinsics.reifiedOperationMarker(5, "T");
            $this$firstOrNull$iv$iv = new Enum[]{};
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                Enum element$iv$iv;
                Enum it$iv = element$iv$iv = $this$firstOrNull$iv$iv[i];
                boolean bl = false;
                if (!this_$iv.equals(it$iv.name())) continue;
                enum_ = element$iv$iv;
                break block3;
            }
            enum_ = null;
        }
        Enum enum_2 = enum_;
        if (enum_2 == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            StringBuilder stringBuilder = new StringBuilder().append('\'').append(this).append("' is not a valid ");
            Intrinsics.reifiedOperationMarker(4, "T");
            StringBuilder stringBuilder2 = stringBuilder.append(Enum.class.getSimpleName()).append(". Options are: ");
            Intrinsics.reifiedOperationMarker(5, "T");
            this_$iv = new Enum[]{};
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean $i$f$map = false;
            $this$firstOrNull$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Enum bl = (Enum)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.name());
            }
            String string = stringBuilder3.append((List)destination$iv$iv).append('.').toString();
            throw new ConsoleErrorException(string);
        }
        return (T)enum_2;
    }

    @Nullable
    public final String findOrNull(@NotNull Iterable<String> options2) {
        String string;
        block1: {
            Intrinsics.checkNotNullParameter(options2, "options");
            Iterable<String> $this$firstOrNull$iv = options2;
            boolean $i$f$firstOrNull = false;
            Iterator<String> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                String element$iv;
                String it = element$iv = iterator2.next();
                boolean bl = false;
                if (!this.equals(it)) continue;
                string = element$iv;
                break block1;
            }
            string = null;
        }
        return string;
    }

    @NotNull
    public final String find(@NotNull Iterable<String> options2, @NotNull String typeName) {
        String string;
        block2: {
            Intrinsics.checkNotNullParameter(options2, "options");
            Intrinsics.checkNotNullParameter(typeName, "typeName");
            Iterable<String> $this$firstOrNull$iv = options2;
            boolean $i$f$firstOrNull = false;
            Iterator<String> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                String element$iv;
                String it = element$iv = iterator2.next();
                boolean bl = false;
                if (!this.equals(it)) continue;
                string = element$iv;
                break block2;
            }
            string = null;
        }
        String string2 = string;
        if (string2 == null) {
            throw new ConsoleErrorException("" + '\'' + this + "' is not a valid " + typeName + ". Options are: " + com.unciv.ui.screens.devconsole.CliInput$Companion.joinToStringLimited$default(Companion, options2, null, null, null, 0, null, 31, null));
        }
        return string2;
    }

    @Nullable
    public final <T extends INamed> T findOrNull(@NotNull Iterable<? extends T> options2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(options2, "options");
            Iterable<T> $this$firstOrNull$iv = options2;
            boolean $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                INamed it = (INamed)element$iv;
                boolean bl = false;
                if (!this.equals(it.getName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (T)((INamed)v0);
    }

    public final /* synthetic */ <T extends INamed> T find(Iterable<? extends T> options2) {
        Intrinsics.checkNotNullParameter(options2, "options");
        boolean $i$f$find = false;
        T t = this.findOrNull(options2);
        if (t == null) {
            StringBuilder stringBuilder = new StringBuilder().append('\'').append(this).append("' is not a valid ");
            Intrinsics.reifiedOperationMarker(4, "T");
            StringBuilder stringBuilder2 = stringBuilder.append(INamed.class.getSimpleName()).append(". Options are: ");
            Intrinsics.needClassReification();
            throw new ConsoleErrorException(stringBuilder2.append(com.unciv.ui.screens.devconsole.CliInput$Companion.joinToStringLimited$default(CliInput.Companion, options2, null, null, null, 0, find.2.INSTANCE, 15, null)).append('.').toString());
        }
        return (T)((INamed)t);
    }

    @Nullable
    public final <T extends INamed> T findOrNull(@NotNull Sequence<? extends T> options2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(options2, "options");
            Sequence<T> $this$firstOrNull$iv = options2;
            boolean $i$f$firstOrNull = false;
            Iterator<T> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                T element$iv = iterator2.next();
                INamed it = (INamed)element$iv;
                boolean bl = false;
                if (!this.equals(it.getName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (T)((INamed)v0);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends INamed> T find(Sequence<? extends T> options2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(options2, "options");
        boolean $i$f$find = false;
        CliInput cliInput = this;
        Iterable<? extends T> options$iv = SequencesKt.asIterable(options2);
        boolean $i$f$find2 = false;
        T t = this_$iv.findOrNull(options$iv);
        if (t == null) {
            StringBuilder stringBuilder = new StringBuilder().append('\'').append(this_$iv).append("' is not a valid ");
            Intrinsics.reifiedOperationMarker(4, "T");
            StringBuilder stringBuilder2 = stringBuilder.append(INamed.class.getSimpleName()).append(". Options are: ");
            Intrinsics.needClassReification();
            throw new ConsoleErrorException(stringBuilder2.append(com.unciv.ui.screens.devconsole.CliInput$Companion.joinToStringLimited$default(CliInput.Companion, options$iv, null, null, null, 0, find$$inlined$find$1.INSTANCE, 15, null)).append('.').toString());
        }
        return (T)((INamed)t);
    }

    @NotNull
    public final String toStringAsPlaceholder() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()]) {
            case 1: {
                string = '[' + this.content + ']';
                break;
            }
            case 2: {
                string = "\"[" + this.originalUnquoted() + "]\"";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\nH\u0002J\f\u0010\f\u001a\u00020\n*\u00020\nH\u0002J\f\u0010\r\u001a\u00020\n*\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016*\u00020\nJ\f\u0010\u0017\u001a\u00020\u0005*\u0004\u0018\u00010\u0005J(\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\n\b\u0000\u0010\u0019\u0018\u0001*\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\"\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b#J-\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!2\u0006\u0010\"\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b$JX\u0010%\u001a\u00020\n\"\u0004\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190!2\b\b\u0002\u0010&\u001a\u00020\n2\b\b\u0002\u0010'\u001a\u00020\n2\b\b\u0002\u0010(\u001a\u00020\n2\b\b\u0002\u0010)\u001a\u00020*2\u0016\b\u0002\u0010+\u001a\u0010\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\n\u0018\u00010,H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0003\u00a8\u0006-"}, d2={"Lcom/unciv/ui/screens/devconsole/CliInput$Companion;", "", "<init>", "()V", "empty", "Lcom/unciv/ui/screens/devconsole/CliInput;", "getEmpty", "()Lcom/unciv/ui/screens/devconsole/CliInput;", "hasLeadingQuote", "", "", "toDashedRepresentation", "removeOuterQuotes", "toQuotedRepresentation", "charIsNotAQuote", "char", "", "repeatedWhiteSpaceRegex", "Lkotlin/text/Regex;", "splitStringRegex", "getSplitStringRegex$annotations", "splitToCliInput", "", "orEmpty", "findCliInput", "T", "Lcom/unciv/models/ruleset/IRulesetObject;", "Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "param", "(Lcom/unciv/ui/screens/devconsole/DevConsolePopup;Lcom/unciv/ui/screens/devconsole/CliInput;)Lcom/unciv/models/ruleset/IRulesetObject;", "getAutocompleteString", "lastWord", "allOptions", "", "console", "getAutocompleteString$core", "getAutocompleteStringFromStrings", "joinToStringLimited", "separator", "prefix", "postfix", "limit", "", "transform", "Lkotlin/Function1;", "core"})
    @SourceDebugExtension(value={"SMAP\nCliInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliInput.kt\ncom/unciv/ui/screens/devconsole/CliInput$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n161#2,6:293\n173#2,6:299\n479#3:305\n614#3:309\n777#4:306\n873#4,2:307\n1807#4,3:310\n1807#4,3:313\n1586#4:316\n1661#4,3:317\n*S KotlinDebug\n*F\n+ 1 CliInput.kt\ncom/unciv/ui/screens/devconsole/CliInput$Companion\n*L\n212#1:293,6\n213#1:299,6\n254#1:305\n270#1:309\n262#1:306\n262#1:307,2\n277#1:310,3\n278#1:313,3\n286#1:316\n286#1:317,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CliInput getEmpty() {
            return empty;
        }

        private final boolean hasLeadingQuote(String $this$hasLeadingQuote) {
            return StringsKt.startsWith$default((CharSequence)$this$hasLeadingQuote, '\"', false, 2, null);
        }

        private final String toDashedRepresentation(String $this$toDashedRepresentation) {
            String string = this.removeOuterQuotes($this$toDashedRepresentation).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            return StringsKt.replace$default(string, " ", "-", false, 4, null);
        }

        private final String removeOuterQuotes(String $this$removeOuterQuotes) {
            return StringsKt.removeSuffix(StringsKt.removePrefix($this$removeOuterQuotes, (CharSequence)"\""), (CharSequence)"\"");
        }

        private final String toQuotedRepresentation(String $this$toQuotedRepresentation) {
            int n;
            int start2;
            StringBuilder sb;
            block6: {
                int n2;
                int n3;
                block5: {
                    sb = new StringBuilder($this$toQuotedRepresentation.length());
                    CharSequence $this$indexOfFirst$iv = $this$toQuotedRepresentation;
                    boolean $i$f$indexOfFirst = false;
                    n3 = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n3; ++index$iv) {
                        char p0 = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!this.charIsNotAQuote(p0)) continue;
                        n2 = index$iv;
                        break block5;
                    }
                    n2 = -1;
                }
                start2 = RangesKt.coerceAtLeast(n2, 0);
                CharSequence $this$indexOfLast$iv = $this$toQuotedRepresentation;
                boolean $i$f$indexOfLast = false;
                n3 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n3) {
                    do {
                        int index$iv = n3--;
                        char p0 = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!this.charIsNotAQuote(p0)) continue;
                        n = index$iv;
                        break block6;
                    } while (0 <= n3);
                }
                n = -1;
            }
            int end = n + 1;
            if (end > start2) {
                sb.append(Character.toTitleCase($this$toQuotedRepresentation.charAt(start2)));
                if (end > start2 + 1) {
                    String string = $this$toQuotedRepresentation.substring(start2 + 1, end);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    CharSequence charSequence = string;
                    Regex regex = repeatedWhiteSpaceRegex;
                    String string2 = "";
                    sb.append(regex.replace(charSequence, string2));
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        private final boolean charIsNotAQuote(char c) {
            return c != '\"';
        }

        private static /* synthetic */ void getSplitStringRegex$annotations() {
        }

        @NotNull
        public final List<CliInput> splitToCliInput(@NotNull String $this$splitToCliInput) {
            Intrinsics.checkNotNullParameter($this$splitToCliInput, "<this>");
            return SequencesKt.toList(SequencesKt.map(Regex.findAll$default(splitStringRegex, $this$splitToCliInput, 0, 2, null), Companion::splitToCliInput$lambda$0));
        }

        @NotNull
        public final CliInput orEmpty(@Nullable CliInput $this$orEmpty) {
            CliInput cliInput = $this$orEmpty;
            if (cliInput == null) {
                cliInput = this.getEmpty();
            }
            return cliInput;
        }

        public final /* synthetic */ <T extends IRulesetObject> T findCliInput(DevConsolePopup $this$findCliInput, CliInput param) {
            Intrinsics.checkNotNullParameter($this$findCliInput, "<this>");
            Intrinsics.checkNotNullParameter(param, "param");
            boolean $i$f$findCliInput = false;
            Sequence<IRulesetObject> $this$filterIsInstance$iv = $this$findCliInput.getGameInfo$core().getRuleset().allRulesetObjects();
            boolean $i$f$filterIsInstance = false;
            Intrinsics.needClassReification();
            Sequence<IRulesetObject> sequence = SequencesKt.filter($this$filterIsInstance$iv, Companion$findCliInput$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<T of com.unciv.ui.screens.devconsole.CliInput.Companion.findCliInput>");
            return (T)param.findOrNull(sequence);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getAutocompleteString$core(@NotNull CliInput lastWord, @NotNull Iterable<CliInput> allOptions, @NotNull DevConsolePopup console) {
            void $this$sortedBy$iv;
            Sequence<CliInput> $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(lastWord, "lastWord");
            Intrinsics.checkNotNullParameter(allOptions, "allOptions");
            Intrinsics.checkNotNullParameter(console, "console");
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            console.showResponse$core(null, color);
            Iterable<CliInput> $this$filter$iv = allOptions;
            boolean $i$f$filter = false;
            Iterable<CliInput> iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                CliInput it = (CliInput)element$iv$iv;
                boolean bl = false;
                if (!it.startsWith(lastWord)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List matchingOptions = (List)destination$iv$iv;
            if (matchingOptions.isEmpty()) {
                return null;
            }
            if (matchingOptions.size() == 1) {
                return CliInput.getAutocompleteString$default((CliInput)CollectionsKt.first(matchingOptions), lastWord.getMethod(), 0, " ", 2, null);
            }
            Method showMethod = lastWord.getMethod().or(((CliInput)CollectionsKt.first(matchingOptions)).getMethod());
            $this$filterTo$iv$iv = SequencesKt.map(CollectionsKt.asSequence(matchingOptions), arg_0 -> Companion.getAutocompleteString$lambda$1(showMethod, arg_0));
            boolean $i$f$sortedBy = false;
            String message = com.unciv.ui.screens.devconsole.CliInput$Companion.joinToStringLimited$default(this, SequencesKt.asIterable(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    CliInput it = (CliInput)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getContent());
                    it = (CliInput)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getContent()));
                }
            })), null, "Matching completions: ", null, 0, null, 29, null);
            Color color2 = Color.LIME.lerp(Color.OLIVE.cpy(), 0.5f);
            Intrinsics.checkNotNullExpressionValue(color2, "lerp(...)");
            console.showResponse$core(message, color2);
            CliInput firstOption = (CliInput)CollectionsKt.first(matchingOptions);
            String string = firstOption.getDashedRepresentation();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                CliInput it;
                boolean bl;
                boolean $i$f$any;
                Iterable $this$any$iv;
                char c;
                int index;
                block11: {
                    index = i;
                    c = string.charAt(i);
                    $this$any$iv = matchingOptions;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (CliInput)element$iv;
                            boolean bl2 = false;
                            if (!(StringsKt.getLastIndex(it.getDashedRepresentation()) < index)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    boolean bl3;
                    block12: {
                        $this$any$iv = matchingOptions;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (CliInput)element$iv;
                                boolean bl4 = false;
                                if (!(it.getDashedRepresentation().charAt(index) != c)) continue;
                                bl3 = true;
                                break block12;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                }
                return CliInput.getAutocompleteString$default(firstOption, lastWord.getMethod(), index, null, 4, null);
            }
            return CliInput.getAutocompleteString$default(firstOption, lastWord.getMethod(), 0, null, 6, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmName(name="getAutocompleteStringFromStrings")
        @Nullable
        public final String getAutocompleteStringFromStrings(@NotNull CliInput lastWord, @NotNull Iterable<String> allOptions, @NotNull DevConsolePopup console) {
            Collection<CliInput> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(lastWord, "lastWord");
            Intrinsics.checkNotNullParameter(allOptions, "allOptions");
            Intrinsics.checkNotNullParameter(console, "console");
            Iterable<String> iterable = allOptions;
            CliInput cliInput = lastWord;
            Companion companion = this;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CliInput((String)it, null, 2, null));
            }
            collection = (List)destination$iv$iv;
            return companion.getAutocompleteString$core(cliInput, (Iterable<CliInput>)collection, console);
        }

        private final <T> String joinToStringLimited(Iterable<? extends T> $this$joinToStringLimited, String separator, String prefix, String postfix, int limit, Function1<? super T, String> transform2) {
            return CollectionsKt.joinToString($this$joinToStringLimited, separator, prefix, postfix, limit, "... (" + (CollectionsKt.count($this$joinToStringLimited) - limit) + " not shown)", transform2);
        }

        static /* synthetic */ String joinToStringLimited$default(Companion companion, Iterable iterable, String string, String string2, String string3, int n, Function1 function1, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = ", ";
            }
            if ((n2 & 2) != 0) {
                string2 = "";
            }
            if ((n2 & 4) != 0) {
                string3 = "";
            }
            if ((n2 & 8) != 0) {
                n = 42;
            }
            if ((n2 & 0x10) != 0) {
                function1 = null;
            }
            return companion.joinToStringLimited(iterable, string, string2, string3, n, function1);
        }

        private static final CliInput splitToCliInput$lambda$0(MatchResult it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return new CliInput(it.getValue(), null, 2, null);
        }

        private static final CliInput getAutocompleteString$lambda$1(Method $showMethod, CliInput it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.toMethod($showMethod);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0004j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/devconsole/CliInput$Method;", "", "<init>", "(Ljava/lang/String;I)V", "Dashed", "Quoted", "or", "other", "and", "core"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method Dashed = new Method();
        public static final /* enum */ Method Quoted = new Method();
        private static final /* synthetic */ Method[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final Method or(@NotNull Method other) {
            Intrinsics.checkNotNullParameter((Object)other, "other");
            return this == Dashed && other == Dashed ? Dashed : Quoted;
        }

        @NotNull
        public final Method and(@NotNull Method other) {
            Intrinsics.checkNotNullParameter((Object)other, "other");
            return this == Quoted && other == Quoted ? Quoted : Dashed;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        @NotNull
        public static EnumEntries<Method> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = methodArray = new Method[]{Method.Dashed, Method.Quoted};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.Dashed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.Quoted.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

