/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTab;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0013\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u00160\u0015H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditStartsTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/IMapEditorEditSubTabs;", "editTab", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "<init>", "(Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;Lcom/unciv/models/ruleset/Ruleset;)V", "collator", "Ljava/text/Collator;", "usageOptionGroup", "Lcom/badlogic/gdx/scenes/scene2d/ui/ButtonGroup;", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "spectatorToAnyCiv", "", "addNations", "", "firstNation", "Lcom/unciv/models/ruleset/nation/Nation;", "allowedNations", "Lkotlin/sequences/Sequence;", "Lkotlin/jvm/internal/EnhancedNullability;", "getNations", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "addUsage", "isDisabled", "", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorEditSubTabs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorEditSubTabs.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditStartsTab\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,494:1\n1#2:495\n*E\n"})
public final class MapEditorEditStartsTab
extends Table
implements IMapEditorEditSubTabs {
    @NotNull
    private final MapEditorEditTab editTab;
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final Collator collator;
    @NotNull
    private final ButtonGroup<CheckBox> usageOptionGroup;

    public MapEditorEditStartsTab(@NotNull MapEditorEditTab editTab, @NotNull Ruleset ruleset) {
        block0: {
            Intrinsics.checkNotNullParameter(editTab, "editTab");
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            super(BaseScreen.Companion.getSkin());
            this.editTab = editTab;
            this.ruleset = ruleset;
            this.collator = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
            this.usageOptionGroup = new ButtonGroup();
            this.top();
            this.defaults().pad(10.0f).fillX().left();
            Nation nation = SequencesKt.firstOrNull(this.allowedNations());
            if (nation == null) break block0;
            Nation it = nation;
            boolean bl = false;
            this.addNations(it);
        }
    }

    private final String spectatorToAnyCiv(String $this$spectatorToAnyCiv) {
        return Intrinsics.areEqual($this$spectatorToAnyCiv, "Spectator") ? "Any Civ" : $this$spectatorToAnyCiv;
    }

    /*
     * WARNING - void declaration
     */
    private final void addNations(Nation firstNation) {
        void $this$addNations_u24lambda_u240;
        Actor actor;
        String eraserIcon = "Nation/" + firstNation.getName();
        FormattedLine eraser = new FormattedLine("Remove starting locations", null, eraserIcon, null, 0.0f, 24, 0, 0, 0.0f, null, false, false, false, true, 8154, null);
        Actor actor2 = actor = FormattedLine.render$default(eraser, 0.0f, null, 2, null);
        MapEditorEditStartsTab mapEditorEditStartsTab = this;
        boolean bl = false;
        ActivationExtensionsKt.onClick((Actor)$this$addNations_u24lambda_u240, () -> MapEditorEditStartsTab.addNations$lambda$0$0(this, eraserIcon));
        mapEditorEditStartsTab.add(actor).padBottom(0.0f).row();
        this.addUsage();
        this.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, this.getNations(), 0.0f, 0.0f, FormattedLine.IconDisplay.NoLink, arg_0 -> MapEditorEditStartsTab.addNations$lambda$1(this, arg_0), 6, null)).padTop(0.0f).row();
    }

    private final Sequence<Nation> allowedNations() {
        Collection<Nation> collection = this.ruleset.getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)collection), MapEditorEditStartsTab::allowedNations$lambda$0);
    }

    private final Iterable<FormattedLine> getNations() {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                Nation it = (Nation)a;
                boolean bl = false;
                boolean bl2 = !it.isSpectator();
                it = (Nation)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, !it.isSpectator());
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Nation it = (Nation)a;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it.isCityState());
                    it = (Nation)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.isCityState());
                }
                return n;
            }
        };
        Comparator comparator2 = this.collator;
        return SequencesKt.asIterable(SequencesKt.map(SequencesKt.sortedWith(this.allowedNations(), new Comparator(comparator, comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Nation nation = (Nation)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Nation it = (Nation)b;
                    String string = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                    bl = false;
                    String string2 = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }), arg_0 -> MapEditorEditStartsTab.getNations$lambda$3(this, arg_0)));
    }

    private final void addUsage() {
        Table table2 = new Table();
        table2.defaults().pad(5.0f);
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Use for new game \"Select players\" button:")).colspan(3).row();
        TileMap.StartingLocation.Usage defaultUsage = TileMap.StartingLocation.Usage.Companion.getDefault();
        for (TileMap.StartingLocation.Usage usage : TileMap.StartingLocation.Usage.getEntries()) {
            CheckBox checkBox = new CheckBox(TranslationsKt.tr$default(usage.getLabel(), false, false, 3, null), this.getSkin());
            table2.add((Actor)checkBox);
            this.usageOptionGroup.add((CheckBox)((Button)checkBox));
            checkBox.setChecked(usage == defaultUsage);
        }
        this.add((Actor)table2).row();
    }

    @Override
    public boolean isDisabled() {
        return SequencesKt.none(this.allowedNations());
    }

    private static final Unit addNations$lambda$0$0$0(Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        tile.getTileMap().removeStartingLocations(tile.getPosition());
        return Unit.INSTANCE;
    }

    private static final Unit addNations$lambda$0$0(MapEditorEditStartsTab this$0, String $eraserIcon) {
        this$0.editTab.setBrush("Remove", $eraserIcon, MapEditorEditTab.BrushHandlerType.Direct, "", true, MapEditorEditStartsTab::addNations$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit addNations$lambda$1$0(String $it, TileMap.StartingLocation.Usage $selectedUsage, Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!tile.getTileMap().addStartingLocation($it, tile, $selectedUsage)) {
            tile.getTileMap().removeStartingLocation($it, tile);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addNations$lambda$1(MapEditorEditStartsTab this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        UncivGame.Companion.getCurrent().getMusicController().chooseTrack(it, "Theme", MusicTrackChooserFlags.Companion.getSetSpecific());
        String icon = "Nation/" + it;
        String pediaLink = Intrinsics.areEqual(it, "Spectator") ? "" : icon;
        Nation nation = this$0.ruleset.getNations().get(it);
        boolean isMajorCiv = nation != null ? nation.isMajorCiv() : false;
        TileMap.StartingLocation.Usage selectedUsage = isMajorCiv ? (TileMap.StartingLocation.Usage)((Object)TileMap.StartingLocation.Usage.getEntries().get(this$0.usageOptionGroup.getCheckedIndex())) : TileMap.StartingLocation.Usage.Normal;
        MapEditorEditTab.setBrush$default(this$0.editTab, this$0.spectatorToAnyCiv(it), icon, MapEditorEditTab.BrushHandlerType.Direct, pediaLink, false, arg_0 -> MapEditorEditStartsTab.addNations$lambda$1$0(it, selectedUsage, arg_0), 16, null);
        return Unit.INSTANCE;
    }

    private static final boolean allowedNations$lambda$0(Nation it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return IHasUniques.hasUnique$default(it, UniqueType.ExcludedFromMapEditor, null, 2, null);
    }

    private static final FormattedLine getNations$lambda$3(MapEditorEditStartsTab this$0, Nation it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new FormattedLine('[' + this$0.spectatorToAnyCiv(it.getName()) + "] starting location", it.getName(), "Nation/" + it.getName(), null, 0.0f, 24, 0, 0, 0.0f, null, false, false, false, false, 16344, null);
    }
}

