/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.modmanager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.unciv.UncivGame;
import com.unciv.logic.github.Github;
import com.unciv.logic.github.GithubAPI;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.validation.ModCompatibility;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.extensions.UncivDateFormat;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.modmanager.ModManagementScreen;
import com.unciv.ui.screens.modmanager.ModUIData;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015JL\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u001dJ(\u0010!\u001a\u00020\u00112\b\b\u0002\u0010\"\u001a\u00020\r2\u0016\b\u0002\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0011\u0018\u00010$J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(J*\u0010)\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0018\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0006H\u0002R.\u0010\u0004\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005j\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/unciv/ui/screens/modmanager/ModInfoAndActionPane;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "<init>", "()V", "repoUrlToPreviewImage", "Ljava/util/HashMap;", "", "Lcom/badlogic/gdx/graphics/Texture;", "Lkotlin/collections/HashMap;", "imageHolder", "sizeLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "isBuiltin", "", "currentRepoName", "enableVisualCheckBox", "update", "", "repo", "Lcom/unciv/logic/github/GithubAPI$Repo;", "mod", "Lcom/unciv/models/ruleset/Ruleset;", "isLocal", "modName", "repoUrl", "defaultBranch", "updatedAt", "author", "modSize", "", "avatarUrl", "updateSize", "size", "addVisualCheckBox", "startsOutChecked", "changeAction", "Lkotlin/Function1;", "addUpdateModButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "modInfo", "Lcom/unciv/ui/screens/modmanager/ModUIData;", "addPreviewImage", "addLocalPreviewImage", "addUncivLogo", "setTextureAsPreview", "texture", "core"})
@SourceDebugExtension(value={"SMAP\nModInfoAndActionPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModInfoAndActionPane.kt\ncom/unciv/ui/screens/modmanager/ModInfoAndActionPane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1807#2,3:199\n1#3:202\n*S KotlinDebug\n*F\n+ 1 ModInfoAndActionPane.kt\ncom/unciv/ui/screens/modmanager/ModInfoAndActionPane\n*L\n64#1:199,3\n*E\n"})
public final class ModInfoAndActionPane
extends Table {
    @NotNull
    private final HashMap<String, Texture> repoUrlToPreviewImage = new HashMap();
    @NotNull
    private final Table imageHolder = new Table();
    @NotNull
    private final Label sizeLabel = Scene2dExtensionsKt.toLabel("");
    private boolean isBuiltin;
    @NotNull
    private String currentRepoName = "";
    private boolean enableVisualCheckBox;

    public ModInfoAndActionPane() {
        this.defaults().pad(10.0f);
    }

    public final void update(@NotNull GithubAPI.Repo repo) {
        Intrinsics.checkNotNullParameter(repo, "repo");
        this.isBuiltin = false;
        this.enableVisualCheckBox = false;
        this.update(false, repo.getName(), repo.getHtml_url(), repo.getDefault_branch(), repo.getPushed_at(), repo.getOwner().getLogin(), repo.getSize(), repo.getOwner().getAvatar_url());
    }

    /*
     * Unable to fully structure code
     */
    public final void update(@NotNull Ruleset mod) {
        block5: {
            Intrinsics.checkNotNullParameter(mod, "mod");
            modName = mod.getName();
            modOptions = mod.getModOptions();
            v0 = this;
            if (!(((CharSequence)modOptions.getModUrl()).length() == 0)) ** GOTO lbl-1000
            var4_4 = BaseRuleset.getEntries();
            var10_5 = v0;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (BaseRuleset)element$iv;
                    $i$a$-any-ModInfoAndActionPane$update$1 = false;
                    if (!Intrinsics.areEqual(it.getFullName(), modName)) continue;
                    v1 = true;
                    break block5;
                }
                v1 = false;
            }
        }
        var11_11 = v1;
        v0 = var10_5;
        if (var11_11) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v0.isBuiltin = v2;
        this.enableVisualCheckBox = ModCompatibility.INSTANCE.isAudioVisualMod(mod);
        ModInfoAndActionPane.update$default(this, true, modName, modOptions.getModUrl(), modOptions.getDefaultBranch(), modOptions.getLastUpdated(), modOptions.getAuthor(), modOptions.getModSize(), null, 128, null);
    }

    private final void update(boolean isLocal, String modName, String repoUrl, String defaultBranch, String updatedAt, String author, int modSize, String avatarUrl) {
        this.clear();
        this.currentRepoName = modName;
        this.imageHolder.clear();
        if (this.isBuiltin) {
            this.addUncivLogo(modName);
        } else if (isLocal) {
            this.addLocalPreviewImage(modName);
        } else {
            this.addPreviewImage(modName, repoUrl, defaultBranch, avatarUrl);
        }
        this.add((Actor)this.imageHolder).row();
        if (((CharSequence)author).length() > 0) {
            this.add((Actor)Scene2dExtensionsKt.toLabel("Author: [" + author + ']')).row();
        }
        this.updateSize(modSize);
        this.add((Actor)this.sizeLabel).padBottom(15.0f).row();
        if (((CharSequence)repoUrl).length() > 0) {
            TextButton githubButton = Scene2dExtensionsKt.toTextButton$default("Open Github page", null, false, 3, null);
            ActivationExtensionsKt.onClick(githubButton, () -> ModInfoAndActionPane.update$lambda$1(repoUrl));
            ActivationExtensionsKt.onRightClick$default(githubButton, null, () -> ModInfoAndActionPane.update$lambda$2(repoUrl, this), 1, null);
            this.add((Actor)githubButton).row();
        }
        if (((CharSequence)updatedAt).length() > 0) {
            Date date = UncivDateFormat.INSTANCE.parseDate(updatedAt);
            String updateString = "{Updated}: " + UncivDateFormat.INSTANCE.formatDate(date);
            this.add((Actor)Scene2dExtensionsKt.toLabel(updateString)).row();
        }
    }

    static /* synthetic */ void update$default(ModInfoAndActionPane modInfoAndActionPane, boolean bl, String string, String string2, String string3, String string4, String string5, int n, String string6, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            string6 = null;
        }
        modInfoAndActionPane.update(bl, string, string2, string3, string4, string5, n, string6);
    }

    public final void updateSize(int size) {
        String text2 = size <= 0 ? "" : (size < 2048 ? "Size: [" + size + "] kB" : "Size: [" + (size + 512) / 1024 + "] MB");
        this.sizeLabel.setText(TranslationsKt.tr$default(text2, false, false, 3, null));
    }

    public final void addVisualCheckBox(boolean startsOutChecked, @Nullable Function1<? super Boolean, Unit> changeAction) {
        if (this.enableVisualCheckBox) {
            this.add((Actor)Scene2dExtensionsKt.toCheckBox("Permanent audiovisual mod", startsOutChecked, changeAction)).row();
        }
    }

    public static /* synthetic */ void addVisualCheckBox$default(ModInfoAndActionPane modInfoAndActionPane, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        modInfoAndActionPane.addVisualCheckBox(bl, function1);
    }

    @Nullable
    public final TextButton addUpdateModButton(@NotNull ModUIData modInfo) {
        Intrinsics.checkNotNullParameter(modInfo, "modInfo");
        if (!modInfo.getHasUpdate()) {
            return null;
        }
        TextButton updateModTextbutton = Scene2dExtensionsKt.toTextButton$default("Update [" + ModManagementScreen.Companion.cleanModName(modInfo.getName()) + ']', null, false, 3, null);
        this.add((Actor)updateModTextbutton).row();
        return updateModTextbutton;
    }

    private final void addPreviewImage(String modName, String repoUrl, String defaultBranch, String avatarUrl) {
        if (!StringsKt.startsWith$default(repoUrl, "http", false, 2, null)) {
            return;
        }
        if (this.repoUrlToPreviewImage.containsKey(repoUrl)) {
            Texture texture = this.repoUrlToPreviewImage.get(repoUrl);
            if (texture != null) {
                this.setTextureAsPreview(texture, modName);
            }
            return;
        }
        Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(repoUrl, defaultBranch, avatarUrl, this, modName, null){
            int label;
            final /* synthetic */ String $repoUrl;
            final /* synthetic */ String $defaultBranch;
            final /* synthetic */ String $avatarUrl;
            final /* synthetic */ ModInfoAndActionPane this$0;
            final /* synthetic */ String $modName;
            {
                this.$repoUrl = $repoUrl;
                this.$defaultBranch = $defaultBranch;
                this.$avatarUrl = $avatarUrl;
                this.this$0 = $receiver;
                this.$modName = $modName;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        v0 = Github.INSTANCE.getPreviewImageOrNull(this.$repoUrl, this.$defaultBranch, this.$avatarUrl, this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((imagePixmap = (Pixmap)v0) == null) {
                            ((Map)ModInfoAndActionPane.access$getRepoUrlToPreviewImage$p(this.this$0)).put(this.$repoUrl, null);
                            return Unit.INSTANCE;
                        }
                        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(imagePixmap, this.this$0, this.$repoUrl, this.$modName, null){
                            int label;
                            final /* synthetic */ Pixmap $imagePixmap;
                            final /* synthetic */ ModInfoAndActionPane this$0;
                            final /* synthetic */ String $repoUrl;
                            final /* synthetic */ String $modName;
                            {
                                this.$imagePixmap = $imagePixmap;
                                this.this$0 = $receiver;
                                this.$repoUrl = $repoUrl;
                                this.$modName = $modName;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        Texture texture = new Texture(this.$imagePixmap);
                                        this.$imagePixmap.dispose();
                                        ((Map)ModInfoAndActionPane.access$getRepoUrlToPreviewImage$p(this.this$0)).put(this.$repoUrl, texture);
                                        ModInfoAndActionPane.access$setTextureAsPreview(this.this$0, texture, this.$modName);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void addLocalPreviewImage(String modName) {
        block4: {
            Object[] objectArray;
            FileHandle fileHandle;
            FileHandle modFolder = UncivGame.Companion.getCurrent().getFiles().getModFolder(modName);
            FileHandle it = fileHandle = modFolder.child("preview.jpg");
            boolean bl = false;
            Object object = it.exists() ? fileHandle : null;
            if (object == null) {
                Object[] it2 = objectArray = modFolder.child("preview.png");
                boolean bl2 = false;
                object = it2.exists() ? objectArray : null;
                if (object == null) {
                    return;
                }
            }
            FileHandle previewFile = object;
            try {
                this.setTextureAsPreview(new Texture(previewFile), modName);
            }
            catch (Throwable ex) {
                Throwable cause = ex instanceof GdxRuntimeException ? ex.getCause() : ex;
                objectArray = new Object[]{previewFile.path(), cause};
                Log.INSTANCE.debug("Could not load local preview file %s: %s", objectArray);
                if (!(cause instanceof IOException)) break block4;
                previewFile.delete();
            }
        }
    }

    private final void addUncivLogo(String modName) {
        this.setTextureAsPreview(new Texture(Gdx.files.internal("ExtraImages/banner.png")), modName);
    }

    private final void setTextureAsPreview(Texture texture, String modName) {
        Image image = new Image(texture);
        if (!Intrinsics.areEqual(modName, this.currentRepoName)) {
            return;
        }
        Cell<Actor> cell = this.imageHolder.add((Actor)image);
        int largestImageSize = Math.max(texture.getWidth(), texture.getHeight());
        if ((float)largestImageSize > 200.0f) {
            float resizeRatio = 200.0f / (float)largestImageSize;
            cell.size((float)texture.getWidth() * resizeRatio, (float)texture.getHeight() * resizeRatio);
        }
    }

    private static final Unit update$lambda$1(String $repoUrl) {
        Gdx.net.openURI($repoUrl);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$2(String $repoUrl, ModInfoAndActionPane this$0) {
        Gdx.app.getClipboard().setContents($repoUrl);
        Stage stage = this$0.getStage();
        Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
        new ToastPopup("Link copied to clipboard", stage, 0L, 4, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ HashMap access$getRepoUrlToPreviewImage$p(ModInfoAndActionPane $this) {
        return $this.repoUrlToPreviewImage;
    }

    public static final /* synthetic */ void access$setTextureAsPreview(ModInfoAndActionPane $this, Texture texture, String modName) {
        $this.setTextureAsPreview(texture, modName);
    }
}

