/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.StatMap;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u0016J\u0014\u0010\u001e\u001a\u00020\u0016*\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u001c\u0010 \u001a\u00020\u0016*\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\u0016*\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\tH\u0002J\u001c\u0010%\u001a\u00020\u0016*\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\f\u0010*\u001a\u00020\u0016*\u00020\tH\u0002J\b\u0010+\u001a\u00020\tH\u0002J\b\u0010,\u001a\u00020\tH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/unciv/ui/screens/overviewscreen/StatsOverviewTab;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;)V", "happinessTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "unhappinessTable", "Lcom/unciv/ui/screens/overviewscreen/StatsOverviewTab$UnhappinessTable;", "goldAndSliderTable", "goldTable", "scienceTable", "cultureTable", "faithTable", "greatPeopleTable", "scoreTable", "isReligionEnabled", "", "activated", "", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "update", "addHeading", "label", "addLabeledValue", "value", "", "addTotal", "updateHappinessTable", "updateStatTable", "stat", "Lcom/unciv/models/stats/Stat;", "statMap", "Lcom/unciv/models/stats/StatMap;", "addGoldSlider", "updateGreatPeopleTable", "updateScoreTable", "UnhappinessTable", "core"})
@SourceDebugExtension(value={"SMAP\nStatsOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/StatsOverviewTab\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1011#2:244\n1041#2,3:245\n1044#2,3:255\n383#3,7:248\n139#4,10:258\n221#4:268\n222#4:270\n149#4:271\n1#5:269\n*S KotlinDebug\n*F\n+ 1 StatsOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/StatsOverviewTab\n*L\n74#1:244\n74#1:245,3\n74#1:255,3\n74#1:248,7\n75#1:258,10\n75#1:268\n75#1:270\n75#1:271\n75#1:269\n*E\n"})
public final class StatsOverviewTab
extends EmpireOverviewTab {
    @NotNull
    private final Table happinessTable;
    @NotNull
    private final UnhappinessTable unhappinessTable;
    @NotNull
    private final Table goldAndSliderTable;
    @NotNull
    private final Table goldTable;
    @NotNull
    private final Table scienceTable;
    @NotNull
    private final Table cultureTable;
    @NotNull
    private final Table faithTable;
    @NotNull
    private final Table greatPeopleTable;
    @NotNull
    private final Table scoreTable;
    private final boolean isReligionEnabled;

    /*
     * WARNING - void declaration
     */
    public StatsOverviewTab(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen) {
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        this.happinessTable = new Table();
        this.unhappinessTable = new UnhappinessTable();
        this.goldAndSliderTable = new Table();
        this.goldTable = new Table();
        this.scienceTable = new Table();
        this.cultureTable = new Table();
        this.faithTable = new Table();
        this.greatPeopleTable = new Table();
        this.scoreTable = new Table();
        this.isReligionEnabled = this.getGameInfo().isReligionEnabled();
        float tablePadding = 30.0f;
        this.defaults().pad(tablePadding).top();
        this.happinessTable.defaults().pad(5.0f);
        this.goldTable.defaults().pad(5.0f);
        this.scienceTable.defaults().pad(5.0f);
        this.cultureTable.defaults().pad(5.0f);
        this.faithTable.defaults().pad(5.0f);
        this.greatPeopleTable.defaults().pad(5.0f);
        this.scoreTable.defaults().pad(5.0f);
        this.unhappinessTable.update();
        this.goldAndSliderTable.add((Actor)this.goldTable).row();
        if (IHasUniques.hasUnique$default(this.getGameInfo().getRuleset().getModOptions(), UniqueType.ConvertGoldToScience, null, 2, null)) {
            this.addGoldSlider(this.goldAndSliderTable);
        }
        this.update();
        Sequence allStatTables2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Table>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ StatsOverviewTab this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield(StatsOverviewTab.access$getHappinessTable$p(this.this$0), this);
                        if (v0 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if (StatsOverviewTab.access$getUnhappinessTable$p(this.this$0).getShow()) {
                            this.L$0 = $this$sequence;
                            this.label = 2;
                            v1 = $this$sequence.yield(StatsOverviewTab.access$getUnhappinessTable$p(this.this$0), this);
                            if (v1 == var3_3) {
                                return var3_3;
                            }
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 3;
                        v2 = $this$sequence.yield(StatsOverviewTab.access$getGoldAndSliderTable$p(this.this$0), this);
                        if (v2 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl34
                    }
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl34:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 4;
                        v3 = $this$sequence.yield(StatsOverviewTab.access$getScienceTable$p(this.this$0), this);
                        if (v3 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl43
                    }
                    case 4: {
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl43:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 5;
                        v4 = $this$sequence.yield(StatsOverviewTab.access$getCultureTable$p(this.this$0), this);
                        if (v4 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl52
                    }
                    case 5: {
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl52:
                        // 2 sources

                        if (StatsOverviewTab.access$isReligionEnabled$p(this.this$0)) {
                            this.L$0 = $this$sequence;
                            this.label = 6;
                            v5 = $this$sequence.yield(StatsOverviewTab.access$getFaithTable$p(this.this$0), this);
                            if (v5 == var3_3) {
                                return var3_3;
                            }
                        }
                        ** GOTO lbl62
                    }
                    case 6: {
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl62:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 7;
                        v6 = $this$sequence.yield(StatsOverviewTab.access$getGreatPeopleTable$p(this.this$0), this);
                        if (v6 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl71
                    }
                    case 7: {
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
lbl71:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.label = 8;
                        v7 = $this$sequence.yield(StatsOverviewTab.access$getScoreTable$p(this.this$0), this);
                        if (v7 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl80
                    }
                    case 8: {
                        ResultKt.throwOnFailure($result);
                        v7 = $result;
lbl80:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Table>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Table> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        int optimumColumns = 1;
        for (int numColumns = SequencesKt.count(allStatTables2); 0 < numColumns; --numColumns) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            Sequence sequence = SequencesKt.withIndex(allStatTables2);
            boolean $i$f$groupBy = false;
            void var10_12 = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                IndexedValue it = (IndexedValue)element$iv$iv;
                boolean bl = false;
                Integer key$iv$iv = it.getIndex() % numColumns;
                Object object2 = destination$iv$iv;
                Integer key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$groupByTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Float f;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Map.Entry col = element$iv$iv;
                boolean bl3 = false;
                Iterator iterator3 = ((Iterable)col.getValue()).iterator();
                if (!iterator3.hasNext()) {
                    f = null;
                } else {
                    IndexedValue it = (IndexedValue)iterator3.next();
                    boolean bl4 = false;
                    float f2 = ((Table)it.getValue()).getPrefWidth() + tablePadding * (float)2;
                    while (iterator3.hasNext()) {
                        IndexedValue it2 = (IndexedValue)iterator3.next();
                        $i$a$-maxOfOrNull-StatsOverviewTab$totalWidth$2$1 = false;
                        float f3 = ((Table)it2.getValue()).getPrefWidth() + tablePadding * (float)2;
                        f2 = Math.max(f2, f3);
                    }
                    f = Float.valueOf(f2);
                }
                if (f == null) continue;
                Float it$iv$iv = f;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            float totalWidth = CollectionsKt.sumOfFloat((List)destination$iv$iv);
            if (!(totalWidth < overviewScreen.getStage().getWidth())) continue;
            optimumColumns = numColumns;
            break;
        }
        Iterator iterator4 = SequencesKt.withIndex(allStatTables2).iterator();
        while (iterator4.hasNext()) {
            IndexedValue entry = iterator4.next();
            if (entry.getIndex() % optimumColumns == 0) {
                this.row();
            }
            this.add((Actor)entry.getValue());
        }
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.getOverviewScreen().getGame().getSettings().addCompletedTutorialTask("See your stats breakdown");
        super.activated(index, caption, pager);
    }

    public final void update() {
        StatMap statMap = this.getViewingPlayer().getStats().getStatMapForNextTurn();
        this.updateHappinessTable();
        this.updateStatTable(this.goldTable, Stat.Gold, statMap);
        this.updateStatTable(this.scienceTable, Stat.Science, statMap);
        this.updateStatTable(this.cultureTable, Stat.Culture, statMap);
        if (this.isReligionEnabled) {
            this.updateStatTable(this.faithTable, Stat.Faith, statMap);
        }
        this.updateGreatPeopleTable();
        this.updateScoreTable();
    }

    private final void addHeading(Table $this$addHeading, String label) {
        $this$addHeading.clear();
        $this$addHeading.add((Actor)Scene2dExtensionsKt.toLabel$default(label, null, 24, 0, false, 13, null)).colspan(2).row();
        Scene2dExtensionsKt.addSeparator$default($this$addHeading, null, 0, 0.0f, 7, null);
    }

    private final void addLabeledValue(Table $this$addLabeledValue, String label, float value) {
        int roundedValue = MathKt.roundToInt(value);
        if (roundedValue == 0) {
            return;
        }
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel$default(label, null, 0, 0, true, 7, null)).left();
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel(roundedValue)).right().row();
    }

    private final void addTotal(Table $this$addTotal, float value) {
        $this$addTotal.add((Actor)Scene2dExtensionsKt.toLabel("Total")).left();
        $this$addTotal.add((Actor)Scene2dExtensionsKt.toLabel(MathKt.roundToInt(value))).right();
        $this$addTotal.pack();
    }

    private final Table updateHappinessTable() {
        Table table2;
        Table $this$updateHappinessTable_u24lambda_u240 = table2 = this.happinessTable;
        boolean bl = false;
        this.addHeading($this$updateHappinessTable_u24lambda_u240, "Happiness");
        HashMap<String, Float> happinessBreakdown = this.getViewingPlayer().getStats().getHappinessBreakdown();
        for (Map.Entry entry : ((Map)happinessBreakdown).entrySet()) {
            String key = (String)entry.getKey();
            float value = ((Number)entry.getValue()).floatValue();
            this.addLabeledValue($this$updateHappinessTable_u24lambda_u240, key, value);
        }
        Collection<Float> collection = happinessBreakdown.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        this.addTotal($this$updateHappinessTable_u24lambda_u240, CollectionsKt.sumOfFloat((Iterable<Float>)collection));
        return table2;
    }

    private final void updateStatTable(Table $this$updateStatTable, Stat stat, StatMap statMap) {
        this.addHeading($this$updateStatTable, stat.name());
        float total = 0.0f;
        for (Map.Entry entry : ((Map)statMap).entrySet()) {
            String source = (String)entry.getKey();
            Stats stats = (Stats)entry.getValue();
            this.addLabeledValue($this$updateStatTable, source, stats.get(stat));
            total += stats.get(stat);
        }
        this.addTotal($this$updateStatTable, total);
    }

    private final void addGoldSlider(Table $this$addGoldSlider) {
        Scene2dExtensionsKt.addSeparator$default($this$addGoldSlider, null, 0, 0.0f, 7, null);
        Table sliderTable = new Table();
        sliderTable.add((Actor)Scene2dExtensionsKt.toLabel("Convert gold to science")).row();
        UncivSlider slider2 = new UncivSlider(0.0f, 1.0f, 0.1f, false, false, this.getViewingPlayer().getTech().getGoldPercentConvertedToScience(), null, null, new Function1<Float, String>((Object)UncivSlider.Companion){

            public final String invoke(float p0) {
                return ((UncivSlider.Companion)this.receiver).formatPercent(p0);
            }
        }, arg_0 -> StatsOverviewTab.addGoldSlider$lambda$0(this, arg_0), 216, null);
        slider2.setDisabled(!GUI.INSTANCE.isAllowedChangeState());
        sliderTable.add((Actor)slider2).padTop(15.0f);
        $this$addGoldSlider.add((Actor)sliderTable).colspan(2);
    }

    private final Table updateGreatPeopleTable() {
        Table table2;
        Table $this$updateGreatPeopleTable_u24lambda_u240 = table2 = this.greatPeopleTable;
        boolean bl = false;
        $this$updateGreatPeopleTable_u24lambda_u240.clear();
        Table greatPeopleHeader = new Table();
        Image greatPeopleIcon = ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, "Specialist", 0.0f, 2, null);
        greatPeopleIcon.setColor(Color.ROYAL);
        greatPeopleHeader.add((Actor)greatPeopleIcon).padRight(1.0f).size(24.0f);
        greatPeopleHeader.add((Actor)Scene2dExtensionsKt.toLabel$default("Great person points", null, 24, 0, false, 13, null));
        $this$updateGreatPeopleTable_u24lambda_u240.add((Actor)greatPeopleHeader).colspan(3).row();
        Scene2dExtensionsKt.addSeparator$default($this$updateGreatPeopleTable_u24lambda_u240, null, 0, 0.0f, 7, null);
        $this$updateGreatPeopleTable_u24lambda_u240.add();
        $this$updateGreatPeopleTable_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel("Current points"));
        $this$updateGreatPeopleTable_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel("Points per turn")).row();
        Counter<String> greatPersonPoints = this.getViewingPlayer().getGreatPeople().getGreatPersonPointsCounter();
        Counter<String> greatPersonPointsPerTurn = this.getViewingPlayer().getGreatPeople().getGreatPersonPointsForNextTurn();
        for (Map.Entry entry : ((Map)greatPersonPoints).entrySet()) {
            String greatPerson = (String)entry.getKey();
            int points = ((Number)entry.getValue()).intValue();
            int pointsToGreatPerson = this.getViewingPlayer().getGreatPeople().getPointsRequiredForGreatPerson(greatPerson);
            $this$updateGreatPeopleTable_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel(greatPerson)).left();
            $this$updateGreatPeopleTable_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel("" + points + '/' + pointsToGreatPerson));
            $this$updateGreatPeopleTable_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel(((Number)greatPersonPointsPerTurn.get(greatPerson)).intValue())).right().row();
        }
        Counter<String> greatGeneralPoints = this.getViewingPlayer().getGreatPeople().getGreatGeneralPointsCounter();
        Counter<String> pointsForNextGreatGeneral = this.getViewingPlayer().getGreatPeople().getPointsForNextGreatGeneralCounter();
        for (Map.Entry entry : ((Map)greatGeneralPoints).entrySet()) {
            String unit = (String)entry.getKey();
            int points = ((Number)entry.getValue()).intValue();
            int pointsToGreatGeneral = ((Number)pointsForNextGreatGeneral.get(unit)).intValue();
            $this$updateGreatPeopleTable_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel(unit)).left();
            $this$updateGreatPeopleTable_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel("" + points + '/' + pointsToGreatGeneral));
        }
        $this$updateGreatPeopleTable_u24lambda_u240.pack();
        return table2;
    }

    private final Table updateScoreTable() {
        Table table2;
        Table $this$updateScoreTable_u24lambda_u240 = table2 = this.scoreTable;
        boolean bl = false;
        $this$updateScoreTable_u24lambda_u240.clear();
        Table scoreHeader = new Table();
        Image scoreIcon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Score", null, 2, null);
        scoreIcon.setColor(Color.FIREBRICK);
        scoreHeader.add((Actor)scoreIcon).padRight(1.0f).size(24.0f);
        scoreHeader.add((Actor)Scene2dExtensionsKt.toLabel$default("Score", null, 24, 0, false, 13, null));
        $this$updateScoreTable_u24lambda_u240.add((Actor)scoreHeader).colspan(2).row();
        Scene2dExtensionsKt.addSeparator$default($this$updateScoreTable_u24lambda_u240, null, 0, 0.0f, 7, null);
        HashMap<String, Double> scoreBreakdown = this.getViewingPlayer().calculateScoreBreakdown();
        for (Map.Entry entry : ((Map)scoreBreakdown).entrySet()) {
            String label = (String)entry.getKey();
            double value = ((Number)entry.getValue()).doubleValue();
            this.addLabeledValue($this$updateScoreTable_u24lambda_u240, label, (float)value);
        }
        Collection<Double> collection = scoreBreakdown.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        this.addTotal($this$updateScoreTable_u24lambda_u240, (float)CollectionsKt.sumOfDouble((Iterable<Double>)collection));
        return table2;
    }

    private static final Unit addGoldSlider$lambda$0(StatsOverviewTab this$0, float it) {
        this$0.getViewingPlayer().getTech().setGoldPercentConvertedToScience(it);
        for (City city : this$0.getViewingPlayer().getCities()) {
            CityStats.update$default(city.getCityStats(), null, false, false, null, false, 31, null);
        }
        this$0.update();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Table access$getHappinessTable$p(StatsOverviewTab $this) {
        return $this.happinessTable;
    }

    public static final /* synthetic */ UnhappinessTable access$getUnhappinessTable$p(StatsOverviewTab $this) {
        return $this.unhappinessTable;
    }

    public static final /* synthetic */ Table access$getGoldAndSliderTable$p(StatsOverviewTab $this) {
        return $this.goldAndSliderTable;
    }

    public static final /* synthetic */ Table access$getScienceTable$p(StatsOverviewTab $this) {
        return $this.scienceTable;
    }

    public static final /* synthetic */ Table access$getCultureTable$p(StatsOverviewTab $this) {
        return $this.cultureTable;
    }

    public static final /* synthetic */ boolean access$isReligionEnabled$p(StatsOverviewTab $this) {
        return $this.isReligionEnabled;
    }

    public static final /* synthetic */ Table access$getFaithTable$p(StatsOverviewTab $this) {
        return $this.faithTable;
    }

    public static final /* synthetic */ Table access$getScoreTable$p(StatsOverviewTab $this) {
        return $this.scoreTable;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/overviewscreen/StatsOverviewTab$UnhappinessTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "<init>", "(Lcom/unciv/ui/screens/overviewscreen/StatsOverviewTab;)V", "show", "", "getShow", "()Z", "uniques", "", "Lcom/unciv/models/ruleset/unique/Unique;", "update", "", "core"})
    @SourceDebugExtension(value={"SMAP\nStatsOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/StatsOverviewTab$UnhappinessTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,243:1\n1586#2:244\n1661#2,3:245\n614#3:248\n*S KotlinDebug\n*F\n+ 1 StatsOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/StatsOverviewTab$UnhappinessTable\n*L\n158#1:244\n158#1:245,3\n144#1:248\n*E\n"})
    public final class UnhappinessTable
    extends Table {
        private final boolean show;
        @NotNull
        private final Set<Unique> uniques;

        public UnhappinessTable() {
            this.defaults().pad(5.0f);
            UniqueType[] uniqueTypeArray = new UniqueType[]{UniqueType.ConditionalWhenAboveAmountStatResource, UniqueType.ConditionalWhenBetweenStatResource, UniqueType.ConditionalWhenBelowAmountStatResource};
            this.uniques = SequencesKt.toSet(SequencesKt.filterNot(SequencesKt.flatMap(SequencesKt.sequenceOf(uniqueTypeArray), arg_0 -> UnhappinessTable._init_$lambda$0(StatsOverviewTab.this, arg_0)), UnhappinessTable::_init_$lambda$1));
            this.show = !((Collection)this.uniques).isEmpty();
        }

        public final boolean getShow() {
            return this.show;
        }

        /*
         * WARNING - void declaration
         */
        public final void update() {
            Collection<FormattedLine> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.add((Actor)ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, "Malcontent", 0.0f, 2, null)).size(24.0f).right().padRight(1.0f);
            this.add((Actor)Scene2dExtensionsKt.toLabel$default("Unhappiness", null, 24, 0, false, 13, null)).left();
            Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
            Iterable iterable = this.uniques;
            MarkupRenderer markupRenderer = MarkupRenderer.INSTANCE;
            UnhappinessTable unhappinessTable = this;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Unique unique = (Unique)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new FormattedLine((Unique)it, 0, 2, null));
            }
            collection = (List)destination$iv$iv;
            unhappinessTable.add((Actor)MarkupRenderer.render$default(markupRenderer, collection, RangesKt.coerceAtLeast(StatsOverviewTab.this.getOverviewScreen().getStage().getWidth() * 0.25f, StatsOverviewTab.this.greatPeopleTable.getWidth() * 0.8f), 0.0f, FormattedLine.IconDisplay.NoLink, null, 20, null)).colspan(2);
        }

        private static final boolean lambda$0$0(Unique it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return Intrinsics.areEqual(CollectionsKt.last(it.getParams()), "Happiness");
        }

        private static final Sequence _init_$lambda$0(StatsOverviewTab this$0, UniqueType conditionalType) {
            Intrinsics.checkNotNullParameter((Object)conditionalType, "conditionalType");
            Sequence<Unique> $this$sortedBy$iv = SequencesKt.filter(Civilization.getMatchingUniques$default(this$0.getViewingPlayer(), conditionalType, null, 2, null), UnhappinessTable::lambda$0$0);
            boolean $i$f$sortedBy = false;
            return SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Unique it = (Unique)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getType());
                    it = (Unique)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getType()));
                }
            });
        }

        private static final boolean _init_$lambda$1(Unique it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.isHiddenToUsers();
        }
    }
}

