/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.ReligionManager;
import com.unciv.logic.civilization.managers.ReligionState;
import com.unciv.models.Counter;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.BeliefType;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.AskTextPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.ReligionPickerScreenCommon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020#H\u0002J\"\u0010&\u001a\u00020#2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020#0(H\u0002J\b\u0010*\u001a\u00020#H\u0002J\u0018\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u001eH\u0002J\u0010\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\fH\u0002J\"\u00100\u001a\u00020#2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u0010,\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u001eH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/unciv/ui/screens/pickerscreens/ReligiousBeliefsPickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/ReligionPickerScreenCommon;", "choosingCiv", "Lcom/unciv/logic/civilization/Civilization;", "numberOfBeliefsCanChoose", "Lcom/unciv/models/Counter;", "Lcom/unciv/models/ruleset/BeliefType;", "pickIconAndName", "", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/models/Counter;Z)V", "topReligionIcons", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "leftChosenBeliefs", "leftScrollPane", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "rightBeliefsToChoose", "rightScrollPane", "middlePanes", "iconSelection", "Lcom/unciv/ui/screens/pickerscreens/ReligionPickerScreenCommon$Selection;", "displayName", "", "religionName", "beliefsToChoose", "", "Lcom/unciv/ui/screens/pickerscreens/ReligiousBeliefsPickerScreen$BeliefToChoose;", "[Lcom/unciv/ui/screens/pickerscreens/ReligiousBeliefsPickerScreen$BeliefToChoose;", "leftSelection", "leftSelectedIndex", "", "rightSelection", "currentReligion", "Lcom/unciv/models/Religion;", "checkAndEnableRightSideButton", "", "setupChoosableReligionIcons", "setupVisibleReligionIcons", "addIconsScroll", "buttonSetup", "Lkotlin/Function2;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "updateLeftTable", "loadRightTable", "beliefType", "leftButtonIndex", "equalizeAllButtons", "table", "addChoosableBeliefButton", "belief", "Lcom/unciv/models/ruleset/Belief;", "index", "BeliefToChoose", "core"})
@SourceDebugExtension(value={"SMAP\nReligiousBeliefsPickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReligiousBeliefsPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/ReligiousBeliefsPickerScreen\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,271:1\n78#2:272\n99#2,2:273\n101#2,3:279\n635#2,3:304\n1586#3:275\n1661#3,3:276\n1807#3,3:287\n777#3:290\n873#3,2:291\n2792#3,3:301\n37#4,2:282\n13225#5,2:284\n13225#5,2:293\n11705#5:297\n12052#5,3:298\n1#6:286\n1276#7,2:295\n*S KotlinDebug\n*F\n+ 1 ReligiousBeliefsPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/ReligiousBeliefsPickerScreen\n*L\n50#1:272\n50#1:273,2\n50#1:279,3\n130#1:304,3\n50#1:275\n50#1:276,3\n161#1:287,3\n201#1:290\n201#1:291,2\n129#1:301,3\n50#1:282,2\n88#1:284,2\n213#1:293,2\n82#1:297\n82#1:298,3\n224#1:295,2\n*E\n"})
public final class ReligiousBeliefsPickerScreen
extends ReligionPickerScreenCommon {
    @NotNull
    private final Table topReligionIcons;
    @NotNull
    private final Table leftChosenBeliefs;
    @NotNull
    private final AutoScrollPane leftScrollPane;
    @NotNull
    private final Table rightBeliefsToChoose;
    @NotNull
    private final AutoScrollPane rightScrollPane;
    @NotNull
    private final Table middlePanes;
    @NotNull
    private ReligionPickerScreenCommon.Selection iconSelection;
    @Nullable
    private String displayName;
    @Nullable
    private String religionName;
    @NotNull
    private final BeliefToChoose[] beliefsToChoose;
    @NotNull
    private ReligionPickerScreenCommon.Selection leftSelection;
    private int leftSelectedIndex;
    @NotNull
    private ReligionPickerScreenCommon.Selection rightSelection;
    @NotNull
    private final Religion currentReligion;

    /*
     * WARNING - void declaration
     */
    public ReligiousBeliefsPickerScreen(@NotNull Civilization choosingCiv, @NotNull Counter<BeliefType> numberOfBeliefsCanChoose, boolean pickIconAndName) {
        void $this$toTypedArray$iv;
        void $this$flatMapTo$iv$iv;
        Collection $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(choosingCiv, "choosingCiv");
        Intrinsics.checkNotNullParameter(numberOfBeliefsCanChoose, "numberOfBeliefsCanChoose");
        super(choosingCiv, true);
        this.topReligionIcons = new Table();
        this.leftChosenBeliefs = new Table();
        this.leftScrollPane = new AutoScrollPane((Actor)this.leftChosenBeliefs, null, 2, null);
        this.rightBeliefsToChoose = new Table();
        this.rightScrollPane = new AutoScrollPane((Actor)this.rightBeliefsToChoose, null, 2, null);
        this.middlePanes = new Table();
        this.iconSelection = new ReligionPickerScreenCommon.Selection();
        Map map2 = numberOfBeliefsCanChoose;
        ReligiousBeliefsPickerScreen religiousBeliefsPickerScreen = this;
        boolean $i$f$flatMap = false;
        void var6_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            Iterable $this$map$iv = RangesKt.until(0, ((Number)entry.getValue()).intValue());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator3).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new BeliefToChoose((BeliefType)((Object)entry.getKey()), null, 2, null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        religiousBeliefsPickerScreen.beliefsToChoose = thisCollection$iv.toArray(new BeliefToChoose[0]);
        this.leftSelection = new ReligionPickerScreenCommon.Selection();
        this.leftSelectedIndex = -1;
        this.rightSelection = new ReligionPickerScreenCommon.Selection();
        Religion religion = choosingCiv.getReligionManager().getReligion();
        if (religion == null) {
            religion = new Religion("None", this.getGameInfo(), choosingCiv);
        }
        this.currentReligion = religion;
        this.leftChosenBeliefs.defaults().right().pad(10.0f).fillX();
        this.rightBeliefsToChoose.defaults().left().pad(10.0f).fillX();
        if (pickIconAndName) {
            this.setupChoosableReligionIcons();
        } else {
            this.setupVisibleReligionIcons();
        }
        this.updateLeftTable();
        this.middlePanes.add((Actor)this.leftScrollPane);
        Scene2dExtensionsKt.addSeparatorVertical$default(this.middlePanes, null, 0.0f, 3, null);
        this.middlePanes.add((Actor)this.rightScrollPane);
        this.getTopTable().add((Actor)this.topReligionIcons).minHeight(this.topReligionIcons.getPrefHeight()).row();
        Scene2dExtensionsKt.addSeparator$default(this.getTopTable(), null, 0, 0.0f, 7, null);
        this.getTopTable().add((Actor)this.middlePanes);
        this.setOKAction(pickIconAndName ? "Choose a Religion" : "Enhance [" + this.currentReligion.getReligionDisplayName() + ']', arg_0 -> ReligiousBeliefsPickerScreen._init_$lambda$0(this, arg_0));
    }

    private final void checkAndEnableRightSideButton() {
        boolean bl;
        block3: {
            if (this.religionName == null || this.displayName == null) {
                return;
            }
            BeliefToChoose[] $this$any$iv = this.beliefsToChoose;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                BeliefToChoose element$iv;
                BeliefToChoose it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(it.getBelief() == null)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        Scene2dExtensionsKt.enable(this.getRightSideButton());
    }

    private final void setupChoosableReligionIcons() {
        Image image;
        Label descriptionLabel = this.toLabel("Choose an Icon and name for your Religion");
        Image $this$setupChoosableReligionIcons_u24lambda_u240 = image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Pencil", null, 2, null);
        boolean bl = false;
        $this$setupChoosableReligionIcons_u24lambda_u240.setColor(ImageGetter.INSTANCE.getCHARCOAL());
        Skin skin = BaseScreen.Companion.getSkin();
        Actor actor = Scene2dExtensionsKt.surroundWithCircle$default(image, 30.0f, false, null, null, 14, null);
        Button changeReligionNameButton = new Button(actor, skin);
        this.addIconsScroll((arg_0, arg_1) -> ReligiousBeliefsPickerScreen.setupChoosableReligionIcons$lambda$1(this, changeReligionNameButton, descriptionLabel, arg_0, arg_1));
        Table labelTable = new Table();
        labelTable.add((Actor)descriptionLabel).pad(5.0f);
        labelTable.add((Actor)changeReligionNameButton).pad(5.0f).row();
        this.topReligionIcons.add((Actor)labelTable).center().pad(5.0f).row();
        ActivationExtensionsKt.onClick(changeReligionNameButton, () -> ReligiousBeliefsPickerScreen.setupChoosableReligionIcons$lambda$2(this, descriptionLabel));
        Scene2dExtensionsKt.disable(changeReligionNameButton);
    }

    private final void setupVisibleReligionIcons() {
        this.topReligionIcons.clear();
        this.religionName = this.currentReligion.getName();
        String string = this.displayName = this.currentReligion.getReligionDisplayName();
        Intrinsics.checkNotNull(string);
        Label descriptionLabel = this.toLabel(string);
        this.addIconsScroll(ReligiousBeliefsPickerScreen::setupVisibleReligionIcons$lambda$0);
        this.topReligionIcons.add((Actor)descriptionLabel).center().padBottom(15.0f);
    }

    private final void addIconsScroll(Function2<? super Button, ? super String, Unit> buttonSetup) {
        float scrollTo = 0.0f;
        Table iconsTable = new Table();
        iconsTable.align(1);
        Iterator<String> iterator2 = this.getRuleset().getReligions().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Object object = iterator2;
        while (object.hasNext()) {
            String religionName;
            Intrinsics.checkNotNullExpressionValue(object.next(), "next(...)");
            if (Intrinsics.areEqual(religionName, this.religionName)) {
                scrollTo = Scene2dExtensionsKt.packIfNeeded(iconsTable).getPrefWidth();
            }
            Button button = new Button((Actor)ImageGetter.INSTANCE.getReligionPortrait(religionName, 60.0f), BaseScreen.Companion.getSkin());
            buttonSetup.invoke(button, religionName);
            if (Intrinsics.areEqual(religionName, this.religionName)) {
                this.disable(button, new Color(ReligionPickerScreenCommon.Companion.getGreenDisableColor()));
            } else {
                boolean bl;
                block8: {
                    Set<String> set = this.getGameInfo().getReligions().keySet();
                    Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
                    Iterable $this$any$iv = set;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it, religionName)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.disable(button, ReligionPickerScreenCommon.Companion.getRedDisableColor());
                }
            }
            iconsTable.add((Actor)button).pad(5.0f);
        }
        iconsTable.row();
        Object $this$addIconsScroll_u24lambda_u241 = object = new AutoScrollPane((Actor)iconsTable, BaseScreen.Companion.getSkin());
        boolean bl = false;
        ((AutoScrollPane)$this$addIconsScroll_u24lambda_u241).setScrollingDisabled(false, true);
        ((ScrollPane)$this$addIconsScroll_u24lambda_u241).setupFadeScrollBars(0.0f, 0.0f);
        ((ScrollPane)$this$addIconsScroll_u24lambda_u241).setScrollbarsOnTop(true);
        this.topReligionIcons.add((Actor)$this$addIconsScroll_u24lambda_u241).padBottom(10.0f).row();
        ((ScrollPane)$this$addIconsScroll_u24lambda_u241).layout();
        ((ScrollPane)$this$addIconsScroll_u24lambda_u241).setScrollX(scrollTo - (((Actor)$this$addIconsScroll_u24lambda_u241).getWidth() - 70.0f) / (float)2);
    }

    private final void updateLeftTable() {
        this.leftChosenBeliefs.clear();
        this.leftSelection.clear();
        BeliefToChoose[] beliefToChooseArray = this.currentReligion.getAllBeliefsOrdered().iterator();
        while (beliefToChooseArray.hasNext()) {
            Belief belief;
            Intrinsics.checkNotNullExpressionValue(beliefToChooseArray.next(), "next(...)");
            Button beliefButton = ReligionPickerScreenCommon.getBeliefButton$default(this, belief, null, false, 6, null);
            this.leftChosenBeliefs.add((Actor)beliefButton).row();
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            this.disable(beliefButton, color);
        }
        beliefToChooseArray = this.beliefsToChoose;
        int n = beliefToChooseArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            BeliefToChoose entry = beliefToChooseArray[i];
            this.addChoosableBeliefButton(entry.getBelief(), entry.getType(), index);
        }
        this.equalizeAllButtons(this.leftChosenBeliefs);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadRightTable(BeliefType beliefType, int leftButtonIndex) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        float selectedButtonY = 0.0f;
        float selectedButtonHeight = 0.0f;
        this.rightBeliefsToChoose.clear();
        this.rightSelection.clear();
        Collection<Belief> collection = this.getRuleset().getBeliefs().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Belief it = (Belief)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == beliefType || beliefType == BeliefType.Any)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List availableBeliefs = (List)destination$iv$iv;
        ReligionManager civReligionManager = this.currentReligion.getFoundingCiv().getReligionManager();
        for (Object e : availableBeliefs) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Belief belief = (Belief)e;
            Button beliefButton = ReligionPickerScreenCommon.getBeliefButton$default(this, belief, null, false, 6, null);
            if (Intrinsics.areEqual(this.beliefsToChoose[leftButtonIndex].getBelief(), belief)) {
                selectedButtonY = Scene2dExtensionsKt.packIfNeeded(this.rightBeliefsToChoose).getPrefHeight();
                selectedButtonHeight = Scene2dExtensionsKt.packIfNeeded(beliefButton).getPrefHeight() + 20.0f;
                this.rightSelection.switch(beliefButton);
            } else {
                boolean bl;
                boolean $i$f$any;
                Object $this$any$iv;
                block13: {
                    $this$any$iv = this.beliefsToChoose;
                    $i$f$any = false;
                    int it = ((BeliefToChoose[])$this$any$iv).length;
                    for (int i = 0; i < it; ++i) {
                        BeliefToChoose element$iv;
                        BeliefToChoose it2 = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it2.getBelief(), belief)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
                if (bl || this.currentReligion.hasBelief(belief.getName())) {
                    this.disable(beliefButton, ReligionPickerScreenCommon.Companion.getGreenDisableColor());
                } else if (civReligionManager.getReligionWithBelief(belief) != null && !Intrinsics.areEqual(civReligionManager.getReligionWithBelief(belief), this.currentReligion)) {
                    this.disable(beliefButton, ReligionPickerScreenCommon.Companion.getRedDisableColor());
                } else {
                    boolean bl3;
                    block14: {
                        $this$any$iv = belief.getMatchingUniques(UniqueType.OnlyAvailable, GameContext.Companion.getIgnoreConditionals());
                        $i$f$any = false;
                        Iterator iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            Unique it = (Unique)element$iv;
                            boolean bl4 = false;
                            if (!(!it.conditionalsApply(this.getChoosingCiv().getState()))) continue;
                            bl3 = true;
                            break block14;
                        }
                        bl3 = false;
                    }
                    if (bl3) {
                        this.disable(beliefButton, ReligionPickerScreenCommon.Companion.getRedDisableColor());
                    } else {
                        this.onClickSelect(beliefButton, this.rightSelection, belief, () -> ReligiousBeliefsPickerScreen.loadRightTable$lambda$3(this, leftButtonIndex, belief));
                    }
                }
            }
            this.rightBeliefsToChoose.add((Actor)beliefButton).row();
        }
        this.equalizeAllButtons(this.rightBeliefsToChoose);
        if (this.rightSelection.isEmpty()) {
            return;
        }
        this.rightScrollPane.layout();
        this.rightScrollPane.setScrollY(selectedButtonY - (this.rightScrollPane.getHeight() - selectedButtonHeight) / (float)2);
    }

    private final void equalizeAllButtons(Table table2) {
        Float f;
        Array<Cell> array = table2.getCells();
        Intrinsics.checkNotNullExpressionValue(array, "getCells(...)");
        Iterator iterator2 = ((Iterable)array).iterator();
        if (!iterator2.hasNext()) {
            f = null;
        } else {
            Cell it = (Cell)iterator2.next();
            boolean bl = false;
            float f2 = it.getPrefWidth();
            while (iterator2.hasNext()) {
                Cell it2 = (Cell)iterator2.next();
                $i$a$-maxOfOrNull-ReligiousBeliefsPickerScreen$equalizeAllButtons$minWidth$1 = false;
                float f3 = it2.getPrefWidth();
                f2 = Math.max(f2, f3);
            }
            f = Float.valueOf(f2);
        }
        if (f == null) {
            return;
        }
        float minWidth = f.floatValue();
        Iterator iterator3 = table2.getCells().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
        Iterator iterator4 = iterator3;
        while (((Array.ArrayIterator)iterator4).hasNext()) {
            Cell buttonCell = (Cell)((Array.ArrayIterator)iterator4).next();
            if (!(buttonCell.getActor() instanceof Button)) continue;
            buttonCell.minWidth(minWidth);
        }
    }

    private final void addChoosableBeliefButton(Belief belief, BeliefType beliefType, int index) {
        Button newBeliefButton = ReligionPickerScreenCommon.getBeliefButton$default(this, belief, beliefType, false, 4, null);
        if (index == this.leftSelectedIndex) {
            this.leftSelection.switch(newBeliefButton);
            this.leftScrollPane.setScrollY(Scene2dExtensionsKt.packIfNeeded(this.leftChosenBeliefs).getPrefHeight() - (this.leftScrollPane.getHeight() - (newBeliefButton.getPrefHeight() + 20.0f)) / (float)2);
            this.leftScrollPane.updateVisualScroll();
        }
        this.leftChosenBeliefs.add((Actor)newBeliefButton).row();
        this.onClickSelect(newBeliefButton, this.leftSelection, belief, () -> ReligiousBeliefsPickerScreen.addChoosableBeliefButton$lambda$0(this, index, beliefType));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$0(ReligiousBeliefsPickerScreen this$0, ReligionManager $this$setOKAction) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$setOKAction, "$this$setOKAction");
        if ($this$setOKAction.getCivInfo().getReligionManager().getReligionState() == ReligionState.FoundingReligion) {
            ReligionManager religionManager = $this$setOKAction.getCivInfo().getReligionManager();
            String string = this$0.displayName;
            Intrinsics.checkNotNull(string);
            String string2 = this$0.religionName;
            Intrinsics.checkNotNull(string2);
            religionManager.foundReligion$core(string, string2);
        }
        BeliefToChoose[] beliefToChooseArray = this$0.beliefsToChoose;
        ReligionManager religionManager = $this$setOKAction;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Belief belief = it.getBelief();
            Intrinsics.checkNotNull(belief);
            collection.add(belief);
        }
        religionManager.chooseBeliefs((List)destination$iv$iv, $this$setOKAction.usingFreeBeliefs());
        return Unit.INSTANCE;
    }

    private static final Unit setupChoosableReligionIcons$lambda$1$0(String $religionName, ReligiousBeliefsPickerScreen this$0, Button $changeReligionNameButton, Label $descriptionLabel) {
        ReligiousBeliefsPickerScreen.setupChoosableReligionIcons$changeDisplayedReligionName(this$0, $descriptionLabel, $religionName);
        this$0.religionName = $religionName;
        Scene2dExtensionsKt.enable($changeReligionNameButton);
        this$0.checkAndEnableRightSideButton();
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean setupChoosableReligionIcons$lambda$2$0(ReligiousBeliefsPickerScreen this$0, String religionName) {
        boolean bl;
        Object it;
        boolean bl2;
        Intrinsics.checkNotNullParameter(religionName, "religionName");
        if (Intrinsics.areEqual(religionName, "The religion of TheLegend27")) return false;
        Object $this$none$iv = this$0.getRuleset().getReligions();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl2 = true;
        } else {
            Iterator<Object> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                it = (String)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it, religionName)) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        $this$none$iv = this$0.getGameInfo().getReligions();
        $i$f$none = false;
        if ($this$none$iv.isEmpty()) {
            bl = true;
        } else {
            for (Map.Entry entry : $this$none$iv.entrySet()) {
                it = entry;
                boolean bl4 = false;
                if (!Intrinsics.areEqual(((Religion)it.getValue()).getName(), religionName)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (Intrinsics.areEqual(religionName, "")) return false;
        return true;
    }

    private static final Unit setupChoosableReligionIcons$lambda$2$1(ReligiousBeliefsPickerScreen this$0, Label $descriptionLabel, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ReligiousBeliefsPickerScreen.setupChoosableReligionIcons$changeDisplayedReligionName(this$0, $descriptionLabel, it);
        return Unit.INSTANCE;
    }

    private static final void setupChoosableReligionIcons$changeDisplayedReligionName(ReligiousBeliefsPickerScreen this$0, Label descriptionLabel, String newReligionName) {
        this$0.displayName = newReligionName;
        this$0.getRightSideButton().setLabel(this$0.toLabel("Found [" + newReligionName + ']'));
        descriptionLabel.setText(TranslationsKt.tr$default(newReligionName, false, false, 3, null));
    }

    private static final Unit setupChoosableReligionIcons$lambda$1(ReligiousBeliefsPickerScreen this$0, Button $changeReligionNameButton, Label $descriptionLabel, Button button, String religionName) {
        Intrinsics.checkNotNullParameter(button, "button");
        Intrinsics.checkNotNullParameter(religionName, "religionName");
        this$0.onClickSelect(button, this$0.iconSelection, null, () -> ReligiousBeliefsPickerScreen.setupChoosableReligionIcons$lambda$1$0(religionName, this$0, $changeReligionNameButton, $descriptionLabel));
        return Unit.INSTANCE;
    }

    private static final Unit setupChoosableReligionIcons$lambda$2(ReligiousBeliefsPickerScreen this$0, Label $descriptionLabel) {
        BaseScreen baseScreen = this$0;
        String string = this$0.religionName;
        Intrinsics.checkNotNull(string);
        Group group = ImageGetter.INSTANCE.getReligionPortrait(string, 80.0f);
        String string2 = this$0.religionName;
        Intrinsics.checkNotNull(string2);
        Popup.open$default(new AskTextPopup(baseScreen, "Choose a name for your religion", group, string2, null, 0, arg_0 -> ReligiousBeliefsPickerScreen.setupChoosableReligionIcons$lambda$2$0(this$0, arg_0), arg_0 -> ReligiousBeliefsPickerScreen.setupChoosableReligionIcons$lambda$2$1(this$0, $descriptionLabel, arg_0), 48, null), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit setupVisibleReligionIcons$lambda$0(Button button, String string) {
        Intrinsics.checkNotNullParameter(button, "button");
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        Scene2dExtensionsKt.disable(button);
        return Unit.INSTANCE;
    }

    private static final Unit loadRightTable$lambda$3(ReligiousBeliefsPickerScreen this$0, int $leftButtonIndex, Belief $belief) {
        this$0.beliefsToChoose[$leftButtonIndex].setBelief($belief);
        this$0.updateLeftTable();
        this$0.checkAndEnableRightSideButton();
        return Unit.INSTANCE;
    }

    private static final Unit addChoosableBeliefButton$lambda$0(ReligiousBeliefsPickerScreen this$0, int $index, BeliefType $beliefType) {
        this$0.leftSelectedIndex = $index;
        this$0.loadRightTable($beliefType, $index);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/pickerscreens/ReligiousBeliefsPickerScreen$BeliefToChoose;", "", "type", "Lcom/unciv/models/ruleset/BeliefType;", "belief", "Lcom/unciv/models/ruleset/Belief;", "<init>", "(Lcom/unciv/models/ruleset/BeliefType;Lcom/unciv/models/ruleset/Belief;)V", "getType", "()Lcom/unciv/models/ruleset/BeliefType;", "getBelief", "()Lcom/unciv/models/ruleset/Belief;", "setBelief", "(Lcom/unciv/models/ruleset/Belief;)V", "core"})
    public static final class BeliefToChoose {
        @NotNull
        private final BeliefType type;
        @Nullable
        private Belief belief;

        public BeliefToChoose(@NotNull BeliefType type, @Nullable Belief belief) {
            Intrinsics.checkNotNullParameter((Object)type, "type");
            this.type = type;
            this.belief = belief;
        }

        public /* synthetic */ BeliefToChoose(BeliefType beliefType, Belief belief, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                belief = null;
            }
            this(beliefType, belief);
        }

        @NotNull
        public final BeliefType getType() {
            return this.type;
        }

        @Nullable
        public final Belief getBelief() {
            return this.belief;
        }

        public final void setBelief(@Nullable Belief belief) {
            this.belief = belief;
        }
    }
}

