/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.ui.screens.victoryscreen.IndependentMiniMap;
import com.unciv.ui.screens.worldscreen.minimap.MinimapTile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/victoryscreen/ReplayMap;", "Lcom/unciv/ui/screens/victoryscreen/IndependentMiniMap;", "tileMap", "Lcom/unciv/logic/map/TileMap;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "maxWidth", "", "maxHeight", "<init>", "(Lcom/unciv/logic/map/TileMap;Lcom/unciv/logic/civilization/Civilization;FF)V", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "calcTileSize", "includeTileFilter", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "update", "", "turn", "", "core"})
public final class ReplayMap
extends IndependentMiniMap {
    @NotNull
    private final Civilization viewingCiv;

    public ReplayMap(@NotNull TileMap tileMap, @NotNull Civilization viewingCiv, float maxWidth, float maxHeight) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        super(tileMap);
        this.viewingCiv = viewingCiv;
        this.deferredInit(maxWidth, maxHeight);
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    @Override
    protected float calcTileSize(float maxWidth, float maxHeight) {
        float height = this.viewingCiv.getExploredRegion().getHeight();
        float width = this.viewingCiv.getExploredRegion().getWidth();
        return Math.min(maxHeight / (height + 1.5f) / (float)Math.sqrt(3.0f) * 4.0f, maxWidth / (width + 0.5f) / 0.75f);
    }

    @Override
    protected boolean includeTileFilter(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return tile.isExplored(this.viewingCiv);
    }

    public final void update(int turn) {
        boolean viewingCivIsDefeated = this.viewingCiv.getGameInfo().getVictoryData() != null || !this.viewingCiv.isAlive();
        for (MinimapTile minimapTile : this.getMinimapTiles()) {
            boolean isVisible = viewingCivIsDefeated || this.viewingCiv.hasExplored(minimapTile.getTile());
            minimapTile.updateColor(!isVisible, turn);
            if (!isVisible) continue;
            minimapTile.updateBorders(turn).updateActorsIn(this);
            minimapTile.updateCityCircle(turn).updateActorsIn(this);
        }
    }
}

