/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.utils;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.InternalState;
import yairm210.purity.annotations.Readonly;

@InternalState
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 I2\u00020\u0001:\u0003GHIB\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000bB\u001b\b\u0016\u0012\u0006\u0010\b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0011\u001a\u00020\u0003H\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0016H\u0007J\b\u0010\u0018\u001a\u00020\nH\u0007J\u0011\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0003H\u0087\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\nH\u0007J\u0016\u0010\u001d\u001a\u00020\u00162\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\fH\u0007J\u0011\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\nJ\u0014\u0010!\u001a\u00020\u00162\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\fJ\u000f\u0010\"\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\nJ\u0011\u0010%\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\nH\u0086\u0002J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\nJ\u0014\u0010'\u001a\u00020\u00162\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010'\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\fJ\u001a\u0010(\u001a\u00020\u00162\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00160*J\u0014\u0010+\u001a\u00020\u00162\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010+\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\fJ\b\u0010,\u001a\u00020\u0014H\u0002J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0003H\u0002J\u0010\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u0003H\u0002J\u0010\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u0003H\u0002J\u0018\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0002J\u0010\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\fH\u0007J\b\u00108\u001a\u00020\u0000H\u0007J\u0014\u00109\u001a\u00020\u00162\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u0097\u0082\u0004J\n\u0010;\u001a\u00020\u0003H\u0097\u0080\u0004J\n\u0010<\u001a\u00020=H\u0097\u0080\u0004J\u001c\u0010>\u001a\u00020\u00142\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140*H\u0007J\f\u0010@\u001a\u00060AR\u00020\u0000H\u0007J\f\u0010B\u001a\u00060CR\u00020\u0000H\u0007J\b\u0010D\u001a\u00020EH\u0007J\b\u0010F\u001a\u00020EH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/unciv/utils/LongPriorityQueue;", "", "initialCapacity", "", "comparator", "Lcom/unciv/utils/LongPriorityQueue$Companion$Comparator;", "<init>", "(ILcom/unciv/utils/LongPriorityQueue$Companion$Comparator;)V", "c", "", "", "(Ljava/util/Collection;Lcom/unciv/utils/LongPriorityQueue$Companion$Comparator;)V", "", "([JLcom/unciv/utils/LongPriorityQueue$Companion$Comparator;)V", "getComparator", "()Lcom/unciv/utils/LongPriorityQueue$Companion$Comparator;", "queue", "size", "mutCounter", "clear", "", "isEmpty", "", "isNotEmpty", "element", "get", "index", "contains", "value", "containsAll", "plus", "add", "offer", "addAll", "peek", "()Ljava/lang/Long;", "poll", "minus", "remove", "removeAll", "removeIf", "predicate", "Lkotlin/Function1;", "retainAll", "resizeUp", "resize", "newSize", "bubbleUp", "initialIndex", "fillHole", "startIndex", "swap", "i", "j", "toArray", "array", "clone", "equals", "other", "hashCode", "toString", "", "forEach", "action", "iterator", "Lcom/unciv/utils/LongPriorityQueue$Iterator;", "spliterator", "Lcom/unciv/utils/LongPriorityQueue$Spliterator;", "stream", "Ljava/util/stream/LongStream;", "parallelStream", "Iterator", "Spliterator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLongPriorityQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongPriorityQueue.kt\ncom/unciv/utils/LongPriorityQueue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,408:1\n1915#2,2:409\n*S KotlinDebug\n*F\n+ 1 LongPriorityQueue.kt\ncom/unciv/utils/LongPriorityQueue\n*L\n111#1:409,2\n*E\n"})
public final class LongPriorityQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Companion.Comparator comparator;
    @NotNull
    private long[] queue;
    private int size;
    private int mutCounter;

    public LongPriorityQueue(int initialCapacity, @NotNull Companion.Comparator comparator) {
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        this.comparator = comparator;
        this.queue = new long[initialCapacity];
    }

    public /* synthetic */ LongPriorityQueue(int n, Companion.Comparator comparator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        if ((n2 & 2) != 0) {
            comparator = Companion.DefaultComparator.INSTANCE;
        }
        this(n, comparator);
    }

    @NotNull
    public final Companion.Comparator getComparator() {
        return this.comparator;
    }

    public LongPriorityQueue(@NotNull Collection<Long> c, @NotNull Companion.Comparator comparator) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        this(c.size(), comparator);
        this.addAll(c);
    }

    public /* synthetic */ LongPriorityQueue(Collection collection, Companion.Comparator comparator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            comparator = Companion.DefaultComparator.INSTANCE;
        }
        this(collection, comparator);
    }

    public LongPriorityQueue(@NotNull long[] c, @NotNull Companion.Comparator comparator) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        this(c.length, comparator);
        this.addAll(c);
    }

    public /* synthetic */ LongPriorityQueue(long[] lArray, Companion.Comparator comparator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            comparator = Companion.DefaultComparator.INSTANCE;
        }
        this(lArray, comparator);
    }

    public final void clear() {
        this.size = 0;
        ++this.mutCounter;
    }

    @Readonly
    public final int size() {
        return this.size;
    }

    @Readonly
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Readonly
    public final boolean isNotEmpty() {
        return this.size != 0;
    }

    @Readonly
    public final long element() {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty.");
        }
        return this.queue[0];
    }

    @Readonly
    public final long get(int index) {
        if (!(0 <= index ? index < this.size : false)) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for priority queue of size " + this.size + '.');
        }
        return this.queue[index];
    }

    @Readonly
    public final boolean contains(long value) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (this.queue[i] != value) continue;
            return true;
        }
        return false;
    }

    @Readonly
    public final boolean containsAll(@NotNull Collection<Long> c) {
        Intrinsics.checkNotNullParameter(c, "c");
        java.util.Iterator<Long> iterator2 = c.iterator();
        while (iterator2.hasNext()) {
            long item = ((Number)iterator2.next()).longValue();
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Readonly
    public final boolean containsAll(@NotNull long[] c) {
        Intrinsics.checkNotNullParameter(c, "c");
        for (long item : c) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public final void plus(long value) {
        this.add(value);
    }

    public final void add(long value) {
        if (this.size == this.queue.length) {
            this.resizeUp();
        }
        this.queue[this.size] = value;
        ++this.size;
        this.bubbleUp(this.size - 1);
        ++this.mutCounter;
    }

    public final boolean offer(long value) {
        this.add(value);
        return true;
    }

    public final boolean addAll(@NotNull Collection<Long> c) {
        Intrinsics.checkNotNullParameter(c, "c");
        ++this.mutCounter;
        int oldSize = this.size;
        if (this.size + c.size() > this.queue.length) {
            this.resize(this.size + c.size());
        }
        Iterable $this$forEach$iv = c;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            int n = this.size;
            this.size = n + 1;
            this.queue[n] = it;
        }
        int n = oldSize - 1;
        int i = this.size - 1;
        if (n <= i) {
            while (true) {
                this.bubbleUp(i);
                if (i == n) break;
                --i;
            }
        }
        ++this.mutCounter;
        return false;
    }

    public final boolean addAll(@NotNull long[] c) {
        Intrinsics.checkNotNullParameter(c, "c");
        ++this.mutCounter;
        int oldSize = this.size;
        if (this.size + c.length > this.queue.length) {
            this.resize(this.size + c.length);
        }
        ArraysKt.copyInto$default(c, this.queue, this.size, 0, 0, 12, null);
        this.size += c.length;
        int n = this.size;
        for (int i = oldSize; i < n; ++i) {
            this.bubbleUp(i);
        }
        ++this.mutCounter;
        return false;
    }

    @Readonly
    @Nullable
    public final Long peek() {
        return this.size > 0 ? Long.valueOf(this.queue[0]) : null;
    }

    public final long poll() {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty.");
        }
        long top = this.queue[0];
        this.fillHole(0);
        ++this.mutCounter;
        return top;
    }

    public final boolean minus(long value) {
        return this.remove(value);
    }

    public final boolean remove(long value) {
        if (this.size == 0) {
            return false;
        }
        this.fillHole(0);
        ++this.mutCounter;
        return true;
    }

    public final boolean removeAll(@NotNull Collection<Long> c) {
        Intrinsics.checkNotNullParameter(c, "c");
        ++this.mutCounter;
        if (c.size() > this.size) {
            return this.removeIf(arg_0 -> LongPriorityQueue.removeAll$lambda$0(c, arg_0));
        }
        java.util.Iterator<Long> iterator2 = c.iterator();
        while (iterator2.hasNext()) {
            long item = ((Number)iterator2.next()).longValue();
            if (this.remove(item)) continue;
            return false;
        }
        ++this.mutCounter;
        return true;
    }

    public final boolean removeAll(@NotNull long[] c) {
        Intrinsics.checkNotNullParameter(c, "c");
        ++this.mutCounter;
        if (c.length > this.size) {
            return this.removeIf(arg_0 -> LongPriorityQueue.removeAll$lambda$1(c, arg_0));
        }
        for (long item : c) {
            if (this.remove(item)) continue;
            return false;
        }
        ++this.mutCounter;
        return true;
    }

    public final boolean removeIf(@NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        ++this.mutCounter;
        int i = 0;
        while (i < this.size) {
            if (predicate.invoke((Long)this.queue[i]).booleanValue()) {
                this.fillHole(i);
                continue;
            }
            ++i;
        }
        ++this.mutCounter;
        return true;
    }

    public final boolean retainAll(@NotNull Collection<Long> c) {
        Intrinsics.checkNotNullParameter(c, "c");
        return this.removeIf(arg_0 -> LongPriorityQueue.retainAll$lambda$0(c, arg_0));
    }

    public final boolean retainAll(@NotNull long[] c) {
        Intrinsics.checkNotNullParameter(c, "c");
        return this.removeIf(arg_0 -> LongPriorityQueue.retainAll$lambda$1(c, arg_0));
    }

    private final void resizeUp() {
        this.resize(this.queue.length * 3 / 2 + 1);
    }

    private final void resize(int newSize) {
        long[] newQueue = new long[newSize];
        ArraysKt.copyInto$default(this.queue, newQueue, 0, 0, 0, 14, null);
        this.queue = newQueue;
    }

    private final void bubbleUp(int initialIndex) {
        int parentIndex;
        int index = initialIndex;
        while (index > 0 && this.comparator.invoke(this.queue[parentIndex = (index - 1) / 2], this.queue[index]) >= 0) {
            this.swap(parentIndex, index);
            index = parentIndex;
        }
    }

    private final void fillHole(int startIndex) {
        int index = startIndex;
        while (true) {
            int child1 = index * 2 + 1;
            int child2 = index * 2 + 2;
            if (child1 >= this.size) break;
            if (child2 >= this.size) {
                this.queue[index] = this.queue[child1];
                break;
            }
            if (this.comparator.invoke(this.queue[child1], this.queue[child2]) <= 0) {
                this.queue[index] = this.queue[child1];
                index = child1;
                continue;
            }
            this.queue[index] = this.queue[child2];
            index = child2;
        }
        if (index == this.size - 1) {
            this.size += -1;
            return;
        }
        this.queue[index] = this.queue[this.size - 1];
        this.queue[this.size - 1] = Long.MIN_VALUE;
        this.size += -1;
        this.bubbleUp(index);
    }

    private final void swap(int i, int j) {
        long temp = this.queue[i];
        this.queue[i] = this.queue[j];
        this.queue[j] = temp;
    }

    @Readonly
    @NotNull
    public final long[] toArray(@NotNull long[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        if (array.length >= this.size) {
            ArraysKt.copyInto(this.queue, array, 0, 0, this.size);
            return array;
        }
        long[] newArray = new long[this.size];
        ArraysKt.copyInto(this.queue, newArray, 0, 0, this.size);
        return newArray;
    }

    @Readonly
    @NotNull
    public final LongPriorityQueue clone() {
        LongPriorityQueue c = new LongPriorityQueue(this.size, this.comparator);
        ArraysKt.copyInto$default(this.queue, c.queue, 0, this.size, 0, 8, null);
        c.size = this.size;
        return c;
    }

    @Readonly
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof LongPriorityQueue)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.comparator, ((LongPriorityQueue)other).comparator)) {
            return false;
        }
        if (this.size != ((LongPriorityQueue)other).size) {
            return false;
        }
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (this.queue[i] == ((LongPriorityQueue)other).queue[i]) continue;
            return false;
        }
        return true;
    }

    @Readonly
    public int hashCode() {
        Object[] objectArray = new Object[]{this.comparator};
        int hash = Objects.hash(objectArray);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2 = new Object[]{hash, this.queue[i]};
            hash = Objects.hash(objectArray2);
        }
        return hash;
    }

    @Readonly
    @NotNull
    public String toString() {
        return "LongPriorityQueue[size=" + this.size + " top=" + (this.size > 0 ? Long.valueOf(this.queue[0]) : "null") + ']';
    }

    @Readonly
    public final void forEach(@NotNull Function1<? super Long, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, "action");
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            action2.invoke((Long)this.queue[i]);
        }
    }

    @Readonly
    @NotNull
    public final Iterator iterator() {
        return new Iterator(this.mutCounter);
    }

    @Readonly
    @NotNull
    public final Spliterator spliterator() {
        return new Spliterator(-1, this.size - 1, this.mutCounter);
    }

    @Readonly
    @NotNull
    public final LongStream stream() {
        LongStream longStream = StreamSupport.longStream(this.spliterator(), false);
        Intrinsics.checkNotNullExpressionValue(longStream, "longStream(...)");
        return longStream;
    }

    @Readonly
    @NotNull
    public final LongStream parallelStream() {
        LongStream longStream = this.stream().parallel();
        Intrinsics.checkNotNullExpressionValue(longStream, "parallel(...)");
        return longStream;
    }

    private static final boolean removeAll$lambda$0(Collection $c, long it) {
        return $c.contains(it);
    }

    private static final boolean removeAll$lambda$1(long[] $c, long it) {
        return ArraysKt.contains($c, it);
    }

    private static final boolean retainAll$lambda$0(Collection $c, long it) {
        return !$c.contains(it);
    }

    private static final boolean retainAll$lambda$1(long[] $c, long it) {
        return !ArraysKt.contains($c, it);
    }

    public LongPriorityQueue() {
        this(0, null, 3, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/unciv/utils/LongPriorityQueue$Companion;", "", "<init>", "()V", "Comparator", "DefaultComparator", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0019\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u00a6\u0002\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/unciv/utils/LongPriorityQueue$Companion$Comparator;", "", "invoke", "", "a", "", "b", "core"})
        public static interface Comparator {
            public int invoke(long var1, long var3);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a8\u0006\t"}, d2={"Lcom/unciv/utils/LongPriorityQueue$Companion$DefaultComparator;", "Lcom/unciv/utils/LongPriorityQueue$Companion$Comparator;", "<init>", "()V", "invoke", "", "a", "", "b", "core"})
        public static final class DefaultComparator
        implements Comparator {
            @NotNull
            public static final DefaultComparator INSTANCE = new DefaultComparator();

            private DefaultComparator() {
            }

            @Override
            public int invoke(long a, long b) {
                return Intrinsics.compare(a, b);
            }
        }
    }

    @InternalState
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0087\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000e\u001a\u00020\fH\u0096\u0082\u0004J\u000f\u0010\u000f\u001a\u00020\u0002H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004R\u0018\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\bR\u0018\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/unciv/utils/LongPriorityQueue$Iterator;", "", "", "mutSnapshot", "", "<init>", "(Lcom/unciv/utils/LongPriorityQueue;I)V", "getMutSnapshot$annotations", "()V", "index", "getIndex$annotations", "canRemove", "", "getCanRemove$annotations", "hasNext", "next", "()Ljava/lang/Long;", "remove", "", "core"})
    public final class Iterator
    implements java.util.Iterator<Long>,
    KMutableIterator {
        private int mutSnapshot;
        private int index;
        private boolean canRemove;

        public Iterator(int mutSnapshot) {
            this.mutSnapshot = mutSnapshot;
            this.index = -1;
            this.canRemove = true;
        }

        @Cache
        private static /* synthetic */ void getMutSnapshot$annotations() {
        }

        @Cache
        private static /* synthetic */ void getIndex$annotations() {
        }

        @Cache
        private static /* synthetic */ void getCanRemove$annotations() {
        }

        @Override
        public boolean hasNext() {
            if (this.mutSnapshot != LongPriorityQueue.this.mutCounter) {
                throw new ConcurrentModificationException("Priority queue modified during iteration.");
            }
            return this.index < LongPriorityQueue.this.size - 1;
        }

        @Override
        @NotNull
        public Long next() {
            if (this.mutSnapshot != LongPriorityQueue.this.mutCounter) {
                throw new ConcurrentModificationException("Priority queue modified during iteration.");
            }
            if (this.index >= LongPriorityQueue.this.size) {
                throw new NoSuchElementException("No more elements in priority queue.");
            }
            ++this.index;
            this.canRemove = true;
            return LongPriorityQueue.this.queue[this.index];
        }

        @Override
        public void remove() {
            if (this.mutSnapshot != LongPriorityQueue.this.mutCounter) {
                throw new ConcurrentModificationException("Priority queue modified during iteration.");
            }
            if (!this.canRemove) {
                throw new IllegalStateException("Cannot remove element before calling next().");
            }
            LongPriorityQueue.this.fillHole(this.index);
            LongPriorityQueue.this.mutCounter = LongPriorityQueue.this.mutCounter + 1;
            LongPriorityQueue.this.mutCounter;
            ++this.mutSnapshot;
            this.canRemove = false;
        }
    }

    @InternalState
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0018\u00010\u0000R\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/unciv/utils/LongPriorityQueue$Spliterator;", "Ljava/util/Spliterator$OfLong;", "index", "", "endIndex", "mutSnapshot", "<init>", "(Lcom/unciv/utils/LongPriorityQueue;III)V", "getIndex", "()I", "setIndex", "(I)V", "getEndIndex", "setEndIndex", "getMutSnapshot", "tryAdvance", "", "action", "Ljava/util/function/LongConsumer;", "trySplit", "Lcom/unciv/utils/LongPriorityQueue;", "estimateSize", "", "characteristics", "core"})
    public final class Spliterator
    implements Spliterator.OfLong {
        private int index;
        private int endIndex;
        private final int mutSnapshot;

        public Spliterator(int index, int endIndex, int mutSnapshot) {
            this.index = index;
            this.endIndex = endIndex;
            this.mutSnapshot = mutSnapshot;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final int getEndIndex() {
            return this.endIndex;
        }

        public final void setEndIndex(int n) {
            this.endIndex = n;
        }

        public final int getMutSnapshot() {
            return this.mutSnapshot;
        }

        @Override
        public boolean tryAdvance(@Nullable LongConsumer action2) {
            block2: {
                if (this.mutSnapshot != LongPriorityQueue.this.mutCounter) {
                    throw new ConcurrentModificationException("Priority queue modified during iteration.");
                }
                if (this.index >= this.endIndex) {
                    return false;
                }
                ++this.index;
                LongConsumer longConsumer = action2;
                if (longConsumer == null) break block2;
                longConsumer.accept(LongPriorityQueue.this.queue[this.index]);
            }
            return true;
        }

        @Override
        @Nullable
        public Spliterator trySplit() {
            if (this.mutSnapshot != LongPriorityQueue.this.mutCounter) {
                throw new ConcurrentModificationException("Priority queue modified during iteration.");
            }
            if (this.endIndex - this.index < 2) {
                return null;
            }
            int mid = (this.index + this.endIndex) / 2;
            Spliterator split2 = new Spliterator(mid, this.endIndex, this.mutSnapshot);
            this.endIndex = mid;
            return split2;
        }

        @Override
        public long estimateSize() {
            return (long)this.endIndex - (long)this.index;
        }

        @Override
        public int characteristics() {
            return 21824;
        }
    }
}

