/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.CivilizationInfoPreview;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.managers.GreatPersonManager;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.Ruleset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\n\u0010\u0007\u001a\u00020\u0005*\u00020\u0006J\n\u0010\u0007\u001a\u00020\u0005*\u00020\bJ\f\u0010\t\u001a\u00020\u0005*\u00020\u0006H\u0002J\n\u0010\n\u001a\u00020\u0005*\u00020\u0006J\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\f\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\r\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u000e\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0006H\u0002J(\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u001c\u0010\u0019\u001a\u00020\u0005*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u001a\u0010\u001d\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\n\u0010!\u001a\u00020\u0005*\u00020\u0006J\n\u0010\"\u001a\u00020\u0005*\u00020#J\n\u0010$\u001a\u00020\u0005*\u00020\u0006J\n\u0010%\u001a\u00020\u0005*\u00020\u0006J\n\u0010&\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006'"}, d2={"Lcom/unciv/logic/BackwardCompatibility;", "", "<init>", "()V", "removeMissingModReferences", "", "Lcom/unciv/logic/GameInfo;", "migrateCivID", "Lcom/unciv/logic/GameInfoPreview;", "updateMissingStartingEra", "migrateGreatGeneralPools", "removeUnitsAndPromotions", "removeMissingGreatPersonPoints", "removeOldPillagedImprovements", "removeMissingLastSeenImprovements", "handleMissingReferencesForEachCity", "removeTechAndPolicies", "changeBuildingNameIfNotInRuleset", "ruleSet", "Lcom/unciv/models/ruleset/Ruleset;", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "oldBuildingName", "", "newBuildingName", "replaceUpdatedTechName", "Lcom/unciv/logic/civilization/managers/TechManager;", "oldTechName", "newTechName", "replaceDiplomacyFlag", "old", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyFlags;", "new", "guaranteeUnitPromotions", "updateDeprecations", "Lcom/unciv/models/ruleset/ModOptions;", "convertFortify", "migrateToTileHistory", "ensureUnitIds", "core"})
@SourceDebugExtension(value={"SMAP\nBackwardCompatibility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackwardCompatibility.kt\ncom/unciv/logic/BackwardCompatibility\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1391#2:254\n1480#2,5:255\n1915#2,2:260\n1404#2:263\n1496#2,5:264\n1#3:262\n*S KotlinDebug\n*F\n+ 1 BackwardCompatibility.kt\ncom/unciv/logic/BackwardCompatibility\n*L\n209#1:254\n209#1:255,5\n209#1:260,2\n248#1:263\n248#1:264,5\n*E\n"})
public final class BackwardCompatibility {
    @NotNull
    public static final BackwardCompatibility INSTANCE = new BackwardCompatibility();

    private BackwardCompatibility() {
    }

    public final void removeMissingModReferences(@NotNull GameInfo $this$removeMissingModReferences) {
        Intrinsics.checkNotNullParameter($this$removeMissingModReferences, "<this>");
        $this$removeMissingModReferences.getTileMap().removeMissingTerrainModReferences($this$removeMissingModReferences.getRuleset());
        this.removeUnitsAndPromotions($this$removeMissingModReferences);
        this.removeMissingGreatPersonPoints($this$removeMissingModReferences);
        this.removeOldPillagedImprovements($this$removeMissingModReferences);
        this.removeMissingLastSeenImprovements($this$removeMissingModReferences);
        this.handleMissingReferencesForEachCity($this$removeMissingModReferences);
        this.removeTechAndPolicies($this$removeMissingModReferences);
        this.updateMissingStartingEra($this$removeMissingModReferences);
        this.migrateCivID($this$removeMissingModReferences);
    }

    public final void migrateCivID(@NotNull GameInfo $this$migrateCivID) {
        Intrinsics.checkNotNullParameter($this$migrateCivID, "<this>");
        Iterator<Civilization> iterator2 = $this$migrateCivID.getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civ;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (!Intrinsics.areEqual(civ.getCivID(), "")) continue;
            civ.setCivID(civ.getCivName());
        }
    }

    public final void migrateCivID(@NotNull GameInfoPreview $this$migrateCivID) {
        Intrinsics.checkNotNullParameter($this$migrateCivID, "<this>");
        for (CivilizationInfoPreview civ : $this$migrateCivID.getCivilizations()) {
            if (!Intrinsics.areEqual(civ.getCivID(), "")) continue;
            civ.setCivID(civ.getCivName());
        }
    }

    private final void updateMissingStartingEra(GameInfo $this$updateMissingStartingEra) {
        if (((Map)$this$updateMissingStartingEra.getRuleset().getEras()).containsKey($this$updateMissingStartingEra.getGameParameters().getStartingEra())) {
            return;
        }
        GameParameters gameParameters = $this$updateMissingStartingEra.getGameParameters();
        Set<String> set = $this$updateMissingStartingEra.getRuleset().getEras().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        gameParameters.setStartingEra((String)CollectionsKt.first((Iterable)set));
    }

    public final void migrateGreatGeneralPools(@NotNull GameInfo $this$migrateGreatGeneralPools) {
        Intrinsics.checkNotNullParameter($this$migrateGreatGeneralPools, "<this>");
        Iterator<Civilization> iterator2 = $this$migrateGreatGeneralPools.getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civ;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            GreatPersonManager $this$migrateGreatGeneralPools_u24lambda_u240 = civ.getGreatPeople();
            boolean bl = false;
            if ($this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneral() >= ((Number)$this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneralCounter().get("Great General")).intValue()) {
                ((Map)$this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneralCounter()).put("Great General", $this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneral());
                continue;
            }
            $this$migrateGreatGeneralPools_u24lambda_u240.setPointsForNextGreatGeneral(((Number)$this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneralCounter().get("Great General")).intValue());
        }
    }

    private final void removeUnitsAndPromotions(GameInfo $this$removeUnitsAndPromotions) {
        for (Tile tile : $this$removeUnitsAndPromotions.getTileMap().getValues()) {
            for (MapUnit unit : SequencesKt.toList(tile.getUnits())) {
                if (!$this$removeUnitsAndPromotions.getRuleset().getUnits().containsKey(unit.getName())) {
                    tile.removeUnit(unit);
                }
                for (String promotion : CollectionsKt.toList((Iterable)unit.getPromotions().getPromotions())) {
                    if ($this$removeUnitsAndPromotions.getRuleset().getUnitPromotions().containsKey(promotion)) continue;
                    unit.getPromotions().getPromotions().remove(promotion);
                }
            }
        }
    }

    private final void removeMissingGreatPersonPoints(GameInfo $this$removeMissingGreatPersonPoints) {
        Iterator<Civilization> iterator2 = $this$removeMissingGreatPersonPoints.getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civ;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Set<String> set = civ.getGreatPeople().getGreatGeneralPointsCounter().keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            for (String key : CollectionsKt.toList((Iterable)set)) {
                if ($this$removeMissingGreatPersonPoints.getRuleset().getUnits().containsKey(key)) continue;
                civ.getGreatPeople().getGreatGeneralPointsCounter().remove(key);
            }
            Set<String> set2 = civ.getGreatPeople().getGreatPersonPointsCounter().keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            for (String key : CollectionsKt.toList((Iterable)set2)) {
                if ($this$removeMissingGreatPersonPoints.getRuleset().getUnits().containsKey(key)) continue;
                civ.getGreatPeople().getGreatPersonPointsCounter().remove(key);
            }
        }
    }

    private final void removeOldPillagedImprovements(GameInfo $this$removeOldPillagedImprovements) {
        if (!$this$removeOldPillagedImprovements.getRuleset().getTileImprovements().containsKey("Repair")) {
            for (Tile tile : $this$removeOldPillagedImprovements.getTileMap().getValues()) {
                if (tile.getRoadIsPillaged()) {
                    tile.removeRoad();
                }
                if (!tile.getImprovementIsPillaged()) continue;
                tile.setImprovement(null);
                tile.setImprovementIsPillaged(false);
            }
        }
    }

    private final void removeMissingLastSeenImprovements(GameInfo $this$removeMissingLastSeenImprovements) {
        Iterator<Civilization> iterator2 = $this$removeMissingLastSeenImprovements.getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civ;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            for (Pair pair : MapsKt.toList(civ.getLastSeenImprovement())) {
                HexCoord vector = (HexCoord)pair.component1();
                String improvementName = (String)pair.component2();
                if ($this$removeMissingLastSeenImprovements.getRuleset().getTileImprovements().containsKey(improvementName)) continue;
                civ.getLastSeenImprovement().remove((Object)vector);
            }
        }
    }

    private final void handleMissingReferencesForEachCity(GameInfo $this$handleMissingReferencesForEachCity) {
        Iterator iterator2 = SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)$this$handleMissingReferencesForEachCity.getCivilizations()), BackwardCompatibility::handleMissingReferencesForEachCity$lambda$0).iterator();
        while (iterator2.hasNext()) {
            City city = (City)iterator2.next();
            for (String building : CollectionsKt.toList((Iterable)city.getCityConstructions().getBuiltBuildings())) {
                if ($this$handleMissingReferencesForEachCity.getRuleset().getBuildings().containsKey(building)) continue;
                city.getCityConstructions().getBuiltBuildings().remove(building);
            }
            for (String construction : CollectionsKt.toList((Iterable)city.getCityConstructions().getConstructionQueue())) {
                if (!BackwardCompatibility.handleMissingReferencesForEachCity$isInvalidConstruction($this$handleMissingReferencesForEachCity, construction)) continue;
                city.getCityConstructions().getConstructionQueue().remove(construction);
            }
            Set<String> set = city.getCityConstructions().getInProgressConstructions().keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            for (String construction : CollectionsKt.toList((Iterable)set)) {
                if (!BackwardCompatibility.handleMissingReferencesForEachCity$isInvalidConstruction($this$handleMissingReferencesForEachCity, construction)) continue;
                city.getCityConstructions().getInProgressConstructions().remove(construction);
            }
        }
    }

    private final void removeTechAndPolicies(GameInfo $this$removeTechAndPolicies) {
        Iterator<Civilization> iterator2 = $this$removeTechAndPolicies.getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civInfo;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            for (String tech : CollectionsKt.toList((Iterable)civInfo.getTech().getTechsResearched())) {
                if ($this$removeTechAndPolicies.getRuleset().getTechnologies().containsKey(tech)) continue;
                civInfo.getTech().getTechsResearched().remove(tech);
            }
            for (String tech : CollectionsKt.toList((Iterable)civInfo.getTech().getTechsToResearch())) {
                if ($this$removeTechAndPolicies.getRuleset().getTechnologies().containsKey(tech)) continue;
                civInfo.getTech().getTechsToResearch().remove(tech);
            }
            for (String policy : CollectionsKt.toList((Iterable)civInfo.getPolicies().getAdoptedPolicies$core())) {
                if ($this$removeTechAndPolicies.getRuleset().getPolicies().containsKey(policy)) continue;
                civInfo.getPolicies().getAdoptedPolicies$core().remove(policy);
            }
        }
    }

    private final void changeBuildingNameIfNotInRuleset(Ruleset ruleSet, CityConstructions cityConstructions, String oldBuildingName, String newBuildingName) {
        if (ruleSet.getBuildings().containsKey(oldBuildingName)) {
            return;
        }
        if (cityConstructions.isBuilt(oldBuildingName)) {
            cityConstructions.removeBuilding(oldBuildingName);
            cityConstructions.addBuilding(newBuildingName);
        }
        if (!cityConstructions.isBuilt(newBuildingName) && !cityConstructions.getConstructionQueue().contains(newBuildingName)) {
            cityConstructions.transformQueue((arg_0, arg_1) -> BackwardCompatibility.changeBuildingNameIfNotInRuleset$lambda$0(oldBuildingName, newBuildingName, arg_0, arg_1));
        } else {
            cityConstructions.getConstructionQueue().remove(oldBuildingName);
        }
        if (cityConstructions.getInProgressConstructions().containsKey(oldBuildingName)) {
            if (!cityConstructions.isBuilt(newBuildingName) && !cityConstructions.getInProgressConstructions().containsKey(newBuildingName)) {
                Map map2 = cityConstructions.getInProgressConstructions();
                Integer n = cityConstructions.getInProgressConstructions().get(oldBuildingName);
                Intrinsics.checkNotNull(n);
                map2.put(newBuildingName, n);
            }
            cityConstructions.getInProgressConstructions().remove(oldBuildingName);
        }
    }

    private final void replaceUpdatedTechName(TechManager $this$replaceUpdatedTechName, String oldTechName, String newTechName) {
        int index;
        if ($this$replaceUpdatedTechName.getTechsResearched().contains(oldTechName)) {
            $this$replaceUpdatedTechName.getTechsResearched().remove(oldTechName);
            $this$replaceUpdatedTechName.getTechsResearched().add(newTechName);
        }
        if ((index = $this$replaceUpdatedTechName.getTechsToResearch().indexOf(oldTechName)) >= 0) {
            $this$replaceUpdatedTechName.getTechsToResearch().set(index, newTechName);
        }
        if (((Map)$this$replaceUpdatedTechName.getTechsInProgress()).containsKey(oldTechName)) {
            ((Map)$this$replaceUpdatedTechName.getTechsInProgress()).put(newTechName, $this$replaceUpdatedTechName.researchOfTech(oldTechName));
            $this$replaceUpdatedTechName.getTechsInProgress().remove(oldTechName);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void replaceDiplomacyFlag(@NotNull GameInfo $this$replaceDiplomacyFlag, @NotNull DiplomacyFlags old, @NotNull DiplomacyFlags diplomacyFlags) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$replaceDiplomacyFlag, "<this>");
        Intrinsics.checkNotNullParameter((Object)old, "old");
        Intrinsics.checkNotNullParameter((Object)diplomacyFlags, "new");
        Iterable $this$flatMap$iv = $this$replaceDiplomacyFlag.getCivilizations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Civilization civ = (Civilization)element$iv$iv;
            boolean bl = false;
            Collection<DiplomacyManager> collection = civ.getDiplomacy().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DiplomacyManager it = (DiplomacyManager)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            BackwardCompatibility.replaceDiplomacyFlag$replaceFlag(it, old, diplomacyFlags);
        }
    }

    public final void guaranteeUnitPromotions(@NotNull GameInfo $this$guaranteeUnitPromotions) {
        Intrinsics.checkNotNullParameter($this$guaranteeUnitPromotions, "<this>");
        for (Tile tileInfo : $this$guaranteeUnitPromotions.getTileMap().getValues()) {
            Iterator<MapUnit> iterator2 = tileInfo.getUnits().iterator();
            while (iterator2.hasNext()) {
                Iterator<String> iterator3;
                MapUnit unit = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(unit.getBaseUnit().getPromotions().iterator(), "iterator(...)");
                while (iterator3.hasNext()) {
                    String startingPromo;
                    Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                    unit.getPromotions().addPromotion(startingPromo, true);
                }
            }
        }
    }

    public final void updateDeprecations(@NotNull ModOptions $this$updateDeprecations) {
        Intrinsics.checkNotNullParameter($this$updateDeprecations, "<this>");
    }

    public final void convertFortify(@NotNull GameInfo $this$convertFortify) {
        Intrinsics.checkNotNullParameter($this$convertFortify, "<this>");
        Regex reg = new Regex("^Fortify\\s+(\\d+)([\\w\\s]*)");
        Iterator<Civilization> iterator2 = $this$convertFortify.getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civInfo;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Iterator<MapUnit> iterator4 = civInfo.getUnits().getCivUnits().iterator();
            while (iterator4.hasNext()) {
                MapUnit unit = iterator4.next();
                if (unit.getAction() == null) continue;
                String string = unit.getAction();
                Intrinsics.checkNotNull(string);
                if (!reg.matches(string)) continue;
                String string2 = unit.getAction();
                Intrinsics.checkNotNull(string2);
                MatchResult matchResult = Regex.find$default(reg, string2, 0, 2, null);
                Intrinsics.checkNotNull(matchResult);
                MatchResult.Destructured destructured = matchResult.getDestructured();
                String turns = destructured.getMatch().getGroupValues().get(1);
                String heal = destructured.getMatch().getGroupValues().get(2);
                unit.setTurnsFortified(Integer.parseInt(turns));
                unit.setAction("Fortify" + heal);
            }
        }
    }

    public final void migrateToTileHistory(@NotNull GameInfo $this$migrateToTileHistory) {
        Intrinsics.checkNotNullParameter($this$migrateToTileHistory, "<this>");
        if ($this$migrateToTileHistory.getHistoryStartTurn() >= 0) {
            return;
        }
        Iterator iterator2 = SequencesKt.flatMap($this$migrateToTileHistory.getCities(), BackwardCompatibility::migrateToTileHistory$lambda$0).iterator();
        while (iterator2.hasNext()) {
            Tile tile = (Tile)iterator2.next();
            tile.getHistory().recordTakeOwnership(tile);
        }
        $this$migrateToTileHistory.setHistoryStartTurn($this$migrateToTileHistory.getTurns());
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureUnitIds(@NotNull GameInfo $this$ensureUnitIds) {
        void $this$flatMapTo$iv$iv;
        Object it;
        Intrinsics.checkNotNullParameter($this$ensureUnitIds, "<this>");
        if ($this$ensureUnitIds.getLastUnitId() == 0) {
            Object object;
            Sequence sequence = SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)$this$ensureUnitIds.getTileMap().getValues()), BackwardCompatibility::ensureUnitIds$lambda$0);
            GameInfo gameInfo = $this$ensureUnitIds;
            Iterator iterator2 = sequence.iterator();
            if (!iterator2.hasNext()) {
                object = null;
            } else {
                it = (MapUnit)iterator2.next();
                boolean bl = false;
                it = ((MapUnit)it).getId();
                while (iterator2.hasNext()) {
                    Object it2 = (MapUnit)iterator2.next();
                    $i$a$-maxOfOrNull-BackwardCompatibility$ensureUnitIds$2 = false;
                    if (it.compareTo(it2 = (Comparable)Integer.valueOf(((MapUnit)it2).getId())) >= 0) continue;
                    it = it2;
                }
                object = it;
            }
            Integer n = (Integer)object;
            gameInfo.setLastUnitId(n != null ? RangesKt.coerceAtLeast(n, 0) : 0);
        }
        Iterable $this$flatMap$iv = $this$ensureUnitIds.getTileMap().getValues();
        boolean $i$f$flatMapSequence = false;
        it = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Tile it3 = (Tile)element$iv$iv;
            boolean bl = false;
            Sequence<MapUnit> list$iv$iv = it3.getUnits();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (MapUnit unit : (List)destination$iv$iv) {
            if (unit.getId() != -1) continue;
            $this$ensureUnitIds.setLastUnitId($this$ensureUnitIds.getLastUnitId() + 1);
            unit.setId($this$ensureUnitIds.getLastUnitId());
        }
    }

    private static final Sequence handleMissingReferencesForEachCity$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CollectionsKt.asSequence((Iterable)it.getCities());
    }

    @Readonly
    private static final boolean handleMissingReferencesForEachCity$isInvalidConstruction(GameInfo $this_handleMissingReferencesForEachCity, String construction) {
        return !$this_handleMissingReferencesForEachCity.getRuleset().getBuildings().containsKey(construction) && !$this_handleMissingReferencesForEachCity.getRuleset().getUnits().containsKey(construction) && !PerpetualConstruction.Companion.getPerpetualConstructionsMap().containsKey(construction);
    }

    private static final String changeBuildingNameIfNotInRuleset$lambda$0(String $oldBuildingName, String $newBuildingName, String entry, City city) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        Intrinsics.checkNotNullParameter(city, "<unused var>");
        return Intrinsics.areEqual(entry, $oldBuildingName) ? $newBuildingName : entry;
    }

    private static final void replaceDiplomacyFlag$replaceFlag(DiplomacyManager $this$replaceDiplomacyFlag_u24replaceFlag, DiplomacyFlags $old, DiplomacyFlags $new) {
        if ($this$replaceDiplomacyFlag_u24replaceFlag.hasFlag($old)) {
            int value = $this$replaceDiplomacyFlag_u24replaceFlag.getFlag($old);
            $this$replaceDiplomacyFlag_u24replaceFlag.removeFlag($old);
            $this$replaceDiplomacyFlag_u24replaceFlag.setFlag($new, value);
        }
    }

    private static final Sequence migrateToTileHistory$lambda$0(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTiles();
    }

    private static final Sequence ensureUnitIds$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUnits();
    }
}

