/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.MapParameters;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010\f\u001a\u00020\u0005H\u0007J\b\u0010\u0015\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u0005H\u0007J\b\u0010\u0016\u001a\u00020\tH\u0007J\b\u0010\u0017\u001a\u00020\tH\u0007J\b\u0010\u0018\u001a\u00020\tH\u0007J\b\u0010\u0019\u001a\u00020\tH\u0007J\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!J\u0016\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tJ\u0010\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020!H\u0007J\b\u0010(\u001a\u00020)H\u0007J\b\u0010*\u001a\u00020)H\u0007J\u000e\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/unciv/logic/civilization/ExploredRegion;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "worldWrap", "", "evenMapWidth", "rectangularMap", "mapRadius", "", "tileRadius", "shouldRecalculateCoords", "shouldUpdateMinimap", "exploredRectangle", "Lcom/badlogic/gdx/math/Rectangle;", "shouldRestrictX", "topLeftStage", "Lcom/badlogic/gdx/math/Vector2;", "bottomRightStage", "topLeft", "bottomRight", "getRectangle", "getLeftX", "getRightX", "getTopY", "getBottomY", "clone", "setMapParameters", "", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "checkTilePosition", "tilePosition", "Lcom/unciv/logic/map/HexCoord;", "explorerPosition", "calculateStageCoords", "mapMaxX", "mapMaxY", "isPositionInRegion", "postition", "getWidth", "", "getHeight", "getMinimapLeft", "tileSize", "core"})
public final class ExploredRegion
implements IsPartOfGameInfoSerialization {
    private transient boolean worldWrap;
    private transient boolean evenMapWidth;
    private transient boolean rectangularMap;
    private transient float mapRadius;
    private final transient float tileRadius;
    private transient boolean shouldRecalculateCoords = true;
    private transient boolean shouldUpdateMinimap = true;
    @NotNull
    private final transient Rectangle exploredRectangle = new Rectangle();
    private transient boolean shouldRestrictX;
    @NotNull
    private transient Vector2 topLeftStage = new Vector2();
    @NotNull
    private transient Vector2 bottomRightStage = new Vector2();
    @NotNull
    private Vector2 topLeft = new Vector2();
    @NotNull
    private Vector2 bottomRight = new Vector2();

    public ExploredRegion() {
        this.tileRadius = 40.0f;
    }

    @Readonly
    public final boolean shouldRecalculateCoords() {
        return this.shouldRecalculateCoords;
    }

    @Readonly
    public final boolean shouldUpdateMinimap() {
        return this.shouldUpdateMinimap;
    }

    @Readonly
    @NotNull
    public final Rectangle getRectangle() {
        return this.exploredRectangle;
    }

    @Readonly
    public final boolean shouldRestrictX() {
        return this.shouldRestrictX;
    }

    @Readonly
    public final float getLeftX() {
        return this.topLeftStage.x;
    }

    @Readonly
    public final float getRightX() {
        return this.bottomRightStage.x;
    }

    @Readonly
    public final float getTopY() {
        return this.topLeftStage.y;
    }

    @Readonly
    public final float getBottomY() {
        return this.bottomRightStage.y;
    }

    @NotNull
    public final ExploredRegion clone() {
        ExploredRegion toReturn = new ExploredRegion();
        toReturn.topLeft = this.topLeft;
        toReturn.bottomRight = this.bottomRight;
        return toReturn;
    }

    public final void setMapParameters(@NotNull MapParameters mapParameters) {
        Intrinsics.checkNotNullParameter(mapParameters, "mapParameters");
        this.evenMapWidth = this.worldWrap = mapParameters.getWorldWrap();
        if (Intrinsics.areEqual(mapParameters.getShape(), "Rectangular")) {
            this.mapRadius = mapParameters.getMapSize().getWidth() / 2;
            this.evenMapWidth = mapParameters.getMapSize().getWidth() % 2 == 0 || this.evenMapWidth;
            this.rectangularMap = true;
        } else {
            this.mapRadius = mapParameters.getMapSize().getRadius();
        }
    }

    public final void checkTilePosition(@NotNull HexCoord tilePosition, @Nullable HexCoord explorerPosition) {
        Intrinsics.checkNotNullParameter(tilePosition, "tilePosition");
        boolean mapExplored = false;
        float longitude = HexMath.INSTANCE.getLongitude(tilePosition);
        float latitude = HexMath.INSTANCE.getLatitude(tilePosition);
        if (Intrinsics.areEqual(this.topLeft, Vector2.Zero) && Intrinsics.areEqual(this.bottomRight, Vector2.Zero)) {
            this.topLeft = new Vector2(longitude, latitude);
            this.bottomRight = new Vector2(longitude, latitude);
            return;
        }
        if (this.topLeft.x >= this.bottomRight.x) {
            if (longitude > this.topLeft.x) {
                if (this.worldWrap && longitude == this.mapRadius) {
                    longitude = this.mapRadius * -1.0f;
                }
                this.topLeft.x = longitude;
                mapExplored = true;
            } else if (longitude < this.bottomRight.x) {
                if (this.worldWrap && longitude == this.mapRadius * -1.0f + 1.0f) {
                    longitude = this.mapRadius + 1.0f;
                }
                this.bottomRight.x = longitude;
                mapExplored = true;
            }
        } else if (longitude < this.bottomRight.x && longitude > this.topLeft.x) {
            float rightSideDistance = 0.0f;
            float leftSideDistance = 0.0f;
            if (explorerPosition != null) {
                int explorerLongitude = HexMath.INSTANCE.getLongitude(explorerPosition);
                rightSideDistance = explorerLongitude < 0 && this.bottomRight.x > 0.0f ? this.mapRadius * 2.0f + (float)explorerLongitude - this.bottomRight.x : Math.abs((float)explorerLongitude - this.bottomRight.x);
                leftSideDistance = explorerLongitude > 0 && this.topLeft.x < 0.0f ? this.mapRadius * 2.0f - (float)explorerLongitude + this.topLeft.x : Math.abs(this.topLeft.x - (float)explorerLongitude);
            } else {
                rightSideDistance = this.bottomRight.x - longitude;
                leftSideDistance = longitude - this.topLeft.x;
            }
            if (rightSideDistance > leftSideDistance) {
                this.topLeft.x = longitude;
            } else {
                this.bottomRight.x = longitude;
            }
            mapExplored = true;
        }
        if (latitude > this.topLeft.y) {
            this.topLeft.y = latitude;
            mapExplored = true;
        } else if (latitude < this.bottomRight.y) {
            this.bottomRight.y = latitude;
            mapExplored = true;
        }
        if (mapExplored) {
            this.shouldRecalculateCoords = true;
            this.shouldUpdateMinimap = true;
        }
    }

    public final void calculateStageCoords(float mapMaxX, float mapMaxY) {
        this.shouldRecalculateCoords = false;
        this.shouldRestrictX = !(this.bottomRight.x - this.topLeft.x == 1.0f);
        Vector2 topLeftWorld = HexMath.INSTANCE.worldFromLatLong(this.topLeft, this.tileRadius);
        Vector2 bottomRightWorld = HexMath.INSTANCE.worldFromLatLong(this.bottomRight, this.tileRadius);
        float mapCenterX = this.evenMapWidth ? (mapMaxX + 50.0f + 4.0f) * 0.5f : mapMaxX * 0.5f;
        float left = mapCenterX + topLeftWorld.x;
        float right = mapCenterX + bottomRightWorld.x;
        if (left > mapMaxX) {
            left = 10.0f;
        }
        if (right < 0.0f) {
            right = mapMaxX - 10.0f;
        }
        float mapCenterY = this.rectangularMap ? mapMaxY * 0.5f + 12.5f : mapMaxY * 0.5f;
        float top = mapCenterY - topLeftWorld.y;
        float bottom = mapCenterY - bottomRightWorld.y;
        this.topLeftStage = new Vector2(left, top);
        this.bottomRightStage = new Vector2(right, bottom);
        float yOffset = this.tileRadius * (float)Math.sqrt(3.0f) * 0.5f;
        this.exploredRectangle.x = left - this.tileRadius;
        this.exploredRectangle.y = mapMaxY - bottom - yOffset * 0.5f;
        this.exploredRectangle.width = (float)this.getWidth() * this.tileRadius * 1.5f;
        this.exploredRectangle.height = (float)this.getHeight() * yOffset;
    }

    @Readonly
    public final boolean isPositionInRegion(@NotNull HexCoord postition) {
        Intrinsics.checkNotNullParameter(postition, "postition");
        int n = HexMath.INSTANCE.getLongitude(postition);
        int lat = HexMath.INSTANCE.getLatitude(postition);
        return this.topLeft.x > this.bottomRight.x ? (float)n <= this.topLeft.x && (float)n >= this.bottomRight.x && (float)lat <= this.topLeft.y && (float)lat >= this.bottomRight.y : ((float)n >= this.topLeft.x && (float)n >= this.bottomRight.x || (float)n <= this.topLeft.x && (float)n <= this.bottomRight.x) && (float)lat <= this.topLeft.y && (float)lat >= this.bottomRight.y;
    }

    @Readonly
    public final int getWidth() {
        float result2 = 0.0f;
        result2 = this.topLeft.x > this.bottomRight.x ? this.topLeft.x - this.bottomRight.x : this.mapRadius * 2.0f - (this.bottomRight.x - this.topLeft.x);
        return (int)result2 + 1;
    }

    @Readonly
    public final int getHeight() {
        return (int)(this.topLeft.y - this.bottomRight.y) + 1;
    }

    public final float getMinimapLeft(float tileSize) {
        this.shouldUpdateMinimap = false;
        return (this.topLeft.x + 1.0f) * tileSize * -0.75f;
    }
}

