/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator;

import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.mapgenerator.MapGenerator;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.NamedStats;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0015*\u00020\u0016H\u0002J\f\u0010\u0018\u001a\u00020\u0011*\u00020\u0016H\u0002J\u001a\u0010\u0019\u001a\u00020\u0015*\u00020\u00162\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00162\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator;", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "terrains", "", "Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange;", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "<init>", "(Lcom/unciv/logic/map/TileMap;Lcom/unciv/models/ruleset/Ruleset;Ljava/util/List;Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;)V", "flats", "hills", "mountains", "raiseMountainsAndHills", "", "cellularMountainRanges", "cellularHills", "isMountainTerrain", "", "Lcom/unciv/logic/map/tile/Tile;", "isHillTerrain", "dropElevatedFeatures", "hasTerrain", "applyTerrain", "tile", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMapElevationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapElevationGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapElevationGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n777#2:219\n873#2,2:220\n777#2:222\n873#2,2:223\n777#2:225\n873#2,2:226\n1834#2,4:228\n777#2:232\n873#2,2:233\n1586#2:235\n1661#2,3:236\n1834#2,4:239\n1834#2,4:249\n1834#2,4:253\n777#2:263\n873#2,2:264\n777#2:267\n873#2,2:268\n777#2:270\n873#2,2:271\n1297#3,3:243\n1297#3,3:246\n1297#3,3:257\n1297#3,3:260\n1#4:266\n*S KotlinDebug\n*F\n+ 1 MapElevationGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapElevationGenerator\n*L\n25#1:219\n25#1:220,2\n26#1:222\n26#1:223,2\n27#1:225\n27#1:226,2\n68#1:228,4\n69#1:232\n69#1:233,2\n69#1:235\n69#1:236,3\n72#1:239,4\n116#1:249,4\n119#1:253,4\n201#1:263\n201#1:264,2\n206#1:267\n206#1:268,2\n207#1:270\n207#1:271,2\n77#1:243,3\n78#1:246,3\n125#1:257,3\n126#1:260,3\n*E\n"})
public final class MapElevationGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TileMap tileMap;
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final MapGenerationRandomness randomness;
    @NotNull
    private final List<MapGenerator.TerrainOccursRange> flats;
    @NotNull
    private final List<MapGenerator.TerrainOccursRange> hills;
    @NotNull
    private final List<MapGenerator.TerrainOccursRange> mountains;
    @NotNull
    private static final String rising = "~Raising~";
    @NotNull
    private static final String lowering = "~Lowering~";

    public MapElevationGenerator(@NotNull TileMap tileMap, @NotNull Ruleset ruleset, @NotNull List<MapGenerator.TerrainOccursRange> terrains, @NotNull MapGenerationRandomness randomness) {
        MapGenerator.TerrainOccursRange it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(terrains, "terrains");
        Intrinsics.checkNotNullParameter(randomness, "randomness");
        this.tileMap = tileMap;
        this.ruleset = ruleset;
        this.randomness = randomness;
        Iterable iterable = terrains;
        MapElevationGenerator mapElevationGenerator = this;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MapGenerator.TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!(!it.getTerrain().getImpassable() && it.getTerrain().getType() == TerrainType.Land && !it.getRareFeature() && !IHasUniques.hasUnique$default(it.getTerrain(), UniqueType.RoughTerrain, null, 2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mapElevationGenerator.flats = (List)destination$iv$iv;
        $this$filter$iv = terrains;
        mapElevationGenerator = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MapGenerator.TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!((it.getTerrain().getType() == TerrainType.Land || it.getTerrain().getType() == TerrainType.TerrainFeature) && it.getOccursInGroups() && !it.getRareFeature())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mapElevationGenerator.hills = (List)destination$iv$iv;
        $this$filter$iv = terrains;
        mapElevationGenerator = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MapGenerator.TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!((it.getTerrain().getType() == TerrainType.Land || it.getTerrain().getType() == TerrainType.TerrainFeature) && it.getOccursInChains() && !it.getRareFeature())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mapElevationGenerator.mountains = (List)destination$iv$iv;
    }

    public final void raiseMountainsAndHills() {
        if (this.flats.isEmpty()) {
            Log.INSTANCE.debug("Ruleset seems to contain no flat terrain - can't generate heightmap", new Object[0]);
            return;
        }
        double elevationSeed = this.randomness.getRNG().nextInt();
        double exponent = 1.0 - (double)this.tileMap.getMapParameters().getElevationExponent();
        TileMap.setTransients$default(this.tileMap, this.ruleset, false, 2, null);
        for (Tile tile : this.tileMap.getValues()) {
            if (tile.isWater()) continue;
            double elevation = MapElevationGenerator.raiseMountainsAndHills$powSigned(MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, elevationSeed, 0, 0.0, 0.0, 2.0, 28, null), exponent);
            if (elevation > 0.7 && !((Collection)this.mountains).isEmpty()) {
                this.applyTerrain(tile, this.mountains);
                continue;
            }
            if (elevation > 0.5 && !((Collection)this.hills).isEmpty()) {
                this.applyTerrain(tile, this.hills);
                continue;
            }
            this.applyTerrain(tile, this.flats);
        }
        this.cellularMountainRanges();
        this.cellularHills();
        for (Tile tile : this.tileMap.getValues()) {
            tile.setTerrainTransients();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cellularMountainRanges() {
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        int n;
        if (this.mountains.isEmpty()) {
            return;
        }
        Log.INSTANCE.debug("Mountain-like generation", new Object[0]);
        Iterable $this$count$iv = this.tileMap.getValues();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Tile it2 = (Tile)element$iv;
                boolean bl = false;
                if (!this.isMountainTerrain(it2) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int targetMountains = n * 2;
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterator<Tile> iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            boolean bl = false;
            if (!((Terrain)it).getImpassable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Terrain)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((NamedStats)it).getName());
        }
        Set impassableTerrains = CollectionsKt.toSet((List)destination$iv$iv);
        for (int i = 1; i < 6; ++i) {
            int n2;
            Iterable $this$count$iv2 = this.tileMap.getValues();
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv2) {
                    it = (Tile)element$iv;
                    boolean bl = false;
                    if (!this.isMountainTerrain((Tile)it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int totalMountains = n2 * 2;
            for (Tile tile : this.tileMap.getValues()) {
                if (tile.isWater()) continue;
                boolean isMountain = this.isMountainTerrain(tile);
                Sequence<Tile> $this$count$iv3 = tile.getNeighbors();
                boolean $i$f$count3 = false;
                int count$iv = 0;
                Iterator<Tile> iterator3 = $this$count$iv3.iterator();
                while (iterator3.hasNext()) {
                    Tile element$iv;
                    Tile it3 = element$iv = iterator3.next();
                    boolean bl = false;
                    if (!this.isMountainTerrain(it3) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int adjacentMountains = count$iv;
                Sequence<Tile> $this$count$iv4 = tile.getNeighbors();
                boolean $i$f$count4 = false;
                int count$iv2 = 0;
                Iterator<Tile> iterator4 = $this$count$iv4.iterator();
                while (iterator4.hasNext()) {
                    Tile element$iv;
                    Tile it4 = element$iv = iterator4.next();
                    boolean bl = false;
                    if (!impassableTerrains.contains(it4.getBaseTerrain()) || ++count$iv2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int adjacentImpassible = count$iv2;
                if (adjacentMountains == 0) {
                    if (!isMountain || this.randomness.getRNG().nextInt(4) != 0) continue;
                    tile.addTerrainFeature(lowering);
                    continue;
                }
                if (adjacentMountains == 1) {
                    if (isMountain || this.randomness.getRNG().nextInt(10) != 0) continue;
                    tile.addTerrainFeature(rising);
                    continue;
                }
                if (adjacentImpassible == 3) {
                    if (!isMountain || this.randomness.getRNG().nextInt(2) != 0) continue;
                    tile.addTerrainFeature(lowering);
                    continue;
                }
                if (!isMountain || adjacentImpassible <= 3) continue;
                tile.addTerrainFeature(lowering);
            }
            for (Tile tile : this.tileMap.getValues()) {
                if (tile.isWater()) continue;
                if (tile.getTerrainFeatures().contains(rising)) {
                    tile.removeTerrainFeature(rising);
                    if (totalMountains >= targetMountains) continue;
                    ++totalMountains;
                    this.applyTerrain(tile, this.mountains);
                }
                if (!tile.getTerrainFeatures().contains(lowering)) continue;
                tile.removeTerrainFeature(lowering);
                if (totalMountains * 2 <= targetMountains) continue;
                --totalMountains;
                this.applyTerrain(tile, this.flats);
            }
        }
    }

    private final void cellularHills() {
        int n;
        if (this.hills.isEmpty()) {
            return;
        }
        Log.INSTANCE.debug("Hill-like generation", new Object[0]);
        Iterable $this$count$iv = this.tileMap.getValues();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!this.isHillTerrain(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int targetHills = n;
        for (int i = 1; i < 6; ++i) {
            int n2;
            Iterable $this$count$iv2 = this.tileMap.getValues();
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv2) {
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    if (!this.isHillTerrain(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int totalHills = n2;
            for (Tile tile : this.tileMap.getValues()) {
                boolean isMountain = this.hasTerrain(tile, this.mountains);
                if (tile.isWater() || isMountain) continue;
                boolean isHill = this.isHillTerrain(tile);
                Sequence<Tile> $this$count$iv3 = tile.getNeighbors();
                boolean $i$f$count3 = false;
                int count$iv = 0;
                Iterator<Tile> iterator2 = $this$count$iv3.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!this.isMountainTerrain(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int adjacentMountains = count$iv;
                Sequence<Tile> $this$count$iv4 = tile.getNeighbors();
                boolean $i$f$count4 = false;
                int count$iv2 = 0;
                Iterator<Tile> iterator3 = $this$count$iv4.iterator();
                while (iterator3.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator3.next();
                    boolean bl = false;
                    if (!this.isHillTerrain(it) || ++count$iv2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int adjacentHills = count$iv2;
                if (adjacentHills <= 1 && adjacentMountains == 0 && isHill && this.randomness.getRNG().nextInt(2) == 0) {
                    tile.addTerrainFeature(lowering);
                    continue;
                }
                if (adjacentHills > 3 && adjacentMountains == 0 && isHill && this.randomness.getRNG().nextInt(2) == 0) {
                    tile.addTerrainFeature(lowering);
                    continue;
                }
                int n3 = adjacentHills + adjacentMountains;
                boolean bl = 2 <= n3 ? n3 < 4 : false;
                if (!bl || isHill || this.randomness.getRNG().nextInt(2) != 0) continue;
                tile.addTerrainFeature(rising);
            }
            for (Tile tile : this.tileMap.getValues()) {
                if (tile.getTerrainFeatures().contains(rising)) {
                    tile.removeTerrainFeature(rising);
                    if (totalHills > targetHills && i != 1) continue;
                    ++totalHills;
                    this.applyTerrain(tile, this.hills);
                }
                if (!tile.getTerrainFeatures().contains(lowering)) continue;
                tile.removeTerrainFeature(lowering);
                if (!((float)totalHills >= (float)targetHills * 0.9f) && i != 1) continue;
                --totalHills;
                this.applyTerrain(tile, this.flats);
            }
        }
    }

    private final boolean isMountainTerrain(Tile $this$isMountainTerrain) {
        Terrain terrain = $this$isMountainTerrain.getRuleset().getTerrains().get($this$isMountainTerrain.getBaseTerrain());
        if (terrain == null) {
            return false;
        }
        Terrain terrainObj = terrain;
        if (IHasUniques.hasUnique$default(terrainObj, UniqueType.OccursInChains, null, 2, null)) {
            return true;
        }
        for (String feature : $this$isMountainTerrain.getTerrainFeatures()) {
            Terrain featureObj;
            if ($this$isMountainTerrain.getRuleset().getTerrains().get(feature) == null || !IHasUniques.hasUnique$default(featureObj, UniqueType.OccursInChains, null, 2, null)) continue;
            return true;
        }
        return false;
    }

    private final boolean isHillTerrain(Tile $this$isHillTerrain) {
        Terrain terrain = $this$isHillTerrain.getRuleset().getTerrains().get($this$isHillTerrain.getBaseTerrain());
        if (terrain == null) {
            return false;
        }
        Terrain terrainObj = terrain;
        if (IHasUniques.hasUnique$default(terrainObj, UniqueType.OccursInGroups, null, 2, null)) {
            return true;
        }
        for (String feature : $this$isHillTerrain.getTerrainFeatures()) {
            Terrain featureObj;
            if ($this$isHillTerrain.getRuleset().getTerrains().get(feature) == null || !IHasUniques.hasUnique$default(featureObj, UniqueType.OccursInGroups, null, 2, null)) continue;
            return true;
        }
        return false;
    }

    private final void dropElevatedFeatures(Tile $this$dropElevatedFeatures) {
        for (String feature : $this$dropElevatedFeatures.getTerrainFeatures()) {
            Terrain featureObj;
            if ($this$dropElevatedFeatures.getRuleset().getTerrains().get(feature) == null || !IHasUniques.hasUnique$default(featureObj, UniqueType.OccursInChains, null, 2, null) && !IHasUniques.hasUnique$default(featureObj, UniqueType.OccursInGroups, null, 2, null)) continue;
            $this$dropElevatedFeatures.removeTerrainFeature(feature);
            return;
        }
    }

    private final boolean hasTerrain(Tile $this$hasTerrain, List<MapGenerator.TerrainOccursRange> terrains) {
        for (MapGenerator.TerrainOccursRange terrain : terrains) {
            if (!(terrain.getTerrain().getType() == TerrainType.Land ? Intrinsics.areEqual($this$hasTerrain.getBaseTerrain(), terrain.getName()) : $this$hasTerrain.getTerrainFeatures().contains(terrain.getName()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyTerrain(Tile tile, List<MapGenerator.TerrainOccursRange> terrains) {
        List<MapGenerator.TerrainOccursRange> list2;
        void $this$filterTo$iv$iv;
        Collection<MapGenerator.TerrainOccursRange> $this$filter$iv = terrains;
        boolean $i$f$filter = false;
        List<MapGenerator.TerrainOccursRange> list3 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MapGenerator.TerrainOccursRange it = (MapGenerator.TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!it.matches(tile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        if ($this$filter$iv.isEmpty()) {
            boolean bl = false;
            list2 = terrains;
        } else {
            list2 = $this$filter$iv;
        }
        MapGenerator.TerrainOccursRange desiredTerrain = (MapGenerator.TerrainOccursRange)CollectionsKt.random((Collection)list2, this.randomness.getRNG());
        this.dropElevatedFeatures(tile);
        if (desiredTerrain.getTerrain().getType() == TerrainType.Land) {
            tile.setBaseTerrain(desiredTerrain.getName());
        } else {
            Iterable iterable;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = this.flats;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                MapGenerator.TerrainOccursRange it = (MapGenerator.TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!(desiredTerrain.getTerrain().getOccursOn().contains(it.getName()) && it.matches(tile))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            if ($this$filter$iv2.isEmpty()) {
                void $this$filterTo$iv$iv3;
                boolean bl = false;
                Iterable $this$filter$iv3 = this.flats;
                boolean $i$f$filter3 = false;
                Iterable $i$f$filterTo22 = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    MapGenerator.TerrainOccursRange it = (MapGenerator.TerrainOccursRange)element$iv$iv;
                    boolean bl2 = false;
                    if (!desiredTerrain.getTerrain().getOccursOn().contains(it.getName())) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                iterable = (List)destination$iv$iv3;
            } else {
                iterable = $this$filter$iv2;
            }
            List baseTerrains = (List)iterable;
            if (baseTerrains.isEmpty()) {
                Log.INSTANCE.debug("Ruleset seems to contain no flat terrain that " + desiredTerrain.getName() + " can apply to. Failing feature.", new Object[0]);
                return;
            }
            MapGenerator.TerrainOccursRange baseTerrain = (MapGenerator.TerrainOccursRange)CollectionsKt.random(baseTerrains, this.randomness.getRNG());
            tile.setBaseTerrain(baseTerrain.getName());
            tile.addTerrainFeature(desiredTerrain.getName());
        }
    }

    private static final double raiseMountainsAndHills$powSigned(double $this$raiseMountainsAndHills_u24powSigned, double exponent) {
        return Math.pow(Math.abs($this$raiseMountainsAndHills_u24powSigned), exponent) * Math.signum($this$raiseMountainsAndHills_u24powSigned);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$Companion;", "", "<init>", "()V", "rising", "", "lowering", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

