/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapunit;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J\u0006\u0010\r\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/unciv/logic/map/mapunit/UnitTurnManager;", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "<init>", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "endTurn", "", "healUnit", "doCitadelDamage", "doTerrainDamage", "startTurn", "core"})
@SourceDebugExtension(value={"SMAP\nUnitTurnManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitTurnManager.kt\ncom/unciv/logic/map/mapunit/UnitTurnManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1484#2,14:180\n1276#2,2:194\n1#3:196\n*S KotlinDebug\n*F\n+ 1 UnitTurnManager.kt\ncom/unciv/logic/map/mapunit/UnitTurnManager\n*L\n85#1:180,14\n150#1:194,2\n*E\n"})
public final class UnitTurnManager {
    @NotNull
    private final MapUnit unit;

    public UnitTurnManager(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    public final void endTurn() {
        IsPartOfGameInfoSerialization tile;
        this.unit.getMovement().clearPathfindingCache();
        Iterator iterator2 = MapUnit.getTriggeredUniques$default(this.unit, UniqueType.TriggerUponTurnEnd, null, null, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.unit, null, null, 12, null);
        }
        if (this.unit.hasMovement() && this.unit.getTile().getImprovementInProgress() != null) {
            TileImprovement tileImprovement = this.unit.getTile().getTileImprovementInProgress();
            Intrinsics.checkNotNull(tileImprovement);
            if (MapUnit.canBuildImprovement$default(this.unit, tileImprovement, null, 2, null) && ((Tile)(tile = this.unit.getTile())).doWorkerTurn(this.unit)) {
                City city = ((Tile)tile).getCity();
                if (city != null) {
                    city.setShouldReassignPopulation(true);
                }
            }
        }
        if (!this.unit.hasUnitMovedThisTurn() && (this.unit.isFortified() || this.unit.isGuarding() && MapUnit.canFortify$default(this.unit, false, 1, null)) && this.unit.getTurnsFortified() < 2) {
            tile = this.unit;
            int unique = ((MapUnit)tile).getTurnsFortified();
            ((MapUnit)tile).setTurnsFortified(unique + 1);
        }
        if (!this.unit.isFortified() && !this.unit.isGuarding()) {
            this.unit.setTurnsFortified(0);
        }
        if (!this.unit.hasUnitMovedThisTurn() && this.unit.getAttacksThisTurn() == 0 || MapUnit.hasUnique$default(this.unit, UniqueType.HealsEvenAfterAction, null, false, 6, null)) {
            this.healUnit();
        }
        if (this.unit.isPreparingParadrop() || this.unit.isPreparingAirSweep()) {
            this.unit.setAction(null);
        }
        if (MapUnit.hasUnique$default(this.unit, UniqueType.ReligiousUnit, null, false, 6, null) && this.unit.getTile().getOwner() != null) {
            Civilization civilization = this.unit.getTile().getOwner();
            Intrinsics.checkNotNull(civilization);
            if (!civilization.isCityState()) {
                DiplomacyFunctions diplomacyFunctions = this.unit.getCiv().getDiplomacyFunctions();
                Civilization civilization2 = this.unit.getTile().getOwner();
                Intrinsics.checkNotNull(civilization2);
                if (!diplomacyFunctions.canPassThroughTiles(civilization2)) {
                    Integer lostReligiousStrength = SequencesKt.minOrNull(SequencesKt.map(MapUnit.getMatchingUniques$default(this.unit, UniqueType.CanEnterForeignTilesButLosesReligiousStrength, null, false, 6, null), UnitTurnManager::endTurn$lambda$0));
                    if (lostReligiousStrength != null) {
                        MapUnit unique = this.unit;
                        unique.setReligiousStrengthLost(unique.getReligiousStrengthLost() + lostReligiousStrength);
                    }
                    if (this.unit.getReligiousStrengthLost() >= this.unit.getBaseUnit().getReligiousStrength()) {
                        String[] unique = new String[]{this.unit.getName()};
                        this.unit.getCiv().addNotification("Your [" + this.unit.getName() + "] lost its faith after spending too long inside enemy territory!", this.unit.getTile().getPosition(), Notification.NotificationCategory.Units, unique);
                        MapUnit.destroy$default(this.unit, false, 1, null);
                    }
                }
            }
        }
        this.doCitadelDamage();
        this.doTerrainDamage();
        this.unit.addMovementMemory();
        iterator2 = MapUnit.getTriggeredUniques$default(this.unit, UniqueType.TriggerUponEndingTurnInTile, null, arg_0 -> UnitTurnManager.endTurn$lambda$1(this, arg_0), 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.unit, null, null, 12, null);
        }
    }

    private final void healUnit() {
        int amountToHealBy = this.unit.getHealAmountForCurrentTile();
        if (amountToHealBy == 0) {
            return;
        }
        this.unit.healBy(amountToHealBy);
    }

    private final void doCitadelDamage() {
        Pair pair;
        Sequence<Pair> $this$maxByOrNull$iv = SequencesKt.map(SequencesKt.filter(this.unit.getCurrentTile().getNeighbors(), arg_0 -> UnitTurnManager.doCitadelDamage$lambda$0(this, arg_0)), UnitTurnManager::doCitadelDamage$lambda$1);
        boolean $i$f$maxByOrNull = false;
        Iterator<Pair> iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            pair = null;
        } else {
            Pair maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                pair = maxElem$iv;
            } else {
                Pair it = maxElem$iv;
                boolean bl = false;
                int maxValue$iv = ((Number)it.getSecond()).intValue();
                do {
                    Pair e$iv;
                    Pair it2 = e$iv = iterator$iv.next();
                    $i$a$-maxByOrNull-UnitTurnManager$doCitadelDamage$3 = false;
                    int v$iv = ((Number)it2.getSecond()).intValue();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                pair = maxElem$iv;
            }
        }
        Pair pair2 = pair;
        if (pair2 == null) {
            return;
        }
        Pair pair3 = pair2;
        Tile citadelTile = (Tile)pair3.component1();
        int damage = ((Number)pair3.component2()).intValue();
        if (damage == 0) {
            return;
        }
        this.unit.takeDamage(damage);
        String string = citadelTile.getImprovement();
        Intrinsics.checkNotNull(string);
        String improvementName = string;
        String improvementIcon = "ImprovementIcons/" + improvementName;
        Object[] objectArray = new HexCoord[]{citadelTile.getPosition(), this.unit.getCurrentTile().getPosition()};
        Sequence<LocationAction> locations = LocationAction.Companion.invoke((HexCoord[])objectArray);
        if (this.unit.getHealth() <= 0) {
            objectArray = new String[]{improvementIcon, "OtherIcons/DisbandUnit", this.unit.getName()};
            this.unit.getCiv().addNotification("An enemy [" + improvementName + "] has destroyed our [" + this.unit.getName() + ']', locations, Notification.NotificationCategory.War, (String[])objectArray);
            Civilization civilization = citadelTile.getOwner();
            if (civilization != null) {
                String[] stringArray = new String[]{improvementIcon, "OtherIcons/DisbandUnit", this.unit.getName()};
                civilization.addNotification("Your [" + improvementName + "] has destroyed an enemy [" + this.unit.getName() + ']', locations, Notification.NotificationCategory.War, stringArray);
            }
            MapUnit.destroy$default(this.unit, false, 1, null);
        } else {
            objectArray = new String[]{improvementIcon, "OtherIcons/Pillage", this.unit.getName()};
            this.unit.getCiv().addNotification("An enemy [" + improvementName + "] has attacked our [" + this.unit.getName() + ']', locations, Notification.NotificationCategory.War, (String[])objectArray);
        }
    }

    private final void doTerrainDamage() {
        int tileDamage = MapUnit.getDamageFromTerrain$default(this.unit, null, 1, null);
        if (tileDamage == 0) {
            return;
        }
        this.unit.takeDamage(tileDamage);
        if (this.unit.isDestroyed()) {
            String[] stringArray = new String[]{this.unit.getName(), "OtherIcons/DisbandUnit"};
            this.unit.getCiv().addNotification("Our [" + this.unit.getName() + "] took [" + tileDamage + "] tile damage and was destroyed", this.unit.getCurrentTile().getPosition(), Notification.NotificationCategory.Units, stringArray);
        } else {
            String[] stringArray = new String[]{this.unit.getName()};
            this.unit.getCiv().addNotification("Our [" + this.unit.getName() + "] took [" + tileDamage + "] tile damage", new MapUnitAction(this.unit), Notification.NotificationCategory.Units, stringArray);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void startTurn() {
        block9: {
            block8: {
                this.unit.getMovement().clearPathfindingCache();
                this.unit.setCurrentMovement(MapUnit.getMaxMovement$default(this.unit, false, 1, null));
                this.unit.setAttacksThisTurn(0);
                this.unit.setDue(true);
                var1_1 = MapUnit.getTriggeredUniques$default(this.unit, UniqueType.TriggerUponTurnStart, null, null, 6, null).iterator();
                while (var1_1.hasNext()) {
                    unique = (Unique)var1_1.next();
                    UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.unit, null, null, 12, null);
                }
                if (!this.unit.isSleeping() || !this.unit.isMilitary() && (this.unit.getCurrentTile().getMilitaryUnit() != null || this.unit.getCurrentTile().isCityCenter())) break block9;
                $this$any$iv = this.unit.getCurrentTile().getTilesInDistance(3);
                $i$f$any = false;
                var3_5 = $this$any$iv.iterator();
                while (var3_5.hasNext()) {
                    it = element$iv = var3_5.next();
                    $i$a$-any-UnitTurnManager$startTurn$1 = false;
                    if (it.getMilitaryUnit() == null || !this.unit.getCiv().getViewableTiles().contains(it)) ** GOTO lbl-1000
                    v0 = it.getMilitaryUnit();
                    Intrinsics.checkNotNull(v0);
                    if (v0.getCiv().isAtWarWith(this.unit.getCiv())) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = true;
                    break block8;
                }
                v2 = false;
            }
            if (v2) {
                this.unit.setAction(null);
            }
        }
        if (this.unit.getAction() != null && this.unit.getHealth() > 99 && this.unit.isActionUntilHealed()) {
            this.unit.setAction(null);
            $this$any$iv = new String[]{this.unit.getName()};
            this.unit.getCiv().addNotification('[' + this.unit.shortDisplayName() + "] has fully healed", new MapUnitAction(this.unit), Notification.NotificationCategory.Units, $this$any$iv);
        }
        if (!((tileOwner = this.unit.getTile().getOwner()) == null || this.unit.getCache().getCanEnterForeignTerrain() || this.unit.getCiv().getDiplomacyFunctions().canPassThroughTiles(tileOwner) || tileOwner.isCityState())) {
            this.unit.getMovement().teleportToClosestMoveableTile();
        }
        this.unit.addMovementMemory();
        this.unit.getAttacksSinceTurnStart().clear();
        v3 = this.unit.getStatusMap().values();
        Intrinsics.checkNotNullExpressionValue(v3, "<get-values>(...)");
        for (T v4 : CollectionsKt.toList((Iterable)v3)) {
            Intrinsics.checkNotNullExpressionValue(v4, "next(...)");
            status = (MapUnit.UnitStatus)v4;
            var4_7 = status.getTurnsLeft();
            status.setTurnsLeft(var4_7 + -1);
            if (status.getTurnsLeft() > 0) continue;
            this.unit.removeStatus(status.getName());
        }
        this.unit.updateUniques();
    }

    private static final int endTurn$lambda$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.parseInt(it.getParams().get(0));
    }

    private static final boolean endTurn$lambda$1(UnitTurnManager this$0, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.unit.getTile().matchesFilter(it.getParams().get(0), this$0.unit.getCiv());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean doCitadelDamage$lambda$0(UnitTurnManager this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getOwner() == null) return false;
        if (it.getUnpillagedImprovement() == null) return false;
        Civilization civilization = this$0.unit.getCiv();
        Civilization civilization2 = it.getOwner();
        Intrinsics.checkNotNull(civilization2);
        if (!civilization.isAtWarWith(civilization2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair doCitadelDamage$lambda$1(Tile tile) {
        int n;
        Intrinsics.checkNotNullParameter(tile, "tile");
        TileImprovement tileImprovement = tile.getTileImprovement();
        Intrinsics.checkNotNull(tileImprovement);
        Sequence<Unique> sequence = tileImprovement.getMatchingUniques(UniqueType.DamagesAdjacentEnemyUnits, tile.getStateThisTile$core());
        Tile tile2 = tile;
        int n2 = 0;
        Iterator<Unique> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Unique unique;
            Unique unique2 = unique = iterator2.next();
            n = n2;
            boolean bl = false;
            int n3 = Integer.parseInt(it.getParams().get(0));
            n2 = n + n3;
        }
        n = n2;
        return TuplesKt.to(tile2, n);
    }
}

