/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapunit.movement;

import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0003J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bJ\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0006\u0010\u0013\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/map/mapunit/movement/PathfindingCache;", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "<init>", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "shortestPathCache", "", "Lcom/unciv/logic/map/tile/Tile;", "destination", "movement", "", "currentTile", "isValid", "", "getShortestPathCache", "setShortestPathCache", "", "newShortestPath", "clear", "core"})
public final class PathfindingCache {
    @NotNull
    private final MapUnit unit;
    @NotNull
    private List<Tile> shortestPathCache;
    @Nullable
    private Tile destination;
    private float movement;
    @Nullable
    private Tile currentTile;

    public PathfindingCache(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
        this.shortestPathCache = CollectionsKt.emptyList();
        this.movement = -1.0f;
    }

    @Readonly
    private final boolean isValid() {
        return this.movement == this.unit.getCurrentMovement() && Intrinsics.areEqual(this.unit.getTile(), this.currentTile);
    }

    @NotNull
    public final List<Tile> getShortestPathCache(@NotNull Tile destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (this.unit.getCiv().isHuman()) {
            return CollectionsKt.emptyList();
        }
        if (this.isValid() && Intrinsics.areEqual(this.destination, destination)) {
            return this.shortestPathCache;
        }
        return CollectionsKt.emptyList();
    }

    public final void setShortestPathCache(@NotNull Tile destination, @NotNull List<Tile> newShortestPath) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(newShortestPath, "newShortestPath");
        if (this.unit.getCiv().isHuman()) {
            return;
        }
        if (this.isValid()) {
            this.shortestPathCache = newShortestPath;
            this.destination = destination;
        }
    }

    public final void clear() {
        this.movement = this.unit.getCurrentMovement();
        this.currentTile = this.unit.getTile();
        this.destination = null;
        this.shortestPathCache = CollectionsKt.emptyList();
    }
}

