/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.trade;

import com.unciv.logic.automation.civilization.DeclareWarPlanEvaluator;
import com.unciv.logic.automation.civilization.DiplomacyAutomation;
import com.unciv.logic.automation.civilization.MotivationToAttackAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0003J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u0012\u001a\u00020\u0005H\u0007J(\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0007J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\tH\u0003J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0003J(\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J(\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\tH\u0007J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0003J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0007J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0003\u00a8\u0006)"}, d2={"Lcom/unciv/logic/trade/TradeEvaluation;", "", "<init>", "()V", "isTradeValid", "", "trade", "Lcom/unciv/logic/trade/Trade;", "offerer", "Lcom/unciv/logic/civilization/Civilization;", "tradePartner", "isOfferValid", "tradeOffer", "Lcom/unciv/logic/trade/TradeOffer;", "isTradeAcceptable", "evaluator", "getTradeAcceptability", "", "includeDiplomaticGifts", "evaluateBuyCostWithInflation", "offer", "civInfo", "evaluateBuyCost", "isPeaceProposalEnabled", "thirdCiv", "surroundedByOurCities", "city", "Lcom/unciv/logic/city/City;", "getNeighbouringCivs", "", "evaluateSellCostWithInflation", "evaluateSellCost", "getGoldInflation", "", "distanceCityTradeModifier", "evaluatePeaceCostForThem", "ourCiv", "otherCiv", "introductionValue", "ruleSet", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
@SourceDebugExtension(value={"SMAP\nTradeEvaluation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeEvaluation.kt\ncom/unciv/logic/trade/TradeEvaluation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,560:1\n1834#2,4:561\n1834#2,4:565\n1807#2,3:569\n1834#2,4:572\n2792#2,3:577\n296#2,2:580\n1834#2,4:582\n1807#2,2:586\n1809#2:590\n1807#2,2:591\n1809#2:595\n1807#2,3:596\n1807#2,3:599\n296#2,2:602\n1807#2,3:604\n1807#2,3:607\n1807#2,3:610\n296#2,2:613\n1#3:576\n1276#4,2:588\n1276#4,2:593\n*S KotlinDebug\n*F\n+ 1 TradeEvaluation.kt\ncom/unciv/logic/trade/TradeEvaluation\n*L\n32#1:561,4\n33#1:565,4\n98#1:569,3\n109#1:572,4\n124#1:577,3\n128#1:580,2\n179#1:582,4\n204#1:586,2\n204#1:590\n207#1:591,2\n207#1:595\n227#1:596,3\n228#1:599,3\n259#1:602,2\n408#1:604,3\n439#1:607,3\n440#1:610,3\n458#1:613,2\n204#1:588,2\n207#1:593,2\n*E\n"})
public final class TradeEvaluation {
    @Readonly
    public final boolean isTradeValid(@NotNull Trade trade, @NotNull Civilization offerer, @NotNull Civilization tradePartner) {
        TradeOffer offer;
        block15: {
            block14: {
                int n;
                TradeOffer it;
                int count$iv;
                boolean $i$f$count;
                Iterable $this$count$iv;
                block13: {
                    int n2;
                    Intrinsics.checkNotNullParameter(trade, "trade");
                    Intrinsics.checkNotNullParameter(offerer, "offerer");
                    Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
                    if (!offerer.getHasEverOwnedOriginalCapital()) break block13;
                    $this$count$iv = trade.getOurOffers();
                    $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n2 = 0;
                    } else {
                        count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            it = (TradeOffer)element$iv;
                            boolean bl = false;
                            if (!(it.getType() == TradeOfferType.City) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n2 = count$iv;
                    }
                    if (n2 == offerer.getCities().size()) break block14;
                }
                if (!tradePartner.getHasEverOwnedOriginalCapital()) break block15;
                $this$count$iv = trade.getTheirOffers();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (TradeOffer)element$iv;
                        boolean bl = false;
                        if (!(it.getType() == TradeOfferType.City) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                if (n != tradePartner.getCities().size()) break block15;
            }
            return false;
        }
        TradeOffer embassyOffer = new TradeOffer("Accept Embassy", TradeOfferType.Embassy, 0, offerer.getGameInfo().getSpeed(), 4, null);
        DiplomacyManager diplomacyManager = tradePartner.getDiplomacyManager(offerer);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager theirDiploManager = diplomacyManager;
        DiplomacyManager diplomacyManager2 = offerer.getDiplomacyManager(tradePartner);
        Intrinsics.checkNotNull(diplomacyManager2);
        DiplomacyManager ourDiploManager = diplomacyManager2;
        if (trade.getOurOffers().contains((Object)embassyOffer) && (Civilization.getCapital$default(offerer, false, 1, null) == null || theirDiploManager.hasModifier(DiplomaticModifiers.EstablishedEmbassy) || theirDiploManager.hasModifier(DiplomaticModifiers.SharedEmbassies))) {
            return false;
        }
        if (trade.getTheirOffers().contains((Object)embassyOffer) && (Civilization.getCapital$default(tradePartner, false, 1, null) == null || ourDiploManager.hasModifier(DiplomaticModifiers.EstablishedEmbassy) || ourDiploManager.hasModifier(DiplomaticModifiers.SharedEmbassies))) {
            return false;
        }
        Iterator iterator2 = trade.getOurOffers().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object object = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            offer = (TradeOffer)object;
            if (this.isOfferValid(offer, offerer, tradePartner)) continue;
            return false;
        }
        Iterator iterator4 = trade.getTheirOffers().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            Object object = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            offer = (TradeOffer)object;
            if (this.isOfferValid(offer, tradePartner, offerer)) continue;
            return false;
        }
        return true;
    }

    @Readonly
    private final boolean isOfferValid(TradeOffer tradeOffer, Civilization offerer, Civilization tradePartner) {
        boolean bl;
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[tradeOffer.getType().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                if ((float)tradeOffer.getAmount() * 0.9f < (float)offerer.getGold()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if ((float)tradeOffer.getAmount() * 0.9f < offerer.getStats().getStatsForNextTurn().getGold()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                switch (tradeOffer.getName()) {
                    case "Peace Treaty": {
                        bl = offerer.isAtWarWith(tradePartner);
                        break block0;
                    }
                    case "Research Agreement": {
                        DiplomacyManager diplomacyManager = offerer.getDiplomacyManager(tradePartner);
                        Intrinsics.checkNotNull(diplomacyManager);
                        if (!diplomacyManager.hasFlag(DiplomacyFlags.ResearchAgreement)) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case "Defensive Pact": {
                        DiplomacyManager diplomacyManager = offerer.getDiplomacyManager(tradePartner);
                        Intrinsics.checkNotNull(diplomacyManager);
                        if (!diplomacyManager.hasFlag(DiplomacyFlags.DefensivePact)) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                }
                bl = true;
                break;
            }
            case 5: {
                bl = true;
                break;
            }
            case 6: {
                bl = TradeEvaluation.isOfferValid$hasResource(offerer, tradeOffer);
                break;
            }
            case 7: {
                bl = TradeEvaluation.isOfferValid$hasResource(offerer, tradeOffer);
                break;
            }
            case 8: {
                bl = TradeEvaluation.isOfferValid$hasResource(offerer, tradeOffer);
                break;
            }
            case 9: {
                bl = true;
                break;
            }
            case 10: {
                if (!tradePartner.knows(tradeOffer.getName())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 11: {
                DiplomacyManager diplomacyManager = offerer.getDiplomacyManager(tradeOffer.getName());
                Intrinsics.checkNotNull(diplomacyManager);
                bl = diplomacyManager.canDeclareWar();
                break;
            }
            case 12: {
                bl = offerer.isAtWarWith(offerer.getGameInfo().getCivilization(tradeOffer.getName()));
                break;
            }
            case 13: {
                Iterable $this$any$iv = offerer.getCities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getId(), tradeOffer.getName())) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Readonly
    public final boolean isTradeAcceptable(@NotNull Trade trade, @NotNull Civilization evaluator, @NotNull Civilization tradePartner) {
        Intrinsics.checkNotNullParameter(trade, "trade");
        Intrinsics.checkNotNullParameter(evaluator, "evaluator");
        Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
        return this.getTradeAcceptability(trade, evaluator, tradePartner, true) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int getTradeAcceptability(@NotNull Trade trade, @NotNull Civilization evaluator, @NotNull Civilization tradePartner, boolean includeDiplomaticGifts) {
        int n;
        Object v3;
        RelationshipLevel relationshipLevel;
        int sumOfOurOffers;
        int sumOfTheirOffers;
        block17: {
            boolean bl;
            block16: {
                Object it;
                int n2;
                Intrinsics.checkNotNullParameter(trade, "trade");
                Intrinsics.checkNotNullParameter(evaluator, "evaluator");
                Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
                Iterable $this$count$iv = trade.getOurOffers();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (TradeOffer)element$iv;
                        boolean bl2 = false;
                        if (!(((TradeOffer)it).getType() == TradeOfferType.City) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int citiesAskedToSurrender = n2;
                int maxCitiesToSurrender = (int)Math.ceil((float)evaluator.getCities().size() / (float)5);
                if (citiesAskedToSurrender > maxCitiesToSurrender) {
                    return Integer.MIN_VALUE;
                }
                sumOfTheirOffers = SequencesKt.sumOfInt(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence(trade.getTheirOffers()), TradeEvaluation::getTradeAcceptability$lambda$1), arg_0 -> TradeEvaluation.getTradeAcceptability$lambda$2(this, evaluator, tradePartner, trade, arg_0)));
                Iterable iterable = trade.getOurOffers();
                int element$iv = 0;
                it = iterable.iterator();
                while (it.hasNext()) {
                    void it2;
                    Object e = it.next();
                    TradeOffer tradeOffer = (TradeOffer)e;
                    int n3 = element$iv;
                    boolean bl3 = false;
                    int n4 = this.evaluateSellCostWithInflation((TradeOffer)it2, evaluator, tradePartner, trade);
                    element$iv = n3 + n4;
                }
                sumOfOurOffers = element$iv;
                DiplomacyManager diplomacyManager = evaluator.getDiplomacyManager(tradePartner);
                Intrinsics.checkNotNull(diplomacyManager);
                relationshipLevel = diplomacyManager.relationshipIgnoreAfraid();
                Iterable $this$none$iv = trade.getOurOffers();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        TradeOffer it3 = (TradeOffer)element$iv2;
                        boolean bl4 = false;
                        if (!(Intrinsics.areEqual(it3.getName(), "Peace Treaty") || Intrinsics.areEqual(it3.getName(), "Research Agreement"))) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            if (bl) {
                if (relationshipLevel == RelationshipLevel.Enemy) {
                    sumOfOurOffers = (int)((double)sumOfOurOffers * 1.5);
                } else if (relationshipLevel == RelationshipLevel.Unforgivable) {
                    sumOfOurOffers *= 2;
                }
            }
            Iterable $this$firstOrNull$iv = trade.getOurOffers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                TradeOffer it = (TradeOffer)element$iv2;
                boolean bl5 = false;
                if (!Intrinsics.areEqual(it.getName(), "Defensive Pact")) continue;
                v3 = element$iv2;
                break block17;
            }
            v3 = null;
        }
        if (v3 != null && relationshipLevel != RelationshipLevel.Ally) {
            return Integer.MIN_VALUE;
        }
        if (includeDiplomaticGifts) {
            DiplomacyManager diplomacyManager = evaluator.getDiplomacyManager(tradePartner);
            Intrinsics.checkNotNull(diplomacyManager);
            n = diplomacyManager.getGoldGifts();
        } else {
            n = 0;
        }
        int diplomaticGifts = n;
        return sumOfTheirOffers - sumOfOurOffers + diplomaticGifts;
    }

    public static /* synthetic */ int getTradeAcceptability$default(TradeEvaluation tradeEvaluation, Trade trade, Civilization civilization, Civilization civilization2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return tradeEvaluation.getTradeAcceptability(trade, civilization, civilization2, bl);
    }

    @Readonly
    public final int evaluateBuyCostWithInflation(@NotNull TradeOffer offer, @NotNull Civilization civInfo, @NotNull Civilization tradePartner, @NotNull Trade trade) {
        Intrinsics.checkNotNullParameter(offer, "offer");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
        Intrinsics.checkNotNullParameter(trade, "trade");
        if (offer.getType() != TradeOfferType.Gold && offer.getType() != TradeOfferType.Gold_Per_Turn) {
            return (int)((double)this.evaluateBuyCost(offer, civInfo, tradePartner, trade) / this.getGoldInflation(civInfo));
        }
        return this.evaluateBuyCost(offer, civInfo, tradePartner, trade);
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    private final int evaluateBuyCost(TradeOffer offer, Civilization civInfo, Civilization tradePartner, Trade trade) {
        switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
            case 1: {
                return (int)((float)30 * civInfo.getGameInfo().getSpeed().getGoldCostModifier());
            }
            case 2: {
                return offer.getAmount();
            }
            case 3: {
                return offer.getAmount() * offer.getDuration() * 4 / 5;
            }
            case 4: {
                var5_5 = offer.getName();
                tmp = -1;
                switch (var5_5.hashCode()) {
                    case 980683217: {
                        if (var5_5.equals("Peace Treaty")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 631699055: {
                        if (var5_5.equals("Defensive Pact")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 245239237: {
                        if (var5_5.equals("Research Agreement")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v0 = this.evaluatePeaceCostForThem(civInfo, tradePartner);
                        break;
                    }
                    case 2: {
                        v0 = 0;
                        break;
                    }
                    case 3: {
                        v0 = -offer.getAmount();
                        break;
                    }
                    default: {
                        v0 = 1000;
                    }
                }
                return v0;
            }
            case 6: {
                v1 = civInfo.getDiplomacyManager(tradePartner);
                Intrinsics.checkNotNull(v1);
                if (v1.hasFlag(DiplomacyFlags.ResourceTradesCutShort)) {
                    return 0;
                }
                v2 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                Intrinsics.checkNotNull(v2);
                var7_12 = v2.getMatchingUniques(UniqueType.AiWillBuyAt, new GameContext(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!var7_12.hasNext()) {
                    v3 = null;
                } else {
                    it = var7_12.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestExplicitBuyCost$1 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (var7_12.hasNext()) {
                        it = var7_12.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestExplicitBuyCost$1 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v3 = it;
                }
                v4 = lowestExplicitBuyCost = (Integer)v3;
                if (v4 != null) {
                    return v4;
                }
                $this$count$iv = civInfo.getCities();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v5 = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (City)element$iv;
                        $i$a$-count-TradeEvaluation$evaluateBuyCost$weLoveTheKingPotential$1 = false;
                        if (!Intrinsics.areEqual(it.getDemandedResource(), offer.getName()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v5 = count$iv;
                }
                weLoveTheKingPotential = v5 * 50;
                return civInfo.hasResource(offer.getName()) == false ? weLoveTheKingPotential + (civInfo.getHappiness() < 0 ? 450 : (civInfo.getHappiness() < 10 ? 350 : 300)) : 0;
            }
            case 7: {
                v6 = civInfo.getDiplomacyManager(tradePartner);
                Intrinsics.checkNotNull(v6);
                if (v6.hasFlag(DiplomacyFlags.ResourceTradesCutShort)) {
                    return 0;
                }
                amountWillingToBuy = 2 - civInfo.getResourceAmount(offer.getName());
                if (amountWillingToBuy <= 0) {
                    return 0;
                }
                amountToBuyInOffer = Math.min(amountWillingToBuy, offer.getAmount());
                v7 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                Intrinsics.checkNotNull(v7);
                count$iv = v7.getMatchingUniques(UniqueType.AiWillBuyAt, new GameContext(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!count$iv.hasNext()) {
                    v8 = null;
                } else {
                    it = count$iv.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestExplicitBuyCost$2 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (count$iv.hasNext()) {
                        it = (Unique)count$iv.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestExplicitBuyCost$2 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v8 = it;
                }
                v9 = lowestExplicitBuyCost = (Integer)v8;
                if (v9 != null) {
                    return v9;
                }
                count$iv = civInfo.getCities();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl118
                v10 = false;
                ** GOTO lbl136
lbl118:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    city = (City)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateBuyCost$canUseForBuildings$1 = false;
                    $this$any$iv = city.getCityConstructions().getBuildableBuildings$core();
                    $i$f$any = false;
                    var17_67 = $this$any$iv.iterator();
                    while (var17_67.hasNext()) {
                        it = element$iv = var17_67.next();
                        $i$a$-any-TradeEvaluation$evaluateBuyCost$canUseForBuildings$1$1 = false;
                        if (!it.getResourceRequirementsPerTurn(city.getState()).containsKey(offer.getName())) continue;
                        v11 = true;
                        ** GOTO lbl132
                    }
                    v11 = false;
lbl132:
                    // 2 sources

                    if (!v11) continue;
                    v10 = true;
                    ** GOTO lbl136
                }
                v10 = false;
lbl136:
                // 3 sources

                canUseForBuildings = v10;
                $i$f$any = civInfo.getCities();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl143
                v12 = false;
                ** GOTO lbl161
lbl143:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    city = (City)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateBuyCost$canUseForUnits$1 = false;
                    $this$any$iv = city.getCityConstructions().getConstructableUnits();
                    $i$f$any = false;
                    var18_69 = $this$any$iv.iterator();
                    while (var18_69.hasNext()) {
                        it = element$iv = var18_69.next();
                        $i$a$-any-TradeEvaluation$evaluateBuyCost$canUseForUnits$1$1 = false;
                        if (!it.getResourceRequirementsPerTurn(civInfo.getState()).containsKey(offer.getName())) continue;
                        v13 = true;
                        ** GOTO lbl157
                    }
                    v13 = false;
lbl157:
                    // 2 sources

                    if (!v13) continue;
                    v12 = true;
                    ** GOTO lbl161
                }
                v12 = canUseForUnits = false;
lbl161:
                // 3 sources

                if (!canUseForBuildings && !canUseForUnits) {
                    return 0;
                }
                return 50 * amountToBuyInOffer;
            }
            case 8: {
                v14 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                if (v14 == null) {
                    return 0;
                }
                resource = v14;
                canUseForBuildings = resource.getMatchingUniques(UniqueType.AiWillBuyAt, new GameContext(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!canUseForBuildings.hasNext()) {
                    v15 = null;
                } else {
                    it = canUseForBuildings.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestBuyCost$1 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (canUseForBuildings.hasNext()) {
                        it = canUseForBuildings.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestBuyCost$1 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v15 = it;
                }
                v16 = lowestBuyCost = (Integer)v15;
                return v16 != null ? v16 : 0;
            }
            case 9: {
                v17 = civInfo.getGameInfo().getRuleset().getTechnologies().get(offer.getName());
                Intrinsics.checkNotNull(v17);
                return (int)(Math.sqrt(v17.getCost()) * (double)civInfo.getGameInfo().getSpeed().getScienceCostModifier()) * 20;
            }
            case 10: {
                return this.introductionValue(civInfo.getGameInfo().getRuleset());
            }
            case 11: {
                civToDeclareWarOn = civInfo.getGameInfo().getCivilization(offer.getName());
                $this$any$iv = trade.getTheirOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl200
                v18 = false;
                ** GOTO lbl207
lbl200:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateBuyCost$1 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), offer.getName()) != false)) continue;
                    v18 = true;
                    ** GOTO lbl207
                }
                v18 = false;
lbl207:
                // 3 sources

                if (!v18) ** GOTO lbl222
                $this$any$iv = trade.getOurOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl213
                v19 = false;
                ** GOTO lbl220
lbl213:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateBuyCost$2 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), offer.getName()) != false)) continue;
                    v19 = true;
                    ** GOTO lbl220
                }
                v19 = false;
lbl220:
                // 3 sources

                if (v19) {
                    return 0;
                }
lbl222:
                // 3 sources

                if (civInfo.isAtWarWith(civToDeclareWarOn)) {
                    return RangesKt.coerceAtLeast((int)((float)20 * DeclareWarPlanEvaluator.INSTANCE.evaluateJoinOurWarPlan(civInfo, civToDeclareWarOn, tradePartner, null)), 0);
                }
                return 0;
            }
            case 12: {
                thirdCiv = civInfo.getGameInfo().getCivilization(offer.getName());
                if (thirdCiv.isCityState() && (allyCiv = thirdCiv.getAllyCiv()) != null && Intrinsics.areEqual(allyCiv, civInfo)) {
                    v20 = thirdCiv.getDiplomacyManager(civInfo);
                    Intrinsics.checkNotNull(v20);
                    surplusInfluence = RangesKt.coerceAtLeast(v20.getInfluence() - (float)60, 0.0f);
                    return (int)(surplusInfluence * (float)15);
                }
                v21 = civInfo.getDiplomacyManager(thirdCiv);
                Intrinsics.checkNotNull(v21);
                return v21.isRelationshipLevelLT(RelationshipLevel.Neutral) != false ? -2147483648 : 0;
            }
            case 13: {
                $this$firstOrNull$iv = tradePartner.getCities();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (City)element$iv;
                    $i$a$-firstOrNull-TradeEvaluation$evaluateBuyCost$city$1 = false;
                    if (!Intrinsics.areEqual(it.getId(), offer.getName())) continue;
                    v22 = element$iv;
                    ** GOTO lbl245
                }
                v22 = null;
lbl245:
                // 2 sources

                v23 = v22;
                if (v23 == null) {
                    throw new Exception("Got an offer for city id " + offer.getName() + " which does't seem to exist for this civ!");
                }
                city = v23;
                surrounded = this.surroundedByOurCities(city, civInfo);
                v24 = civInfo.getHappiness();
                v25 = city.getCityStats().getHappinessList().values();
                Intrinsics.checkNotNullExpressionValue(v25, "<get-values>(...)");
                if (v24 + CollectionsKt.sumOfFloat((Iterable<Float>)v25) < 0.0f) {
                    return 0;
                }
                sumOfPop = city.getPopulation().getPopulation();
                sumOfBuildings = SequencesKt.count(city.getCityConstructions().getBuiltBuildings());
                return (sumOfPop * 4 + sumOfBuildings + 4 + surrounded) * 100;
            }
            case 5: {
                if (Intrinsics.areEqual(offer.getName(), "Open Borders")) {
                    return 100;
                }
                throw new Exception("Invalid agreement type!");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Readonly
    public final boolean isPeaceProposalEnabled(@NotNull Civilization thirdCiv, @NotNull Civilization civInfo) {
        Civilization allyCiv;
        Intrinsics.checkNotNullParameter(thirdCiv, "thirdCiv");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(thirdCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diploManager = diplomacyManager;
        if (diploManager.getFlag(DiplomacyFlags.DeclaredWar) > 0) {
            return false;
        }
        if (thirdCiv.isHuman()) {
            return false;
        }
        if (thirdCiv.isCityState() && (allyCiv = thirdCiv.getAllyCiv()) != null && civInfo.isAtWarWith(allyCiv)) {
            return false;
        }
        Trade trade = new Trade();
        TradeOffer peaceOffer = new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, civInfo.getGameInfo().getSpeed().getPeaceDealDuration(), 4, null);
        trade.getOurOffers().add(peaceOffer);
        trade.getTheirOffers().add(peaceOffer);
        return new TradeEvaluation().isTradeAcceptable(trade, thirdCiv, civInfo);
    }

    @Readonly
    private final int surroundedByOurCities(City city, Civilization civInfo) {
        Set<Civilization> borderingCivs = this.getNeighbouringCivs(city);
        if (borderingCivs.contains(civInfo)) {
            return 3;
        }
        return 0;
    }

    @Readonly
    private final Set<Civilization> getNeighbouringCivs(City city) {
        HashSet<Tile> tilesList = SequencesKt.toHashSet(city.getTiles());
        ArrayList<Tile> cityPositionList = new ArrayList<Tile>();
        Iterator<Tile> iterator2 = tilesList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Tile> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Tile tiles;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Iterator<Tile> iterator4 = tiles.getNeighbors().iterator();
            while (iterator4.hasNext()) {
                Tile tile = iterator4.next();
                if (tilesList.contains(tile)) continue;
                cityPositionList.add(tile);
            }
        }
        return SequencesKt.toSet(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)cityPositionList), TradeEvaluation::getNeighbouringCivs$lambda$0));
    }

    @Readonly
    public final int evaluateSellCostWithInflation(@NotNull TradeOffer offer, @NotNull Civilization civInfo, @NotNull Civilization tradePartner, @NotNull Trade trade) {
        Intrinsics.checkNotNullParameter(offer, "offer");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
        Intrinsics.checkNotNullParameter(trade, "trade");
        if (offer.getType() != TradeOfferType.Gold && offer.getType() != TradeOfferType.Gold_Per_Turn) {
            return (int)((double)this.evaluateSellCost(offer, civInfo, tradePartner, trade) / this.getGoldInflation(civInfo));
        }
        return this.evaluateSellCost(offer, civInfo, tradePartner, trade);
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    private final int evaluateSellCost(TradeOffer offer, Civilization civInfo, Civilization tradePartner, Trade trade) {
        switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
            case 1: {
                v0 = civInfo.getDiplomacyManager(tradePartner);
                Intrinsics.checkNotNull(v0);
                tradePartnerDiplo = v0;
                if (tradePartnerDiplo.isRelationshipLevelLE(RelationshipLevel.Enemy)) {
                    return -2147483648;
                }
                if (tradePartnerDiplo.isRelationshipLevelLE(RelationshipLevel.Competitor)) {
                    return (int)((float)60 * civInfo.getGameInfo().getSpeed().getGoldCostModifier());
                }
                return (int)((float)30 * civInfo.getGameInfo().getSpeed().getGoldCostModifier());
            }
            case 2: {
                return offer.getAmount();
            }
            case 3: {
                return offer.getAmount() * offer.getDuration() * 4 / 5;
            }
            case 4: {
                tradePartnerDiplo = offer.getName();
                tmp = -1;
                switch (tradePartnerDiplo.hashCode()) {
                    case 980683217: {
                        if (tradePartnerDiplo.equals("Peace Treaty")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 631699055: {
                        if (tradePartnerDiplo.equals("Defensive Pact")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 245239237: {
                        if (tradePartnerDiplo.equals("Research Agreement")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v1 = this.evaluatePeaceCostForThem(civInfo, tradePartner);
                        break;
                    }
                    case 2: {
                        if (DiplomacyAutomation.INSTANCE.wantsToSignDefensivePact(civInfo, tradePartner)) {
                            v1 = 0;
                            break;
                        }
                        v1 = 100000;
                        break;
                    }
                    case 3: {
                        v1 = -offer.getAmount();
                        break;
                    }
                    default: {
                        v1 = 1000;
                    }
                }
                return v1;
            }
            case 6: {
                v2 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                Intrinsics.checkNotNull(v2);
                var7_13 = v2.getMatchingUniques(UniqueType.AiWillSellAt, new GameContext(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!var7_13.hasNext()) {
                    v3 = null;
                } else {
                    it = var7_13.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestExplicitSellCost$1 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (var7_13.hasNext()) {
                        it = var7_13.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestExplicitSellCost$1 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v3 = it;
                }
                v4 = lowestExplicitSellCost = (Integer)v3;
                if (v4 != null) {
                    return v4;
                }
                return civInfo.getResourceAmount(offer.getName()) > 1 ? 250 : (Civilization.hasUnique$default(civInfo, UniqueType.RetainHappinessFromLuxury, null, 2, null) != false ? 600 - (int)(Float.parseFloat(((Unique)SequencesKt.first(Civilization.getMatchingUniques$default(civInfo, UniqueType.RetainHappinessFromLuxury, null, 2, null))).getParams().get(0)) * 3.5f) : 600);
            }
            case 7: {
                if (civInfo.getGameInfo().getSpaceResources().contains(offer.getName()) && (Civilization.hasUnique$default(civInfo, UniqueType.EnablesConstructionOfSpaceshipParts, null, 2, null) || Civilization.hasUnique$default(tradePartner, UniqueType.EnablesConstructionOfSpaceshipParts, null, 2, null))) {
                    return 0x7FFFFFFF;
                }
                v5 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                Intrinsics.checkNotNull(v5);
                var7_14 = v5.getMatchingUniques(UniqueType.AiWillSellAt, new GameContext(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!var7_14.hasNext()) {
                    v6 = null;
                } else {
                    it = var7_14.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestExplicitSellCost$2 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (var7_14.hasNext()) {
                        it = var7_14.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestExplicitSellCost$2 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v6 = it;
                }
                v7 = lowestExplicitSellCost = (Integer)v6;
                if (v7 != null) {
                    return v7;
                }
                if (!civInfo.isAtWar()) {
                    return 50 * offer.getAmount();
                }
                v8 = civInfo.getGameInfo().getRuleset().getUnits().values();
                Intrinsics.checkNotNullExpressionValue(v8, "<get-values>(...)");
                var7_14 = v8;
                $i$f$any = false;
                if (!((Collection)$this$any$iv).isEmpty()) ** GOTO lbl108
                v9 = false;
                ** GOTO lbl115
lbl108:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (BaseUnit)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateSellCost$canUseForUnits$1 = false;
                    if (!(it.getResourceRequirementsPerTurn(civInfo.getState()).containsKey(offer.getName()) != false && it.isBuildable(civInfo) != false)) continue;
                    v9 = true;
                    ** GOTO lbl115
                }
                v9 = canUseForUnits = false;
lbl115:
                // 3 sources

                if (!canUseForUnits) {
                    return 50 * offer.getAmount();
                }
                amountLeft = civInfo.getResourceAmount(offer.getName());
                totalCost = 0;
                numberOfResource = amountLeft - offer.getAmount() + 1;
                if (numberOfResource <= amountLeft) {
                    while (true) {
                        totalCost += numberOfResource > 5 ? 100 : (6 - numberOfResource) * 100;
                        if (numberOfResource == amountLeft) break;
                        ++numberOfResource;
                    }
                }
                return totalCost;
            }
            case 8: {
                v10 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                if (v10 == null) {
                    return 0;
                }
                resource = v10;
                totalCost = resource.getMatchingUniques(UniqueType.AiWillSellAt, new GameContext(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!totalCost.hasNext()) {
                    v11 = null;
                } else {
                    it = totalCost.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestSellCost$1 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (totalCost.hasNext()) {
                        it = totalCost.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestSellCost$1 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v11 = it;
                }
                v12 = lowestSellCost = (Integer)v11;
                return v12 != null ? v12 : 0x7FFFFFFF;
            }
            case 9: {
                v13 = civInfo.getGameInfo().getRuleset().getTechnologies().get(offer.getName());
                Intrinsics.checkNotNull(v13);
                return (int)Math.sqrt(v13.getCost()) * 20;
            }
            case 10: {
                return this.introductionValue(civInfo.getGameInfo().getRuleset());
            }
            case 11: {
                civToDeclareWarOn = civInfo.getGameInfo().getCivilization(offer.getName());
                $this$any$iv = trade.getTheirOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl163
                v14 = false;
                ** GOTO lbl170
lbl163:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateSellCost$1 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), offer.getName()) != false)) continue;
                    v14 = true;
                    ** GOTO lbl170
                }
                v14 = false;
lbl170:
                // 3 sources

                if (!v14) ** GOTO lbl185
                $this$any$iv = trade.getOurOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl176
                v15 = false;
                ** GOTO lbl183
lbl176:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateSellCost$2 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), offer.getName()) != false)) continue;
                    v15 = true;
                    ** GOTO lbl183
                }
                v15 = false;
lbl183:
                // 3 sources

                if (v15) {
                    return RangesKt.coerceAtLeast((int)((float)-20 * DeclareWarPlanEvaluator.INSTANCE.evaluateTeamWarPlan(civInfo, civToDeclareWarOn, tradePartner, null)), 0);
                }
lbl185:
                // 3 sources

                if (tradePartner.isAtWarWith(civToDeclareWarOn)) {
                    return RangesKt.coerceAtLeast((int)((float)-20 * DeclareWarPlanEvaluator.INSTANCE.evaluateJoinWarPlan(civInfo, civToDeclareWarOn, tradePartner, null)), 0);
                }
                return RangesKt.coerceAtLeast((int)((float)-25 * DeclareWarPlanEvaluator.INSTANCE.evaluateDeclareWarPlan(civInfo, civToDeclareWarOn, null)), 0);
            }
            case 12: {
                thirdCiv = civInfo.getGameInfo().getCivilization(offer.getName());
                return this.evaluatePeaceCostForThem(civInfo, thirdCiv);
            }
            case 13: {
                $this$firstOrNull$iv = civInfo.getCities();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (City)element$iv;
                    $i$a$-firstOrNull-TradeEvaluation$evaluateSellCost$city$1 = false;
                    if (!Intrinsics.areEqual(it.getId(), offer.getName())) continue;
                    v16 = element$iv;
                    ** GOTO lbl201
                }
                v16 = null;
lbl201:
                // 2 sources

                v17 = v16;
                if (v17 == null) {
                    throw new Exception("Got an offer to sell city id " + offer.getName() + " which does't seem to exist for this civ!");
                }
                city = v17;
                distanceBonus = this.distanceCityTradeModifier(civInfo, city);
                sumOfPop = city.getPopulation().getPopulation();
                sumOfBuildings = SequencesKt.count(city.getCityConstructions().getBuiltBuildings());
                return RangesKt.coerceAtLeast((sumOfPop * 4 + sumOfBuildings * 1 + 4 + distanceBonus) * 100, 1000);
            }
            case 5: {
                if (Intrinsics.areEqual(offer.getName(), "Open Borders")) {
                    v18 = civInfo.getDiplomacyManager(tradePartner);
                    Intrinsics.checkNotNull(v18);
                    switch (WhenMappings.$EnumSwitchMapping$1[v18.relationshipIgnoreAfraid().ordinal()]) {
                        case 1: {
                            v19 = 10000;
                            break;
                        }
                        case 2: {
                            v19 = 2000;
                            break;
                        }
                        case 3: {
                            v19 = 500;
                            break;
                        }
                        case 4: 
                        case 5: {
                            v19 = 200;
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            v19 = 100;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return v19;
                }
                throw new Exception("Invalid agreement type!");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Readonly
    public final double getGoldInflation(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        double modifier = 1000.0;
        double goldPerTurn = civInfo.getStats().getStatsForNextTurn().getGold();
        return modifier / (Math.pow(RangesKt.coerceAtLeast(goldPerTurn, 1.0), 1.2) + 1.66 * modifier) + 0.4;
    }

    @Readonly
    private final int distanceCityTradeModifier(Civilization civInfo, City city) {
        City city2 = Civilization.getCapital$default(civInfo, false, 1, null);
        Intrinsics.checkNotNull(city2);
        int distanceToCapital = city2.getCenterTile().aerialDistanceTo(city.getCenterTile());
        if (distanceToCapital < 500) {
            return 0;
        }
        return (distanceToCapital - 500) * civInfo.getEraNumber();
    }

    @Readonly
    public final int evaluatePeaceCostForThem(@NotNull Civilization ourCiv, @NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(ourCiv, "ourCiv");
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        int ourCombatStrength = ourCiv.getStatForRanking(RankingType.Force);
        int theirCombatStrength = otherCiv.getStatForRanking(RankingType.Force);
        if ((float)ourCombatStrength * 1.5f >= (float)theirCombatStrength && (float)theirCombatStrength * 1.5f >= (float)ourCombatStrength) {
            return 0;
        }
        if (ourCombatStrength > theirCombatStrength) {
            if (MotivationToAttackAutomation.INSTANCE.hasAtLeastMotivationToAttack(ourCiv, otherCiv, 0.0f) <= 0.0f) {
                return 0;
            }
            int absoluteAdvantage = ourCombatStrength - theirCombatStrength;
            float percentageAdvantage = (float)absoluteAdvantage / (float)theirCombatStrength;
            int totalAdvantage = (int)((float)absoluteAdvantage * percentageAdvantage);
            if (totalAdvantage < 0) {
                return 10000;
            }
            return (int)((double)totalAdvantage / (this.getGoldInflation(otherCiv) * (double)2));
        }
        int absoluteAdvantage = theirCombatStrength - ourCombatStrength;
        float percentageAdvantage = (float)absoluteAdvantage / (float)ourCombatStrength;
        double peaceCost = (double)((float)absoluteAdvantage * percentageAdvantage) / (this.getGoldInflation(ourCiv) * 2.0);
        return -RangesKt.coerceAtMost((int)peaceCost, ourCiv.getGameInfo().getRuleset().getModOptions().getConstants().getMaxGoldTradeOffer());
    }

    @Readonly
    private final int introductionValue(Ruleset ruleSet) {
        Unique unique = (Unique)SequencesKt.firstOrNull(IHasUniques.getMatchingUniques$default(ruleSet.getModOptions(), UniqueType.TradeCivIntroductions, null, 2, null));
        if (unique == null) {
            return 0;
        }
        Unique unique2 = unique;
        return Integer.parseInt(unique2.getParams().get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private static final boolean isOfferValid$hasResource(Civilization $offerer, TradeOffer tradeOffer) {
        HashMap<String, Integer> resourcesByName = $offerer.getCivResourcesByName();
        if (!resourcesByName.containsKey(tradeOffer.getName())) return false;
        Integer n = resourcesByName.get(tradeOffer.getName());
        Intrinsics.checkNotNull(n);
        if (((Number)n).intValue() < tradeOffer.getAmount()) return false;
        return true;
    }

    private static final boolean getTradeAcceptability$lambda$1(TradeOffer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() != TradeOfferType.Treaty;
    }

    private static final int getTradeAcceptability$lambda$2(TradeEvaluation this$0, Civilization $evaluator, Civilization $tradePartner, Trade $trade, TradeOffer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.evaluateBuyCostWithInflation(it, $evaluator, $tradePartner, $trade);
    }

    private static final Civilization getNeighbouringCivs$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOwner();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TradeOfferType.values().length];
            try {
                nArray[TradeOfferType.Embassy.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Gold.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Gold_Per_Turn.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Treaty.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Agreement.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Luxury_Resource.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Strategic_Resource.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Stockpiled_Resource.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Technology.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Introduction.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.WarDeclaration.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.PeaceProposal.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.City.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RelationshipLevel.values().length];
            try {
                nArray[RelationshipLevel.Unforgivable.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Enemy.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Competitor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Neutral.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Afraid.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Favorable.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Friend.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Ally.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

