/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models;

import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.MultiFilter;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.BeliefType;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.INamed;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004B!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0003\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\rJ\u0006\u00102\u001a\u00020\u0000J\u000e\u00103\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\bJ\b\u00105\u001a\u000204H\u0002J\u0014\u00106\u001a\u0002042\f\u00107\u001a\b\u0012\u0004\u0012\u00020908J\u000e\u0010:\u001a\u0002042\u0006\u0010;\u001a\u000209J\u0015\u0010:\u001a\u0004\u0018\u0001042\u0006\u0010<\u001a\u00020\u0006\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u00020\u0006H\u0007J\b\u0010?\u001a\u00020\u0006H\u0007J\u001c\u0010@\u001a\b\u0012\u0004\u0012\u0002090A2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060BH\u0003J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u0002090A2\u0006\u0010D\u001a\u00020EH\u0007J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u0002090AH\u0007J\u0010\u0010G\u001a\u00020H2\u0006\u0010;\u001a\u00020\u0006H\u0007J\b\u0010I\u001a\u00020HH\u0007J\b\u0010J\u001a\u00020HH\u0007J\b\u0010K\u001a\u00020HH\u0007J&\u0010L\u001a\u00020H2\u0006\u0010M\u001a\u00020\u00062\b\b\u0002\u0010N\u001a\u00020O2\n\b\u0002\u0010P\u001a\u0004\u0018\u00010\nH\u0007J&\u0010Q\u001a\u00020H2\u0006\u0010M\u001a\u00020\u00062\b\b\u0002\u0010N\u001a\u00020O2\n\b\u0002\u0010P\u001a\u0004\u0018\u00010\nH\u0003J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00060-H\u0003R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0016j\b\u0012\u0004\u0012\u00020\u0006`\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0016j\b\u0012\u0004\u0012\u00020\u0006`\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000fR\u0018\u0010(\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\b\n\u0000\u0012\u0004\b)\u0010\u0004R\u0011\u0010\t\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R!\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/\u00a8\u0006S"}, d2={"Lcom/unciv/models/Religion;", "Lcom/unciv/models/stats/INamed;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "name", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "foundingCiv", "Lcom/unciv/logic/civilization/Civilization;", "(Ljava/lang/String;Lcom/unciv/logic/GameInfo;Lcom/unciv/logic/civilization/Civilization;)V", "foundingCivName", "(Ljava/lang/String;Lcom/unciv/logic/GameInfo;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "displayName", "getDisplayName", "setDisplayName", "founderBeliefs", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "followerBeliefs", "founderBeliefUniqueMap", "Lcom/unciv/models/ruleset/unique/UniqueMap;", "getFounderBeliefUniqueMap", "()Lcom/unciv/models/ruleset/unique/UniqueMap;", "setFounderBeliefUniqueMap", "(Lcom/unciv/models/ruleset/unique/UniqueMap;)V", "followerBeliefUniqueMap", "getFollowerBeliefUniqueMap", "setFollowerBeliefUniqueMap", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "setGameInfo", "(Lcom/unciv/logic/GameInfo;)V", "value", "getFoundingCivName", "_foundingCiv", "get_foundingCiv$annotations", "getFoundingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "buildingsPurchasableByBeliefs", "", "getBuildingsPurchasableByBeliefs", "()Ljava/util/List;", "buildingsPurchasableByBeliefs$delegate", "Lkotlin/Lazy;", "clone", "setTransients", "", "updateUniqueMaps", "addBeliefs", "beliefs", "", "Lcom/unciv/models/ruleset/Belief;", "addBelief", "belief", "beliefName", "(Ljava/lang/String;)Lkotlin/Unit;", "getIconName", "getReligionDisplayName", "mapToExistingBeliefs", "Lkotlin/sequences/Sequence;", "", "getBeliefs", "beliefType", "Lcom/unciv/models/ruleset/BeliefType;", "getAllBeliefsOrdered", "hasBelief", "", "isPantheon", "isMajorReligion", "isEnhancedReligion", "matchesFilter", "filter", "state", "Lcom/unciv/models/ruleset/unique/GameContext;", "civ", "matchesSingleFilter", "unlockedBuildingsPurchasable", "core"})
@SourceDebugExtension(value={"SMAP\nReligion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Religion.kt\ncom/unciv/models/Religion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class Religion
implements INamed,
IsPartOfGameInfoSerialization {
    public String name;
    @Nullable
    private String displayName;
    @NotNull
    private HashSet<String> founderBeliefs;
    @NotNull
    private HashSet<String> followerBeliefs;
    @NotNull
    private transient UniqueMap founderBeliefUniqueMap;
    @NotNull
    private transient UniqueMap followerBeliefUniqueMap;
    public transient GameInfo gameInfo;
    private String foundingCivName;
    private transient Civilization _foundingCiv;
    @NotNull
    private final transient Lazy buildingsPurchasableByBeliefs$delegate;

    public Religion() {
        this.founderBeliefs = new HashSet();
        this.followerBeliefs = new HashSet();
        this.founderBeliefUniqueMap = new UniqueMap();
        this.followerBeliefUniqueMap = new UniqueMap();
        this.buildingsPurchasableByBeliefs$delegate = LazyKt.lazy(() -> Religion.buildingsPurchasableByBeliefs_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("name");
        return null;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @Nullable
    public final String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(@Nullable String string) {
        this.displayName = string;
    }

    @NotNull
    public final UniqueMap getFounderBeliefUniqueMap() {
        return this.founderBeliefUniqueMap;
    }

    public final void setFounderBeliefUniqueMap(@NotNull UniqueMap uniqueMap2) {
        Intrinsics.checkNotNullParameter(uniqueMap2, "<set-?>");
        this.founderBeliefUniqueMap = uniqueMap2;
    }

    @NotNull
    public final UniqueMap getFollowerBeliefUniqueMap() {
        return this.followerBeliefUniqueMap;
    }

    public final void setFollowerBeliefUniqueMap(@NotNull UniqueMap uniqueMap2) {
        Intrinsics.checkNotNullParameter(uniqueMap2, "<set-?>");
        this.followerBeliefUniqueMap = uniqueMap2;
    }

    @NotNull
    public final GameInfo getGameInfo() {
        GameInfo gameInfo = this.gameInfo;
        if (gameInfo != null) {
            return gameInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
        return null;
    }

    public final void setGameInfo(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "<set-?>");
        this.gameInfo = gameInfo;
    }

    @NotNull
    public final String getFoundingCivName() {
        String string = this.foundingCivName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("foundingCivName");
        return null;
    }

    @Cache
    private static /* synthetic */ void get_foundingCiv$annotations() {
    }

    @Readonly
    @NotNull
    public final Civilization getFoundingCiv() {
        Civilization civilization;
        if (this._foundingCiv == null) {
            this._foundingCiv = this.getGameInfo().getCivilization(this.getFoundingCivName());
        }
        if ((civilization = this._foundingCiv) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("_foundingCiv");
            civilization = null;
        }
        return civilization;
    }

    @NotNull
    public final List<String> getBuildingsPurchasableByBeliefs() {
        Lazy lazy = this.buildingsPurchasableByBeliefs$delegate;
        return (List)lazy.getValue();
    }

    public Religion(@NotNull String name, @NotNull GameInfo gameInfo, @NotNull Civilization foundingCiv) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        Intrinsics.checkNotNullParameter(foundingCiv, "foundingCiv");
        this();
        this.setName(name);
        this.setGameInfo(gameInfo);
        this._foundingCiv = foundingCiv;
        this.foundingCivName = foundingCiv.getCivID();
    }

    public Religion(@NotNull String name, @NotNull GameInfo gameInfo, @NotNull String foundingCivName) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        Intrinsics.checkNotNullParameter(foundingCivName, "foundingCivName");
        this();
        this.setName(name);
        this.foundingCivName = foundingCivName;
        this.setGameInfo(gameInfo);
    }

    @NotNull
    public final Religion clone() {
        Religion toReturn = new Religion(this.getName(), this.getGameInfo(), this.getFoundingCivName());
        toReturn.displayName = this.displayName;
        toReturn.founderBeliefs.addAll((Collection<String>)this.founderBeliefs);
        toReturn.followerBeliefs.addAll((Collection<String>)this.followerBeliefs);
        return toReturn;
    }

    public final void setTransients(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.setGameInfo(gameInfo);
        this.updateUniqueMaps();
    }

    private final void updateUniqueMaps() {
        this.followerBeliefUniqueMap = new UniqueMap(SequencesKt.flatMapIterable(this.mapToExistingBeliefs((Set<String>)this.followerBeliefs), Religion::updateUniqueMaps$lambda$0));
        this.founderBeliefUniqueMap = new UniqueMap(SequencesKt.flatMapIterable(this.mapToExistingBeliefs((Set<String>)this.founderBeliefs), Religion::updateUniqueMaps$lambda$1));
    }

    public final void addBeliefs(@NotNull Iterable<Belief> beliefs) {
        Intrinsics.checkNotNullParameter(beliefs, "beliefs");
        Iterator<Belief> iterator2 = beliefs.iterator();
        block4: while (iterator2.hasNext()) {
            Belief belief;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            switch (WhenMappings.$EnumSwitchMapping$0[belief.getType().ordinal()]) {
                case 1: 
                case 2: {
                    boolean bl = this.founderBeliefs.add(belief.getName());
                    break;
                }
                case 3: 
                case 4: {
                    boolean bl = this.followerBeliefs.add(belief.getName());
                    break;
                }
                default: {
                    continue block4;
                }
            }
        }
        this.updateUniqueMaps();
    }

    public final void addBelief(@NotNull Belief belief) {
        Intrinsics.checkNotNullParameter(belief, "belief");
        this.addBeliefs((Iterable<Belief>)CollectionsKt.listOf(belief));
    }

    @Nullable
    public final Unit addBelief(@NotNull String beliefName) {
        Unit unit;
        Intrinsics.checkNotNullParameter(beliefName, "beliefName");
        Belief belief = this.getGameInfo().getRuleset().getBeliefs().get(beliefName);
        if (belief != null) {
            Belief it = belief;
            boolean bl = false;
            this.addBelief(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Readonly
    @NotNull
    public final String getIconName() {
        return this.isPantheon() ? "Pantheon" : this.getName();
    }

    @Readonly
    @NotNull
    public final String getReligionDisplayName() {
        String string;
        if (this.displayName != null) {
            String string2 = this.displayName;
            string = string2;
            Intrinsics.checkNotNull(string2);
        } else {
            string = this.getName();
        }
        return string;
    }

    @Readonly
    private final Sequence<Belief> mapToExistingBeliefs(Set<String> beliefs) {
        LinkedHashMap<String, Belief> rulesetBeliefs = this.getGameInfo().getRuleset().getBeliefs();
        return SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)beliefs), arg_0 -> Religion.mapToExistingBeliefs$lambda$0(rulesetBeliefs, arg_0));
    }

    @Readonly
    @NotNull
    public final Sequence<Belief> getBeliefs(@NotNull BeliefType beliefType) {
        HashSet<String> hashSet;
        Intrinsics.checkNotNullParameter((Object)beliefType, "beliefType");
        if (beliefType == BeliefType.Any) {
            return this.mapToExistingBeliefs(CollectionsKt.toHashSet(SetsKt.plus((Set)this.founderBeliefs, (Iterable)this.followerBeliefs)));
        }
        if (beliefType.isFollower()) {
            hashSet = this.followerBeliefs;
        } else if (beliefType.isFounder()) {
            hashSet = this.founderBeliefs;
        } else {
            Intrinsics.checkNotNull(null);
            throw new KotlinNothingValueException();
        }
        HashSet<String> beliefs = hashSet;
        return SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)beliefs), arg_0 -> Religion.getBeliefs$lambda$0(beliefType, arg_0));
    }

    @Readonly
    @NotNull
    public final Sequence<Belief> getAllBeliefsOrdered() {
        return SequencesKt.plus(SequencesKt.plus(SequencesKt.plus(SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)this.followerBeliefs), Religion::getAllBeliefsOrdered$lambda$0), SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)this.founderBeliefs), Religion::getAllBeliefsOrdered$lambda$1)), SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)this.followerBeliefs), Religion::getAllBeliefsOrdered$lambda$2)), SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)this.founderBeliefs), Religion::getAllBeliefsOrdered$lambda$3));
    }

    @Readonly
    public final boolean hasBelief(@NotNull String belief) {
        Intrinsics.checkNotNullParameter(belief, "belief");
        return this.followerBeliefs.contains(belief) || this.founderBeliefs.contains(belief);
    }

    @Readonly
    public final boolean isPantheon() {
        return SequencesKt.any(this.getBeliefs(BeliefType.Pantheon)) && !this.isMajorReligion();
    }

    @Readonly
    public final boolean isMajorReligion() {
        return SequencesKt.any(this.getBeliefs(BeliefType.Founder));
    }

    @Readonly
    public final boolean isEnhancedReligion() {
        return SequencesKt.any(this.getBeliefs(BeliefType.Enhancer));
    }

    @Readonly
    public final boolean matchesFilter(@NotNull String filter2, @NotNull GameContext state, @Nullable Civilization civ) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter(state, "state");
        return MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, arg_0 -> Religion.matchesFilter$lambda$0(this, state, civ, arg_0), false, 4, null);
    }

    public static /* synthetic */ boolean matchesFilter$default(Religion religion, String string, GameContext gameContext, Civilization civilization, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = GameContext.Companion.getIgnoreConditionals();
        }
        if ((n & 4) != 0) {
            civilization = null;
        }
        return religion.matchesFilter(string, gameContext, civilization);
    }

    @Readonly
    private final boolean matchesSingleFilter(String filter2, GameContext state, Civilization civ) {
        Civilization foundingCiv = this.getFoundingCiv();
        switch (filter2) {
            case "any": {
                return true;
            }
            case "major": {
                return this.isMajorReligion();
            }
            case "enhanced": {
                return this.isEnhancedReligion();
            }
            case "your": {
                return Intrinsics.areEqual(civ, foundingCiv);
            }
            case "foreign": {
                return civ != null && !Intrinsics.areEqual(civ, foundingCiv);
            }
            case "enemy": {
                if (civ == null) {
                    return false;
                }
                return civ.knows(foundingCiv) && civ.isAtWarWith(foundingCiv);
            }
        }
        if (Intrinsics.areEqual(filter2, this.getName())) {
            return true;
        }
        if (SequencesKt.contains(SequencesKt.map(this.getBeliefs(BeliefType.Any), Religion::matchesSingleFilter$lambda$0), filter2)) {
            return true;
        }
        if (this.founderBeliefUniqueMap.hasMatchingTagUnique(filter2, state)) {
            return true;
        }
        return this.followerBeliefUniqueMap.hasMatchingTagUnique(filter2, state);
    }

    static /* synthetic */ boolean matchesSingleFilter$default(Religion religion, String string, GameContext gameContext, Civilization civilization, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = GameContext.Companion.getIgnoreConditionals();
        }
        if ((n & 4) != 0) {
            civilization = null;
        }
        return religion.matchesSingleFilter(string, gameContext, civilization);
    }

    @Readonly
    private final List<String> unlockedBuildingsPurchasable() {
        return SequencesKt.toList(SequencesKt.filter(SequencesKt.flatMap(this.getAllBeliefsOrdered(), Religion::unlockedBuildingsPurchasable$lambda$0), arg_0 -> Religion.unlockedBuildingsPurchasable$lambda$1(this, arg_0)));
    }

    private static final List buildingsPurchasableByBeliefs_delegate$lambda$0(Religion this$0) {
        return this$0.unlockedBuildingsPurchasable();
    }

    private static final Iterable updateUniqueMaps$lambda$0(Belief it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUniqueObjects();
    }

    private static final Iterable updateUniqueMaps$lambda$1(Belief it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUniqueObjects();
    }

    private static final Belief mapToExistingBeliefs$lambda$0(LinkedHashMap $rulesetBeliefs, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Belief)$rulesetBeliefs.get(it);
    }

    private static final boolean getBeliefs$lambda$0(BeliefType $beliefType, Belief it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == $beliefType;
    }

    private static final boolean getAllBeliefsOrdered$lambda$0(Belief it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == BeliefType.Pantheon;
    }

    private static final boolean getAllBeliefsOrdered$lambda$1(Belief it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == BeliefType.Founder;
    }

    private static final boolean getAllBeliefsOrdered$lambda$2(Belief it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == BeliefType.Follower;
    }

    private static final boolean getAllBeliefsOrdered$lambda$3(Belief it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == BeliefType.Enhancer;
    }

    private static final boolean matchesFilter$lambda$0(Religion this$0, GameContext $state, Civilization $civ, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.matchesSingleFilter(it, $state, $civ);
    }

    private static final String matchesSingleFilter$lambda$0(Belief it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName();
    }

    private static final String unlockedBuildingsPurchasable$lambda$0$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getParams().get(0);
    }

    private static final String unlockedBuildingsPurchasable$lambda$0$1(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getParams().get(0);
    }

    private static final String unlockedBuildingsPurchasable$lambda$0$2(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getParams().get(0);
    }

    private static final Sequence unlockedBuildingsPurchasable$lambda$0(Belief belief) {
        Intrinsics.checkNotNullParameter(belief, "belief");
        return SequencesKt.plus(SequencesKt.plus(SequencesKt.map(IHasUniques.getMatchingUniques$default(belief, UniqueType.BuyBuildingsWithStat, null, 2, null), Religion::unlockedBuildingsPurchasable$lambda$0$0), SequencesKt.map(IHasUniques.getMatchingUniques$default(belief, UniqueType.BuyBuildingsForAmountStat, null, 2, null), Religion::unlockedBuildingsPurchasable$lambda$0$1)), SequencesKt.map(IHasUniques.getMatchingUniques$default(belief, UniqueType.BuyBuildingsIncreasingCost, null, 2, null), Religion::unlockedBuildingsPurchasable$lambda$0$2));
    }

    private static final boolean unlockedBuildingsPurchasable$lambda$1(Religion this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getGameInfo().getRuleset().getBuildings().containsKey(it);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BeliefType.values().length];
            try {
                nArray[BeliefType.Founder.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeliefType.Enhancer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeliefType.Pantheon.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeliefType.Follower.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

