/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.models.ruleset.RejectionReasonType;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0007H\u0007J\b\u0010\u0011\u001a\u00020\u0007H\u0007J\b\u0010\u0012\u001a\u00020\u0007H\u0007J\b\u0010\u0013\u001a\u00020\u0007H\u0007J\b\u0010\u0014\u001a\u00020\u0007H\u0007J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/unciv/models/ruleset/RejectionReason;", "", "type", "Lcom/unciv/models/ruleset/RejectionReasonType;", "errorMessage", "", "shouldShow", "", "<init>", "(Lcom/unciv/models/ruleset/RejectionReasonType;Ljava/lang/String;Z)V", "getType", "()Lcom/unciv/models/ruleset/RejectionReasonType;", "getErrorMessage", "()Ljava/lang/String;", "getShouldShow", "()Z", "techPolicyEraWonderRequirements", "hasAReasonToBeRemovedFromQueue", "isImportantRejection", "isConstructionRejection", "isNeverVisible", "getRejectionPrecedence", "", "Companion", "core"})
public final class RejectionReason {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RejectionReasonType type;
    @NotNull
    private final String errorMessage;
    private final boolean shouldShow;
    @NotNull
    private static final HashSet<RejectionReasonType> techPolicyEraWonderRequirements;
    @NotNull
    private static final HashSet<RejectionReasonType> reasonsToDefinitivelyRemoveFromQueue;
    @NotNull
    private static final List<RejectionReasonType> orderedImportantRejectionTypes;
    @NotNull
    private static final List<RejectionReasonType> constructionRejectionReasonType;
    @NotNull
    private static final List<RejectionReasonType> neverVisible;

    public RejectionReason(@NotNull RejectionReasonType type, @NotNull String errorMessage, boolean shouldShow) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(errorMessage, "errorMessage");
        this.type = type;
        this.errorMessage = errorMessage;
        this.shouldShow = shouldShow;
    }

    public /* synthetic */ RejectionReason(RejectionReasonType rejectionReasonType, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = rejectionReasonType.getErrorMessage();
        }
        if ((n & 4) != 0) {
            bl = rejectionReasonType.getShouldShow();
        }
        this(rejectionReasonType, string, bl);
    }

    @NotNull
    public final RejectionReasonType getType() {
        return this.type;
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final boolean getShouldShow() {
        return this.shouldShow;
    }

    @Readonly
    public final boolean techPolicyEraWonderRequirements() {
        return techPolicyEraWonderRequirements.contains((Object)this.type);
    }

    @Readonly
    public final boolean hasAReasonToBeRemovedFromQueue() {
        return reasonsToDefinitivelyRemoveFromQueue.contains((Object)this.type);
    }

    @Readonly
    public final boolean isImportantRejection() {
        return orderedImportantRejectionTypes.contains((Object)this.type);
    }

    @Readonly
    public final boolean isConstructionRejection() {
        return constructionRejectionReasonType.contains((Object)this.type);
    }

    @Readonly
    public final boolean isNeverVisible() {
        return neverVisible.contains((Object)this.type);
    }

    public final int getRejectionPrecedence() {
        return orderedImportantRejectionTypes.indexOf((Object)this.type);
    }

    static {
        RejectionReasonType[] rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.Obsoleted, RejectionReasonType.RequiresTech, RejectionReasonType.RequiresPolicy, RejectionReasonType.MorePolicyBranches, RejectionReasonType.RequiresBuildingInSomeCity};
        techPolicyEraWonderRequirements = SetsKt.hashSetOf(rejectionReasonTypeArray);
        rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.Obsoleted, RejectionReasonType.WonderAlreadyBuilt, RejectionReasonType.NationalWonderAlreadyBuilt, RejectionReasonType.CannotBeBuiltWith, RejectionReasonType.MaxNumberBuildable};
        reasonsToDefinitivelyRemoveFromQueue = SetsKt.hashSetOf(rejectionReasonTypeArray);
        rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.ShouldNotBeDisplayed, RejectionReasonType.WonderBeingBuiltElsewhere, RejectionReasonType.RequiresBuildingInAllCities, RejectionReasonType.RequiresBuildingInThisCity, RejectionReasonType.RequiresBuildingInSomeCity, RejectionReasonType.RequiresBuildingInSomeCities, RejectionReasonType.CanOnlyBeBuiltInSpecificCities, RejectionReasonType.PopulationRequirement, RejectionReasonType.ConsumesResources, RejectionReasonType.CanOnlyBePurchased, RejectionReasonType.MaxNumberBuildable, RejectionReasonType.NoPlaceToPutUnit};
        orderedImportantRejectionTypes = CollectionsKt.listOf(rejectionReasonTypeArray);
        rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.Unbuildable, RejectionReasonType.CannotBeBuilt, RejectionReasonType.CanOnlyBeBuiltInSpecificCities};
        constructionRejectionReasonType = CollectionsKt.listOf(rejectionReasonTypeArray);
        rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.AlreadyBuilt, RejectionReasonType.WonderAlreadyBuilt, RejectionReasonType.NationalWonderAlreadyBuilt, RejectionReasonType.DisabledBySetting, RejectionReasonType.UniqueToOtherNation, RejectionReasonType.ReplacedByOurUnique, RejectionReasonType.Obsoleted, RejectionReasonType.WonderBeingBuiltElsewhere, RejectionReasonType.RequiresTech, RejectionReasonType.NoSettlerForOneCityPlayers, RejectionReasonType.WaterUnitsInCoastalCities};
        neverVisible = CollectionsKt.listOf(rejectionReasonTypeArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unciv/models/ruleset/RejectionReason$Companion;", "", "<init>", "()V", "techPolicyEraWonderRequirements", "Ljava/util/HashSet;", "Lcom/unciv/models/ruleset/RejectionReasonType;", "Lkotlin/collections/HashSet;", "reasonsToDefinitivelyRemoveFromQueue", "orderedImportantRejectionTypes", "", "constructionRejectionReasonType", "neverVisible", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

