/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.tile;

import com.unciv.logic.MultiFilter;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.objectdescriptions.ImprovementDescriptions;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0016J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0007J\u000e\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0$J\b\u0010.\u001a\u00020/H\u0007J\b\u00100\u001a\u00020/H\u0007J\u0014\u00101\u001a\u00020/2\n\b\u0002\u00102\u001a\u0004\u0018\u000103H\u0007J\u0010\u00104\u001a\u00020/2\u0006\u00105\u001a\u00020\u0005H\u0007J\u0010\u00104\u001a\u00020/2\u0006\u00105\u001a\u000206H\u0007J\u0010\u00107\u001a\u00020/2\u0006\u00105\u001a\u000206H\u0007J&\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020\u00052\n\b\u0002\u0010:\u001a\u0004\u0018\u0001032\b\b\u0002\u0010;\u001a\u00020/H\u0007J\u0010\u0010<\u001a\u00020/2\u0006\u00109\u001a\u00020\u0005H\u0003J\b\u0010=\u001a\u00020\u0005H\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020-0?2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020+H\u0016J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020C0?2\u0006\u0010*\u001a\u00020+H\u0007J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020C0?2\u0006\u0010*\u001a\u00020+H\u0007R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006E"}, d2={"Lcom/unciv/models/ruleset/tile/TileImprovement;", "Lcom/unciv/models/ruleset/RulesetStatsObject;", "<init>", "()V", "replaces", "", "getReplaces", "()Ljava/lang/String;", "setReplaces", "(Ljava/lang/String;)V", "terrainsCanBeBuiltOn", "", "getTerrainsCanBeBuiltOn", "()Ljava/util/Collection;", "setTerrainsCanBeBuiltOn", "(Ljava/util/Collection;)V", "techRequired", "getTechRequired", "setTechRequired", "uniqueTo", "getUniqueTo", "setUniqueTo", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "shortcutKey", "", "getShortcutKey", "()Ljava/lang/Character;", "Ljava/lang/Character;", "turnsToBuild", "", "getTurnsToBuild", "()I", "setTurnsToBuild", "(I)V", "legacyRequiredTechs", "Lkotlin/sequences/Sequence;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getDescription", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getShortDecription", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "isGreatImprovement", "", "isRoad", "isAncientRuinsEquivalent", "state", "Lcom/unciv/models/ruleset/unique/GameContext;", "canBeBuiltOn", "terrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "isAllowedOnFeature", "matchesFilter", "filter", "tileState", "multiFilter", "matchesSingleFilter", "makeLink", "getCivilopediaTextLines", "", "getSortGroup", "getSubCategory", "getConstructorUnits", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getCreatingUnits", "core"})
@SourceDebugExtension(value={"SMAP\nTileImprovement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileImprovement.kt\ncom/unciv/models/ruleset/tile/TileImprovement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1#2:190\n1313#3,3:191\n1276#3,2:200\n1276#3,2:211\n1276#3,2:213\n1807#4,3:194\n1807#4,3:197\n777#4:202\n873#4,2:203\n2792#4,3:205\n1807#4,3:208\n*S KotlinDebug\n*F\n+ 1 TileImprovement.kt\ncom/unciv/models/ruleset/tile/TileImprovement\n*L\n46#1:191,3\n75#1:200,2\n174#1:211,2\n185#1:213,2\n57#1:194,3\n61#1:197,3\n135#1:202\n135#1:203,2\n160#1:205,3\n168#1:208,3\n*E\n"})
public final class TileImprovement
extends RulesetStatsObject {
    @Nullable
    private String replaces;
    @NotNull
    private Collection<String> terrainsCanBeBuiltOn = new ArrayList();
    @Nullable
    private String techRequired;
    @Nullable
    private String uniqueTo;
    @Nullable
    private final Character shortcutKey;
    private int turnsToBuild = -1;

    @Nullable
    public final String getReplaces() {
        return this.replaces;
    }

    public final void setReplaces(@Nullable String string) {
        this.replaces = string;
    }

    @NotNull
    public final Collection<String> getTerrainsCanBeBuiltOn() {
        return this.terrainsCanBeBuiltOn;
    }

    public final void setTerrainsCanBeBuiltOn(@NotNull Collection<String> collection) {
        Intrinsics.checkNotNullParameter(collection, "<set-?>");
        this.terrainsCanBeBuiltOn = collection;
    }

    @Nullable
    public final String getTechRequired() {
        return this.techRequired;
    }

    public final void setTechRequired(@Nullable String string) {
        this.techRequired = string;
    }

    @Nullable
    public final String getUniqueTo() {
        return this.uniqueTo;
    }

    public final void setUniqueTo(@Nullable String string) {
        this.uniqueTo = string;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Improvement;
    }

    @Nullable
    public final Character getShortcutKey() {
        return this.shortcutKey;
    }

    public final int getTurnsToBuild() {
        return this.turnsToBuild;
    }

    public final void setTurnsToBuild(int n) {
        this.turnsToBuild = n;
    }

    @Override
    @NotNull
    public Sequence<String> legacyRequiredTechs() {
        Sequence<String> sequence;
        if (this.techRequired == null) {
            sequence = SequencesKt.emptySequence();
        } else {
            String string = this.techRequired;
            Intrinsics.checkNotNull(string);
            sequence = SequencesKt.sequenceOf(string);
        }
        return sequence;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int getTurnsToBuild(@NotNull Civilization civInfo, @NotNull MapUnit unit) {
        void $this$fold$iv;
        Sequence<Unique> buildSpeedIncreases;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(unit, "unit");
        GameContext state = new GameContext(civInfo, null, unit, null, null, null, null, null, null, null, false, 2042, null);
        Sequence<Unique> buildSpeedUniques = SequencesKt.filter(unit.getMatchingUniques(UniqueType.SpecificImprovementTime, state, true), arg_0 -> TileImprovement.getTurnsToBuild$lambda$0(this, state, arg_0));
        Sequence<Unique> sequence = buildSpeedIncreases = SequencesKt.filter(unit.getMatchingUniques(UniqueType.ImprovementTimeIncrease, state, true), arg_0 -> TileImprovement.getTurnsToBuild$lambda$1(this, state, arg_0));
        double d = 0.0;
        Iterator<Unique> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Unique unique = iterator2.next();
            Unique unique2 = unique;
            double d2 = d;
            boolean bl = false;
            double d3 = Double.parseDouble(it.getParams().get(1));
            d = d2 + d3;
        }
        float increase = FormattingExtensionsKt.toPercent((float)d);
        float buildTime = increase == 0.0f ? 0.0f : civInfo.getGameInfo().getSpeed().getImprovementBuildLengthModifier() * (float)this.turnsToBuild / increase;
        Sequence<Unique> sequence2 = buildSpeedUniques;
        float initial$iv = buildTime;
        boolean $i$f$fold = false;
        float accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void unique;
            Unique unique3 = (Unique)element$iv;
            float calculatedTurnsToBuild = accumulator$iv;
            boolean bl = false;
            accumulator$iv = calculatedTurnsToBuild * FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return RangesKt.coerceAtLeast(MathKt.roundToInt(accumulator$iv), 1);
    }

    @NotNull
    public final String getDescription(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return ImprovementDescriptions.INSTANCE.getDescription(this, ruleset);
    }

    @NotNull
    public final Sequence<FormattedLine> getShortDecription() {
        return ImprovementDescriptions.INSTANCE.getShortDescription(this);
    }

    @Readonly
    public final boolean isGreatImprovement() {
        return IHasUniques.hasUnique$default(this, UniqueType.GreatImprovement, null, 2, null);
    }

    @Readonly
    public final boolean isRoad() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = RoadStatus.getEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RoadStatus it = (RoadStatus)element$iv;
                    boolean bl2 = false;
                    if (!(it != RoadStatus.None && Intrinsics.areEqual(it.name(), this.getName()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Readonly
    public final boolean isAncientRuinsEquivalent(@Nullable GameContext state) {
        return this.hasUnique(UniqueType.IsAncientRuinsEquivalent, state);
    }

    public static /* synthetic */ boolean isAncientRuinsEquivalent$default(TileImprovement tileImprovement, GameContext gameContext, int n, Object object) {
        if ((n & 1) != 0) {
            gameContext = GameContext.Companion.getIgnoreConditionals();
        }
        return tileImprovement.isAncientRuinsEquivalent(gameContext);
    }

    @Readonly
    public final boolean canBeBuiltOn(@NotNull String terrain) {
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        return this.terrainsCanBeBuiltOn.contains(terrain);
    }

    @Readonly
    public final boolean canBeBuiltOn(@NotNull Terrain terrain) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(terrain, "terrain");
            Iterable $this$any$iv = this.terrainsCanBeBuiltOn;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Terrain.matchesFilter$default(terrain, it, null, false, 6, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    public final boolean isAllowedOnFeature(@NotNull Terrain terrain) {
        Unique it;
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        if (this.canBeBuiltOn(terrain)) return true;
        Sequence $this$any$iv = IHasUniques.getMatchingUniques$default(this, UniqueType.NoFeatureRemovalNeeded, null, 2, null);
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Unique)element$iv;
            boolean bl = false;
        } while (!Terrain.matchesFilter$default(terrain, it.getParams().get(0), null, false, 6, null));
        return true;
    }

    @Readonly
    public final boolean matchesFilter(@NotNull String filter2, @Nullable GameContext tileState, boolean multiFilter) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return multiFilter ? MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, arg_0 -> TileImprovement.matchesFilter$lambda$0(this, tileState, arg_0), false, 4, null) : this.matchesSingleFilter(filter2) || tileState != null && this.hasTagUnique(filter2, tileState) || tileState == null && this.hasTagUnique(filter2);
    }

    public static /* synthetic */ boolean matchesFilter$default(TileImprovement tileImprovement, String string, GameContext gameContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return tileImprovement.matchesFilter(string, gameContext, bl);
    }

    @Readonly
    private final boolean matchesSingleFilter(String filter2) {
        boolean bl;
        switch (filter2) {
            case "all": 
            case "All": {
                bl = true;
                break;
            }
            case "Improvement": {
                bl = true;
                break;
            }
            case "All Road": {
                bl = this.isRoad();
                break;
            }
            case "Great Improvement": 
            case "Great": {
                bl = this.isGreatImprovement();
                break;
            }
            default: {
                bl = Intrinsics.areEqual(filter2, this.getName()) || Intrinsics.areEqual(filter2, this.replaces);
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public String makeLink() {
        return "Improvement/" + this.getName();
    }

    @Override
    @NotNull
    public List<FormattedLine> getCivilopediaTextLines(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return ImprovementDescriptions.INSTANCE.getCivilopediaTextLines(this, ruleset);
    }

    @Override
    public int getSortGroup(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return this.isGreatImprovement() ? 1 : (StringsKt.startsWith$default(this.getName(), "Cancel ", false, 2, null) ? 2 : (StringsKt.startsWith$default(this.getName(), "Remove ", false, 2, null) ? 2 : (Intrinsics.areEqual(this.getName(), "Repair") ? 2 : 0)));
    }

    @Override
    @Nullable
    public String getSubCategory(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return this.isGreatImprovement() ? "Great Improvement" : (StringsKt.startsWith$default(this.getName(), "Cancel ", false, 2, null) ? "Action" : (StringsKt.startsWith$default(this.getName(), "Remove ", false, 2, null) ? "Action" : (Intrinsics.areEqual(this.getName(), "Repair") ? "Action" : "Tile Improvements")));
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<BaseUnit> getConstructorUnits(@NotNull Ruleset ruleset) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        if (IHasUniques.hasUnique$default(this, UniqueType.Unbuildable, null, 2, null)) {
            return CollectionsKt.emptyList();
        }
        Set<String> canOnlyFilters = SequencesKt.toSet(SequencesKt.map(IHasUniques.getMatchingUniques$default(this, UniqueType.CanOnlyBeBuiltOnTile, null, 2, null), TileImprovement::getConstructorUnits$lambda$0));
        Set<String> cannotFilters = SequencesKt.toSet(SequencesKt.map(IHasUniques.getMatchingUniques$default(this, UniqueType.CannotBuildOnTile, null, 2, null), TileImprovement::getConstructorUnits$lambda$1));
        Collection<TileResource> collection = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileResource it = (TileResource)element$iv$iv;
            boolean bl = false;
            if (!it.isImprovedBy(this.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List resourcesImprovedByThis = (List)destination$iv$iv;
        Set<String> expandedTerrainsCanBeBuiltOn2 = SequencesKt.toMutableSet(SequencesKt.filter(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, (List<TileResource>)resourcesImprovedByThis, ruleset, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TileImprovement this$0;
            final /* synthetic */ List<TileResource> $resourcesImprovedByThis;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.this$0 = $receiver;
                this.$resourcesImprovedByThis = $resourcesImprovedByThis;
                this.$ruleset = $ruleset;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                block18: {
                    var2_2 = (SequenceScope)this.L$0;
                    var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yieldAll((Iterable)this.this$0.getTerrainsCanBeBuiltOn(), (Continuation<? super Unit>)this);
                            if (v0 == var9_3) {
                                return var9_3;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 2;
                            v1 = $this$sequence.yieldAll(SequencesKt.flatMap(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)this.this$0.getTerrainsCanBeBuiltOn()), (Function1<String, Terrain>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.unciv.models.ruleset.Ruleset java.lang.String ), (Ljava/lang/String;)Lcom/unciv/models/ruleset/tile/Terrain;)((Ruleset)this.$ruleset)), (Function1<Terrain, Sequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$1(com.unciv.models.ruleset.tile.Terrain ), (Lcom/unciv/models/ruleset/tile/Terrain;)Lkotlin/sequences/Sequence;)()), (Continuation<? super Unit>)this);
                            if (v1 == var9_3) {
                                return var9_3;
                            }
                            ** GOTO lbl24
                        }
                        case 2: {
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl24:
                            // 2 sources

                            if (IHasUniques.hasUnique$default(this.this$0, UniqueType.CanOnlyImproveResource, null, 2, null)) {
                                this.L$0 = $this$sequence;
                                this.label = 3;
                                v2 = $this$sequence.yieldAll(SequencesKt.flatMapIterable(CollectionsKt.asSequence((Iterable)this.$resourcesImprovedByThis), (Function1<TileResource, Iterable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$2(com.unciv.models.ruleset.tile.TileResource ), (Lcom/unciv/models/ruleset/tile/TileResource;)Ljava/lang/Iterable;)()), (Continuation<? super Unit>)this);
                                if (v2 == var9_3) {
                                    return var9_3;
                                }
                            }
                            ** GOTO lbl34
                        }
                        case 3: {
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
lbl34:
                            // 2 sources

                            if (!StringsKt.startsWith$default(this.this$0.getName(), "Remove ", false, 2, null)) break;
                            var3_4 = StringsKt.removePrefix(this.this$0.getName(), (CharSequence)"Remove ");
                            var4_6 = this.$ruleset;
                            $this$invokeSuspend_u24lambda_u243 = var3_4;
                            $i$a$-apply-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4 = 0;
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = var4_6;
                            this.L$3 = $this$invokeSuspend_u24lambda_u243;
                            this.I$0 = $i$a$-apply-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4;
                            this.label = 4;
                            v3 = $this$sequence.yield($this$invokeSuspend_u24lambda_u243, this);
                            if (v3 == var9_3) {
                                return var9_3;
                            }
                            ** GOTO lbl56
                        }
                        case 4: {
                            $i$a$-apply-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4 = this.I$0;
                            $this$invokeSuspend_u24lambda_u243 = (String)this.L$3;
                            var4_6 = (Ruleset)this.L$2;
                            var3_4 = (String)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl56:
                            // 2 sources

                            if ((v4 /* !! */  = var4_6.getTerrains().get($this$invokeSuspend_u24lambda_u243)) == null || (v4 /* !! */  = v4 /* !! */ .getOccursOn()) == null) break;
                            it /* !! */  = v4 /* !! */ ;
                            $i$a$-let-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4$1 = 0;
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = var4_6;
                            this.L$3 = $this$invokeSuspend_u24lambda_u243;
                            this.L$4 = SpillingKt.nullOutSpilledVariable(it /* !! */ );
                            this.I$0 = $i$a$-apply-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4;
                            this.I$1 = $i$a$-let-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4$1;
                            this.label = 5;
                            v5 = $this$sequence.yieldAll(it /* !! */ , (Continuation<? super Unit>)this);
                            if (v5 == var9_3) {
                                return var9_3;
                            }
                            break;
                        }
                        case 5: {
                            $i$a$-let-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4$1 = this.I$1;
                            $i$a$-apply-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4 = this.I$0;
                            it /* !! */  = (ArrayList)this.L$4;
                            $this$invokeSuspend_u24lambda_u243 = (String)this.L$3;
                            var4_6 = (Ruleset)this.L$2;
                            var3_4 = (String)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v5 = $result;
                            break;
                        }
                    }
                    if ((v6 /* !! */  = var4_6.getTileImprovements().get($this$invokeSuspend_u24lambda_u243)) != null && (v6 /* !! */  = v6 /* !! */ .getTerrainsCanBeBuiltOn()) != null) {
                        it /* !! */  = v6 /* !! */ ;
                        $i$a$-let-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4$2 = 0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.L$1 = var3_4;
                        this.L$2 = SpillingKt.nullOutSpilledVariable($this$invokeSuspend_u24lambda_u243);
                        this.L$3 = SpillingKt.nullOutSpilledVariable(it /* !! */ );
                        this.L$4 = null;
                        this.I$0 = $i$a$-apply-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4;
                        this.I$1 = $i$a$-let-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4$2;
                        this.label = 6;
                        v7 = $this$sequence.yieldAll(it /* !! */ , (Continuation<? super Unit>)this);
                        if (v7 == var9_3) {
                            return var9_3;
                        }
                    }
                    break block18;
                    {
                        case 6: {
                            $i$a$-let-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4$2 = this.I$1;
                            $i$a$-apply-TileImprovement$getConstructorUnits$expandedTerrainsCanBeBuiltOn$1$4 = this.I$0;
                            it = (Collection)this.L$3;
                            $this$invokeSuspend_u24lambda_u243 = (String)this.L$2;
                            var3_5 = (String)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v7 = $result;
                        }
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Terrain invokeSuspend$lambda$0(Ruleset $ruleset, String it) {
                return $ruleset.getTerrains().get(it);
            }

            private static final Sequence invokeSuspend$lambda$1(Terrain it) {
                return CollectionsKt.asSequence((Iterable)it.getOccursOn());
            }

            private static final Iterable invokeSuspend$lambda$2(TileResource it) {
                return it.getTerrainsCanBeFoundOn();
            }
        }), arg_0 -> TileImprovement.getConstructorUnits$lambda$3(cannotFilters, arg_0)));
        Set<TerrainType> terrainsCanBeBuiltOnTypes2 = SequencesKt.toMutableSet(SequencesKt.filter(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super TerrainType>, Continuation<? super Unit>, Object>(expandedTerrainsCanBeBuiltOn2, ruleset, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Set<String> $expandedTerrainsCanBeBuiltOn;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.$expandedTerrainsCanBeBuiltOn = $expandedTerrainsCanBeBuiltOn;
                this.$ruleset = $ruleset;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yieldAll(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)this.$expandedTerrainsCanBeBuiltOn), (Function1<String, TerrainType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.unciv.models.ruleset.Ruleset java.lang.String ), (Ljava/lang/String;)Lcom/unciv/models/ruleset/tile/TerrainType;)((Ruleset)this.$ruleset)), (Continuation<? super Unit>)this);
                        if (v0 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.label = 2;
                        v1 = $this$sequence.yieldAll(SequencesKt.filter(CollectionsKt.asSequence((Iterable)TerrainType.getEntries()), (Function1<TerrainType, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$1(java.util.Set com.unciv.models.ruleset.tile.TerrainType ), (Lcom/unciv/models/ruleset/tile/TerrainType;)Ljava/lang/Boolean;)(this.$expandedTerrainsCanBeBuiltOn)), (Continuation<? super Unit>)this);
                        if (v1 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super TerrainType>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super TerrainType> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final TerrainType invokeSuspend$lambda$0(Ruleset $ruleset, String it) {
                Terrain terrain = $ruleset.getTerrains().get(it);
                return terrain != null ? terrain.getType() : null;
            }

            private static final boolean invokeSuspend$lambda$1(Set $expandedTerrainsCanBeBuiltOn, TerrainType it) {
                return $expandedTerrainsCanBeBuiltOn.contains(it.name());
            }
        }), arg_0 -> TileImprovement.getConstructorUnits$lambda$4(cannotFilters, arg_0)));
        if (!((Collection)canOnlyFilters).isEmpty() && CollectionsKt.intersect((Iterable)canOnlyFilters, (Iterable)expandedTerrainsCanBeBuiltOn2).isEmpty()) {
            boolean bl;
            block7: {
                expandedTerrainsCanBeBuiltOn2.clear();
                Iterable $this$none$iv = terrainsCanBeBuiltOnTypes2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        TerrainType it = (TerrainType)((Object)element$iv);
                        boolean bl2 = false;
                        if (!canOnlyFilters.contains(it.name())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (bl) {
                terrainsCanBeBuiltOnTypes2.clear();
            }
        }
        Collection<BaseUnit> collection2 = ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        return SequencesKt.toList(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), arg_0 -> TileImprovement.getConstructorUnits$lambda$7(this, terrainsCanBeBuiltOnTypes2, expandedTerrainsCanBeBuiltOn2, arg_0)));
    }

    @Readonly
    @NotNull
    public final List<BaseUnit> getCreatingUnits(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Collection<BaseUnit> collection = ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.toList(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), arg_0 -> TileImprovement.getCreatingUnits$lambda$0(this, arg_0)));
    }

    private static final boolean getTurnsToBuild$lambda$0(TileImprovement this$0, GameContext $state, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TileImprovement.matchesFilter$default(this$0, it.getParams().get(1), $state, false, 4, null);
    }

    private static final boolean getTurnsToBuild$lambda$1(TileImprovement this$0, GameContext $state, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TileImprovement.matchesFilter$default(this$0, it.getParams().get(0), $state, false, 4, null);
    }

    private static final boolean matchesFilter$lambda$0(TileImprovement this$0, GameContext $tileState, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.matchesSingleFilter(it) || $tileState != null && this$0.hasTagUnique(it, $tileState) || $tileState == null && this$0.hasTagUnique(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final String getConstructorUnits$lambda$0(Unique it) {
        void var1_1;
        Intrinsics.checkNotNullParameter(it, "it");
        String $this$getConstructorUnits_u24lambda_u240_u240 = it.getParams().get(0);
        boolean bl = false;
        return Intrinsics.areEqual($this$getConstructorUnits_u24lambda_u240_u240, "Coastal") ? "Land" : var1_1;
    }

    private static final String getConstructorUnits$lambda$1(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getParams().get(0);
    }

    private static final boolean getConstructorUnits$lambda$3(Set $cannotFilters, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !$cannotFilters.contains(it);
    }

    private static final boolean getConstructorUnits$lambda$4(Set $cannotFilters, TerrainType it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return !$cannotFilters.contains(it.name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private static final boolean getConstructorUnits$matchesBuildImprovementsFilter(TileImprovement this$0, Set<String> expandedTerrainsCanBeBuiltOn2, Set<TerrainType> terrainsCanBeBuiltOnTypes2, String filter2) {
        TerrainType it;
        if (TileImprovement.matchesFilter$default(this$0, filter2, null, false, 6, null)) return true;
        if (expandedTerrainsCanBeBuiltOn2.contains(filter2)) return true;
        Iterable $this$any$iv = terrainsCanBeBuiltOnTypes2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (TerrainType)((Object)element$iv);
            boolean bl = false;
        } while (!Intrinsics.areEqual(it.name(), filter2));
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getConstructorUnits$lambda$7(TileImprovement this$0, Set $terrainsCanBeBuiltOnTypes, Set $expandedTerrainsCanBeBuiltOn, BaseUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (this$0.turnsToBuild != -1) {
            void $this$any$iv;
            Sequence<Unique> sequence = unit.getMatchingUniques(UniqueType.BuildImprovements, GameContext.Companion.getIgnoreConditionals());
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Unique it = (Unique)element$iv;
                boolean bl = false;
                if (!TileImprovement.getConstructorUnits$matchesBuildImprovementsFilter(this$0, $expandedTerrainsCanBeBuiltOn, $terrainsCanBeBuiltOnTypes, it.getParams().get(0))) continue;
                return true;
            }
            boolean bl = false;
            if (bl) return true;
        }
        if (!IHasUniques.hasUnique$default(unit, UniqueType.CreateWaterImprovements, null, 2, null)) return false;
        if (!$terrainsCanBeBuiltOnTypes.contains((Object)TerrainType.Water)) return false;
        return true;
    }

    private static final boolean getCreatingUnits$lambda$0(TileImprovement this$0, BaseUnit unit) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Sequence<Unique> $this$any$iv = unit.getMatchingUniques(UniqueType.ConstructImprovementInstantly, GameContext.Companion.getIgnoreConditionals());
            boolean $i$f$any = false;
            Iterator<Unique> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Unique element$iv;
                Unique it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getParams().get(0), this$0.getName())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

