/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetFile;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.validation.RulesetError;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000bJ2\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Lcom/unciv/models/ruleset/validation/UniqueAutoUpdater;", "", "<init>", "()V", "autoupdateUniques", "", "mod", "Lcom/unciv/models/ruleset/Ruleset;", "replaceableUniques", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getDeprecatedReplaceableUniques", "rulesetForValidation", "core"})
@SourceDebugExtension(value={"SMAP\nUniqueAutoUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueAutoUpdater.kt\ncom/unciv/models/ruleset/validation/UniqueAutoUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1586#2:78\n1661#2,3:79\n*S KotlinDebug\n*F\n+ 1 UniqueAutoUpdater.kt\ncom/unciv/models/ruleset/validation/UniqueAutoUpdater\n*L\n19#1:78\n19#1:79,3\n*E\n"})
public final class UniqueAutoUpdater {
    @NotNull
    public static final UniqueAutoUpdater INSTANCE = new UniqueAutoUpdater();

    private UniqueAutoUpdater() {
    }

    /*
     * WARNING - void declaration
     */
    public final void autoupdateUniques(@NotNull Ruleset mod, @NotNull HashMap<String, String> replaceableUniques) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(mod, "mod");
        Intrinsics.checkNotNullParameter(replaceableUniques, "replaceableUniques");
        Iterable $this$map$iv = RulesetFile.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object entry : $this$mapTo$iv$iv) {
            void it;
            RulesetFile rulesetFile = (RulesetFile)((Object)entry);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFilename());
        }
        List filesToReplace = (List)destination$iv$iv;
        FileHandle fileHandle = mod.getFolderLocation();
        Intrinsics.checkNotNull(fileHandle);
        FileHandle jsonFolder = fileHandle.child("jsons");
        for (String fileName : filesToReplace) {
            FileHandle file = jsonFolder.child(fileName);
            if (!file.exists() || file.isDirectory()) continue;
            String newFileText = file.readString();
            for (Map.Entry entry : ((Map)replaceableUniques).entrySet()) {
                String original = (String)entry.getKey();
                String replacement = (String)entry.getValue();
                String string = newFileText;
                Intrinsics.checkNotNull(string);
                newFileText = StringsKt.replace$default(string, '\"' + original + '\"', '\"' + replacement + '\"', false, 4, null);
                newFileText = StringsKt.replace$default(newFileText, '<' + original + '>', '<' + replacement + '>', false, 4, null);
            }
            file.writeString(newFileText, false);
        }
    }

    public static /* synthetic */ void autoupdateUniques$default(UniqueAutoUpdater uniqueAutoUpdater, Ruleset ruleset, HashMap hashMap, int n, Object object) {
        if ((n & 2) != 0) {
            hashMap = uniqueAutoUpdater.getDeprecatedReplaceableUniques(ruleset, ruleset);
        }
        uniqueAutoUpdater.autoupdateUniques(ruleset, hashMap);
    }

    @NotNull
    public final HashMap<String, String> getDeprecatedReplaceableUniques(@NotNull Ruleset mod, @NotNull Ruleset rulesetForValidation) {
        Intrinsics.checkNotNullParameter(mod, "mod");
        Intrinsics.checkNotNullParameter(rulesetForValidation, "rulesetForValidation");
        Sequence<Unique> allUniques = mod.allUniques();
        HashSet<String> allDeprecatedUniques = new HashSet<String>();
        HashMap<String, String> deprecatedUniquesToReplacementText = new HashMap<String, String>();
        UniqueValidator validator = new UniqueValidator(rulesetForValidation);
        boolean reportRulesetSpecificErrors = rulesetForValidation.getModOptions().isBaseRuleset();
        Sequence<Unique> deprecatedUniques = SequencesKt.filter(allUniques, UniqueAutoUpdater::getDeprecatedReplaceableUniques$lambda$0);
        Sequence<Unique> deprecatedConditionals = SequencesKt.filter(SequencesKt.flatMapIterable(allUniques, UniqueAutoUpdater::getDeprecatedReplaceableUniques$lambda$1), UniqueAutoUpdater::getDeprecatedReplaceableUniques$lambda$2);
        Iterator<Unique> iterator2 = SequencesKt.plus(deprecatedUniques, deprecatedConditionals).iterator();
        while (iterator2.hasNext()) {
            Object[] objectArray;
            Unique deprecatedUnique = iterator2.next();
            if (allDeprecatedUniques.contains(deprecatedUnique.getText())) continue;
            allDeprecatedUniques.add(deprecatedUnique.getText());
            String uniqueReplacementText = deprecatedUnique.getReplacementText(mod);
            while (new Unique(uniqueReplacementText, null, null, 6, null).getDeprecationAnnotation() != null) {
                uniqueReplacementText = new Unique(uniqueReplacementText, null, null, 6, null).getReplacementText(mod);
            }
            for (Unique conditional : deprecatedUnique.getModifiers()) {
                uniqueReplacementText = uniqueReplacementText + " <" + conditional.getText() + '>';
            }
            Unique replacementUnique = new Unique(uniqueReplacementText, null, null, 6, null);
            RulesetErrorList modErrors = validator.checkUnique(replacementUnique, false, null, reportRulesetSpecificErrors);
            Intrinsics.checkNotNullExpressionValue(modErrors.iterator(), "iterator(...)");
            while (objectArray.hasNext()) {
                Object e = objectArray.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                RulesetError error2 = (RulesetError)e;
                Object[] objectArray2 = new Object[]{error2.getText(), error2.getErrorSeverityToReport()};
                Log.INSTANCE.error("ModError: %s - %s", objectArray2);
            }
            if (!((Collection)modErrors).isEmpty()) continue;
            ((Map)deprecatedUniquesToReplacementText).put(deprecatedUnique.getText(), uniqueReplacementText);
            objectArray = new Object[]{deprecatedUnique.getText(), uniqueReplacementText};
            Log.INSTANCE.debug("Replace \"%s\" with \"%s\"", objectArray);
        }
        return deprecatedUniquesToReplacementText;
    }

    private static final boolean getDeprecatedReplaceableUniques$lambda$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDeprecationAnnotation() != null;
    }

    private static final Iterable getDeprecatedReplaceableUniques$lambda$1(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getModifiers();
    }

    private static final boolean getDeprecatedReplaceableUniques$lambda$2(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDeprecationAnnotation() != null;
    }
}

