/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.CityTileState;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/components/tilegroups/CityTileGroup;", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "city", "Lcom/unciv/logic/city/City;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "tileSetStrings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "nightMode", "", "isSpying", "<init>", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/ui/components/tilegroups/TileSetStrings;ZZ)V", "getCity", "()Lcom/unciv/logic/city/City;", "tileState", "Lcom/unciv/ui/components/tilegroups/CityTileState;", "getTileState", "()Lcom/unciv/ui/components/tilegroups/CityTileState;", "setTileState", "(Lcom/unciv/ui/components/tilegroups/CityTileState;)V", "update", "", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "core"})
@SourceDebugExtension(value={"SMAP\nCityTileGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityTileGroup.kt\ncom/unciv/ui/components/tilegroups/CityTileGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class CityTileGroup
extends TileGroup {
    @NotNull
    private final City city;
    private final boolean nightMode;
    private final boolean isSpying;
    @NotNull
    private CityTileState tileState;

    public CityTileGroup(@NotNull City city, @NotNull Tile tile, @NotNull TileSetStrings tileSetStrings, boolean nightMode, boolean isSpying) {
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(tileSetStrings, "tileSetStrings");
        super(tile, tileSetStrings, 0.0f, 4, null);
        this.city = city;
        this.nightMode = nightMode;
        this.isSpying = isSpying;
        this.tileState = CityTileState.NONE;
        this.getLayerMisc().setTouchable(Touchable.childrenOnly);
    }

    public /* synthetic */ CityTileGroup(City city, Tile tile, TileSetStrings tileSetStrings, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(city, tile, tileSetStrings, bl, bl2);
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    @NotNull
    public final CityTileState getTileState() {
        return this.tileState;
    }

    public final void setTileState(@NotNull CityTileState cityTileState) {
        Intrinsics.checkNotNullParameter((Object)cityTileState, "<set-?>");
        this.tileState = cityTileState;
    }

    @Override
    public void update(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        super.update(this.city.getCiv(), localUniqueCache);
        this.tileState = CityTileState.NONE;
        this.getLayerMisc().removeWorkedIcon();
        Actor icon = null;
        Function1<Float, Unit> setDimmed = this.nightMode ? arg_0 -> CityTileGroup.update$lambda$0(this, arg_0) : arg_0 -> CityTileGroup.update$lambda$1(this, arg_0);
        Function0<Unit> setUndimmed = this.nightMode ? () -> CityTileGroup.update$lambda$2(this) : CityTileGroup::update$lambda$3;
        if (!Intrinsics.areEqual(this.getTile().getOwner(), this.city.getCiv())) {
            setDimmed.invoke(Float.valueOf(0.6f));
            this.getLayerYield().setYieldVisible(UncivGame.Companion.getCurrent().getSettings().getShowTileYields());
            this.getLayerYield().dimYields(true);
            if (this.city.getExpansion().canBuyTile(this.getTile())) {
                Group group;
                int price = this.city.getExpansion().getGoldCostOfTile(this.getTile());
                Label label = Scene2dExtensionsKt.toLabel$default(TranslationsKt.tr(price), null, 9, 1, false, 9, null);
                Image image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "TileIcons/Buy", null, 2, null);
                Group $this$update_u24lambda_u244 = group = Scene2dExtensionsKt.toGroup(image, 26.0f);
                boolean bl = false;
                $this$update_u24lambda_u244.setTransform(false);
                icon = group;
                Scene2dExtensionsKt.addToCenter((Group)icon, label);
                label.setY(label.getY() - 15.0f);
                if (!this.city.getCiv().hasStatToBuy(Stat.Gold, price)) {
                    Color color = Color.WHITE;
                    Intrinsics.checkNotNullExpressionValue(color, "WHITE");
                    image.setColor(Scene2dExtensionsKt.darken(color, 0.5f));
                    Color color2 = Color.RED;
                    Intrinsics.checkNotNullExpressionValue(color2, "RED");
                    Scene2dExtensionsKt.setFontColor(label, color2);
                } else {
                    this.tileState = CityTileState.PURCHASABLE;
                }
            }
        } else if (!this.city.getTilesInRange().contains(this.getTile())) {
            setDimmed.invoke(Float.valueOf(1.0f));
            this.getLayerYield().dimYields(true);
        } else if (this.getTile().isWorked() && !Intrinsics.areEqual(this.getTile().getWorkingCity(), this.city)) {
            setDimmed.invoke(Float.valueOf(1.0f));
            this.getLayerYield().dimYields(true);
        } else if (this.getTile().isCityCenter()) {
            icon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "TileIcons/CityCenter", null, 2, null);
            this.getLayerYield().dimYields(false);
        } else if (TileStatFunctions.getTileStats$default(this.getTile().getStats(), this.city, this.city.getCiv(), null, 4, null).isEmpty()) {
            setUndimmed.invoke();
        } else if (this.getTile().isBlockaded()) {
            icon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "TileIcons/Blockaded", null, 2, null);
            this.tileState = CityTileState.BLOCKADED;
            setUndimmed.invoke();
            this.getLayerYield().dimYields(true);
        } else if (this.getTile().isLocked()) {
            icon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "TileIcons/Locked", null, 2, null);
            this.tileState = CityTileState.WORKABLE;
            setUndimmed.invoke();
            this.getLayerYield().dimYields(false);
        } else if (this.getTile().isWorked()) {
            icon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "TileIcons/Worked", null, 2, null);
            this.tileState = CityTileState.WORKABLE;
            setUndimmed.invoke();
            this.getLayerYield().dimYields(false);
        } else if (this.getTile().providesYield()) {
            setUndimmed.invoke();
        } else {
            icon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "TileIcons/NotWorked", null, 2, null);
            this.tileState = CityTileState.WORKABLE;
            setUndimmed.invoke();
            this.getLayerYield().dimYields(true);
        }
        if (icon != null) {
            icon.setSize(26.0f, 26.0f);
            icon.setPosition(this.getWidth() / (float)2 - icon.getWidth() / (float)2, this.getHeight() * 0.85f - icon.getHeight() / (float)2);
            this.getLayerMisc().addWorkedIcon(icon);
        }
        this.getLayerUnitFlag().setVisible(false);
        this.getLayerCityButton().setVisible(false);
        if (this.isSpying) {
            this.getLayerUnitArt().setVisible(false);
        } else {
            this.getLayerUnitArt().dim();
        }
        this.getLayerFeatures().dim();
        this.getLayerImprovement().dimImprovement(true);
        this.getLayerMisc().toFront();
    }

    private static final Unit update$lambda$0(CityTileGroup this$0, float factor) {
        this$0.getLayerTerrain().dim(0.25f * factor);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$1(CityTileGroup this$0, float factor) {
        this$0.getLayerTerrain().dim(0.5f * factor);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$2(CityTileGroup this$0) {
        this$0.getLayerTerrain().dim(0.5f);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$3() {
        return Unit.INSTANCE;
    }
}

